<%@ WebService Language="vb" Class="ToolsServices" %>
Imports System.Web.Services
Imports System.Web.Services.Protocols
Imports System.ComponentModel
Imports System.Data
Imports System.Linq

<System.Web.Services.WebService(Namespace:="http://tempuri.org/")> _
<System.Web.Services.WebServiceBinding(ConformsTo:=WsiProfiles.BasicProfile1_1)> _
Public Class ToolsServices
    Inherits System.Web.Services.WebService


    <WebMethod()> _
    Public Function VerificaResponsavel(ByVal userId as integer) As string
		Select Case userId
		Case 1,3,4
			Return "u6;"
		Case Else
			Return "u1;"
		End Select
    End Function

    <WebMethod()> _
    Public Function MontaMarcador(ByVal markerValue As String) As string
        Return markerValue
    End Function

    <WebMethod()> _
    Public Function AdicionaDias(ByVal processoId As Integer, etapaId As Integer, numDias As Integer) As DateTime
        Dim dataCalc As New WebFoundations.WFWorkflow.Domain.CalcPrazo(processoId, etapaId, 1)
        dataCalc.BaseDate = Now
        dataCalc.AddDays(numDias)
		Return dataCalc.BaseDate
	End Function

	<WebMethod()> _
    Public Function GetUserInfo(ByVal userId As String) As DataTable
        Dim usuarios As New List(Of WebFoundations.Objects.Interfaces.IUserInfo)
		usuarios.Add(WebFoundations.AccessManagement.AdvancedManagement.UserInfoManager.GetUser(userId))
        Dim colecaoUsers = (From p In usuarios Select p)
        return ConvertToDataTable(Of WebFoundations.Objects.Interfaces.IUserInfo)(colecaoUsers)
    End Function
	
    Private Function ConvertToDataTable(Of TSource)(source As IEnumerable(Of TSource)) As DataTable
        Dim props = GetType(TSource).GetProperties()
        Dim dt = New DataTable()
		dt.TableName = "SERIALIZED"
        dt.Columns.AddRange(props.[Select](Function(p) New DataColumn(p.Name, GetColumnType(p.PropertyType))).ToArray())
        source.ToList().ForEach(Function(i) dt.Rows.Add(props.[Select](Function(p) p.GetValue(i, Nothing)).ToArray()))
        Return dt
    End Function

    Private Function GetColumnType(baseType As Type) As Type
        If Not baseType.FullName.ToLower.Contains("nullable") Then Return baseType
        If baseType.FullName.ToLower.Contains("date") Then Return GetType(System.DateTime)
        If baseType.FullName.ToLower.Contains("boolean") Then Return GetType(System.Boolean)
        Return GetType(System.String)
    End Function
End Class

