

IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[APR_CTTCONTRATA]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
	
	DECLARE @TMPTABLE TABLE (TMP_C_NAME NVARCHAR(128))
	CREATE TABLE #TempResult(TMP_C_NAME NVARCHAR(128))
	INSERT INTO @TMPTABLE SELECT NAME FROM SYSCOLUMNS WHERE ID = OBJECT_ID(N'[APR_CTTCONTRATA]')

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='DataInicio')
		ALTER TABLE APR_CTTCONTRATA ADD DataInicio DateTime NULL
	ELSE
		ALTER TABLE APR_CTTCONTRATA ALTER COLUMN DataInicio DateTime NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='TipoContratacao')
		ALTER TABLE APR_CTTCONTRATA ADD TipoContratacao nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_CTTCONTRATA ALTER COLUMN TipoContratacao nVarChar(100) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='Valor')
		ALTER TABLE APR_CTTCONTRATA ADD Valor Decimal (16,2) NULL
	ELSE
		ALTER TABLE APR_CTTCONTRATA ALTER COLUMN Valor Decimal (16,2) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='USERNAME')
		ALTER TABLE APR_CTTCONTRATA ADD USERNAME nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_CTTCONTRATA ALTER COLUMN USERNAME nVarChar(100) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='PASSWORD')
		ALTER TABLE APR_CTTCONTRATA ADD PASSWORD nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_CTTCONTRATA ALTER COLUMN PASSWORD nVarChar(100) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='EMAIL')
		ALTER TABLE APR_CTTCONTRATA ADD EMAIL nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_CTTCONTRATA ALTER COLUMN EMAIL nVarChar(100) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='EMAILPWD')
		ALTER TABLE APR_CTTCONTRATA ADD EMAILPWD nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_CTTCONTRATA ALTER COLUMN EMAILPWD nVarChar(100) NULL

	DROP TABLE #TempResult

END
ELSE
BEGIN
	CREATE TABLE APR_CTTCONTRATA (CodigoAutomatico INT IDENTITY(1,1) PRIMARY KEY CLUSTERED, CodigoUsuario INT, GUID VARCHAR(36) NULL, ParentGUID VARCHAR(36) NULL)
	
	ALTER TABLE APR_CTTCONTRATA ADD DataInicio DateTime NULL


	ALTER TABLE APR_CTTCONTRATA ADD TipoContratacao nVarChar(100) NULL


	ALTER TABLE APR_CTTCONTRATA ADD Valor Decimal (16,2) NULL


	ALTER TABLE APR_CTTCONTRATA ADD USERNAME nVarChar(100) NULL


	ALTER TABLE APR_CTTCONTRATA ADD PASSWORD nVarChar(100) NULL


	ALTER TABLE APR_CTTCONTRATA ADD EMAIL nVarChar(100) NULL


	ALTER TABLE APR_CTTCONTRATA ADD EMAILPWD nVarChar(100) NULL


END

IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_Save_APR_CTTCONTRATA]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_Save_APR_CTTCONTRATA]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_Del_APR_CTTCONTRATA]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_Del_APR_CTTCONTRATA]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_List_APR_CTTCONTRATA]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_List_APR_CTTCONTRATA]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_Get_APR_CTTCONTRATA]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_Get_APR_CTTCONTRATA]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_GetByParent_APR_CTTCONTRATA]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_GetByParent_APR_CTTCONTRATA]

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_Save_APR_CTTCONTRATA
'| Descrição: Adiciona registros para a tabela APR_CTTCONTRATA
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_Save_APR_CTTCONTRATA 
(
	@CodigoAutomatico INT,
	@CodigoUsuario INT,
	@GUID VARCHAR(36),
	@ParentGUID VARCHAR(36) = NULL,
    @DataInicio    DateTime = NULL,
    @TipoContratacao    nVarChar(100),
    @Valor    Decimal(16,2),
    @USERNAME    nVarChar(100),
    @PASSWORD    nVarChar(100),
    @EMAIL    nVarChar(100),
    @EMAILPWD    nVarChar(100)
)
AS
	IF @CodigoAutomatico = 0
	BEGIN
		SET NOCOUNT ON
		
		INSERT INTO APR_CTTCONTRATA
		(GUID, ParentGUID, CodigoUsuario,
    DataInicio,
    TipoContratacao,
    Valor,
    USERNAME,
    PASSWORD,
    EMAIL,
    EMAILPWD)
		VALUES
		(@GUID, @ParentGUID, @CodigoUsuario,
    @DataInicio,
    @TipoContratacao,
    @Valor,
    @USERNAME,
    @PASSWORD,
    @EMAIL,
    @EMAILPWD)
		
		SET NOCOUNT OFF
		
		SELECT * FROM APR_CTTCONTRATA WHERE CodigoAutomatico = @@IDENTITY
	END
	ELSE
	BEGIN
		SET NOCOUNT ON
		
		UPDATE APR_CTTCONTRATA
		SET     DataInicio = @DataInicio,
    TipoContratacao = @TipoContratacao,
    Valor = @Valor,
    USERNAME = @USERNAME,
    PASSWORD = @PASSWORD,
    EMAIL = @EMAIL,
    EMAILPWD = @EMAILPWD 
		WHERE     CodigoAutomatico = @CodigoAutomatico
		
		SET NOCOUNT OFF
	
		SELECT * FROM APR_CTTCONTRATA WHERE CodigoAutomatico = @CodigoAutomatico
	END

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_Del_APR_CTTCONTRATA
'| Descrição: Exclui registros da tabela APR_CTTCONTRATA
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_Del_APR_CTTCONTRATA 
(
	@CodigoAutomatico INT
)
AS
	SET NOCOUNT ON
	
	DELETE FROM APR_CTTCONTRATA
	WHERE CodigoAutomatico = @CodigoAutomatico
	
	SET NOCOUNT OFF

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_Get_APR_CTTCONTRATA
'| Descrição: Recupera um registro da a tabela APR_CTTCONTRATA
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_Get_APR_CTTCONTRATA 
(
	@CodigoAutomatico INT
)
AS
	SET NOCOUNT ON
	
	SELECT DataInicio
,TipoContratacao
,Valor
,USERNAME
,PASSWORD
,EMAIL
,EMAILPWD
, CodigoAutomatico, CodigoUsuario, GUID, ParentGUID
	FROM APR_CTTCONTRATA
	WHERE CodigoAutomatico = @CodigoAutomatico
	
	SET NOCOUNT OFF

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_List_APR_CTTCONTRATA
'| Descrição: Lista registros da a tabela APR_CTTCONTRATA
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_List_APR_CTTCONTRATA AS
	
	SELECT     CONVERT(CHAR,DataInicio,103) DataInicio,    TipoContratacao,    Valor,    USERNAME,    PASSWORD,    EMAIL,    EMAILPWD, CodigoAutomatico, CodigoUsuario
	FROM APR_CTTCONTRATA

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_GetByParent_APR_CTTCONTRATA
'| Descrição: Recupera os registros filhos da tabela APR_CTTCONTRATA
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_GetByParent_APR_CTTCONTRATA 
(
	@ParentGUID VARCHAR(36)
)
AS
	SET NOCOUNT ON
	
	SELECT CodigoAutomatico,CodigoUsuario,GUID,ParentGUID,DataInicio
,TipoContratacao
,Valor
,USERNAME
,PASSWORD
,EMAIL
,EMAILPWD

	FROM APR_CTTCONTRATA
	WHERE ParentGUID = @ParentGUID
	
	SET NOCOUNT OFF