

IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[APR_CTTCANDIDATO]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
	
	DECLARE @TMPTABLE TABLE (TMP_C_NAME NVARCHAR(128))
	CREATE TABLE #TempResult(TMP_C_NAME NVARCHAR(128))
	INSERT INTO @TMPTABLE SELECT NAME FROM SYSCOLUMNS WHERE ID = OBJECT_ID(N'[APR_CTTCANDIDATO]')

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='Nome')
		ALTER TABLE APR_CTTCANDIDATO ADD Nome nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_CTTCANDIDATO ALTER COLUMN Nome nVarChar(100) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='Rg')
		ALTER TABLE APR_CTTCANDIDATO ADD Rg nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_CTTCANDIDATO ALTER COLUMN Rg nVarChar(100) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='EstadoCivil')
		ALTER TABLE APR_CTTCANDIDATO ADD EstadoCivil nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_CTTCANDIDATO ALTER COLUMN EstadoCivil nVarChar(100) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='EstaTrabalhando')
		ALTER TABLE APR_CTTCANDIDATO ADD EstaTrabalhando nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_CTTCANDIDATO ALTER COLUMN EstaTrabalhando nVarChar(100) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='IDADE')
		ALTER TABLE APR_CTTCANDIDATO ADD IDADE INT NULL
	ELSE
		ALTER TABLE APR_CTTCANDIDATO ALTER COLUMN IDADE INT NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='CPF')
		ALTER TABLE APR_CTTCANDIDATO ADD CPF nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_CTTCANDIDATO ALTER COLUMN CPF nVarChar(100) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='FEEDBACK')
		ALTER TABLE APR_CTTCANDIDATO ADD FEEDBACK nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_CTTCANDIDATO ALTER COLUMN FEEDBACK nVarChar(100) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='COMENTARIO')
		ALTER TABLE APR_CTTCANDIDATO ADD COMENTARIO nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_CTTCANDIDATO ALTER COLUMN COMENTARIO nVarChar(100) NULL

	DROP TABLE #TempResult

END
ELSE
BEGIN
	CREATE TABLE APR_CTTCANDIDATO (CodigoAutomatico INT IDENTITY(1,1) PRIMARY KEY CLUSTERED, CodigoUsuario INT, GUID VARCHAR(36) NULL, ParentGUID VARCHAR(36) NULL)
	
	ALTER TABLE APR_CTTCANDIDATO ADD Nome nVarChar(100) NULL


	ALTER TABLE APR_CTTCANDIDATO ADD Rg nVarChar(100) NULL


	ALTER TABLE APR_CTTCANDIDATO ADD EstadoCivil nVarChar(100) NULL


	ALTER TABLE APR_CTTCANDIDATO ADD EstaTrabalhando nVarChar(100) NULL


	ALTER TABLE APR_CTTCANDIDATO ADD IDADE INT NULL


	ALTER TABLE APR_CTTCANDIDATO ADD CPF nVarChar(100) NULL


	ALTER TABLE APR_CTTCANDIDATO ADD FEEDBACK nVarChar(100) NULL


	ALTER TABLE APR_CTTCANDIDATO ADD COMENTARIO nVarChar(100) NULL


END

IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_Save_APR_CTTCANDIDATO]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_Save_APR_CTTCANDIDATO]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_Del_APR_CTTCANDIDATO]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_Del_APR_CTTCANDIDATO]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_List_APR_CTTCANDIDATO]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_List_APR_CTTCANDIDATO]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_Get_APR_CTTCANDIDATO]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_Get_APR_CTTCANDIDATO]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_GetByParent_APR_CTTCANDIDATO]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_GetByParent_APR_CTTCANDIDATO]

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_Save_APR_CTTCANDIDATO
'| Descrição: Adiciona registros para a tabela APR_CTTCANDIDATO
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_Save_APR_CTTCANDIDATO 
(
	@CodigoAutomatico INT,
	@CodigoUsuario INT,
	@GUID VARCHAR(36),
	@ParentGUID VARCHAR(36) = NULL,
    @Nome    nVarChar(100),
    @Rg    nVarChar(100),
    @EstadoCivil    nVarChar(100),
    @EstaTrabalhando    nVarChar(100),
    @IDADE    INT,
    @CPF    nVarChar(100),
    @FEEDBACK    nVarChar(100),
    @COMENTARIO    nVarChar(100)
)
AS
	IF @CodigoAutomatico = 0
	BEGIN
		SET NOCOUNT ON
		
		INSERT INTO APR_CTTCANDIDATO
		(GUID, ParentGUID, CodigoUsuario,
    Nome,
    Rg,
    EstadoCivil,
    EstaTrabalhando,
    IDADE,
    CPF,
    FEEDBACK,
    COMENTARIO)
		VALUES
		(@GUID, @ParentGUID, @CodigoUsuario,
    @Nome,
    @Rg,
    @EstadoCivil,
    @EstaTrabalhando,
    @IDADE,
    @CPF,
    @FEEDBACK,
    @COMENTARIO)
		
		SET NOCOUNT OFF
		
		SELECT * FROM APR_CTTCANDIDATO WHERE CodigoAutomatico = @@IDENTITY
	END
	ELSE
	BEGIN
		SET NOCOUNT ON
		
		UPDATE APR_CTTCANDIDATO
		SET     Nome = @Nome,
    Rg = @Rg,
    EstadoCivil = @EstadoCivil,
    EstaTrabalhando = @EstaTrabalhando,
    IDADE = @IDADE,
    CPF = @CPF,
    FEEDBACK = @FEEDBACK,
    COMENTARIO = @COMENTARIO 
		WHERE     CodigoAutomatico = @CodigoAutomatico
		
		SET NOCOUNT OFF
	
		SELECT * FROM APR_CTTCANDIDATO WHERE CodigoAutomatico = @CodigoAutomatico
	END

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_Del_APR_CTTCANDIDATO
'| Descrição: Exclui registros da tabela APR_CTTCANDIDATO
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_Del_APR_CTTCANDIDATO 
(
	@CodigoAutomatico INT
)
AS
	SET NOCOUNT ON
	
	DELETE FROM APR_CTTCANDIDATO
	WHERE CodigoAutomatico = @CodigoAutomatico
	
	SET NOCOUNT OFF

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_Get_APR_CTTCANDIDATO
'| Descrição: Recupera um registro da a tabela APR_CTTCANDIDATO
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_Get_APR_CTTCANDIDATO 
(
	@CodigoAutomatico INT
)
AS
	SET NOCOUNT ON
	
	SELECT Nome
,Rg
,EstadoCivil
,EstaTrabalhando
,IDADE
,CPF
,FEEDBACK
,COMENTARIO
, CodigoAutomatico, CodigoUsuario, GUID, ParentGUID
	FROM APR_CTTCANDIDATO
	WHERE CodigoAutomatico = @CodigoAutomatico
	
	SET NOCOUNT OFF

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_List_APR_CTTCANDIDATO
'| Descrição: Lista registros da a tabela APR_CTTCANDIDATO
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_List_APR_CTTCANDIDATO AS
	
	SELECT     Nome,    Rg,    EstadoCivil,    EstaTrabalhando,    IDADE,    CPF,    FEEDBACK,    COMENTARIO, CodigoAutomatico, CodigoUsuario
	FROM APR_CTTCANDIDATO

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_GetByParent_APR_CTTCANDIDATO
'| Descrição: Recupera os registros filhos da tabela APR_CTTCANDIDATO
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_GetByParent_APR_CTTCANDIDATO 
(
	@ParentGUID VARCHAR(36)
)
AS
	SET NOCOUNT ON
	
	SELECT CodigoAutomatico,CodigoUsuario,GUID,ParentGUID,Nome
,Rg
,EstadoCivil
,EstaTrabalhando
,IDADE
,CPF
,FEEDBACK
,COMENTARIO

	FROM APR_CTTCANDIDATO
	WHERE ParentGUID = @ParentGUID
	
	SET NOCOUNT OFF