

IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[APR_CTTVAGA]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
	
	DECLARE @TMPTABLE TABLE (TMP_C_NAME NVARCHAR(128))
	CREATE TABLE #TempResult(TMP_C_NAME NVARCHAR(128))
	INSERT INTO @TMPTABLE SELECT NAME FROM SYSCOLUMNS WHERE ID = OBJECT_ID(N'[APR_CTTVAGA]')

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='TituloVaga')
		ALTER TABLE APR_CTTVAGA ADD TituloVaga nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_CTTVAGA ALTER COLUMN TituloVaga nVarChar(100) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='Departamento')
		ALTER TABLE APR_CTTVAGA ADD Departamento nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_CTTVAGA ALTER COLUMN Departamento nVarChar(100) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='Perfil')
		ALTER TABLE APR_CTTVAGA ADD Perfil nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_CTTVAGA ALTER COLUMN Perfil nVarChar(100) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='Nivel')
		ALTER TABLE APR_CTTVAGA ADD Nivel nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_CTTVAGA ALTER COLUMN Nivel nVarChar(100) NULL

	DROP TABLE #TempResult

END
ELSE
BEGIN
	CREATE TABLE APR_CTTVAGA (CodigoAutomatico INT IDENTITY(1,1) PRIMARY KEY CLUSTERED, CodigoUsuario INT, GUID VARCHAR(36) NULL, ParentGUID VARCHAR(36) NULL)
	
	ALTER TABLE APR_CTTVAGA ADD TituloVaga nVarChar(100) NULL


	ALTER TABLE APR_CTTVAGA ADD Departamento nVarChar(100) NULL


	ALTER TABLE APR_CTTVAGA ADD Perfil nVarChar(100) NULL


	ALTER TABLE APR_CTTVAGA ADD Nivel nVarChar(100) NULL


END

IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_Save_APR_CTTVAGA]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_Save_APR_CTTVAGA]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_Del_APR_CTTVAGA]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_Del_APR_CTTVAGA]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_List_APR_CTTVAGA]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_List_APR_CTTVAGA]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_Get_APR_CTTVAGA]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_Get_APR_CTTVAGA]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_GetByParent_APR_CTTVAGA]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_GetByParent_APR_CTTVAGA]

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_Save_APR_CTTVAGA
'| Descrição: Adiciona registros para a tabela APR_CTTVAGA
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_Save_APR_CTTVAGA 
(
	@CodigoAutomatico INT,
	@CodigoUsuario INT,
	@GUID VARCHAR(36),
	@ParentGUID VARCHAR(36) = NULL,
    @TituloVaga    nVarChar(100),
    @Departamento    nVarChar(100),
    @Perfil    nVarChar(100),
    @Nivel    nVarChar(100)
)
AS
	IF @CodigoAutomatico = 0
	BEGIN
		SET NOCOUNT ON
		
		INSERT INTO APR_CTTVAGA
		(GUID, ParentGUID, CodigoUsuario,
    TituloVaga,
    Departamento,
    Perfil,
    Nivel)
		VALUES
		(@GUID, @ParentGUID, @CodigoUsuario,
    @TituloVaga,
    @Departamento,
    @Perfil,
    @Nivel)
		
		SET NOCOUNT OFF
		
		SELECT * FROM APR_CTTVAGA WHERE CodigoAutomatico = @@IDENTITY
	END
	ELSE
	BEGIN
		SET NOCOUNT ON
		
		UPDATE APR_CTTVAGA
		SET     TituloVaga = @TituloVaga,
    Departamento = @Departamento,
    Perfil = @Perfil,
    Nivel = @Nivel 
		WHERE     CodigoAutomatico = @CodigoAutomatico
		
		SET NOCOUNT OFF
	
		SELECT * FROM APR_CTTVAGA WHERE CodigoAutomatico = @CodigoAutomatico
	END

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_Del_APR_CTTVAGA
'| Descrição: Exclui registros da tabela APR_CTTVAGA
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_Del_APR_CTTVAGA 
(
	@CodigoAutomatico INT
)
AS
	SET NOCOUNT ON
	
	DELETE FROM APR_CTTVAGA
	WHERE CodigoAutomatico = @CodigoAutomatico
	
	SET NOCOUNT OFF

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_Get_APR_CTTVAGA
'| Descrição: Recupera um registro da a tabela APR_CTTVAGA
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_Get_APR_CTTVAGA 
(
	@CodigoAutomatico INT
)
AS
	SET NOCOUNT ON
	
	SELECT TituloVaga
,Departamento
,Perfil
,Nivel
, CodigoAutomatico, CodigoUsuario, GUID, ParentGUID
	FROM APR_CTTVAGA
	WHERE CodigoAutomatico = @CodigoAutomatico
	
	SET NOCOUNT OFF

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_List_APR_CTTVAGA
'| Descrição: Lista registros da a tabela APR_CTTVAGA
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_List_APR_CTTVAGA AS
	
	SELECT     TituloVaga,    Departamento,    Perfil,    Nivel, CodigoAutomatico, CodigoUsuario
	FROM APR_CTTVAGA

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_GetByParent_APR_CTTVAGA
'| Descrição: Recupera os registros filhos da tabela APR_CTTVAGA
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_GetByParent_APR_CTTVAGA 
(
	@ParentGUID VARCHAR(36)
)
AS
	SET NOCOUNT ON
	
	SELECT CodigoAutomatico,CodigoUsuario,GUID,ParentGUID,TituloVaga
,Departamento
,Perfil
,Nivel

	FROM APR_CTTVAGA
	WHERE ParentGUID = @ParentGUID
	
	SET NOCOUNT OFF