

IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[APR_PEDCLI]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
	
	DECLARE @TMPTABLE TABLE (TMP_C_NAME NVARCHAR(128))
	CREATE TABLE #TempResult(TMP_C_NAME NVARCHAR(128))
	INSERT INTO @TMPTABLE SELECT NAME FROM SYSCOLUMNS WHERE ID = OBJECT_ID(N'[APR_PEDCLI]')

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='NOME')
		ALTER TABLE APR_PEDCLI ADD NOME nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_PEDCLI ALTER COLUMN NOME nVarChar(100) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='CONTATO')
		ALTER TABLE APR_PEDCLI ADD CONTATO nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_PEDCLI ALTER COLUMN CONTATO nVarChar(100) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='TELEFONE')
		ALTER TABLE APR_PEDCLI ADD TELEFONE nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_PEDCLI ALTER COLUMN TELEFONE nVarChar(100) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='EMAIL')
		ALTER TABLE APR_PEDCLI ADD EMAIL nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_PEDCLI ALTER COLUMN EMAIL nVarChar(100) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='ENDERECO')
		ALTER TABLE APR_PEDCLI ADD ENDERECO nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_PEDCLI ALTER COLUMN ENDERECO nVarChar(100) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='CNPJ')
		ALTER TABLE APR_PEDCLI ADD CNPJ nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_PEDCLI ALTER COLUMN CNPJ nVarChar(100) NULL

	DROP TABLE #TempResult

END
ELSE
BEGIN
	CREATE TABLE APR_PEDCLI (CodigoAutomatico INT IDENTITY(1,1) PRIMARY KEY CLUSTERED, CodigoUsuario INT, GUID VARCHAR(36) NULL, ParentGUID VARCHAR(36) NULL)
	
	ALTER TABLE APR_PEDCLI ADD NOME nVarChar(100) NULL


	ALTER TABLE APR_PEDCLI ADD CONTATO nVarChar(100) NULL


	ALTER TABLE APR_PEDCLI ADD TELEFONE nVarChar(100) NULL


	ALTER TABLE APR_PEDCLI ADD EMAIL nVarChar(100) NULL


	ALTER TABLE APR_PEDCLI ADD ENDERECO nVarChar(100) NULL


	ALTER TABLE APR_PEDCLI ADD CNPJ nVarChar(100) NULL


END

IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_Save_APR_PEDCLI]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_Save_APR_PEDCLI]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_Del_APR_PEDCLI]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_Del_APR_PEDCLI]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_List_APR_PEDCLI]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_List_APR_PEDCLI]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_Get_APR_PEDCLI]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_Get_APR_PEDCLI]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_GetByParent_APR_PEDCLI]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_GetByParent_APR_PEDCLI]

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_Save_APR_PEDCLI
'| Descrição: Adiciona registros para a tabela APR_PEDCLI
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_Save_APR_PEDCLI 
(
	@CodigoAutomatico INT,
	@CodigoUsuario INT,
	@GUID VARCHAR(36),
	@ParentGUID VARCHAR(36) = NULL,
    @NOME    nVarChar(100),
    @CONTATO    nVarChar(100),
    @TELEFONE    nVarChar(100),
    @EMAIL    nVarChar(100),
    @ENDERECO    nVarChar(100),
    @CNPJ    nVarChar(100)
)
AS
	IF @CodigoAutomatico = 0
	BEGIN
		SET NOCOUNT ON
		
		INSERT INTO APR_PEDCLI
		(GUID, ParentGUID, CodigoUsuario,
    NOME,
    CONTATO,
    TELEFONE,
    EMAIL,
    ENDERECO,
    CNPJ)
		VALUES
		(@GUID, @ParentGUID, @CodigoUsuario,
    @NOME,
    @CONTATO,
    @TELEFONE,
    @EMAIL,
    @ENDERECO,
    @CNPJ)
		
		SET NOCOUNT OFF
		
		SELECT * FROM APR_PEDCLI WHERE CodigoAutomatico = @@IDENTITY
	END
	ELSE
	BEGIN
		SET NOCOUNT ON
		
		UPDATE APR_PEDCLI
		SET     NOME = @NOME,
    CONTATO = @CONTATO,
    TELEFONE = @TELEFONE,
    EMAIL = @EMAIL,
    ENDERECO = @ENDERECO,
    CNPJ = @CNPJ 
		WHERE     CodigoAutomatico = @CodigoAutomatico
		
		SET NOCOUNT OFF
	
		SELECT * FROM APR_PEDCLI WHERE CodigoAutomatico = @CodigoAutomatico
	END

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_Del_APR_PEDCLI
'| Descrição: Exclui registros da tabela APR_PEDCLI
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_Del_APR_PEDCLI 
(
	@CodigoAutomatico INT
)
AS
	SET NOCOUNT ON
	
	DELETE FROM APR_PEDCLI
	WHERE CodigoAutomatico = @CodigoAutomatico
	
	SET NOCOUNT OFF

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_Get_APR_PEDCLI
'| Descrição: Recupera um registro da a tabela APR_PEDCLI
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_Get_APR_PEDCLI 
(
	@CodigoAutomatico INT
)
AS
	SET NOCOUNT ON
	
	SELECT NOME
,CONTATO
,TELEFONE
,EMAIL
,ENDERECO
,CNPJ
, CodigoAutomatico, CodigoUsuario, GUID, ParentGUID
	FROM APR_PEDCLI
	WHERE CodigoAutomatico = @CodigoAutomatico
	
	SET NOCOUNT OFF

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_List_APR_PEDCLI
'| Descrição: Lista registros da a tabela APR_PEDCLI
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_List_APR_PEDCLI AS
	
	SELECT     NOME,    CONTATO,    TELEFONE,    EMAIL,    ENDERECO,    CNPJ, CodigoAutomatico, CodigoUsuario
	FROM APR_PEDCLI

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_GetByParent_APR_PEDCLI
'| Descrição: Recupera os registros filhos da tabela APR_PEDCLI
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_GetByParent_APR_PEDCLI 
(
	@ParentGUID VARCHAR(36)
)
AS
	SET NOCOUNT ON
	
	SELECT CodigoAutomatico,CodigoUsuario,GUID,ParentGUID,NOME
,CONTATO
,TELEFONE
,EMAIL
,ENDERECO
,CNPJ

	FROM APR_PEDCLI
	WHERE ParentGUID = @ParentGUID
	
	SET NOCOUNT OFF