

IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[APR_RDVJUS]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
	
	DECLARE @TMPTABLE TABLE (TMP_C_NAME NVARCHAR(128))
	CREATE TABLE #TempResult(TMP_C_NAME NVARCHAR(128))
	INSERT INTO @TMPTABLE SELECT NAME FROM SYSCOLUMNS WHERE ID = OBJECT_ID(N'[APR_RDVJUS]')

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='Justificativa')
		ALTER TABLE APR_RDVJUS ADD Justificativa nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_RDVJUS ALTER COLUMN Justificativa nVarChar(100) NULL

	DROP TABLE #TempResult

END
ELSE
BEGIN
	CREATE TABLE APR_RDVJUS (CodigoAutomatico INT IDENTITY(1,1) PRIMARY KEY CLUSTERED, CodigoUsuario INT, GUID VARCHAR(36) NULL, ParentGUID VARCHAR(36) NULL)
	
	ALTER TABLE APR_RDVJUS ADD Justificativa nVarChar(100) NULL


END

IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_Save_APR_RDVJUS]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_Save_APR_RDVJUS]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_Del_APR_RDVJUS]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_Del_APR_RDVJUS]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_List_APR_RDVJUS]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_List_APR_RDVJUS]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_Get_APR_RDVJUS]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_Get_APR_RDVJUS]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_GetByParent_APR_RDVJUS]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_GetByParent_APR_RDVJUS]

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_Save_APR_RDVJUS
'| Descrição: Adiciona registros para a tabela APR_RDVJUS
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_Save_APR_RDVJUS 
(
	@CodigoAutomatico INT,
	@CodigoUsuario INT,
	@GUID VARCHAR(36),
	@ParentGUID VARCHAR(36) = NULL,
    @Justificativa    nVarChar(100)
)
AS
	IF @CodigoAutomatico = 0
	BEGIN
		SET NOCOUNT ON
		
		INSERT INTO APR_RDVJUS
		(GUID, ParentGUID, CodigoUsuario,
    Justificativa)
		VALUES
		(@GUID, @ParentGUID, @CodigoUsuario,
    @Justificativa)
		
		SET NOCOUNT OFF
		
		SELECT * FROM APR_RDVJUS WHERE CodigoAutomatico = @@IDENTITY
	END
	ELSE
	BEGIN
		SET NOCOUNT ON
		
		UPDATE APR_RDVJUS
		SET     Justificativa = @Justificativa 
		WHERE     CodigoAutomatico = @CodigoAutomatico
		
		SET NOCOUNT OFF
	
		SELECT * FROM APR_RDVJUS WHERE CodigoAutomatico = @CodigoAutomatico
	END

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_Del_APR_RDVJUS
'| Descrição: Exclui registros da tabela APR_RDVJUS
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_Del_APR_RDVJUS 
(
	@CodigoAutomatico INT
)
AS
	SET NOCOUNT ON
	
	DELETE FROM APR_RDVJUS
	WHERE CodigoAutomatico = @CodigoAutomatico
	
	SET NOCOUNT OFF

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_Get_APR_RDVJUS
'| Descrição: Recupera um registro da a tabela APR_RDVJUS
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_Get_APR_RDVJUS 
(
	@CodigoAutomatico INT
)
AS
	SET NOCOUNT ON
	
	SELECT Justificativa
, CodigoAutomatico, CodigoUsuario, GUID, ParentGUID
	FROM APR_RDVJUS
	WHERE CodigoAutomatico = @CodigoAutomatico
	
	SET NOCOUNT OFF

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_List_APR_RDVJUS
'| Descrição: Lista registros da a tabela APR_RDVJUS
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_List_APR_RDVJUS AS
	
	SELECT     Justificativa, CodigoAutomatico, CodigoUsuario
	FROM APR_RDVJUS

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_GetByParent_APR_RDVJUS
'| Descrição: Recupera os registros filhos da tabela APR_RDVJUS
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_GetByParent_APR_RDVJUS 
(
	@ParentGUID VARCHAR(36)
)
AS
	SET NOCOUNT ON
	
	SELECT CodigoAutomatico,CodigoUsuario,GUID,ParentGUID,Justificativa

	FROM APR_RDVJUS
	WHERE ParentGUID = @ParentGUID
	
	SET NOCOUNT OFF