

IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[APR_RDVSOLIC]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
	
	DECLARE @TMPTABLE TABLE (TMP_C_NAME NVARCHAR(128))
	CREATE TABLE #TempResult(TMP_C_NAME NVARCHAR(128))
	INSERT INTO @TMPTABLE SELECT NAME FROM SYSCOLUMNS WHERE ID = OBJECT_ID(N'[APR_RDVSOLIC]')

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='Solicitante')
		ALTER TABLE APR_RDVSOLIC ADD Solicitante nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_RDVSOLIC ALTER COLUMN Solicitante nVarChar(100) NULL

	DROP TABLE #TempResult

END
ELSE
BEGIN
	CREATE TABLE APR_RDVSOLIC (CodigoAutomatico INT IDENTITY(1,1) PRIMARY KEY CLUSTERED, CodigoUsuario INT, GUID VARCHAR(36) NULL, ParentGUID VARCHAR(36) NULL)
	
	ALTER TABLE APR_RDVSOLIC ADD Solicitante nVarChar(100) NULL


END

IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_Save_APR_RDVSOLIC]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_Save_APR_RDVSOLIC]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_Del_APR_RDVSOLIC]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_Del_APR_RDVSOLIC]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_List_APR_RDVSOLIC]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_List_APR_RDVSOLIC]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_Get_APR_RDVSOLIC]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_Get_APR_RDVSOLIC]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_GetByParent_APR_RDVSOLIC]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_GetByParent_APR_RDVSOLIC]

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_Save_APR_RDVSOLIC
'| Descrição: Adiciona registros para a tabela APR_RDVSOLIC
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_Save_APR_RDVSOLIC 
(
	@CodigoAutomatico INT,
	@CodigoUsuario INT,
	@GUID VARCHAR(36),
	@ParentGUID VARCHAR(36) = NULL,
    @Solicitante    nVarChar(100)
)
AS
	IF @CodigoAutomatico = 0
	BEGIN
		SET NOCOUNT ON
		
		INSERT INTO APR_RDVSOLIC
		(GUID, ParentGUID, CodigoUsuario,
    Solicitante)
		VALUES
		(@GUID, @ParentGUID, @CodigoUsuario,
    @Solicitante)
		
		SET NOCOUNT OFF
		
		SELECT * FROM APR_RDVSOLIC WHERE CodigoAutomatico = @@IDENTITY
	END
	ELSE
	BEGIN
		SET NOCOUNT ON
		
		UPDATE APR_RDVSOLIC
		SET     Solicitante = @Solicitante 
		WHERE     CodigoAutomatico = @CodigoAutomatico
		
		SET NOCOUNT OFF
	
		SELECT * FROM APR_RDVSOLIC WHERE CodigoAutomatico = @CodigoAutomatico
	END

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_Del_APR_RDVSOLIC
'| Descrição: Exclui registros da tabela APR_RDVSOLIC
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_Del_APR_RDVSOLIC 
(
	@CodigoAutomatico INT
)
AS
	SET NOCOUNT ON
	
	DELETE FROM APR_RDVSOLIC
	WHERE CodigoAutomatico = @CodigoAutomatico
	
	SET NOCOUNT OFF

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_Get_APR_RDVSOLIC
'| Descrição: Recupera um registro da a tabela APR_RDVSOLIC
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_Get_APR_RDVSOLIC 
(
	@CodigoAutomatico INT
)
AS
	SET NOCOUNT ON
	
	SELECT Solicitante
, CodigoAutomatico, CodigoUsuario, GUID, ParentGUID
	FROM APR_RDVSOLIC
	WHERE CodigoAutomatico = @CodigoAutomatico
	
	SET NOCOUNT OFF

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_List_APR_RDVSOLIC
'| Descrição: Lista registros da a tabela APR_RDVSOLIC
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_List_APR_RDVSOLIC AS
	
	SELECT     Solicitante, CodigoAutomatico, CodigoUsuario
	FROM APR_RDVSOLIC

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_GetByParent_APR_RDVSOLIC
'| Descrição: Recupera os registros filhos da tabela APR_RDVSOLIC
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_GetByParent_APR_RDVSOLIC 
(
	@ParentGUID VARCHAR(36)
)
AS
	SET NOCOUNT ON
	
	SELECT CodigoAutomatico,CodigoUsuario,GUID,ParentGUID,Solicitante

	FROM APR_RDVSOLIC
	WHERE ParentGUID = @ParentGUID
	
	SET NOCOUNT OFF