

IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[APR_RDVITEM]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
	
	DECLARE @TMPTABLE TABLE (TMP_C_NAME NVARCHAR(128))
	CREATE TABLE #TempResult(TMP_C_NAME NVARCHAR(128))
	INSERT INTO @TMPTABLE SELECT NAME FROM SYSCOLUMNS WHERE ID = OBJECT_ID(N'[APR_RDVITEM]')

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='CentroCusto')
		ALTER TABLE APR_RDVITEM ADD CentroCusto nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_RDVITEM ALTER COLUMN CentroCusto nVarChar(100) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='Cliente')
		ALTER TABLE APR_RDVITEM ADD Cliente nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_RDVITEM ALTER COLUMN Cliente nVarChar(100) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='TipoCusto')
		ALTER TABLE APR_RDVITEM ADD TipoCusto nVarChar(100) NULL
	ELSE
		ALTER TABLE APR_RDVITEM ALTER COLUMN TipoCusto nVarChar(100) NULL

	IF NOT EXISTS (SELECT TMP_C_NAME FROM @TMPTABLE WHERE TMP_C_NAME='Valor')
		ALTER TABLE APR_RDVITEM ADD Valor Decimal (16,2) NULL
	ELSE
		ALTER TABLE APR_RDVITEM ALTER COLUMN Valor Decimal (16,2) NULL

	DROP TABLE #TempResult

END
ELSE
BEGIN
	CREATE TABLE APR_RDVITEM (CodigoAutomatico INT IDENTITY(1,1) PRIMARY KEY CLUSTERED, CodigoUsuario INT, GUID VARCHAR(36) NULL, ParentGUID VARCHAR(36) NULL)
	
	ALTER TABLE APR_RDVITEM ADD CentroCusto nVarChar(100) NULL


	ALTER TABLE APR_RDVITEM ADD Cliente nVarChar(100) NULL


	ALTER TABLE APR_RDVITEM ADD TipoCusto nVarChar(100) NULL


	ALTER TABLE APR_RDVITEM ADD Valor Decimal (16,2) NULL


END

IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_Save_APR_RDVITEM]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_Save_APR_RDVITEM]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_Del_APR_RDVITEM]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_Del_APR_RDVITEM]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_List_APR_RDVITEM]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_List_APR_RDVITEM]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_Get_APR_RDVITEM]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_Get_APR_RDVITEM]
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[fd_GetByParent_APR_RDVITEM]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [fd_GetByParent_APR_RDVITEM]

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_Save_APR_RDVITEM
'| Descrição: Adiciona registros para a tabela APR_RDVITEM
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_Save_APR_RDVITEM 
(
	@CodigoAutomatico INT,
	@CodigoUsuario INT,
	@GUID VARCHAR(36),
	@ParentGUID VARCHAR(36) = NULL,
    @CentroCusto    nVarChar(100),
    @Cliente    nVarChar(100),
    @TipoCusto    nVarChar(100),
    @Valor    Decimal(16,2)
)
AS
	IF @CodigoAutomatico = 0
	BEGIN
		SET NOCOUNT ON
		
		INSERT INTO APR_RDVITEM
		(GUID, ParentGUID, CodigoUsuario,
    CentroCusto,
    Cliente,
    TipoCusto,
    Valor)
		VALUES
		(@GUID, @ParentGUID, @CodigoUsuario,
    @CentroCusto,
    @Cliente,
    @TipoCusto,
    @Valor)
		
		SET NOCOUNT OFF
		
		SELECT * FROM APR_RDVITEM WHERE CodigoAutomatico = @@IDENTITY
	END
	ELSE
	BEGIN
		SET NOCOUNT ON
		
		UPDATE APR_RDVITEM
		SET     CentroCusto = @CentroCusto,
    Cliente = @Cliente,
    TipoCusto = @TipoCusto,
    Valor = @Valor 
		WHERE     CodigoAutomatico = @CodigoAutomatico
		
		SET NOCOUNT OFF
	
		SELECT * FROM APR_RDVITEM WHERE CodigoAutomatico = @CodigoAutomatico
	END

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_Del_APR_RDVITEM
'| Descrição: Exclui registros da tabela APR_RDVITEM
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_Del_APR_RDVITEM 
(
	@CodigoAutomatico INT
)
AS
	SET NOCOUNT ON
	
	DELETE FROM APR_RDVITEM
	WHERE CodigoAutomatico = @CodigoAutomatico
	
	SET NOCOUNT OFF

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_Get_APR_RDVITEM
'| Descrição: Recupera um registro da a tabela APR_RDVITEM
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_Get_APR_RDVITEM 
(
	@CodigoAutomatico INT
)
AS
	SET NOCOUNT ON
	
	SELECT CentroCusto
,Cliente
,TipoCusto
,Valor
, CodigoAutomatico, CodigoUsuario, GUID, ParentGUID
	FROM APR_RDVITEM
	WHERE CodigoAutomatico = @CodigoAutomatico
	
	SET NOCOUNT OFF

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_List_APR_RDVITEM
'| Descrição: Lista registros da a tabela APR_RDVITEM
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_List_APR_RDVITEM AS
	
	SELECT     CentroCusto,    Cliente,    TipoCusto,    Valor, CodigoAutomatico, CodigoUsuario
	FROM APR_RDVITEM

/*
'+-----------------------------------------------------------------------------
'| Procedure: fd_GetByParent_APR_RDVITEM
'| Descrição: Recupera os registros filhos da tabela APR_RDVITEM
'| Data Criação: 03/08/2017
'| Data Últ. Modificação: 
'| Responsável: Forms 2005
'+-----------------------------------------------------------------------------
*/

CREATE PROCEDURE fd_GetByParent_APR_RDVITEM 
(
	@ParentGUID VARCHAR(36)
)
AS
	SET NOCOUNT ON
	
	SELECT CodigoAutomatico,CodigoUsuario,GUID,ParentGUID,CentroCusto
,Cliente
,TipoCusto
,Valor

	FROM APR_RDVITEM
	WHERE ParentGUID = @ParentGUID
	
	SET NOCOUNT OFF