﻿const DELTA_TIME_THRESHOLD_MS = 700;
var dblClickTimer = null;
var clickTarget = null;
function debounce(func, timeout = 300) {
    let timer;
    return (...args) => {
        clearTimeout(timer);
        timer = setTimeout(() => { func.apply(this, args); }, timeout);
    };
}

function mobileClick(e, cb) {
    if (window.matchMedia("(pointer: coarse)").matches) {
        cb();
    }
}

function mobileClickAvoidInputs(e, cb) {
    if (window.matchMedia("(pointer: coarse)").matches && e.target.tagName.toUpperCase() != 'INPUT' && e.target.tagName.toUpperCase() != 'SELECT' && e.target.tagName.toUpperCase() != 'A') {
        cb();
    }
}

function touchbleDblClick(e, onSingleTap, onDoubleTap) {
    if (window.matchMedia("(pointer: coarse)").matches) {
        if (dblClickTimer == null) {
            // First tap
            console.log("first tap")
            onSingleTap?.();

            dblClickTimer = setTimeout(() => {
                dblClickTimer = null;
            }, DELTA_TIME_THRESHOLD_MS);
        } else {
            // Second tap
            console.log("second tap")
            if (e.target === clickTarget) {
                onDoubleTap?.();
            }

            clearTimeout(dblClickTimer);
            dblClickTimer = null;
        }
        clickTarget = e.target;
    }

}