﻿const toasterController = {
    /**
     * Função que renderiza toasters na tela
     * @param {string} title Título do toaster
     * @param {string} message Mensagem que será mostrada no toaster
     * @param {number} autohidetime Mensagem que será mostrada no toaster
     * @param {('success'|'error')} [type='success'] Tipo do toaster.
     * @param {boolean} autohide Habilita/desabilita a feature de esconder o toaster automaticamente
     * @param {number} autohidetime Tempo que leva para esconder o toaster
     * @param {string} container Seletor do elemento que servirá de container para os toaster, esse elemento deve ter o atributo css positirion:relative
     * 
     * @returns {Element} Retorna o elemento do toaster criado
     */
    launch: function (title, message, type = 'success', autohide = true, autohidetime = 3000, container = null) {
        const containerElement = document.querySelector(container ?? 'body');
        let toasterContainer = containerElement.querySelector('.toaster-container');
        // container de listagem de toast
        if (!toasterContainer) {
            toasterContainer = document.createElement('div');
            toasterContainer.classList.add('toaster-container');
            containerElement.appendChild(toasterContainer);
        }
        //toast
        const toaster = document.createElement('div');
        toaster.classList.add('toaster', type);

        //toast header
        const toastheader = document.createElement('div');
        toastheader.classList.add('toast-header');
        const disposerButton = document.createElement('button');
        disposerButton.classList.add('icon-button');
        const toastdisposer = document.createElement('i');
        toastdisposer.setAttribute('data-feather', 'x');
        disposerButton.addEventListener('click', e => {
            e.preventDefault();
            this.removeToaster(toaster);
        })
        disposerButton.appendChild(toastdisposer);
        toastheader.appendChild(disposerButton);

        //toast body
        const toastbody = document.createElement('div');
        toastbody.classList.add('toast-body');
        const infoicon = document.createElement('i');
        infoicon.classList.add('info-icon');
        infoicon.setAttribute('data-feather', type == 'success' ? 'check-square' : 'alert-circle');
        toastbody.appendChild(infoicon);

        const toastcontentcontainer = document.createElement('div');
        const toasttitle = document.createElement('h5');
        toasttitle.innerHTML = title;
        toastcontentcontainer.appendChild(toasttitle);
        const toastmessage = document.createElement('p');
        toastmessage.innerHTML = message;
        toastcontentcontainer.appendChild(toastmessage);
        toastbody.appendChild(toastcontentcontainer);


        //adiciona tudo junto
        toaster.appendChild(toastheader);
        toaster.appendChild(toastbody);
        toasterContainer.appendChild(toaster);
        feather?.replace();

        if (autohide) {
            setTimeout(() => {
                toaster.classList.add('close');
                this.removeToaster(toaster);
            }, autohidetime);
        }
        return toaster;
    },
    /**
     * Função que limpa todos os toasters da tela
     * @param {string} container Seletor do elemento que servirá de container para os toaster, esse elemento deve ter o atributo css positirion:relative
     */
    clearToasters: function (container = null) {
        const containerElement = document.querySelector(container ?? 'body');
        let toasterContainer = containerElement.querySelector('.toaster-container');
        toasterContainer?.remove();
    },
    /**
    * Função que remove um toaster em específico da tela
    * @param {Element} toaster Elemento do toaster que será removido da tela
    */
    removeToaster: function (toaster) {
        toaster.classList.add('close');
        setTimeout(() => {
            toaster.remove();
        }, 500);
    }
}