﻿var tabSystem = {
    page: 1,
    init: function () {
        this.page = 1;
        this.render();
    },
    getPage: function () {
        return this.page;
    },
    setPage: function (page) {
        this.page = page;
        this.render();
    },
    nextPage: function () {
        this.setPage(this.page + 1);
    },
    backPage: function () {
        this.setPage(this.page - 1);
    },
    render: function () {
        document.querySelector(`li[data-link].active`)?.classList.remove('active');
        document.querySelector(`.page[data-page].active`)?.classList.remove('active');
        document.querySelector(`li[data-link="${this.page}"]`).classList.add('active');
        document.querySelector(`.page[data-page="${this.page}"]`).classList.add('active');
    },
    enableTabs: function () {
        document.querySelector('.tab-links').classList.add('hoverable');
        document.querySelectorAll('.tab-links li[data-link]').forEach(link => {
            link.addEventListener('click', (e) => {
                e.preventDefault();
                tabSystem.setPage(Number(link.getAttribute('data-link')));
            })
        });
    },
    disableTabs: function () {
        const tabLinks = document.querySelector('.tab-links');
        tabLinks.classList.remove('hoverable');
        document.querySelectorAll('.tab-links li[data-link]').forEach(link => {
            let linkClone = link.cloneNode();
            linkClone.innerHTML = link.innerHTML;
            tabLinks.replaceChild(linkClone, link);
        });
    },
    enableSteps: function () {
        document.querySelector('.tab-links').classList.add('steps');
    },
    disableSteps: function () {
        document.querySelector('.tab-links').classList.remove('steps');
    },
    setStepDone: function (page) {
        const step = document.querySelector(`li[data-link="${page}"]`);
        step.classList.add('done');
    },
    cleanDoneSteps: function () {
        document.querySelectorAll('.tab-links li[data-link]').forEach(link => {
            link.classList.remove('done');
        });
    },
}