﻿/**
* Lib para input com busca:
* 
* Formato para uso:
* <div id="select-rule-search-input" class="input-with-search">
    <input class="text-search-input" data-render="search-input-text" type="text" name="rule-selector" />
    <div class="options">
        <div class="option">
            <input value="example" data-text="Example" type="checkbox"/>
            <label tabindex="0">Example</label>
        </div>
    </div>
  </div>
* 
* OBS: A busca fica desabilitada quando o argumento multiselect for verdadeiro
* */
const specialInputs = {
    inputWithSearch: {
        init: function (id, valueChangeCb) {
            const container = document.querySelector(`#${id}`);
            const inputBusca = container.querySelector(`input[data-render="search-input-text"]`);

            //define função de modificação do value
            const changeValue = (value, text) => {
                const input = container.querySelector('input[data-render="search-input-text"]');
                input.setAttribute('data-value', value);
                changeText(text);
                valueChangeCb(value);
            }

            //define função de modificação do texto
            const changeText = (text) => {
                const input = container.querySelector('input[data-render="search-input-text"]');
                input.value = text;
            }

            // adiciona click aos options
            const options = container.querySelectorAll('.options .option');
            let optionObjects = [];
            for (i = 0; i < options.length; i++) {
                optionObjects.push({
                    value: options[i].getAttribute('data-value'),
                    text: options[i].getAttribute('data-text')
                })
                options[i].setAttribute('tabindex', 0);
                options[i].addEventListener('click', (e) => {
                    changeValue(e.currentTarget.getAttribute('data-value'), e.currentTarget.getAttribute('data-text'));
                    document.activeElement.blur();
                })
            }

            inputBusca.addEventListener('input', (e) => {
                changeValue(e.target.value, e.target.value);
                const filterRegex = new RegExp(e.target.value.toLowerCase(), 'g');
                optionObjects.forEach(option => {
                    if (!option.text.toLowerCase().match(filterRegex)) {
                        container.querySelector(`.options .option[data-value="${option.value}"][data-text="${option.text}"]`).classList.add('hide');
                    } else {
                        container.querySelector(`.options .option[data-value="${option.value}"]`).classList.remove('hide');
                    }
                })
            });
            inputBusca.addEventListener('mousedown', (e) => {
                const options = e.target.parentNode.querySelector('.options');
                if (window.getComputedStyle(options, null).display == 'block') {
                    e.preventDefault();
                    document.activeElement.blur();
                }
            });
        }
    },
    multiSelect: {
        init: function (id, valueChangeCb) {

        },
        disableOptionsWithValues: function (id, values = []) {
            values.forEach(value => {
                document.querySelector(`#${id} .options .option input[value="${value}"]`).parentNode.classList.add('disabled');
            });
            const activeOptions = document.querySelectorAll(`#${id} .options .option:not(.disabled)`);
            if (activeOptions.length == 0) {
                document.querySelector(`#${id} input[data-render="search-input-text"]`).setAttribute('disabled', '');
            }
        },
        enableOptionsWithValues: function (id, values = []) {
            values.forEach(value => {
                document.querySelector(`#${id} .options .option input[value="${value}"]`).parentNode.classList.remove('disabled');
            });
            document.querySelector(`#${id} input[data-render="search-input-text"]`).removeAttribute('disabled');
        }
    },
    getValue: function (id) {
        return document.querySelector(`#${id} input[data-render="search-input-text"]`).getAttribute('data-value');
    },
    setValue: function (id, value, text) {
        const input = document.querySelector(`#${id} input[data-render="search-input-text"]`);
        input.setAttribute('data-value', value);
        input.value = text;
    },
    resetValue: function (id) {
        document.querySelector(`#${id} input[data-render="search-input-text"]`).value = '';
        document.querySelector(`#${id} input[data-render="search-input-text"]`).setAttribute('data-value', '');
        document.querySelectorAll(`#${id} .options .option input`).forEach(checkbox => {
            checkbox.checked = false;
        });
    },
}
// TODO: repassar o código abaixo e transferir o que for multiselect para a lib acima
//var inputWithSearch = {
//    init: function (id, valueChangeCb, multiselect = false) {
//        // adiciona eventos de foco e blur no input de busca
//        const container = document.querySelector(`#${id}`);
//        const inputBusca = container.querySelector(`input[data-render="search-input-text"]`);


//        //define função de modificação do value
//        const changeValue = (value, text) => {
//            const input = container.querySelector('input[data-render="search-input-text"]');
//            let currentValue = input.getAttribute('data-value') ?? '';
//            const newValue = (multiselect && currentValue != '') ? `${currentValue}-${value}` : value;
//            input.setAttribute('data-value', newValue);
//            valueChangeCb(newValue);
//            if (multiselect) {
//                const values = newValue.split('-');
//                if (values.length == 1) {
//                    changeText(text);
//                } else {
//                    changeText(`${values.length} selecionados`);
//                }
//            } else {
//                changeText(text);
//            }
//        }

//        // define função de remoção de valores
//        const removeValue = (value) => {
//            const input = container.querySelector('input[data-render="search-input-text"]');
//            let currentValue = input.getAttribute('data-value');
//            let values = currentValue.split('-');
//            values = values.filter(v => v != value);
//            input.setAttribute('data-value', values.join('-'));
//            valueChangeCb(values.join('-'));
//            if (values.length == 0) {
//                changeText("");
//            } else if (values.length == 1) {
//                changeText(container.querySelector(`.options .option input[value="${values[0]}"]`).getAttribute('data-text'));
//            } else {
//                changeText(`${values.length} selecionados`);
//            }
//        }

//        //define função de modificação do texto
//        const changeText = (text) => {
//            const input = container.querySelector('input[data-render="search-input-text"]');
//            input.value = text;
//        }

//        // adiciona click aos options
//        const options = container.querySelectorAll('.options .option');
//        let optionObjects = [];
//        for (i = 0; i < options.length; i++) {
//            optionObjects.push({
//                value: options[i].querySelector('input').value,
//                text: options[i].querySelector('input').getAttribute('data-text')
//            })
//            options[i].querySelector('label').setAttribute('tabindex', 0);
//            options[i].addEventListener('input', (e) => {
//                const modifiedValue = e.target.value;
//                if (e.target.checked) {
//                    changeValue(modifiedValue, e.target.getAttribute('data-text'));
//                } else {
//                    removeValue(modifiedValue);
//                }
//            })
//        }

//        if (!multiselect) {
//            inputBusca.addEventListener('input', (e) => {
//                changeValue('');
//                const filterRegex = new RegExp(e.target.value.toLowerCase(), 'g');
//                optionObjects.forEach(option => {
//                    if (!option.text.toLowerCase().match(filterRegex)) {
//                        container.querySelector(`.options input[data-value="${option.value}"]`).parentNode.classList.add('hide');
//                    } else {
//                        container.querySelector(`.options input[data-value="${option.value}"]`).parentNode.classList.remove('hide');
//                    }
//                })
//            });
//        } else {
//            // reconhece o mousedown no input de busca, e caso a listagem de opções esteja aparente, aplica o blur do elemento ativo atual, para remover o foco do input ou qualquer checkbox das options e fechar a lista de seleção
//            inputBusca.addEventListener('mousedown', (e) => {
//                const options = e.target.parentNode.querySelector('.options');
//                if (window.getComputedStyle(options, null).display == 'block') {
//                    e.preventDefault();
//                    document.activeElement.blur();
//                }
//            });
//            inputBusca.setAttribute('readonly', '');
//            container.classList.add('multiselect');
//        }
//    },
//    getValue: function (id) {
//        return document.querySelector(`#${id} input[data-render="search-input-text"]`).getAttribute('data-value');
//    },
//    resetValue: function (id) {
//        document.querySelector(`#${id} input[data-render="search-input-text"]`).value = '';
//        document.querySelector(`#${id} input[data-render="search-input-text"]`).setAttribute('data-value', '');
//        document.querySelectorAll(`#${id} .options .option input`).forEach(checkbox => {
//            checkbox.checked = false;
//        });
//    },
//    disableOptionsWithValues: function (id, values = []) {
//        values.forEach(value => {
//            document.querySelector(`#${id} .options .option input[value="${value}"]`).parentNode.classList.add('disabled');
//        });
//        const activeOptions = document.querySelectorAll(`#${id} .options .option:not(.disabled)`);
//        if (activeOptions.length == 0) {
//            document.querySelector(`#${id} input[data-render="search-input-text"]`).setAttribute('disabled', '');
//        }
//    },
//    enableOptionsWithValues: function (id, values = []) {
//        values.forEach(value => {
//            document.querySelector(`#${id} .options .option input[value="${value}"]`).parentNode.classList.remove('disabled');
//        });
//        document.querySelector(`#${id} input[data-render="search-input-text"]`).removeAttribute('disabled');
//    }
//}