﻿/**
 * O cookie de pagepicker hoje é constrído da seguinte forma: PagePicker=CurrentPortal=-1&CurrentArea=1&CurrentPage=0;
 * 
 * Essa lib serve para ler esse cookie do sistema e separar as devidas variáveis para leitura através de métodos get e possibilita a alteração desses cookies
 * */
const pagePickerCookieController = {
    CurrentPortal: null,
    CurrentArea: null,
    CurrentPage: null,
    init: function () {
        let pagepickercookie = cookieController.get('PagePicker');
        if (pagepickercookie) {
            pagepickercookie = pagepickercookie.split('&');
            pagepickercookie.forEach(cookiestring => {
                if (cookiestring) {
                    this[cookiestring.split('=')[0]] = cookiestring.split('=')[1];
                }
            })
        }
    },
    getCurrentPortal: function () {
        return this.CurrentPortal;
    },
    getCurrentArea: function () {
        return this.CurrentArea;
    },
    getCurrentPage: function () {
        return this.CurrentPage;
    },
    setCurrentPortal: function (value) {
        this.CurrentPortal = `${value}`;
        this.updateCookie();
    },
    setCurrentArea: function (value) {
        this.CurrentArea = `${value}`;
        this.updateCookie();
    },
    setCurrentPage: function (value) {
        this.CurrentPage = `${value}`;
        this.updateCookie();
    },
    updateCookie: function () {
        if ((this.CurrentPortal != null) && (this.CurrentArea != null) && (this.CurrentPage != null)) cookieController.set('PagePicker', `CurrentPortal=${this.CurrentPortal}&CurrentArea=${this.CurrentArea}&CurrentPage=${this.CurrentPage}`);
    }
}