﻿/**
 * Controlador dos modais, responsável por inicializar todos os modais que existirem na tela e fazer a conexão entre a view e o model dos modais.
 */
var modalController = {
    init: function () {
        const modais = document.querySelectorAll('.wf-modal');
        modais.length ?
            modalModel.init(Array.prototype.map.call(modais, modal => {
                if (modal.getAttribute('id')) {
                    return modal.getAttribute('id');
                } else {
                    console.log("Existem modais sem id");
                }
            }))
            :
            modalModel.init();
        modalView.init();
    },
    getModais: function () {
        return modalModel.getModais();
    },
    abrirModal: function (id) { // método para abrir o modal de forma programática
        modalView.abrirModal(`${id}-modal-container`)
    },
    closeModal: function (id) { // método para fechar o modal de forma programática
        modalView.fecharModal(`${id}-modal-container`)
    },
    changeModalTitle: function (id, title) {
        modalView.changeModalTitle(`${id}-modal-container`, title);
    },
    changeCloseModalMethod: function (id, method) { // método para personalizar o comportamento do botão de fechar e o comportamento do click na área externa do modal
        modalView.changeCloseModalMethod(`${id}-modal-container`, method);
    },
    disableModalDisposal: function (id) {
        modalView.disableModalDisposal(`${id}-modal-container`);
    },
    addClassToModalBody: function (id, customClass) {
        modalView.addClassToModalBody(`${id}-modal-container`, customClass)
    },
    removeClassFromModalBody: function (id, customClass) {
        modalView.removeClassFromModalBody(`${id}-modal-container`, customClass)
    },
}

/**
 * Estrutura responsável por armazenar e controlar as informações sobre os modais.
 */
var modalModel = {
    modais: [],
    init: function (initModais = []) {
        // filtra possíveis modais com id não definido.
        modais = initModais.filter(modal => modal);
    },
    setModais: function (newModais) {
        modais = newModais;
    },
    getModais: function () {
        return modais;
    }
}

/**
 * Artefato responsável por renderizar os modais.
 */
var modalView = {
    init: function () {
        const modais = modalController.getModais();
        modais.forEach(modal => {
            const modalElement = document.getElementById(modal);
            modalView.render(modal, modalElement, modalElement.getAttribute('data-title'));
            modalElement.remove();
        });
    },
    render: function (modal, modalElement, title) {
        const newId = `${modal}-modal-container`;
        const body = document.querySelector('body form:first-of-type');
        const openModalButtons = document.querySelectorAll(`*[data-modal=${modal}]`);

        // cria as estruturas do modal
        const modalContainer = document.createElement('div');
        const modalDispose = document.createElement('div');
        const modalCard = document.createElement('div');
        const modalHeader = document.createElement('div');
        const modalContentContainer = document.createElement('div');
        const modalTitle = document.createElement('h6');
        const headerButtonsContainer = document.createElement('div');
        const closeModalButton = document.createElement('button');
        const changeSizeModalButton = document.createElement('button');
        const closeModalIcon = document.createElement('i');
        const expandModalIcon = document.createElement('i');
        const shrinkModalIcon = document.createElement('i');

        // distribui as classes da estrutura do modal
        modalContainer.classList.add('wf-modal-container');
        modalDispose.classList.add('wf-modal-dispose');
        modalCard.classList.add('wf-modal');
        modalHeader.classList.add('modal-header');
        modalContentContainer.classList.add('modal-content-container');
        changeSizeModalButton.classList.add('change-size-button');
        closeModalButton.classList.add('close-modal');
        

        // distribui os atributos da estrutura do modal
        modalContainer.setAttribute('id', newId);
        closeModalIcon.setAttribute('data-feather', 'x');
        expandModalIcon.setAttribute('data-feather', 'maximize');
        shrinkModalIcon.setAttribute('data-feather', 'minimize');
        modalTitle.innerHTML = title ? title : '';

        // atribuição de features
        if (openModalButtons.length === 0) console.log(`Não existem elementos programados para abrir o modal ${modal}`)
        openModalButtons.forEach(openModalButton => {
            openModalButton.addEventListener('click', (e) => {
                e.preventDefault();
                modalView.abrirModal(newId);
            })
        })
        closeModalButton.addEventListener('click', (e) => {
            e.preventDefault();
            document.getElementById(newId).classList.remove('aberto');
        })
        changeSizeModalButton.addEventListener('click', (e) => {
            e.preventDefault();
            document.getElementById(newId).classList.toggle('maximized');
        });
        modalDispose.addEventListener('click', (e) => {
            e.preventDefault();
            document.getElementById(newId).classList.remove('aberto');
        })

        // montagem da estrutura:

        // conteúdo
        let childrenLength = modalElement.children.length;
        for (i = 0; i < childrenLength; i++) {
            modalContentContainer.appendChild(modalElement.children[0]);
        }


        // botões
        closeModalButton.appendChild(closeModalIcon);
        changeSizeModalButton.appendChild(expandModalIcon);
        changeSizeModalButton.appendChild(shrinkModalIcon);

        // header
        headerButtonsContainer.appendChild(changeSizeModalButton);
        headerButtonsContainer.appendChild(closeModalButton);
        modalHeader.appendChild(modalTitle);
        modalHeader.appendChild(headerButtonsContainer);

        // card principal
        modalCard.appendChild(modalHeader);
        modalCard.appendChild(modalContentContainer);

        // container
        modalContainer.appendChild(modalDispose);
        modalContainer.appendChild(modalCard);

        //adiciona o modal ao body
        if (body) {
            body.appendChild(modalContainer);
        } else {
            console.log("O funcionamento de modais está atrelado à existência de um form dentro do body");
        }

        // faz o replace dos ícones por SVGS
        feather.replace();
    },
    abrirModal: (id) => {
        document.getElementById(id).classList.add('aberto');
    },
    fecharModal: (id) => {
        document.getElementById(id).classList.remove('aberto');
    },
    changeModalTitle: (id, title) => {
        const modal = document.getElementById(id);
        modal.querySelector('.modal-header h6').innerHTML = title;
    },
    changeCloseModalMethod: (id, method) => {
        const modal = document.getElementById(id);
        const button = modal.querySelector('.modal-header button.close-modal');
        const newButton = button.cloneNode();
        newButton.innerHTML = button.innerHTML;
        newButton.addEventListener('click', method);
        modal.querySelector('.modal-header > div').replaceChild(newButton, button);
    },
    disableModalDisposal: (id) => {
        const modal = document.getElementById(id);
        const dispose = modal.querySelector('.wf-modal-dispose');
        modal.replaceChild(dispose.cloneNode(), dispose);
    },
    addClassToModalBody: (id, customClass) => {
        const modal = document.getElementById(id);
        modal.querySelector('.modal-content-container').classList.add(customClass);
    },
    removeClassFromModalBody: (id, customClass) => {
        const modal = document.getElementById(id);
        modal.querySelector('.modal-content-container').classList.remove(customClass);
    }
}

/**
 * Inicializa a lib de modais.
 */
document.addEventListener("DOMContentLoaded", function (event) {
    modalController.init();
});