﻿var inputFileController = {
    init: function () {
        const inputs = document.querySelectorAll('div.stylized-file-input input[type=file]')
        inputs.forEach(input => {
            inputFileView.init(input);
        })
    }
}

var inputFileView = {
    init: function (input) {
        this.render(input.parentNode, input);
    },
    render: function (father, input) {
        const fakeInput = document.createElement('div');
        const dragStyle = document.createElement('div');
        const selectedFile = document.createElement('div');
        const fileIcon = document.createElement('span');
        const fileName = document.createElement('span');
        const cleanFile = document.createElement('button');
        const cleanIcon = document.createElement('i');

        fakeInput.classList.add('fake-input');
        dragStyle.classList.add('drag-over');
        selectedFile.classList.add('file-info');
        fileIcon.classList.add('file-icon');
        fileName.classList.add('file-name');
        cleanFile.classList.add('icon-button');
        cleanIcon.setAttribute('data-feather', 'trash-2')



        father.insertBefore(fakeInput, input);
        father.insertBefore(dragStyle, input);

        selectedFile.appendChild(fileIcon);
        selectedFile.appendChild(fileName);
        cleanFile.appendChild(cleanIcon);
        selectedFile.appendChild(cleanFile);
        input.after(selectedFile);


        input.addEventListener('change', e => {
            father.classList.remove('file-selected');
            father.classList.remove('dragging')
            fileName.innerText = '';
            if (e.target.files.length > 0) {
                father.classList.add('file-selected');
                fileName.innerText = e.target.files[0].name;
            }
        });

        input.addEventListener('dragenter', e => {
            father.classList.add('dragging')
        });

        input.addEventListener('dragleave', e => {
            father.classList.remove('dragging')
        });

        cleanFile.addEventListener('click', e => {
            e.preventDefault();
            input.value = '';
            fileName.innerText = '';
            father.classList.remove('file-selected');
        })

        try {
            feather.replace();
        } catch (e) {
            console.log('lib de icons não encontrada', e);
        }

    }
}

document.addEventListener("DOMContentLoaded", function (event) {
    inputFileController.init();
});