﻿/**
 * Controlador geral do icon picker
 */
var iconPicker = {
    input: "",
    init: function (inputId, iconPickerViewId) {
        // inicializa variáveis
        input = inputId;

        // esconde o input padrão
        const inputNode = document.getElementById(inputId);
        inputNode.type = "hidden"

        // inicializa o model
        iconsModel.init();
        if (inputNode.value) {
            const auxDiv = document.createElement('div');
            auxDiv.innerHTML = inputNode.value;
            iconsModel.setSelected(auxDiv.firstChild);
        }

        // inicializa a visualização
        iconPickerView.init(iconPickerViewId);
    },
    getIcons: function () {
        return iconsModel.getIcons();
    },
    getSelected: function () {
        return iconsModel.getSelected();
    },
    selectIcon: function (icon) {
        const inputElement = document.getElementById(input);
        inputElement.value = icon.outerHTML;
        iconsModel.setSelected(icon);
        selectedIconView.render();
    },
};

/**
 * Model dos dados da aplicação
 */
var iconsModel = {
    icons: [],
    selected: "",
    init: function () {
        icons = [];
        selected = "";
        for (icon in feather.icons) {
            icons.push(feather.icons[icon]);
        }
    },
    getIcons: function () {
        return icons;
    },
    setSelected: function (val) {
        selected = val;
    },
    getSelected: function () {
        return selected;
    },
};

/**
 * Visualização da estrutura do icon picker
 */
var iconPickerView = {
    init: function (iconPickerViewId) {
        const idWithoutHashtag = iconPickerViewId.replace("#", "");
        iconPickerView.render(
            iconPickerViewId,
            `${idWithoutHashtag}-selected-icon-container`,
            `${idWithoutHashtag}-list-of-icons-container`
        );
    },
    render: function (
        iconPickerViewId,
        selectedIconContainerId,
        listOfIconsContainerId
    ) {
        const container = document.getElementById(iconPickerViewId);
        container.textContent = "";

        // criar a estrutura
        const selectedIconDiv = document.createElement("div");
        selectedIconDiv.setAttribute("id", selectedIconContainerId);

        const iconListContainer = document.createElement("div");
        iconListContainer.setAttribute("id", listOfIconsContainerId);

        selectedIconDiv.classList.add("selected-icon-container");
        iconListContainer.classList.add("icon-list-container");

        container.appendChild(selectedIconDiv);
        container.appendChild(iconListContainer);

        selectedIconView.init(selectedIconContainerId);
        listOfIconsView.init(listOfIconsContainerId);
    },
};

/**
 * Visualização do ícone selecionado
 */
var selectedIconView = {
    iconViewId: "",
    init: function (selectedIconContainerId) {
        iconViewId = selectedIconContainerId;
        selectedIconView.render();
    },
    render: function () {
        const containerElement = document.getElementById(iconViewId);
        containerElement.textContent = "";
        // renderiza o ícone atual
        const selectedIcon = iconPicker.getSelected();
        const containerDiv = document.createElement("div");
        if (selectedIcon) {
            containerDiv.appendChild(selectedIcon.cloneNode(true));
        }
        containerElement.appendChild(containerDiv);
    },
};

/**
 * Visualização da listagem dos ícones disponíveis
 */
var listOfIconsView = {
    listOfIconsViewId: "",
    init: function (listOfIconsId) {
        listOfIconsViewId = listOfIconsId;
        listOfIconsView.render();
    },
    render: function () {
        const container = document.getElementById(listOfIconsViewId);

        // renderiza a lista de ícones.
        const icons = iconPicker.getIcons();
        icons.forEach((icon) => {
            const div = document.createElement("div");
            const svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
            svg.innerHTML = icon.contents;
            svg.setAttribute("width", "24");
            svg.setAttribute("height", "24");
            svg.setAttribute("viewBox", "0 0 24 24");
            svg.setAttribute("fill", "none");
            svg.setAttribute("stroke-width", icon.attrs["stroke-width"]);
            svg.setAttribute("stroke-linecap", icon.attrs["stroke-linecap"]);
            svg.setAttribute("stroke-linejoin", icon.attrs["stroke-linejoin"]);
            div.appendChild(svg);
            div.addEventListener("click", () => {
                iconPicker.selectIcon(svg);
            });
            container.appendChild(div);
        });
    },
};
