﻿/**
 * Controlador da ux do form
 */
var formUx = {
    init: async function () {
        const tables = document.querySelectorAll('.new-form-ux table:not(.subFormStyle):not(.rating):not(.frm-grid):not(.checkbox):not([id*="UpLoad"]):not(.custom-table)');
        await divViewer.init(tables);
        const formGrids = document.querySelectorAll('.new-form-ux table.frm-grid, .new-form-ux table.subFormStyle');
        responsiveFormGrid.init(formGrids);
        const uploadedFilesRemove = document.querySelectorAll('.new-form-ux table[id*="UpLoad"] td:nth-of-type(1) input');
        deleteUploadedFilesView.init(uploadedFilesRemove);
        checkBoxesViewer.init();
    },
};

var divViewer = {
    init: function (tables) {
        return divViewer.render(tables);
    },
    render: function (tables) {
        return new Promise(resolve => {
            for (i = 0; i < tables.length; i++) {
                const table = tables[i];
                const containerElement = document.createElement('div');
                containerElement.classList.add('table-container');
                // children[0] corresponde ao tbody, e os children do tbody são as trs.
                if (table.children.length > 0) {
                    const lines = table.children[0].children;
                    for (l = 0; l < lines.length; l++) {
                        const lineContainer = document.createElement('div');
                        const columns = lines[l].children;
                        for (c = 0; c < columns.length; c++) {
                            const columnElement = document.createElement('div');
                            columnElement.innerHTML = columns[c].innerHTML;
                            lineContainer.appendChild(columnElement);
                        }
                        containerElement.appendChild(lineContainer);
                    }
                    table.parentNode.insertBefore(containerElement, table);
                }

            }
            for (i = 0; i < tables.length; i++) {
                tables[i].remove();
            }
            resolve();
        })
    }
}

var checkBoxesViewer = {
    init: function () {
        document.querySelectorAll('.checkbox').forEach(el => {
            el.querySelectorAll('label').forEach(label => {
                label.setAttribute("tabindex", 0);
                label.addEventListener("keydown", e => { if (e.code === "Space") e.currentTarget.click() })
            })
            el.querySelectorAll('input').forEach(input => {
                input.setAttribute("tabindex", -1);
            })
        })
    }
}

var responsiveFormGrid = {
    init: function (formGrids) {
        if (formGrids?.length > 0) {
            responsiveFormGrid.render(formGrids);
        }
    },
    render: function (grids) {
        grids.forEach(grid => {
            const father = grid.parentNode;
            if (!father.classList.contains('table-responsive')) {
                const gridContainer = document.createElement('div');
                gridContainer.classList.add('table-responsive');
                father.insertBefore(gridContainer, grid);
                father.removeChild(grid);
                gridContainer.appendChild(grid);

                // checa se o grid está em modo de edição e adiciona classe que melhora o visual das colunas inicial e final
                if (grid.querySelector('.frm-grid-insert')) {
                    grid.classList.add('active-form-grid');
                }
            }
        })
    }
}

var deleteUploadedFilesView = {
    init: function (inputs) {
        console.log(inputs);
        if (inputs.length > 0) {
            inputs.forEach(input => {
                deleteUploadedFilesView.render(input);
            })
        }
    },
    render: function (input) {
        input.src = 'data:image/svg+xml; utf8, <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="red" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash-2"><polyline points="3 6 5 6 21 6"/><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"/><line x1="10" y1="11" x2="10" y2="17"/><line x1="14" y1="11" x2="14" y2="17"/></svg>'
    }
}


/**
 * Inicializa a lib da ux do formulário.

document.addEventListener("DOMContentLoaded", function (event) {
    formUx.init();
});
 */

