﻿/**
 * Lib responsável por renderizar os ícones dos cards de arquivo.
 * 
 * OBS: ESTE ARQUIVO ESTÁ PESADO POR CONTA DE ALGUNS SVGS QUE SÃO ENORMES.
 * */
const fileIconsController = {
    init: function () {
        const links = document.querySelectorAll("a.file");
        links.forEach(link => {
            const icon = fileIconsModel.getIcon(link.getAttribute('data-type'));
            fileIconView.render(link, icon);
        });
    }
}

const fileIconsAttrsTemplates = {
    '86x116': {
        width: "86",
        height: "116",
        viewBox: "0 0 86 116",
        fill: "none"
    },
    '87x116': {
        width: "87",
        height: "116",
        viewBox: "0 0 87 116",
        fill: "none"
    },
    '88x116': {
        width: "88",
        height: "116",
        viewBox: "0 0 88 116",
        fill: "none"
    },
    '89x116': {
        width: "89",
        height: "116",
        viewBox: "0 0 89 116",
        fill: "none"
    }
}

const fileIconTemplate = {
    word: {
        contents: '<path d="M63.7367 79.5576C56.8825 79.5576 50.026 79.5598 43.1718 79.5554C42.0224 79.5554 41.4021 79.1107 41.2242 78.2014C41.0597 77.3566 41.471 76.5896 42.287 76.3339C42.656 76.2183 43.0651 76.1827 43.4542 76.1827C56.967 76.1761 70.4798 76.1761 83.9904 76.1827C84.3528 76.1827 84.7307 76.2183 85.0753 76.3206C85.8579 76.5496 86.3515 77.321 86.2514 78.0703C86.1447 78.8595 85.5266 79.4642 84.7263 79.5421C84.4462 79.5687 84.1593 79.5576 83.877 79.5576C77.1628 79.5576 70.4509 79.5576 63.7367 79.5576Z" fill="currentColor"/><path d="M63.7369 66.1314C70.4778 66.1314 77.2209 66.1314 83.9617 66.1336C84.273 66.1336 84.5909 66.1203 84.8932 66.1736C85.6291 66.3026 86.2339 66.9696 86.2517 67.7121C86.2717 68.4947 85.9048 69.0772 85.1578 69.3551C84.8732 69.4596 84.5509 69.5063 84.2463 69.5085C70.5645 69.5152 56.8827 69.5152 43.2009 69.5152C43.0586 69.5152 42.9163 69.5196 42.7763 69.5018C41.7936 69.3751 41.12 68.637 41.1644 67.7432C41.2111 66.8206 41.9047 66.1536 42.9163 66.1425C44.955 66.1203 46.996 66.1358 49.0347 66.1336C53.9369 66.1314 58.8369 66.1314 63.7369 66.1314Z" fill="currentColor"/><path d="M63.6634 49.6344C56.9493 49.6344 50.2373 49.6344 43.5231 49.6321C43.1852 49.6321 42.8362 49.6433 42.5094 49.5766C41.7135 49.4165 41.1621 48.7206 41.1643 47.9403C41.1665 47.1888 41.669 46.5196 42.4382 46.3373C42.7895 46.2528 43.1674 46.255 43.532 46.255C56.9871 46.2506 70.4421 46.2506 83.8971 46.255C84.235 46.255 84.5819 46.2462 84.9109 46.3151C85.7046 46.4818 86.2715 47.1888 86.2671 47.9491C86.2648 48.7406 85.649 49.4587 84.822 49.5966C84.5174 49.6477 84.2017 49.6321 83.8904 49.6321C77.1451 49.6344 70.4043 49.6344 63.6634 49.6344Z" fill="currentColor"/><path d="M63.6863 59.576C57.0344 59.576 50.3825 59.5783 43.7305 59.5716C43.3081 59.5716 42.8791 59.5582 42.4633 59.4849C41.723 59.3515 41.1805 58.6667 41.1605 57.9175C41.1405 57.1772 41.6563 56.4591 42.3877 56.2901C42.7679 56.2012 43.1703 56.17 43.5638 56.17C56.981 56.1634 70.3983 56.1634 83.8155 56.17C84.209 56.17 84.6091 56.2012 84.9915 56.2856C85.7341 56.4502 86.2699 57.1505 86.2699 57.8819C86.2699 58.6467 85.6897 59.3582 84.9093 59.4938C84.5225 59.5605 84.1223 59.5738 83.7265 59.576C77.0457 59.5783 70.3649 59.576 63.6863 59.576Z" fill="currentColor"/><path d="M74.5424 38.4195C71.2876 38.4195 68.0306 38.4261 64.7758 38.4172C63.673 38.415 62.9505 37.8214 62.8549 36.8943C62.7526 35.9072 63.513 35.0868 64.6246 35.0468C65.585 35.0112 66.5499 35.0379 67.5126 35.0379C72.9195 35.0379 78.3264 35.0379 83.7333 35.0379C83.9601 35.0379 84.1868 35.0313 84.4136 35.0402C85.5075 35.0891 86.27 35.7938 86.2655 36.7454C86.2611 37.6991 85.4941 38.4106 84.3958 38.4172C81.1099 38.4284 77.8261 38.4195 74.5424 38.4195Z" fill="currentColor"/><path d="M14.4034 108.3C41.12 108.3 67.8011 108.3 94.4844 108.3C94.4844 80.719 94.4844 53.1665 94.4844 25.5805C94.3088 25.5805 94.1576 25.5805 94.0064 25.5805C86.4674 25.5805 78.9306 25.5805 71.3916 25.5805C70.6468 25.5805 70.4156 25.3493 70.4156 24.6068C70.4156 17.0455 70.4156 9.48655 70.4156 1.92533C70.4156 1.78971 70.4156 1.65187 70.4156 1.51625C51.716 1.51625 33.0719 1.51625 14.4123 1.51625C14.4123 10.1646 14.4123 18.7952 14.4123 27.4525C14.5768 27.4525 14.7147 27.4525 14.8547 27.4525C26.5534 27.4525 38.2543 27.4525 49.953 27.4525C52.8699 27.4525 55.1064 29.6557 55.1064 32.5637C55.1131 47.5217 55.1109 62.4774 55.0998 77.4353C55.0998 77.9511 55.0197 78.4847 54.873 78.9782C54.226 81.1548 52.2785 82.5621 49.9641 82.5621C38.2654 82.5643 26.5645 82.5621 14.8659 82.5621C14.7169 82.5621 14.5679 82.5621 14.4034 82.5621C14.4034 91.1638 14.4034 99.721 14.4034 108.3ZM40.1863 70.9457C40.0929 70.7789 40.0396 70.6767 39.9795 70.5766C36.9604 65.4832 33.9412 60.3897 30.9154 55.303C30.7798 55.0762 30.7842 54.9161 30.9176 54.6916C33.7945 49.7938 36.6625 44.8894 39.5304 39.9849C39.5882 39.8871 39.6349 39.7826 39.7105 39.6359C39.5393 39.6359 39.4215 39.6359 39.3059 39.6359C37.4873 39.6359 35.6687 39.6425 33.8479 39.6292C33.5789 39.6269 33.4454 39.7225 33.3143 39.9449C31.4845 43.0863 29.6482 46.2233 27.8118 49.3603C27.754 49.4581 27.6917 49.5515 27.6072 49.6849C27.5161 49.5337 27.4494 49.4247 27.3827 49.3136C25.533 46.1855 23.6788 43.0574 21.8357 39.9249C21.7112 39.7114 21.5778 39.6269 21.3222 39.6292C19.4924 39.6425 17.6627 39.6359 15.833 39.6359C15.7196 39.6359 15.6062 39.6359 15.4417 39.6359C15.5373 39.8093 15.5951 39.9226 15.6596 40.0338C18.5431 44.9027 21.4266 49.7738 24.3213 54.636C24.4769 54.8961 24.4747 55.0807 24.3235 55.3386C21.3355 60.4231 18.3564 65.5143 15.3772 70.6055C15.3194 70.7033 15.2705 70.8034 15.1927 70.9479C15.3639 70.9479 15.4706 70.9479 15.5773 70.9479C17.3959 70.9479 19.2145 70.9412 21.0353 70.9546C21.3088 70.9568 21.4578 70.8745 21.5978 70.6344C23.5476 67.2862 25.5063 63.9447 27.4649 60.601C27.5183 60.5098 27.5761 60.4231 27.6561 60.2964C27.7495 60.4498 27.8251 60.5654 27.8963 60.6854C29.8527 63.9914 31.8114 67.2973 33.7567 70.61C33.9101 70.8723 34.0768 70.959 34.3725 70.9546C35.931 70.9412 37.4873 70.9479 39.0458 70.9479C39.4059 70.9457 39.7639 70.9457 40.1863 70.9457ZM71.923 24.0776C79.0885 24.0776 86.2161 24.0776 93.2749 24.0776C86.165 16.9677 79.0307 9.83337 71.923 2.72569C71.923 9.79113 71.923 16.921 71.923 24.0776ZM12.8961 109.799C12.8961 100.721 12.8961 91.6707 12.8961 82.5621C12.7538 82.5621 12.6293 82.5621 12.5048 82.5621C10.0326 82.5621 7.56032 82.5665 5.08586 82.5621C2.67142 82.5576 0.668272 80.9725 0.123579 78.6203C0.0368733 78.2423 0.00574148 77.8444 0.00574148 77.4553C-0.00092823 62.4885 -0.000878293 47.5217 0.00134494 32.5548C0.00134494 29.6535 2.21341 27.4547 5.11696 27.4525C7.57808 27.4503 10.0415 27.4525 12.5026 27.4525C12.6204 27.4525 12.736 27.4525 12.885 27.4525C12.885 18.2928 12.885 9.17085 12.885 0.00445081C13.0428 0.00445081 13.1695 0.00445081 13.2963 0.00445081C32.5761 0.00445081 51.8561 0.00444647 71.136 0C71.3872 0 71.5584 0.0800398 71.7318 0.253452C79.7221 8.25265 87.7168 16.2474 95.716 24.2377C95.9184 24.44 95.9962 24.6401 95.9962 24.9225C95.9895 53.0686 95.9917 81.217 95.9917 109.363C95.9917 109.503 95.9917 109.641 95.9917 109.799C68.2835 109.799 40.611 109.799 12.8961 109.799ZM45.2753 75.1676H7.09122V35.0249H45.2753V75.1676Z" fill="currentColor"/><path d="M14.157 71.8101C11.3179 60.6228 8.52326 49.6178 5.67529 38.406C7.64953 38.406 9.48372 38.3482 11.309 38.4616C11.6225 38.4816 12.0471 39.1953 12.1561 39.6532C13.8324 46.7254 15.4642 53.8086 17.1117 60.8874C17.1428 61.0163 17.2072 61.1386 17.3673 61.5521C18.261 58.135 19.0814 54.978 19.9107 51.821C20.9756 47.7614 22.0739 43.7107 23.0944 39.6399C23.3367 38.6684 23.7547 38.2882 24.7685 38.3749C26.1936 38.4949 27.9877 37.9814 28.9526 38.675C29.8197 39.2975 29.8085 41.1739 30.1309 42.5123C31.6071 48.6307 33.0656 54.7512 34.5774 61.0652C34.7597 60.6495 34.9287 60.3716 35.0065 60.0714C36.7628 53.2839 38.5281 46.4964 40.2378 39.6977C40.4756 38.7528 40.8247 38.3126 41.8674 38.3727C43.3969 38.4616 44.9332 38.3949 46.6896 38.3949C45.638 42.0832 44.6308 45.6004 43.6348 49.122C41.6272 56.2141 39.6019 63.2996 37.6521 70.4073C37.352 71.4989 36.8984 71.9346 35.7646 71.8301C34.3951 71.7034 32.6254 72.2148 31.7427 71.53C30.8712 70.8541 30.8468 69.04 30.5244 67.7083C29.1327 61.9367 27.7676 56.1563 26.3914 50.3804C26.3359 50.1469 26.2602 49.9179 26.0757 49.2776C25.7956 50.0669 25.6155 50.4937 25.4932 50.9362C23.7324 57.4058 21.9361 63.8665 20.2642 70.3584C19.9507 71.5767 19.4305 71.9102 18.2766 71.8324C16.956 71.7412 15.6221 71.8101 14.157 71.8101Z" fill="white"/>',
        attrs: {
            width: "96",
            height: "110",
            viewBox: "0 0 96 110",
            fill: "none"
        }
    },
    excel: {
        contents: '<path d="M13.5341 112.107C13.5341 102.908 13.5341 93.7374 13.5341 84.508C13.3898 84.508 13.264 84.508 13.1407 84.508C10.6501 84.508 8.16192 84.5127 5.67137 84.508C3.23901 84.5033 1.2233 82.8987 0.676312 80.514C0.587862 80.1322 0.557601 79.7269 0.557601 79.3334C0.552946 64.1681 0.550616 49.0005 0.555271 33.8351C0.555271 30.8953 2.78277 28.6676 5.70626 28.6653C8.18517 28.6629 10.6641 28.6653 13.143 28.6653C13.2617 28.6653 13.3781 28.6653 13.5271 28.6653C13.5271 19.382 13.5271 10.1385 13.5271 0.852834C13.6877 0.852834 13.8134 0.852834 13.9414 0.852834C33.3537 0.852834 52.7684 0.85283 72.1807 0.848145C72.4344 0.848145 72.6044 0.927796 72.7789 1.10348C80.8255 9.20851 88.8744 17.3112 96.928 25.4069C97.1328 25.613 97.2096 25.8144 97.2096 26.1002C97.2049 54.6224 97.2049 83.1447 97.2049 111.667C97.2049 111.807 97.2049 111.948 97.2049 112.107C69.3061 112.107 41.4422 112.107 13.5341 112.107ZM15.054 110.587C41.9543 110.587 68.8196 110.587 95.6873 110.587C95.6873 82.6387 95.6873 54.7161 95.6873 26.7632C95.5104 26.7632 95.3568 26.7632 95.2055 26.7632C87.6151 26.7632 80.0248 26.7632 72.4344 26.7632C71.685 26.7632 71.4521 26.5289 71.4521 25.777C71.4521 18.117 71.4521 10.4547 71.4521 2.79476C71.4521 2.65655 71.4521 2.51834 71.4521 2.38013C52.624 2.38013 33.8495 2.38013 15.0609 2.38013C15.0609 11.1434 15.0609 19.8903 15.0609 28.6629C15.2262 28.6629 15.3659 28.6629 15.5079 28.6629C27.288 28.6629 39.068 28.6629 50.8504 28.6629C53.7855 28.6629 56.0387 30.8953 56.0387 33.8422C56.0433 48.9981 56.0433 64.1541 56.0317 79.3123C56.0317 79.8347 55.9502 80.3735 55.8036 80.8748C55.1542 83.0791 53.192 84.5056 50.8597 84.5056C39.0796 84.508 27.2996 84.5056 15.5172 84.5056C15.3682 84.5056 15.2169 84.5056 15.0517 84.5056C15.054 93.2221 15.054 101.894 15.054 110.587ZM41.0139 72.7346C40.9208 72.5659 40.8649 72.4605 40.8067 72.3598C37.7669 67.1993 34.727 62.0388 31.6802 56.8806C31.5428 56.6487 31.5475 56.4894 31.6825 56.2598C34.5781 51.2961 37.4666 46.3253 40.3552 41.3569C40.4134 41.2585 40.46 41.1531 40.5368 41.0032C40.3645 41.0032 40.2458 41.0032 40.1294 41.0032C38.2976 41.0032 36.4657 41.0102 34.6339 40.9962C34.3639 40.9938 34.2266 41.0922 34.0962 41.3171C32.2551 44.5005 30.4047 47.6793 28.5565 50.8581C28.4983 50.9564 28.4355 51.0525 28.3493 51.1884C28.2586 51.0361 28.1911 50.9236 28.1236 50.8112C26.2591 47.6418 24.3947 44.4724 22.5373 41.2983C22.4116 41.0828 22.2789 40.9962 22.0206 40.9985C20.1771 41.0126 18.3359 41.0055 16.4925 41.0055C16.3784 41.0055 16.2644 41.0055 16.0968 41.0055C16.1922 41.1812 16.2504 41.296 16.3179 41.4084C19.2228 46.3417 22.1253 51.2774 25.0395 56.206C25.1954 56.4707 25.1954 56.6557 25.0418 56.9181C22.0322 62.0716 19.0342 67.2298 16.0339 72.3879C15.9757 72.4863 15.9268 72.5894 15.85 72.7346C16.0223 72.7346 16.1293 72.7346 16.2387 72.7346C18.0706 72.7346 19.9024 72.7276 21.7343 72.7416C22.0112 72.744 22.1602 72.6596 22.2999 72.4184C24.262 69.0241 26.2359 65.6392 28.2074 62.2496C28.2609 62.1582 28.3191 62.0692 28.4005 61.9404C28.496 62.095 28.5705 62.2145 28.6426 62.3339C30.6118 65.6837 32.5856 69.0335 34.5431 72.3903C34.6991 72.6573 34.8667 72.744 35.1623 72.7416C36.7311 72.7276 38.2999 72.7346 39.8687 72.7346C40.2272 72.7346 40.5879 72.7346 41.0139 72.7346ZM72.9697 25.2429C80.1854 25.2429 87.3614 25.2429 94.4677 25.2429C87.3079 18.0374 80.1248 10.8084 72.9697 3.60526C72.9697 10.7639 72.9697 17.9905 72.9697 25.2429Z" fill="currentColor"/><path d="M72.4432 43.1079C72.4432 45.1201 72.4432 47.1112 72.4432 49.1211C67.9928 49.1211 63.561 49.1211 59.106 49.1211C59.106 47.1136 59.106 45.1225 59.106 43.1079C63.5494 43.1079 67.9741 43.1079 72.4432 43.1079Z" fill="currentColor"/><path d="M75.4946 43.1011C79.9381 43.1011 84.3652 43.1011 88.8156 43.1011C88.8156 45.1016 88.8156 47.095 88.8156 49.1143C84.3885 49.1143 79.9543 49.1143 75.4946 49.1143C75.4946 47.1278 75.4946 45.1367 75.4946 43.1011Z" fill="currentColor"/><path d="M59.1094 58.2035C59.1094 56.1913 59.1094 54.2001 59.1094 52.1926C63.5551 52.1926 67.9799 52.1926 72.435 52.1926C72.435 54.1908 72.435 56.1889 72.435 58.2035C67.9916 58.2035 63.5575 58.2035 59.1094 58.2035Z" fill="currentColor"/><path d="M88.8167 58.2056C84.3756 58.2056 79.9485 58.2056 75.498 58.2056C75.498 56.2098 75.498 54.2187 75.498 52.1995C79.9252 52.1995 84.3593 52.1995 88.8167 52.1995C88.8167 54.1836 88.8167 56.1747 88.8167 58.2056Z" fill="currentColor"/><path d="M72.4466 61.2722C72.4466 63.2821 72.4466 65.2755 72.4466 67.2901C67.9938 67.2901 63.5621 67.2901 59.1094 67.2901C59.1094 65.2755 59.1094 63.2844 59.1094 61.2722C63.5505 61.2722 67.9776 61.2722 72.4466 61.2722Z" fill="currentColor"/><path d="M75.49 61.2686C79.9474 61.2686 84.3745 61.2686 88.8203 61.2686C88.8203 63.2784 88.8203 65.2695 88.8203 67.2864C84.3768 67.2864 79.9427 67.2864 75.49 67.2864C75.49 65.2812 75.49 63.2901 75.49 61.2686Z" fill="currentColor"/>',
        attrs: {
            width: "98",
            height: "113",
            viewBox: "0 0 98 113",
            fill: "none"
        }
    },
    powerpoint: {
        contents: '<path d="M67.0867 83.7394C59.8722 83.7394 52.6553 83.7418 45.4408 83.7371C44.231 83.7371 43.5781 83.2691 43.3909 82.312C43.2178 81.4227 43.6507 80.6154 44.5095 80.3463C44.8979 80.2246 45.3285 80.1871 45.738 80.1871C59.9611 80.1801 74.1842 80.1801 88.4049 80.1871C88.7863 80.1871 89.1842 80.2246 89.5469 80.3322C90.3706 80.5733 90.8901 81.3853 90.7848 82.1739C90.6725 83.0046 90.0219 83.6411 89.1795 83.723C88.8846 83.7511 88.5828 83.7394 88.2856 83.7394C81.2185 83.7394 74.1538 83.7394 67.0867 83.7394Z" fill="currentColor"/><path d="M67.0871 69.6073C74.1822 69.6073 81.2797 69.6073 88.3749 69.6096C88.7025 69.6096 89.0371 69.5956 89.3554 69.6517C90.1299 69.7875 90.7665 70.4895 90.7852 71.2711C90.8063 72.0948 90.4201 72.7079 89.6338 73.0004C89.3343 73.1104 88.995 73.1595 88.6744 73.1619C74.2735 73.1689 59.8725 73.1689 45.4716 73.1689C45.3219 73.1689 45.1721 73.1736 45.0247 73.1549C43.9904 73.0215 43.2813 72.2446 43.3281 71.3038C43.3773 70.3327 44.1073 69.6307 45.1721 69.619C47.3179 69.5956 49.4662 69.6119 51.612 69.6096C56.7719 69.6073 61.9295 69.6073 67.0871 69.6073Z" fill="currentColor"/><path d="M15.1605 113.993C43.2814 113.993 71.3649 113.993 99.4507 113.993C99.4507 84.9617 99.4507 55.961 99.4507 26.9251C99.2658 26.9251 99.1066 26.9251 98.9475 26.9251C91.0123 26.9251 83.0793 26.9251 75.1441 26.9251C74.3602 26.9251 74.1168 26.6817 74.1168 25.9001C74.1168 17.9415 74.1168 9.98518 74.1168 2.02653C74.1168 1.88378 74.1168 1.73869 74.1168 1.59594C54.4343 1.59594 34.8102 1.59594 15.1699 1.59594C15.1699 10.6989 15.1699 19.7831 15.1699 28.8955C15.343 28.8955 15.4881 28.8955 15.6355 28.8955C27.9491 28.8955 40.265 28.8955 52.5786 28.8955C55.6488 28.8955 58.0029 31.2145 58.0029 34.2753C58.0099 50.0195 58.0076 65.7613 57.9959 81.5054C57.9959 82.0483 57.9116 82.6099 57.7572 83.1294C57.0762 85.4204 55.0263 86.9017 52.5903 86.9017C40.2767 86.904 27.9608 86.9017 15.6472 86.9017C15.4905 86.9017 15.3337 86.9017 15.1605 86.9017C15.1605 95.9555 15.1605 104.963 15.1605 113.993ZM42.2986 74.6747C42.2003 74.4992 42.1441 74.3915 42.0809 74.2862C38.9031 68.9251 35.7252 63.5639 32.5404 58.2098C32.3976 57.9711 32.4023 57.8026 32.5427 57.5663C35.5708 52.4111 38.5895 47.2488 41.6082 42.0866C41.6691 41.9836 41.7182 41.8736 41.7978 41.7192C41.6176 41.7192 41.4935 41.7192 41.3719 41.7192C39.4577 41.7192 37.5435 41.7262 35.627 41.7122C35.3438 41.7098 35.2034 41.8104 35.0653 42.0444C33.1394 45.351 31.2065 48.6529 29.2736 51.9547C29.2128 52.0577 29.1472 52.156 29.0583 52.2964C28.9624 52.1373 28.8922 52.0226 28.822 51.9056C26.875 48.6131 24.9234 45.3206 22.9835 42.0234C22.8524 41.7987 22.712 41.7098 22.4429 41.7122C20.517 41.7262 18.5911 41.7192 16.6652 41.7192C16.5459 41.7192 16.4265 41.7192 16.2533 41.7192C16.354 41.9017 16.4148 42.021 16.4827 42.1381C19.5178 47.2629 22.5529 52.39 25.5997 57.5078C25.7635 57.7816 25.7611 57.9758 25.602 58.2473C22.4569 63.599 19.3212 68.9579 16.1855 74.3167C16.1246 74.4196 16.0731 74.5249 15.9912 74.677C16.1714 74.677 16.2837 74.677 16.3961 74.677C18.3103 74.677 20.2245 74.67 22.141 74.6841C22.4288 74.6864 22.5856 74.5998 22.733 74.3471C24.7853 70.8229 26.8469 67.3057 28.9085 63.7862C28.9647 63.6903 29.0256 63.599 29.1098 63.4657C29.2081 63.6271 29.2877 63.7488 29.3625 63.8752C31.4218 67.3549 33.4834 70.8346 35.531 74.3214C35.6925 74.5975 35.868 74.6887 36.1792 74.6841C37.8196 74.67 39.4577 74.677 41.0981 74.677C41.4772 74.6747 41.854 74.6747 42.2986 74.6747ZM75.7034 25.3432C83.2455 25.3432 90.7478 25.3432 98.1776 25.3432C90.694 17.8596 83.1847 10.3502 75.7034 2.86896C75.7034 10.3058 75.7034 17.8104 75.7034 25.3432ZM13.574 115.57C13.574 106.016 13.574 96.489 13.574 86.9017C13.4242 86.9017 13.2931 86.9017 13.1621 86.9017C10.5599 86.9017 7.9577 86.9064 5.35318 86.9017C2.81184 86.897 0.703398 85.2285 0.130075 82.7527C0.0388114 82.3549 0.00604326 81.936 0.00604326 81.5265C-0.000977019 65.773 -0.000924458 50.0195 0.00141563 34.266C0.00141563 31.2122 2.32975 28.8978 5.38591 28.8955C7.9764 28.8931 10.5693 28.8955 13.1598 28.8955C13.2838 28.8955 13.4055 28.8955 13.5622 28.8955C13.5622 19.2543 13.5622 9.65289 13.5622 0.00468476C13.7284 0.00468476 13.8617 0.00468476 13.9951 0.00468476C34.2884 0.00468476 54.5817 0.00468019 74.875 0C75.1394 0 75.3196 0.0842468 75.5021 0.266774C83.9124 8.68643 92.3274 17.1014 100.747 25.5117C100.96 25.7246 101.042 25.9353 101.042 26.2324C101.035 55.858 101.037 85.4859 101.037 115.112C101.037 115.259 101.037 115.404 101.037 115.57C71.8726 115.57 42.7455 115.57 13.574 115.57ZM47.655 79.1185H7.46395V36.8658H47.655V79.1185Z" fill="currentColor"/><path d="M23.3954 64.6485C23.3954 69.7239 23.3954 74.1713 23.3954 79C20.5291 79 17.9568 79 14.9583 79C14.9583 72.6988 14.9583 66.6293 14.9583 60.5599C14.9583 53.8476 15.0464 47.1278 14.9142 40.4155C14.8627 37.8143 15.774 36.9098 18.3169 37.007C22.7119 37.1714 27.1215 37.0668 31.5238 37.0518C40.5048 37.0219 46.5607 41.7385 46.8915 49.0413C47.2957 57.9811 41.7395 63.9758 32.3176 64.6261C29.5321 64.8055 26.7247 64.6485 23.3954 64.6485ZM23.5203 57.7867C25.9383 57.7867 27.9888 57.7942 30.0393 57.7867C30.6493 57.7867 31.2666 57.8091 31.8619 57.7119C35.8159 57.0616 37.9178 54.595 37.9031 50.6559C37.8884 46.6569 36.2275 44.7508 31.8619 44.3098C29.1426 44.0407 26.3792 44.2574 23.5203 44.2574C23.5203 48.8992 23.5203 53.0627 23.5203 57.7867Z" fill="white"/><path d="M53.9159 47.3966C53.9159 45.7461 53.9121 44.0955 53.9172 42.4463C53.921 41.4864 54.246 41.1563 55.2097 41.1259C55.6325 41.1132 56.0565 41.1068 56.4793 41.1259C57.109 41.1551 57.622 41.0751 58.0562 40.4809C58.5552 39.7991 59.1697 39.1655 59.84 38.6513C60.6856 38.0038 61.5832 37.355 62.5621 36.9678C63.8178 36.4701 65.09 35.9191 66.5208 35.9889C67.0769 36.0156 67.2115 36.1819 67.2014 36.6809C67.1798 37.7385 67.181 38.7961 67.1963 39.8537C67.2318 42.1746 67.294 44.4955 67.3207 46.8164C67.3258 47.2772 67.5492 47.4093 67.9416 47.4105C68.8722 47.4156 69.8028 47.422 70.7335 47.422C73.1242 47.422 75.5149 47.422 77.9056 47.4169C79.0293 47.4143 78.8477 47.455 78.7766 48.3298C78.4846 51.919 76.8734 54.7617 73.9723 56.8795C69.6657 60.0231 63.3747 59.6346 59.4045 55.9628C58.818 55.4207 58.338 54.7643 57.7705 54.1993C57.5737 54.0037 57.2677 53.8425 56.996 53.8158C56.4311 53.7574 55.8559 53.8057 55.2846 53.7981C54.2676 53.7841 53.9121 53.4223 53.9121 52.4129C53.9121 50.7421 53.9121 49.07 53.9121 47.3991C53.9134 47.3966 53.9159 47.3966 53.9159 47.3966ZM58.9919 48.5227C59.5671 48.5227 60.0521 48.5507 60.5332 48.5177C62.1609 48.4085 63.1195 47.389 63.0509 45.8705C62.9938 44.63 61.9476 43.8289 60.3961 43.834C59.6356 43.8365 58.8751 43.853 58.1146 43.8264C57.6753 43.8111 57.5179 43.9635 57.5268 44.4053C57.5483 45.5455 57.5344 46.6869 57.5344 47.827C57.5344 48.8579 57.5344 49.8889 57.5344 50.9592C58.0524 50.9592 58.4968 50.9592 58.9919 50.9592C58.9919 50.1403 58.9919 49.3848 58.9919 48.5227Z" fill="currentColor"/><path d="M58.9919 48.5229C58.9919 49.385 58.9919 50.1405 58.9919 50.9606C58.4967 50.9606 58.0523 50.9606 57.5343 50.9606C57.5343 49.8903 57.5343 48.8594 57.5343 47.8285C57.5343 46.6883 57.5496 45.5469 57.5267 44.4068C57.5178 43.965 57.6753 43.8113 58.1146 43.8278C58.8738 43.8558 59.6356 43.838 60.3961 43.8355C61.9476 43.8304 62.9938 44.6315 63.0509 45.872C63.1207 47.3904 62.1609 48.4087 60.5332 48.5191C60.052 48.5496 59.567 48.5229 58.9919 48.5229ZM59.0135 47.3574C59.4312 47.3574 59.7854 47.3587 60.1396 47.3574C60.245 47.3574 60.3517 47.3612 60.4545 47.3447C61.1376 47.2343 61.5007 46.8153 61.4981 46.1462C61.4956 45.4669 61.2087 45.1432 60.4545 45.0683C59.9847 45.0226 59.5073 45.0594 59.0135 45.0594C59.0135 45.8478 59.0135 46.555 59.0135 47.3574Z" fill="currentColor"/><path d="M59.0134 47.3572C59.0134 46.5561 59.0134 45.8489 59.0134 45.0592C59.5073 45.0592 59.9847 45.0224 60.4545 45.0681C61.2086 45.1417 61.4956 45.4667 61.4981 46.146C61.5006 46.8151 61.1375 47.2341 60.4545 47.3445C60.3516 47.361 60.245 47.3572 60.1396 47.3572C59.7854 47.3572 59.4311 47.3572 59.0134 47.3572Z" fill="currentColor"/><path d="M68.9135 32.0046C75.972 31.8104 82.095 37.815 81.9079 44.8344C81.6199 44.8876 81.3157 44.9926 81.0101 44.9926C77.0663 45.0033 73.1225 44.9993 68.9121 44.9993C68.9121 40.6358 68.9121 36.3215 68.9135 32.0046Z" fill="currentColor"/>',
        attrs: {
            width: "102",
            height: "116",
            viewBox: "0 0 102 116",
            fill: "none"
        }
    }
}

const fileIconsModel = {
    icons: {
        png: {
            contents: '<path d="M44.4002 83.7006C37.754 83.7006 31.1078 83.7006 24.4643 83.7006C22.8328 83.7006 22.3682 83.2306 22.3682 81.5751C22.3682 68.2133 22.3682 54.8514 22.3682 41.4923C22.3682 39.9088 22.8461 39.4229 24.4135 39.4229C37.8101 39.4229 51.2066 39.4229 64.6031 39.4229C66.1679 39.4229 66.6486 39.9115 66.6486 41.4923C66.6486 54.8888 66.6486 68.2854 66.6486 81.6819C66.6486 83.1932 66.1493 83.7006 64.6566 83.7006C57.9009 83.7006 51.1506 83.6979 44.4002 83.7006ZM23.8715 82.1625C20.9075 84.6832 27.5164 58.7179 24.5898 61.1558C24.0611 61.5964 34.2667 56.4112 34.2694 57.1215C34.2988 63.2764 23.8234 75.0277 23.8261 81.1826C23.8261 81.519 23.8554 81.8528 23.8715 82.1625C37.6926 82.1625 40.5903 63.6553 54.358 63.6553C54.358 59.9784 65.196 74.8862 65.1586 71.2894C65.1559 70.9823 63.1311 76.1116 62.8721 75.898C59.5903 73.1797 56.1835 69.4342 52.9098 66.7052C52.3891 66.2726 54.2317 66.013 53.671 66.3735C51.4387 67.8047 48.8168 64.9716 46.5631 66.3735C45.2948 67.1639 63.8494 84.8007 62.8721 83.7005C59.2566 79.6204 27.5911 86.3414 23.8715 82.1625ZM23.8795 40.9182C23.8795 47.2386 23.8795 53.4469 23.8795 59.8261C24.3041 59.4816 24.6219 59.2333 24.9263 58.9743C27.5137 56.7847 30.1092 54.6031 32.6806 52.3922C33.3001 51.8608 33.7487 51.9275 34.2694 52.5177C36.6219 55.1959 38.9957 57.8581 41.3668 60.523C42.774 62.1038 44.1946 63.6765 45.6098 65.2547C48.2267 63.6231 50.7473 62.0637 53.2547 60.4803C53.8635 60.0958 54.3655 60.0611 54.953 60.555C56.9583 62.24 58.9957 63.8902 61.0251 65.5484C62.3575 66.6378 63.6953 67.7193 65.1185 68.8755C65.1185 59.4389 65.1185 50.1946 65.1185 40.9182C51.3508 40.9182 37.6525 40.9182 23.8795 40.9182Z" fill="currentColor"/><path d="M54.1039 37.2818C58.2454 37.2925 61.4016 40.5074 61.391 44.7024C61.3803 48.7317 58.0638 52.0161 54.0211 51.9947C50.0451 51.9761 46.6753 48.5929 46.6753 44.6169C46.6726 40.5315 49.9757 37.2684 54.1039 37.2818ZM54.3581 45.0146C57.6051 45.0199 50.6353 47.9494 50.63 44.7024C50.6247 41.45 56.9231 45.2682 53.6601 45.2789C50.4825 45.2896 59.9582 41.837 59.9502 45.0146C59.9422 48.2749 51.1111 45.0092 54.3581 45.0146Z" fill="currentColor"/><path d="M0 115.57C0 77.0628 0 38.5982 0 0.0160207C0.34713 0.0160207 0.667544 0.0160207 0.987971 0.0160207C20.8972 0.0160207 40.8065 0.0186916 60.713 0C61.4099 0 61.8799 0.218963 62.3632 0.704944C70.4994 8.86783 78.6489 17.0174 86.8118 25.1536C87.2578 25.5995 87.4286 26.0427 87.4286 26.6622C87.4153 55.9813 87.4179 85.3005 87.4179 114.617C87.4179 114.913 87.4179 115.21 87.4179 115.567C58.2377 115.57 29.1509 115.57 0 115.57ZM1.53805 113.963C29.7196 113.963 57.7543 113.963 85.8211 113.963C85.8211 84.9506 85.8211 55.9894 85.8211 26.9453C85.3912 26.9453 85.0335 26.9453 84.6756 26.9453C77.1403 26.9453 69.6075 26.9453 62.0748 26.9453C60.5715 26.9453 60.5021 26.8732 60.5021 25.3405C60.5021 17.8078 60.5021 10.2724 60.5021 2.73966C60.5021 2.38719 60.5021 2.03471 60.5021 1.66622C40.7984 1.66622 21.2123 1.66622 1.5861 1.66622C1.56741 1.91188 1.5434 2.08811 1.54073 2.26435C1.45528 9.20427 1.29236 16.1469 1.30304 23.0868C1.3511 49.3004 1.45527 75.5167 1.53538 101.73C1.54606 105.453 1.53805 109.175 1.53805 112.895C1.53805 113.22 1.53805 113.549 1.53805 113.963ZM84.2964 25.2951C76.9159 17.9012 69.5248 10.4967 62.1763 3.13485C62.1763 10.4379 62.1763 17.8531 62.1763 25.2951C69.6316 25.2951 77.0281 25.2951 84.2964 25.2951Z" fill="currentColor"/><path d="M34.3269 90.588C34.8309 90.588 35.2749 90.692 35.6589 90.9C36.0429 91.108 36.3389 91.404 36.5469 91.788C36.7629 92.164 36.8709 92.6 36.8709 93.096C36.8709 93.584 36.7629 94.016 36.5469 94.392C36.3309 94.768 36.0229 95.06 35.6229 95.268C35.2309 95.468 34.7749 95.568 34.2549 95.568H32.3349C32.2949 95.568 32.2749 95.588 32.2749 95.628V98.856C32.2749 98.896 32.2589 98.932 32.2269 98.964C32.2029 98.988 32.1709 99 32.1309 99H31.0269C30.9869 99 30.9509 98.988 30.9189 98.964C30.8949 98.932 30.8829 98.896 30.8829 98.856V90.732C30.8829 90.692 30.8949 90.66 30.9189 90.636C30.9509 90.604 30.9869 90.588 31.0269 90.588H34.3269ZM34.1229 94.44C34.5309 94.44 34.8589 94.32 35.1069 94.08C35.3549 93.84 35.4789 93.524 35.4789 93.132C35.4789 92.732 35.3549 92.408 35.1069 92.16C34.8589 91.912 34.5309 91.788 34.1229 91.788H32.3349C32.2949 91.788 32.2749 91.808 32.2749 91.848V94.38C32.2749 94.42 32.2949 94.44 32.3349 94.44H34.1229ZM42.9756 90.744C42.9756 90.704 42.9876 90.672 43.0116 90.648C43.0436 90.616 43.0796 90.6 43.1196 90.6H44.2236C44.2636 90.6 44.2956 90.616 44.3196 90.648C44.3516 90.672 44.3676 90.704 44.3676 90.744V98.856C44.3676 98.896 44.3516 98.932 44.3196 98.964C44.2956 98.988 44.2636 99 44.2236 99H43.1556C43.0756 99 43.0196 98.968 42.9876 98.904L39.5316 93.24C39.5156 93.216 39.4996 93.208 39.4836 93.216C39.4676 93.216 39.4596 93.232 39.4596 93.264L39.4836 98.856C39.4836 98.896 39.4676 98.932 39.4356 98.964C39.4116 98.988 39.3796 99 39.3396 99H38.2356C38.1956 99 38.1596 98.988 38.1276 98.964C38.1036 98.932 38.0916 98.896 38.0916 98.856V90.744C38.0916 90.704 38.1036 90.672 38.1276 90.648C38.1596 90.616 38.1956 90.6 38.2356 90.6H39.3036C39.3836 90.6 39.4396 90.632 39.4716 90.696L42.9156 96.36C42.9316 96.384 42.9476 96.396 42.9636 96.396C42.9796 96.388 42.9876 96.368 42.9876 96.336L42.9756 90.744ZM48.9269 99.096C48.3269 99.096 47.7989 98.98 47.3429 98.748C46.8869 98.508 46.5349 98.172 46.2869 97.74C46.0389 97.308 45.9149 96.812 45.9149 96.252V93.348C45.9149 92.78 46.0389 92.284 46.2869 91.86C46.5349 91.428 46.8869 91.096 47.3429 90.864C47.7989 90.624 48.3269 90.504 48.9269 90.504C49.5189 90.504 50.0389 90.62 50.4869 90.852C50.9429 91.084 51.2949 91.4 51.5429 91.8C51.7909 92.2 51.9149 92.652 51.9149 93.156V93.252C51.9149 93.292 51.8989 93.328 51.8669 93.36C51.8429 93.384 51.8109 93.396 51.7709 93.396H50.6789C50.6389 93.396 50.6029 93.384 50.5709 93.36C50.5469 93.328 50.5349 93.292 50.5349 93.252V93.192C50.5349 92.76 50.3869 92.404 50.0909 92.124C49.8029 91.844 49.4149 91.704 48.9269 91.704C48.4389 91.704 48.0469 91.852 47.7509 92.148C47.4549 92.436 47.3069 92.82 47.3069 93.3V96.3C47.3069 96.78 47.4629 97.168 47.7749 97.464C48.0869 97.752 48.4909 97.896 48.9869 97.896C49.4669 97.896 49.8429 97.772 50.1149 97.524C50.3949 97.268 50.5349 96.92 50.5349 96.48V95.736C50.5349 95.696 50.5149 95.676 50.4749 95.676H48.9989C48.9589 95.676 48.9229 95.664 48.8909 95.64C48.8669 95.608 48.8549 95.572 48.8549 95.532V94.644C48.8549 94.604 48.8669 94.572 48.8909 94.548C48.9229 94.516 48.9589 94.5 48.9989 94.5H51.7709C51.8109 94.5 51.8429 94.516 51.8669 94.548C51.8989 94.572 51.9149 94.604 51.9149 94.644V96.18C51.9149 97.1 51.6429 97.816 51.0989 98.328C50.5629 98.84 49.8389 99.096 48.9269 99.096Z" fill="currentColor"/>',
            attrs: fileIconsAttrsTemplates['88x116']
        },
        jpeg: {
            contents: '<path d="M45.3214 83.7006C38.6752 83.7006 32.029 83.7006 25.3855 83.7006C23.754 83.7006 23.2893 83.2306 23.2893 81.5751C23.2893 68.2133 23.2893 54.8514 23.2893 41.4923C23.2893 39.9088 23.7673 39.4229 25.3347 39.4229C38.7312 39.4229 52.1277 39.4229 65.5243 39.4229C67.089 39.4229 67.5697 39.9115 67.5697 41.4923C67.5697 54.8888 67.5697 68.2854 67.5697 81.6819C67.5697 83.1932 67.0704 83.7006 65.5777 83.7006C58.8221 83.7006 52.0717 83.6979 45.3214 83.7006ZM24.7926 82.1625C21.8286 84.6832 28.4375 58.7179 25.511 61.1558C24.9822 61.5964 35.1879 56.4112 35.1905 57.1215C35.2199 63.2764 24.7446 75.0277 24.7472 81.1826C24.7472 81.519 24.7766 81.8528 24.7926 82.1625C38.6137 82.1625 41.5115 63.6553 55.2792 63.6553C55.2792 59.9784 66.1171 74.8862 66.0797 71.2894C66.077 70.9823 64.0522 76.1116 63.7932 75.898C60.5115 73.1797 57.1047 69.4342 53.831 66.7052C53.3103 66.2726 55.1529 66.013 54.5921 66.3735C52.3598 67.8047 49.738 64.9716 47.4843 66.3735C46.2159 67.1639 64.7705 84.8007 63.7932 83.7005C60.1777 79.6204 28.5122 86.3414 24.7926 82.1625ZM24.8006 40.9182C24.8006 47.2386 24.8006 53.4469 24.8006 59.8261C25.2252 59.4816 25.543 59.2333 25.8474 58.9743C28.4349 56.7847 31.0303 54.6031 33.6018 52.3922C34.2213 51.8608 34.6698 51.9275 35.1905 52.5177C37.543 55.1959 39.9168 57.8581 42.288 60.523C43.6952 62.1038 45.1158 63.6765 46.531 65.2547C49.1478 63.6231 51.6685 62.0637 54.1758 60.4803C54.7846 60.0958 55.2867 60.0611 55.8741 60.555C57.8795 62.24 59.9168 63.8902 61.9462 65.5484C63.2786 66.6378 64.6165 67.7193 66.0397 68.8755C66.0397 59.4389 66.0397 50.1946 66.0397 40.9182C52.272 40.9182 38.5737 40.9182 24.8006 40.9182Z" fill="currentColor"/><path d="M55.025 37.2818C59.1666 37.2925 62.3228 40.5074 62.3121 44.7024C62.3014 48.7317 58.985 52.0161 54.9422 51.9947C50.9663 51.9761 47.5964 48.5929 47.5964 44.6169C47.5938 40.5315 50.8969 37.2684 55.025 37.2818ZM55.2792 45.0146C58.5262 45.0199 51.5565 47.9494 51.5511 44.7024C51.5458 41.45 57.8443 45.2682 54.5812 45.2789C51.4037 45.2896 60.8793 41.837 60.8713 45.0146C60.8633 48.2749 52.0322 45.0092 55.2792 45.0146Z" fill="currentColor"/><path d="M0.920898 115.57C0.920898 77.0628 0.920898 38.5982 0.920898 0.0160207C1.26803 0.0160207 1.58844 0.0160207 1.90887 0.0160207C21.8181 0.0160207 41.7274 0.0186916 61.6339 0C62.3308 0 62.8008 0.218963 63.2841 0.704944C71.4203 8.86783 79.5698 17.0174 87.7327 25.1536C88.1786 25.5995 88.3495 26.0427 88.3495 26.6622C88.3362 55.9813 88.3388 85.3005 88.3388 114.617C88.3388 114.913 88.3388 115.21 88.3388 115.567C59.1586 115.57 30.0718 115.57 0.920898 115.57ZM2.45895 113.963C30.6405 113.963 58.6752 113.963 86.742 113.963C86.742 84.9506 86.742 55.9894 86.742 26.9453C86.3121 26.9453 85.9544 26.9453 85.5965 26.9453C78.0612 26.9453 70.5284 26.9453 62.9957 26.9453C61.4924 26.9453 61.423 26.8732 61.423 25.3405C61.423 17.8078 61.423 10.2724 61.423 2.73966C61.423 2.38719 61.423 2.03471 61.423 1.66622C41.7193 1.66622 22.1332 1.66622 2.507 1.66622C2.48831 1.91188 2.4643 2.08811 2.46163 2.26435C2.37618 9.20427 2.21326 16.1469 2.22394 23.0868C2.272 49.3004 2.37617 75.5167 2.45628 101.73C2.46696 105.453 2.45895 109.175 2.45895 112.895C2.45895 113.22 2.45895 113.549 2.45895 113.963ZM85.2173 25.2951C77.8368 17.9012 70.4457 10.4967 63.0972 3.13485C63.0972 10.4379 63.0972 17.8531 63.0972 25.2951C70.5525 25.2951 77.949 25.2951 85.2173 25.2951Z" fill="currentColor"/><path d="M34.18 99.096C33.596 99.096 33.084 98.988 32.644 98.772C32.204 98.548 31.864 98.236 31.624 97.836C31.384 97.436 31.264 96.972 31.264 96.444V95.64C31.264 95.6 31.276 95.568 31.3 95.544C31.332 95.512 31.368 95.496 31.408 95.496H32.512C32.552 95.496 32.584 95.512 32.608 95.544C32.64 95.568 32.656 95.6 32.656 95.64V96.444C32.656 96.876 32.792 97.228 33.064 97.5C33.344 97.764 33.716 97.896 34.18 97.896C34.628 97.896 34.996 97.764 35.284 97.5C35.572 97.228 35.716 96.876 35.716 96.444V90.744C35.716 90.704 35.728 90.672 35.752 90.648C35.784 90.616 35.82 90.6 35.86 90.6H36.952C36.992 90.6 37.024 90.616 37.048 90.648C37.08 90.672 37.096 90.704 37.096 90.744V96.444C37.096 96.972 36.972 97.436 36.724 97.836C36.484 98.236 36.14 98.548 35.692 98.772C35.252 98.988 34.748 99.096 34.18 99.096ZM42.2207 90.588C42.7247 90.588 43.1687 90.692 43.5527 90.9C43.9367 91.108 44.2327 91.404 44.4407 91.788C44.6567 92.164 44.7647 92.6 44.7647 93.096C44.7647 93.584 44.6567 94.016 44.4407 94.392C44.2247 94.768 43.9167 95.06 43.5167 95.268C43.1247 95.468 42.6687 95.568 42.1487 95.568H40.2287C40.1887 95.568 40.1687 95.588 40.1687 95.628V98.856C40.1687 98.896 40.1527 98.932 40.1207 98.964C40.0967 98.988 40.0647 99 40.0247 99H38.9207C38.8807 99 38.8447 98.988 38.8127 98.964C38.7887 98.932 38.7767 98.896 38.7767 98.856V90.732C38.7767 90.692 38.7887 90.66 38.8127 90.636C38.8447 90.604 38.8807 90.588 38.9207 90.588H42.2207ZM42.0167 94.44C42.4247 94.44 42.7527 94.32 43.0007 94.08C43.2487 93.84 43.3727 93.524 43.3727 93.132C43.3727 92.732 43.2487 92.408 43.0007 92.16C42.7527 91.912 42.4247 91.788 42.0167 91.788H40.2287C40.1887 91.788 40.1687 91.808 40.1687 91.848V94.38C40.1687 94.42 40.1887 94.44 40.2287 94.44H42.0167ZM51.6734 91.656C51.6734 91.696 51.6574 91.732 51.6254 91.764C51.6014 91.788 51.5694 91.8 51.5294 91.8H47.4374C47.3974 91.8 47.3774 91.82 47.3774 91.86V94.104C47.3774 94.144 47.3974 94.164 47.4374 94.164H50.1854C50.2254 94.164 50.2574 94.18 50.2814 94.212C50.3134 94.236 50.3294 94.268 50.3294 94.308V95.22C50.3294 95.26 50.3134 95.296 50.2814 95.328C50.2574 95.352 50.2254 95.364 50.1854 95.364H47.4374C47.3974 95.364 47.3774 95.384 47.3774 95.424V97.74C47.3774 97.78 47.3974 97.8 47.4374 97.8H51.5294C51.5694 97.8 51.6014 97.816 51.6254 97.848C51.6574 97.872 51.6734 97.904 51.6734 97.944V98.856C51.6734 98.896 51.6574 98.932 51.6254 98.964C51.6014 98.988 51.5694 99 51.5294 99H46.1294C46.0894 99 46.0534 98.988 46.0214 98.964C45.9974 98.932 45.9854 98.896 45.9854 98.856V90.744C45.9854 90.704 45.9974 90.672 46.0214 90.648C46.0534 90.616 46.0894 90.6 46.1294 90.6H51.5294C51.5694 90.6 51.6014 90.616 51.6254 90.648C51.6574 90.672 51.6734 90.704 51.6734 90.744V91.656ZM55.8949 99.096C55.2949 99.096 54.7669 98.98 54.3109 98.748C53.8549 98.508 53.5029 98.172 53.2549 97.74C53.0069 97.308 52.8829 96.812 52.8829 96.252V93.348C52.8829 92.78 53.0069 92.284 53.2549 91.86C53.5029 91.428 53.8549 91.096 54.3109 90.864C54.7669 90.624 55.2949 90.504 55.8949 90.504C56.4869 90.504 57.0069 90.62 57.4549 90.852C57.9109 91.084 58.2629 91.4 58.5109 91.8C58.7589 92.2 58.8829 92.652 58.8829 93.156V93.252C58.8829 93.292 58.8669 93.328 58.8349 93.36C58.8109 93.384 58.7789 93.396 58.7389 93.396H57.6469C57.6069 93.396 57.5709 93.384 57.5389 93.36C57.5149 93.328 57.5029 93.292 57.5029 93.252V93.192C57.5029 92.76 57.3549 92.404 57.0589 92.124C56.7709 91.844 56.3829 91.704 55.8949 91.704C55.4069 91.704 55.0149 91.852 54.7189 92.148C54.4229 92.436 54.2749 92.82 54.2749 93.3V96.3C54.2749 96.78 54.4309 97.168 54.7429 97.464C55.0549 97.752 55.4589 97.896 55.9549 97.896C56.4349 97.896 56.8109 97.772 57.0829 97.524C57.3629 97.268 57.5029 96.92 57.5029 96.48V95.736C57.5029 95.696 57.4829 95.676 57.4429 95.676H55.9669C55.9269 95.676 55.8909 95.664 55.8589 95.64C55.8349 95.608 55.8229 95.572 55.8229 95.532V94.644C55.8229 94.604 55.8349 94.572 55.8589 94.548C55.8909 94.516 55.9269 94.5 55.9669 94.5H58.7389C58.7789 94.5 58.8109 94.516 58.8349 94.548C58.8669 94.572 58.8829 94.604 58.8829 94.644V96.18C58.8829 97.1 58.6109 97.816 58.0669 98.328C57.5309 98.84 56.8069 99.096 55.8949 99.096Z" fill="currentColor"/>',
            attrs: fileIconsAttrsTemplates['89x116']
        },
        jpg: {
            contents: '<path d="M44.4007 83.7011C37.7545 83.7011 31.1083 83.7011 24.4648 83.7011C22.8333 83.7011 22.3687 83.2311 22.3687 81.5756C22.3687 68.2138 22.3687 54.8519 22.3687 41.4928C22.3687 39.9093 22.8466 39.4233 24.414 39.4233C37.8106 39.4233 51.2071 39.4233 64.6036 39.4233C66.1684 39.4233 66.6491 39.912 66.6491 41.4928C66.6491 54.8893 66.6491 68.2858 66.6491 81.6824C66.6491 83.1937 66.1497 83.7011 64.6571 83.7011C57.9014 83.7011 51.1511 83.6984 44.4007 83.7011ZM23.8719 82.163C20.908 84.6837 27.5169 58.7184 24.5903 61.1563C24.0616 61.5969 34.2672 56.4117 34.2699 57.122C34.2993 63.2768 23.8239 75.0282 23.8266 81.183C23.8266 81.5195 23.8559 81.8533 23.8719 82.163C37.693 82.163 40.5908 63.6558 54.3585 63.6558C54.3585 59.9789 65.1964 74.8866 65.1591 71.2899C65.1564 70.9828 63.1316 76.1121 62.8725 75.8984C59.5908 73.1802 56.184 69.4347 52.9103 66.7057C52.3896 66.2731 54.2322 66.0135 53.6715 66.374C51.4391 67.8052 48.8173 64.9721 46.5636 66.374C45.2953 67.1644 63.8498 84.8011 62.8725 83.701C59.2571 79.6209 27.5916 86.3419 23.8719 82.163ZM23.88 40.9187C23.88 47.2391 23.88 53.4474 23.88 59.8266C24.3045 59.4821 24.6223 59.2338 24.9268 58.9748C27.5142 56.7852 30.1097 54.6036 32.6811 52.3926C33.3006 51.8613 33.7492 51.928 34.2699 52.5181C36.6224 55.1964 38.9961 57.8586 41.3673 60.5235C42.7745 62.1043 44.1951 63.677 45.6103 65.2551C48.2272 63.6236 50.7478 62.0642 53.2552 60.4808C53.864 60.0963 54.366 60.0615 54.9535 60.5555C56.9588 62.2404 58.9962 63.8906 61.0256 65.5489C62.358 66.6383 63.6958 67.7198 65.119 68.876C65.119 59.4394 65.119 50.1951 65.119 40.9187C51.3513 40.9187 37.653 40.9187 23.88 40.9187Z" fill="currentColor"/><path d="M54.1041 37.2823C58.2457 37.2929 61.4019 40.5079 61.3912 44.7028C61.3805 48.7322 58.0641 52.0166 54.0213 51.9952C50.0454 51.9765 46.6755 48.5934 46.6755 44.6174C46.6729 40.5319 49.976 37.2689 54.1041 37.2823ZM54.3583 45.0151C57.6053 45.0204 50.6356 47.9498 50.6302 44.7028C50.6249 41.4505 56.9234 45.2687 53.6603 45.2794C50.4828 45.2901 59.9584 41.8375 59.9504 45.0151C59.9424 48.2754 51.1113 45.0097 54.3583 45.0151Z" fill="currentColor"/><path d="M0 115.57C0 77.0628 0 38.5982 0 0.0160207C0.34713 0.0160207 0.667544 0.0160207 0.987971 0.0160207C20.8972 0.0160207 40.8065 0.0186916 60.713 0C61.4099 0 61.8799 0.218963 62.3632 0.704944C70.4994 8.86783 78.6489 17.0174 86.8118 25.1536C87.2578 25.5995 87.4286 26.0427 87.4286 26.6622C87.4153 55.9813 87.4179 85.3005 87.4179 114.617C87.4179 114.913 87.4179 115.21 87.4179 115.567C58.2377 115.57 29.1509 115.57 0 115.57ZM1.53805 113.963C29.7196 113.963 57.7543 113.963 85.8211 113.963C85.8211 84.9506 85.8211 55.9894 85.8211 26.9453C85.3912 26.9453 85.0335 26.9453 84.6756 26.9453C77.1403 26.9453 69.6075 26.9453 62.0748 26.9453C60.5715 26.9453 60.5021 26.8732 60.5021 25.3405C60.5021 17.8078 60.5021 10.2724 60.5021 2.73966C60.5021 2.38719 60.5021 2.03471 60.5021 1.66622C40.7984 1.66622 21.2123 1.66622 1.5861 1.66622C1.56741 1.91188 1.5434 2.08811 1.54073 2.26435C1.45528 9.20427 1.29236 16.1469 1.30304 23.0868C1.3511 49.3004 1.45527 75.5167 1.53538 101.73C1.54606 105.453 1.53805 109.175 1.53805 112.895C1.53805 113.22 1.53805 113.549 1.53805 113.963ZM84.2964 25.2951C76.9159 17.9012 69.5248 10.4967 62.1763 3.13485C62.1763 10.4379 62.1763 17.8531 62.1763 25.2951C69.6316 25.2951 77.0281 25.2951 84.2964 25.2951Z" fill="currentColor"/><path d="M35.803 99.0958C35.219 99.0958 34.707 98.9878 34.267 98.7718C33.827 98.5478 33.487 98.2358 33.247 97.8358C33.007 97.4358 32.887 96.9718 32.887 96.4438V95.6398C32.887 95.5998 32.899 95.5678 32.923 95.5438C32.955 95.5118 32.991 95.4958 33.031 95.4958H34.135C34.175 95.4958 34.207 95.5118 34.231 95.5438C34.263 95.5678 34.279 95.5998 34.279 95.6398V96.4438C34.279 96.8758 34.415 97.2278 34.687 97.4998C34.967 97.7638 35.339 97.8958 35.803 97.8958C36.251 97.8958 36.619 97.7638 36.907 97.4998C37.195 97.2278 37.339 96.8758 37.339 96.4438V90.7438C37.339 90.7038 37.351 90.6718 37.375 90.6478C37.407 90.6158 37.443 90.5998 37.483 90.5998H38.575C38.615 90.5998 38.647 90.6158 38.671 90.6478C38.703 90.6718 38.719 90.7038 38.719 90.7438V96.4438C38.719 96.9718 38.595 97.4358 38.347 97.8358C38.107 98.2358 37.763 98.5478 37.315 98.7718C36.875 98.9878 36.371 99.0958 35.803 99.0958ZM43.8437 90.5878C44.3477 90.5878 44.7917 90.6918 45.1757 90.8998C45.5597 91.1078 45.8557 91.4038 46.0637 91.7878C46.2797 92.1638 46.3877 92.5998 46.3877 93.0958C46.3877 93.5838 46.2797 94.0158 46.0637 94.3918C45.8477 94.7678 45.5397 95.0598 45.1397 95.2678C44.7477 95.4678 44.2917 95.5678 43.7717 95.5678H41.8517C41.8117 95.5678 41.7917 95.5878 41.7917 95.6278V98.8558C41.7917 98.8958 41.7757 98.9318 41.7437 98.9638C41.7197 98.9878 41.6877 98.9998 41.6477 98.9998H40.5437C40.5037 98.9998 40.4677 98.9878 40.4357 98.9638C40.4117 98.9318 40.3997 98.8958 40.3997 98.8558V90.7318C40.3997 90.6918 40.4117 90.6598 40.4357 90.6358C40.4677 90.6038 40.5037 90.5878 40.5437 90.5878H43.8437ZM43.6397 94.4398C44.0477 94.4398 44.3757 94.3198 44.6237 94.0798C44.8717 93.8398 44.9957 93.5238 44.9957 93.1318C44.9957 92.7318 44.8717 92.4078 44.6237 92.1598C44.3757 91.9118 44.0477 91.7878 43.6397 91.7878H41.8517C41.8117 91.7878 41.7917 91.8078 41.7917 91.8478V94.3798C41.7917 94.4198 41.8117 94.4398 41.8517 94.4398H43.6397ZM50.4164 99.0958C49.8164 99.0958 49.2884 98.9798 48.8324 98.7478C48.3764 98.5078 48.0244 98.1718 47.7764 97.7398C47.5284 97.3078 47.4044 96.8118 47.4044 96.2518V93.3478C47.4044 92.7798 47.5284 92.2838 47.7764 91.8598C48.0244 91.4278 48.3764 91.0958 48.8324 90.8638C49.2884 90.6238 49.8164 90.5038 50.4164 90.5038C51.0084 90.5038 51.5284 90.6198 51.9764 90.8518C52.4324 91.0838 52.7844 91.3998 53.0324 91.7998C53.2804 92.1998 53.4044 92.6518 53.4044 93.1558V93.2518C53.4044 93.2918 53.3884 93.3278 53.3564 93.3598C53.3324 93.3838 53.3004 93.3958 53.2604 93.3958H52.1684C52.1284 93.3958 52.0924 93.3838 52.0604 93.3598C52.0364 93.3278 52.0244 93.2918 52.0244 93.2518V93.1918C52.0244 92.7598 51.8764 92.4038 51.5804 92.1238C51.2924 91.8438 50.9044 91.7038 50.4164 91.7038C49.9284 91.7038 49.5364 91.8518 49.2404 92.1478C48.9444 92.4358 48.7964 92.8198 48.7964 93.2998V96.2998C48.7964 96.7798 48.9524 97.1678 49.2644 97.4638C49.5764 97.7518 49.9804 97.8958 50.4764 97.8958C50.9564 97.8958 51.3324 97.7718 51.6044 97.5238C51.8844 97.2678 52.0244 96.9198 52.0244 96.4798V95.7358C52.0244 95.6958 52.0044 95.6758 51.9644 95.6758H50.4884C50.4484 95.6758 50.4124 95.6638 50.3804 95.6398C50.3564 95.6078 50.3444 95.5718 50.3444 95.5318V94.6438C50.3444 94.6038 50.3564 94.5718 50.3804 94.5478C50.4124 94.5158 50.4484 94.4998 50.4884 94.4998H53.2604C53.3004 94.4998 53.3324 94.5158 53.3564 94.5478C53.3884 94.5718 53.4044 94.6038 53.4044 94.6438V96.1798C53.4044 97.0998 53.1324 97.8158 52.5884 98.3278C52.0524 98.8398 51.3284 99.0958 50.4164 99.0958Z" fill="currentColor"/>',
            attrs: fileIconsAttrsTemplates['89x116']
        },
        gif: {
            contents: '<path d="M44.8292 83.7011C38.183 83.7011 31.5368 83.7011 24.8933 83.7011C23.2618 83.7011 22.7971 83.2311 22.7971 81.5756C22.7971 68.2138 22.7971 54.8519 22.7971 41.4928C22.7971 39.9093 23.2751 39.4233 24.8425 39.4233C38.239 39.4233 51.6356 39.4233 65.0321 39.4233C66.5969 39.4233 67.0775 39.912 67.0775 41.4928C67.0775 54.8893 67.0775 68.2858 67.0775 81.6824C67.0775 83.1937 66.5782 83.7011 65.0856 83.7011C58.3299 83.7011 51.5795 83.6984 44.8292 83.7011ZM24.3004 82.163C21.3365 84.6837 27.9453 58.7184 25.0188 61.1563C24.4901 61.5969 34.6957 56.4117 34.6983 57.122C34.7277 63.2768 24.2524 75.0282 24.2551 81.183C24.2551 81.5195 24.2844 81.8533 24.3004 82.163C38.1215 82.163 41.0193 63.6558 54.787 63.6558C54.787 59.9789 65.6249 74.8866 65.5875 71.2899C65.5849 70.9828 63.56 76.1121 63.301 75.8984C60.0193 73.1802 56.6125 69.4347 53.3388 66.7057C52.8181 66.2731 54.6607 66.0135 54.0999 66.374C51.8676 67.8052 49.2458 64.9721 46.9921 66.374C45.7237 67.1644 64.2783 84.8011 63.301 83.701C59.6855 79.6209 28.02 86.3419 24.3004 82.163ZM24.3084 40.9187C24.3084 47.2391 24.3084 53.4474 24.3084 59.8266C24.733 59.4821 25.0508 59.2338 25.3552 58.9748C27.9427 56.7852 30.5381 54.6036 33.1096 52.3926C33.7291 51.8613 34.1777 51.928 34.6983 52.5181C37.0508 55.1964 39.4246 57.8586 41.7958 60.5235C43.203 62.1043 44.6236 63.677 46.0388 65.2551C48.6556 63.6236 51.1763 62.0642 53.6836 60.4808C54.2924 60.0963 54.7945 60.0615 55.3819 60.5555C57.3873 62.2404 59.4246 63.8906 61.454 65.5489C62.7865 66.6383 64.1243 67.7198 65.5475 68.876C65.5475 59.4394 65.5475 50.1951 65.5475 40.9187C51.7798 40.9187 38.0815 40.9187 24.3084 40.9187Z" fill="currentColor"/><path d="M54.5326 37.2823C58.6741 37.2929 61.8303 40.5079 61.8197 44.7028C61.809 48.7322 58.4925 52.0166 54.4498 51.9952C50.4738 51.9765 47.104 48.5934 47.104 44.6174C47.1013 40.5319 50.4044 37.2689 54.5326 37.2823ZM54.7868 45.0151C58.0338 45.0204 51.064 47.9498 51.0587 44.7028C51.0534 41.4505 57.3518 45.2687 54.0888 45.2794C50.9112 45.2901 60.3869 41.8375 60.3789 45.0151C60.3709 48.2754 51.5398 45.0097 54.7868 45.0151Z" fill="currentColor"/><path d="M0.428711 115.57C0.428711 77.0628 0.428711 38.5982 0.428711 0.0160207C0.775841 0.0160207 1.09626 0.0160207 1.41668 0.0160207C21.3259 0.0160207 41.2352 0.0186916 61.1417 0C61.8387 0 62.3086 0.218963 62.7919 0.704944C70.9281 8.86783 79.0777 17.0174 87.2405 25.1536C87.6865 25.5995 87.8573 26.0427 87.8573 26.6622C87.844 55.9813 87.8466 85.3005 87.8466 114.617C87.8466 114.913 87.8466 115.21 87.8466 115.567C58.6664 115.57 29.5796 115.57 0.428711 115.57ZM1.96677 113.963C30.1484 113.963 58.1831 113.963 86.2498 113.963C86.2498 84.9506 86.2498 55.9894 86.2498 26.9453C85.8199 26.9453 85.4622 26.9453 85.1044 26.9453C77.569 26.9453 70.0362 26.9453 62.5035 26.9453C61.0002 26.9453 60.9308 26.8732 60.9308 25.3405C60.9308 17.8078 60.9308 10.2724 60.9308 2.73966C60.9308 2.38719 60.9308 2.03471 60.9308 1.66622C41.2272 1.66622 21.641 1.66622 2.01481 1.66622C1.99612 1.91188 1.97211 2.08811 1.96944 2.26435C1.88399 9.20427 1.72107 16.1469 1.73175 23.0868C1.77982 49.3004 1.88399 75.5167 1.96409 101.73C1.97477 105.453 1.96677 109.175 1.96677 112.895C1.96677 113.22 1.96677 113.549 1.96677 113.963ZM84.7251 25.2951C77.3446 17.9012 69.9535 10.4967 62.605 3.13485C62.605 10.4379 62.605 17.8531 62.605 25.2951C70.0603 25.2951 77.4568 25.2951 84.7251 25.2951Z" fill="currentColor"/><path d="M41.6479 99.0958C41.0479 99.0958 40.5199 98.9798 40.0639 98.7478C39.6079 98.5078 39.2559 98.1718 39.0079 97.7398C38.7599 97.3078 38.6359 96.8118 38.6359 96.2518V93.3478C38.6359 92.7798 38.7599 92.2838 39.0079 91.8598C39.2559 91.4278 39.6079 91.0958 40.0639 90.8638C40.5199 90.6238 41.0479 90.5038 41.6479 90.5038C42.2399 90.5038 42.7599 90.6198 43.2079 90.8518C43.6639 91.0838 44.0159 91.3998 44.2639 91.7998C44.5119 92.1998 44.6359 92.6518 44.6359 93.1558V93.2518C44.6359 93.2918 44.6199 93.3278 44.5879 93.3598C44.5639 93.3838 44.5319 93.3958 44.4919 93.3958H43.3999C43.3599 93.3958 43.3239 93.3838 43.2919 93.3598C43.2679 93.3278 43.2559 93.2918 43.2559 93.2518V93.1918C43.2559 92.7598 43.1079 92.4038 42.8119 92.1238C42.5239 91.8438 42.1359 91.7038 41.6479 91.7038C41.1599 91.7038 40.7679 91.8518 40.4719 92.1478C40.1759 92.4358 40.0279 92.8198 40.0279 93.2998V96.2998C40.0279 96.7798 40.1839 97.1678 40.4959 97.4638C40.8079 97.7518 41.2119 97.8958 41.7079 97.8958C42.1879 97.8958 42.5639 97.7718 42.8359 97.5238C43.1159 97.2678 43.2559 96.9198 43.2559 96.4798V95.7358C43.2559 95.6958 43.2359 95.6758 43.1959 95.6758H41.7199C41.6799 95.6758 41.6439 95.6638 41.6119 95.6398C41.5879 95.6078 41.5759 95.5718 41.5759 95.5318V94.6438C41.5759 94.6038 41.5879 94.5718 41.6119 94.5478C41.6439 94.5158 41.6799 94.4998 41.7199 94.4998H44.4919C44.5319 94.4998 44.5639 94.5158 44.5879 94.5478C44.6199 94.5718 44.6359 94.6038 44.6359 94.6438V96.1798C44.6359 97.0998 44.3639 97.8158 43.8199 98.3278C43.2839 98.8398 42.5599 99.0958 41.6479 99.0958ZM46.3432 98.9998C46.3032 98.9998 46.2672 98.9878 46.2352 98.9638C46.2112 98.9318 46.1992 98.8958 46.1992 98.8558V90.7438C46.1992 90.7038 46.2112 90.6718 46.2352 90.6478C46.2672 90.6158 46.3032 90.5998 46.3432 90.5998H47.4472C47.4872 90.5998 47.5192 90.6158 47.5432 90.6478C47.5752 90.6718 47.5912 90.7038 47.5912 90.7438V98.8558C47.5912 98.8958 47.5752 98.9318 47.5432 98.9638C47.5192 98.9878 47.4872 98.9998 47.4472 98.9998H46.3432ZM55.0159 91.6558C55.0159 91.6958 54.9999 91.7318 54.9679 91.7638C54.9439 91.7878 54.9119 91.7998 54.8719 91.7998H50.7919C50.7519 91.7998 50.7319 91.8198 50.7319 91.8598V94.1038C50.7319 94.1438 50.7519 94.1638 50.7919 94.1638H53.5399C53.5799 94.1638 53.6119 94.1798 53.6359 94.2118C53.6679 94.2358 53.6839 94.2678 53.6839 94.3078V95.2198C53.6839 95.2598 53.6679 95.2958 53.6359 95.3278C53.6119 95.3518 53.5799 95.3638 53.5399 95.3638H50.7919C50.7519 95.3638 50.7319 95.3838 50.7319 95.4238V98.8558C50.7319 98.8958 50.7159 98.9318 50.6839 98.9638C50.6599 98.9878 50.6279 98.9998 50.5879 98.9998H49.4839C49.4439 98.9998 49.4079 98.9878 49.3759 98.9638C49.3519 98.9318 49.3399 98.8958 49.3399 98.8558V90.7438C49.3399 90.7038 49.3519 90.6718 49.3759 90.6478C49.4079 90.6158 49.4439 90.5998 49.4839 90.5998H54.8719C54.9119 90.5998 54.9439 90.6158 54.9679 90.6478C54.9999 90.6718 55.0159 90.7038 55.0159 90.7438V91.6558Z" fill="currentColor"/>',
            attrs: fileIconsAttrsTemplates['88x116']
        },
        bmp: {
            contents: '<path d="M45.2576 83.7011C38.6114 83.7011 31.9653 83.7011 25.3217 83.7011C23.6902 83.7011 23.2256 83.2311 23.2256 81.5756C23.2256 68.2138 23.2256 54.8519 23.2256 41.4928C23.2256 39.9093 23.7035 39.4233 25.271 39.4233C38.6675 39.4233 52.064 39.4233 65.4606 39.4233C67.0253 39.4233 67.506 39.912 67.506 41.4928C67.506 54.8893 67.506 68.2858 67.506 81.6824C67.506 83.1937 67.0067 83.7011 65.514 83.7011C58.7583 83.7011 52.008 83.6984 45.2576 83.7011ZM24.7289 82.163C21.7649 84.6837 28.3738 58.7184 25.4472 61.1563C24.9185 61.5969 35.1241 56.4117 35.1268 57.122C35.1562 63.2768 24.6809 75.0282 24.6835 81.183C24.6835 81.5195 24.7129 81.8533 24.7289 82.163C38.55 82.163 41.4477 63.6558 55.2154 63.6558C55.2154 59.9789 66.0534 74.8866 66.016 71.2899C66.0133 70.9828 63.9885 76.1121 63.7295 75.8984C60.4478 73.1802 57.0409 69.4347 53.7672 66.7057C53.2465 66.2731 55.0891 66.0135 54.5284 66.374C52.2961 67.8052 49.6742 64.9721 47.4206 66.374C46.1522 67.1644 64.7068 84.8011 63.7295 83.701C60.114 79.6209 28.4485 86.3419 24.7289 82.163ZM24.7369 40.9187C24.7369 47.2391 24.7369 53.4474 24.7369 59.8266C25.1615 59.4821 25.4793 59.2338 25.7837 58.9748C28.3711 56.7852 30.9666 54.6036 33.538 52.3926C34.1575 51.8613 34.6061 51.928 35.1268 52.5181C37.4793 55.1964 39.8531 57.8586 42.2242 60.5235C43.6314 62.1043 45.052 63.677 46.4673 65.2551C49.0841 63.6236 51.6047 62.0642 54.1121 60.4808C54.7209 60.0963 55.2229 60.0615 55.8104 60.5555C57.8157 62.2404 59.8531 63.8906 61.8825 65.5489C63.2149 66.6383 64.5527 67.7198 65.976 68.876C65.976 59.4394 65.976 50.1951 65.976 40.9187C52.2083 40.9187 38.51 40.9187 24.7369 40.9187Z" fill="currentColor"/><path d="M54.9611 37.2823C59.1026 37.2929 62.2588 40.5079 62.2481 44.7028C62.2374 48.7322 58.921 52.0166 54.8783 51.9952C50.9023 51.9765 47.5325 48.5934 47.5325 44.6174C47.5298 40.5319 50.8329 37.2689 54.9611 37.2823ZM55.2152 45.0151C58.4622 45.0204 51.4925 47.9498 51.4872 44.7028C51.4818 41.4505 57.7803 45.2687 54.5173 45.2794C51.3397 45.2901 60.8154 41.8375 60.8073 45.0151C60.7993 48.2754 51.9682 45.0097 55.2152 45.0151Z" fill="currentColor"/><path d="M0.857178 115.57C0.857178 77.0628 0.857178 38.5982 0.857178 0.0160207C1.20431 0.0160207 1.52472 0.0160207 1.84515 0.0160207C21.7544 0.0160207 41.6636 0.0186916 61.5702 0C62.2671 0 62.7371 0.218963 63.2204 0.704944C71.3566 8.86783 79.5061 17.0174 87.669 25.1536C88.1149 25.5995 88.2858 26.0427 88.2858 26.6622C88.2724 55.9813 88.2751 85.3005 88.2751 114.617C88.2751 114.913 88.2751 115.21 88.2751 115.567C59.0948 115.57 30.0081 115.57 0.857178 115.57ZM2.39523 113.963C30.5768 113.963 58.6115 113.963 86.6783 113.963C86.6783 84.9506 86.6783 55.9894 86.6783 26.9453C86.2484 26.9453 85.8906 26.9453 85.5328 26.9453C77.9974 26.9453 70.4647 26.9453 62.932 26.9453C61.4286 26.9453 61.3592 26.8732 61.3592 25.3405C61.3592 17.8078 61.3592 10.2724 61.3592 2.73966C61.3592 2.38719 61.3592 2.03471 61.3592 1.66622C41.6556 1.66622 22.0695 1.66622 2.44328 1.66622C2.42459 1.91188 2.40058 2.08811 2.3979 2.26435C2.31246 9.20427 2.14954 16.1469 2.16022 23.0868C2.20828 49.3004 2.31245 75.5167 2.39256 101.73C2.40324 105.453 2.39523 109.175 2.39523 112.895C2.39523 113.22 2.39523 113.549 2.39523 113.963ZM85.1536 25.2951C77.7731 17.9012 70.3819 10.4967 63.0335 3.13485C63.0335 10.4379 63.0335 17.8531 63.0335 25.2951C70.4888 25.2951 77.8852 25.2951 85.1536 25.2951Z" fill="currentColor"/><path d="M38.504 94.62C38.456 94.644 38.456 94.668 38.504 94.692C39.32 95.076 39.728 95.736 39.728 96.672C39.728 97.432 39.472 98.012 38.96 98.412C38.456 98.804 37.796 99 36.98 99H33.956C33.916 99 33.88 98.988 33.848 98.964C33.824 98.932 33.812 98.896 33.812 98.856V90.744C33.812 90.704 33.824 90.672 33.848 90.648C33.88 90.616 33.916 90.6 33.956 90.6H36.884C37.756 90.6 38.428 90.788 38.9 91.164C39.372 91.54 39.608 92.108 39.608 92.868C39.608 93.708 39.24 94.292 38.504 94.62ZM35.264 91.8C35.224 91.8 35.204 91.82 35.204 91.86V94.08C35.204 94.12 35.224 94.14 35.264 94.14H36.884C37.308 94.14 37.64 94.04 37.88 93.84C38.128 93.632 38.252 93.348 38.252 92.988C38.252 92.62 38.128 92.332 37.88 92.124C37.64 91.908 37.308 91.8 36.884 91.8H35.264ZM36.98 97.788C37.396 97.788 37.724 97.676 37.964 97.452C38.212 97.228 38.336 96.924 38.336 96.54C38.336 96.148 38.212 95.844 37.964 95.628C37.716 95.404 37.38 95.292 36.956 95.292H35.264C35.224 95.292 35.204 95.312 35.204 95.352V97.728C35.204 97.768 35.224 97.788 35.264 97.788H36.98ZM46.6889 90.696C46.7289 90.632 46.7849 90.6 46.8569 90.6H47.9609C48.0009 90.6 48.0329 90.616 48.0569 90.648C48.0889 90.672 48.1049 90.704 48.1049 90.744V98.856C48.1049 98.896 48.0889 98.932 48.0569 98.964C48.0329 98.988 48.0009 99 47.9609 99H46.8569C46.8169 99 46.7809 98.988 46.7489 98.964C46.7249 98.932 46.7129 98.896 46.7129 98.856V93.132C46.7129 93.108 46.7009 93.092 46.6769 93.084C46.6609 93.076 46.6489 93.084 46.6409 93.108L45.1409 95.412C45.1009 95.476 45.0449 95.508 44.9729 95.508H44.4209C44.3489 95.508 44.2929 95.476 44.2529 95.412L42.7409 93.12C42.7329 93.096 42.7169 93.088 42.6929 93.096C42.6769 93.104 42.6689 93.12 42.6689 93.144V98.856C42.6689 98.896 42.6529 98.932 42.6209 98.964C42.5969 98.988 42.5649 99 42.5249 99H41.4209C41.3809 99 41.3449 98.988 41.3129 98.964C41.2889 98.932 41.2769 98.896 41.2769 98.856V90.744C41.2769 90.704 41.2889 90.672 41.3129 90.648C41.3449 90.616 41.3809 90.6 41.4209 90.6H42.5249C42.5969 90.6 42.6529 90.632 42.6929 90.696L44.6489 93.66C44.6649 93.676 44.6809 93.684 44.6969 93.684C44.7129 93.684 44.7249 93.676 44.7329 93.66L46.6889 90.696ZM53.227 90.588C53.731 90.588 54.175 90.692 54.559 90.9C54.943 91.108 55.239 91.404 55.447 91.788C55.663 92.164 55.771 92.6 55.771 93.096C55.771 93.584 55.663 94.016 55.447 94.392C55.231 94.768 54.923 95.06 54.523 95.268C54.131 95.468 53.675 95.568 53.155 95.568H51.235C51.195 95.568 51.175 95.588 51.175 95.628V98.856C51.175 98.896 51.159 98.932 51.127 98.964C51.103 98.988 51.071 99 51.031 99H49.927C49.887 99 49.851 98.988 49.819 98.964C49.795 98.932 49.783 98.896 49.783 98.856V90.732C49.783 90.692 49.795 90.66 49.819 90.636C49.851 90.604 49.887 90.588 49.927 90.588H53.227ZM53.023 94.44C53.431 94.44 53.759 94.32 54.007 94.08C54.255 93.84 54.379 93.524 54.379 93.132C54.379 92.732 54.255 92.408 54.007 92.16C53.759 91.912 53.431 91.788 53.023 91.788H51.235C51.195 91.788 51.175 91.808 51.175 91.848V94.38C51.175 94.42 51.195 94.44 51.235 94.44H53.023Z" fill="currentColor"/>',
            attrs: fileIconsAttrsTemplates['89x116']
        },
        rar: {
            contents: '<path d="M0 115.57C0 77.0628 0 38.5981 0 0.0160044C0.347108 0.0160044 0.667503 0.0160044 0.987911 0.0160044C20.8959 0.0160044 40.8039 0.0186916 60.7092 0C61.4061 0 61.876 0.218963 62.3593 0.704944C70.495 8.86783 78.644 17.0174 86.8064 25.1535C87.2523 25.5995 87.4232 26.0427 87.4232 26.6622C87.4099 55.9813 87.4125 85.3005 87.4125 114.617C87.4125 114.913 87.4125 115.21 87.4125 115.568C58.2314 115.57 29.1464 115.57 0 115.57ZM1.53796 113.965C29.7178 113.965 57.7508 113.965 85.8158 113.965C85.8158 84.9533 85.8158 55.992 85.8158 26.948C85.386 26.948 85.0282 26.948 84.6704 26.948C77.1381 26.948 69.6032 26.948 62.071 26.948C60.5677 26.948 60.4983 26.8759 60.4983 25.3432C60.4983 17.8104 60.4983 10.275 60.4983 2.74233C60.4983 2.38986 60.4983 2.03738 60.4983 1.66889C40.7959 1.66889 21.211 1.66889 1.586 1.66889C1.56731 1.91455 1.5433 2.09079 1.54063 2.26702C1.45519 9.20695 1.29228 16.1495 1.30296 23.0895C1.35102 49.3031 1.45519 75.5194 1.53529 101.733C1.54597 105.455 1.53796 109.178 1.53796 112.897C1.53796 113.223 1.53796 113.549 1.53796 113.965ZM84.2886 25.2951C76.9085 17.9012 69.5178 10.4967 62.1697 3.13485C62.1697 10.4379 62.1697 17.8531 62.1697 25.2951C69.6246 25.2951 77.0207 25.2951 84.2886 25.2951Z" fill="currentColor"/><path d="M14.6235 14.9553C15.4493 16.62 16.2453 18.2209 17.0611 19.8684C16.8652 19.9248 16.7611 19.9615 16.6545 19.9836C14.8319 20.3709 13.6987 19.6992 13.2399 17.885C13.111 17.38 12.8158 16.9166 12.5902 16.4361C12.0471 15.2741 12.0447 15.2741 10.4924 15.431C10.4924 16.8946 10.4924 18.3802 10.4924 19.9272C9.57734 19.9272 8.8161 19.9272 7.98291 19.9272C7.98291 16.0757 7.98291 12.2561 7.98291 8.38746C9.989 8.38746 12.0372 8.25508 14.0557 8.43405C15.4543 8.55663 16.2528 9.6525 16.5305 11.0033C16.8777 12.6827 16.3916 13.6633 14.6235 14.9553ZM10.5494 13.4108C11.7273 13.1117 12.791 12.9303 13.7581 12.5258C13.9441 12.4473 13.9293 11.1137 13.721 11.0278C12.7638 10.6258 11.7049 10.4615 10.5519 10.1796C10.5494 11.3833 10.5494 12.2169 10.5494 13.4108Z" fill="currentColor"/><path d="M34.6743 14.9899C35.4627 16.6502 36.2392 18.2835 37.0873 20.0717C36.2153 20.0717 35.5081 20.1258 34.8153 20.0446C34.5381 20.0126 34.1916 19.7322 34.0579 19.469C33.5824 18.5294 33.1333 17.5677 32.7701 16.5764C32.407 15.5876 31.8742 15.0809 30.6796 15.5532C30.6796 16.9773 30.6796 18.4679 30.6796 20.0151C29.8076 20.0151 29.0741 20.0151 28.2761 20.0151C28.2761 16.1238 28.2761 12.2941 28.2761 8.39294C30.197 8.39294 32.137 8.2478 34.046 8.43966C35.4842 8.58479 36.3228 9.72611 36.545 11.1946C36.7624 12.6286 36.4207 13.8806 35.0972 14.6677C34.9658 14.7464 34.8511 14.8546 34.6743 14.9899ZM30.7274 13.551C31.9435 13.1697 32.9684 12.9237 33.9098 12.4859C34.0698 12.4121 34.0698 11.3569 33.8118 11.0494C32.9637 10.0385 31.8097 10.5673 30.7274 10.5132C30.7274 11.4553 30.7274 12.2522 30.7274 13.551Z" fill="currentColor"/><path d="M27.4747 19.6956C25.0198 19.9538 25.0198 19.9538 24.1692 17.3548C23.77 17.3548 23.3162 17.4132 22.8823 17.345C21.449 17.1185 20.519 17.4839 20.3504 19.0818C20.3231 19.3473 19.8099 19.6932 19.4677 19.7638C18.9172 19.8783 18.327 19.7955 17.5955 19.7955C18.4237 16.9699 19.2172 14.2637 20.0132 11.5575C20.105 11.2457 20.2066 10.9388 20.3008 10.6294C21.1167 7.90859 21.1167 7.9086 24.1295 8.20334C25.233 12.0032 26.3514 15.8397 27.4747 19.6956ZM22.7384 11.7134C22.6417 11.7061 22.545 11.6988 22.4507 11.6914C22.1482 12.8046 21.8433 13.9178 21.5159 15.1211C22.2772 15.1211 22.9145 15.1211 23.6435 15.1211C23.3286 13.9373 23.0335 12.8265 22.7384 11.7134Z" fill="currentColor"/><path d="M82.9485 92.5024H86.3582V90.0512H82.3183V89.7334C81.7736 88.8255 81.229 87.9176 80.6843 87.0071C79.8325 87.704 78.9834 88.401 78.1317 89.0979C78.2572 89.3222 78.3826 89.5491 78.5108 89.7734H74.9943C74.164 88.6947 73.4778 87.8055 72.7942 86.919C72.0973 87.7895 71.4004 88.6599 70.4579 89.8375H67.5502C66.6905 88.7668 65.9428 87.8375 65.1979 86.9083C64.5998 87.7574 64.0017 88.6039 63.1766 89.7788H60.1087C59.2597 88.6813 58.5761 87.7975 57.8926 86.9136C57.1903 87.7921 56.4908 88.668 55.5456 89.8482H52.208C51.9997 89.0765 52.0185 88.0485 51.5218 87.6319C51.0866 87.2661 49.4258 87.5091 49.4124 87.6159C49.0493 90.5986 46.9827 90.0752 45.2151 89.8616C44.4087 88.8042 43.6745 87.8429 42.9402 86.8816C42.2487 87.7734 41.5545 88.668 40.6386 89.8482H37.8297C36.9753 88.7027 36.3051 87.8082 35.6349 86.9136C34.906 87.7494 34.1798 88.5852 33.1037 89.8215H30.3936C29.5231 88.7481 28.7702 87.8188 28.0146 86.8869C27.3284 87.7895 26.6395 88.692 25.7557 89.8562H23.0803C22.1031 88.7908 21.2459 87.8562 20.3862 86.9243C19.7961 87.7895 19.206 88.6546 18.4077 89.8269H18.3783V90.0351H1.79456C1.54891 90.0725 1.30326 90.1072 1.05762 90.1313C1.05762 90.5745 1.05762 91.0205 1.05762 91.4637C1.05762 91.7521 1.05762 92.0458 1.05762 92.3449H6.40844V93.0285C6.52058 93.1273 6.63272 93.2287 6.74487 93.3275C6.47519 95.6453 6.23754 97.9684 5.92514 100.281C5.66881 102.177 6.47785 102.903 8.33622 102.868C16.9765 102.713 16.1461 104.019 14.9846 95.7388C14.8752 94.9537 14.8806 94.15 14.8218 93.1593H18.2929C19.1527 94.206 19.9163 95.1353 20.6799 96.0618C21.3528 95.178 22.0283 94.2941 22.9441 93.0925H25.5715C26.6368 94.2835 27.4298 95.17 28.2228 96.0592C28.8717 95.1459 29.5205 94.2327 30.3455 93.0765H33.1544C34.0916 94.2835 34.7858 95.178 35.4774 96.0699C36.1636 95.2207 36.8525 94.3716 37.8591 93.1273H40.6894C41.5224 94.1713 42.2807 95.1193 43.039 96.0672C43.7065 95.17 44.3714 94.2728 45.2499 93.0899H47.9279C49.012 94.2728 49.8156 95.1513 50.6193 96.0298C51.1907 95.1727 51.7622 94.3128 52.5391 93.1486H55.6765C56.4748 94.2487 57.1343 95.1566 57.7938 96.0645C58.4827 95.2234 59.1716 94.3796 60.1889 93.138H63.0138C63.943 94.2968 64.6425 95.1673 65.3421 96.0405C66.0123 95.1566 66.6797 94.2755 67.5689 93.1006C69.0241 93.0899 71.3364 92.0004 71.6701 95.3329C71.6968 95.6052 72.7702 96.0725 72.8369 95.9978C73.5071 95.2207 74.0705 94.3502 74.9035 93.1673H78.0062C78.7939 94.2408 79.4613 95.1486 80.1262 96.0565C80.9272 95.0738 81.7309 94.0912 82.9405 92.6092V92.5024H82.9485ZM9.00106 99.6479C9.32681 97.3382 9.62852 95.2154 9.92756 93.0925C10.3895 93.0231 10.8541 92.9537 11.316 92.8843C11.7539 95.0471 12.1918 97.2127 12.6831 99.6479H9.00106Z" fill="currentColor"/><path d="M43.9091 77.7184C35.6773 77.7184 27.4428 77.721 19.211 77.7157C17.8306 77.7157 17.0857 77.1816 16.8721 76.0895C16.6745 75.0748 17.1684 74.1536 18.1484 73.8465C18.5916 73.7077 19.0829 73.6649 19.5501 73.6649C35.7788 73.6569 52.0074 73.6569 68.2334 73.6649C68.6686 73.6649 69.1225 73.7077 69.5364 73.8305C70.4763 74.1055 71.069 75.0321 70.9489 75.932C70.8207 76.8799 70.0784 77.6062 69.1172 77.6997C68.7808 77.7317 68.4363 77.7184 68.0972 77.7184C60.0336 77.7184 51.9727 77.7184 43.9091 77.7184Z" fill="currentColor"/><path d="M43.9098 61.5944C52.0054 61.5944 60.1037 61.5944 68.1993 61.597C68.5731 61.597 68.9549 61.581 69.3181 61.6451C70.2019 61.8 70.9281 62.601 70.9495 63.4929C70.9735 64.4328 70.5329 65.1324 69.6358 65.4662C69.294 65.5917 68.9069 65.6478 68.5411 65.6504C52.1095 65.6585 35.6779 65.6584 19.2463 65.6584C19.0755 65.6584 18.9046 65.6638 18.7364 65.6424C17.5562 65.4902 16.7472 64.6037 16.8006 63.5303C16.8567 62.4221 17.6897 61.6211 18.9046 61.6077C21.353 61.581 23.8041 61.5997 26.2526 61.597C32.1401 61.5944 38.0249 61.5944 43.9098 61.5944Z" fill="currentColor"/><path d="M43.8218 41.7771C35.7582 41.7771 27.6973 41.7771 19.6337 41.7744C19.2278 41.7744 18.8087 41.7878 18.4162 41.7077C17.4603 41.5154 16.7981 40.6796 16.8008 39.7424C16.8035 38.8399 17.4069 38.0361 18.3307 37.8172C18.7526 37.7157 19.2065 37.7184 19.6444 37.7184C35.8036 37.713 51.9629 37.713 68.1221 37.7184C68.5279 37.7184 68.9445 37.7077 69.3396 37.7905C70.2929 37.9907 70.9737 38.8399 70.9683 39.7531C70.9657 40.7037 70.2261 41.5662 69.2328 41.7317C68.867 41.7931 68.4879 41.7744 68.1141 41.7744C60.0131 41.7771 51.9175 41.7771 43.8218 41.7771Z" fill="currentColor"/><path d="M43.8482 53.7197C35.8594 53.7197 27.8706 53.7224 19.8817 53.7144C19.3744 53.7144 18.8591 53.6984 18.3598 53.6102C17.4707 53.45 16.8191 52.6276 16.7951 51.7277C16.7711 50.8385 17.3905 49.9761 18.269 49.7731C18.7256 49.6663 19.2089 49.6289 19.6815 49.6289C35.7953 49.6209 51.9092 49.6209 68.023 49.6289C68.4956 49.6289 68.9762 49.6663 69.4354 49.7678C70.3272 49.9654 70.9707 50.8065 70.9707 51.685C70.9707 52.6036 70.2738 53.458 69.3366 53.6209C68.8721 53.701 68.3914 53.7171 67.9161 53.7197C59.8926 53.7224 51.8691 53.7197 43.8482 53.7197Z" fill="currentColor"/>',
            attrs: fileIconsAttrsTemplates['88x116']
        },
        zip: {
            contents: '<path d="M0.42334 115.57C0.42334 77.0628 0.42334 38.5981 0.42334 0.0160044C0.770448 0.0160044 1.09084 0.0160044 1.41125 0.0160044C21.3192 0.0160044 41.2272 0.0186916 61.1326 0C61.8294 0 62.2994 0.218963 62.7827 0.704944C70.9184 8.86783 79.0674 17.0174 87.2298 25.1535C87.6757 25.5995 87.8466 26.0427 87.8466 26.6622C87.8332 55.9813 87.8359 85.3005 87.8359 114.617C87.8359 114.913 87.8359 115.21 87.8359 115.567C58.6574 115.57 29.5724 115.57 0.42334 115.57ZM1.96397 113.965C30.1438 113.965 58.1768 113.965 86.2419 113.965C86.2419 84.9533 86.2419 55.992 86.2419 26.9479C85.812 26.9479 85.4542 26.9479 85.0964 26.9479C77.5641 26.9479 70.0292 26.9479 62.497 26.9479C60.9937 26.9479 60.9243 26.8758 60.9243 25.3431C60.9243 17.8104 60.9243 10.275 60.9243 2.7423C60.9243 2.38983 60.9243 2.03738 60.9243 1.66889C41.2219 1.66889 21.637 1.66889 2.01202 1.66889C1.99332 1.91455 1.96931 2.09079 1.96664 2.26702C1.8812 9.20695 1.71829 16.1495 1.72897 23.0895C1.77703 49.3031 1.8812 75.5194 1.9613 101.733C1.97198 105.455 1.96397 109.178 1.96397 112.897C1.96397 113.22 1.96397 113.549 1.96397 113.965ZM84.7146 25.2951C77.3345 17.9012 69.9438 10.4967 62.5957 3.13485C62.5957 10.4379 62.5957 17.8531 62.5957 25.2951C70.0506 25.2951 77.4467 25.2951 84.7146 25.2951Z" fill="currentColor"/><path d="M83.3748 92.4986H86.7844V90.0474H82.7446V89.7296C82.1999 88.8217 81.6552 87.9138 81.1105 87.0033C80.2588 87.7002 79.4097 88.3971 78.5579 89.0941C78.6834 89.3184 78.809 89.5454 78.9371 89.7697H75.4206C74.5902 88.6909 73.904 87.8017 73.2205 86.9152C72.5236 87.7857 71.8267 88.6562 70.8842 89.8337H67.9765C67.1168 88.763 66.3691 87.8337 65.6242 86.9045C65.0261 87.7536 64.428 88.6001 63.6029 89.775H60.535C59.6859 88.6775 59.0024 87.7937 58.3188 86.9098C57.6166 87.7884 56.9171 88.6642 55.9719 89.8444H52.6343C52.4261 89.0727 52.4447 88.0447 51.9481 87.6281C51.5129 87.2623 49.8521 87.5053 49.8387 87.6121C49.4756 90.5948 47.409 90.0714 45.6414 89.8578C44.835 88.8003 44.1007 87.8391 43.3665 86.8778C42.6749 87.7697 41.9808 88.6642 41.0649 89.8444H38.256C37.4016 88.6989 36.7314 87.8044 36.0612 86.9098C35.3323 87.7456 34.606 88.5814 33.53 89.8177H30.8199C29.9494 88.7443 29.1965 87.8151 28.4408 86.8832C27.7546 87.7857 27.0684 88.6882 26.182 89.8524H23.5066C22.5293 88.787 21.6722 87.8524 20.8125 86.9205C20.2224 87.7857 19.6323 88.6508 18.834 89.8231H18.8046V90.0313H2.22083C1.97518 90.0687 1.72953 90.1034 1.48389 90.1275C1.48389 90.5707 1.48389 91.0166 1.48389 91.4599C1.48389 91.7483 1.48389 92.042 1.48389 92.3411H6.83471V93.0247C6.94685 93.1235 7.05899 93.2249 7.17114 93.3237C6.90146 95.6415 6.66381 97.9646 6.35141 100.277C6.09508 102.173 6.90412 102.899 8.76249 102.864C17.4028 102.71 16.5724 104.015 15.4109 95.7349C15.3014 94.9499 15.3068 94.1462 15.2481 93.1555H18.7192C19.5789 94.2022 20.3426 95.1315 21.1062 96.0581C21.779 95.1742 22.4546 94.2904 23.3704 93.0888H25.9978C27.0605 94.2797 27.8561 95.1662 28.6491 96.0554C29.2979 95.1422 29.9468 94.2289 30.7718 93.0727H33.5807C34.5179 94.2797 35.2121 95.1742 35.9037 96.066C36.5899 95.2169 37.2788 94.3678 38.2854 93.1235H41.1156C41.9487 94.1675 42.707 95.1155 43.4653 96.0634C44.1328 95.1662 44.7977 94.269 45.6761 93.0861H48.3542C49.4383 94.269 50.2419 95.1475 51.0456 96.026C51.617 95.1689 52.1884 94.309 52.9654 93.1448H56.1027C56.9011 94.245 57.5606 95.1529 58.2201 96.0607C58.909 95.2196 59.5978 94.3758 60.6151 93.1341H63.4401C64.3693 94.293 65.0688 95.1635 65.7684 96.0367C66.4386 95.1528 67.106 94.2716 67.9952 93.0967C69.4503 93.0861 71.7653 91.9966 72.0964 95.3291C72.1231 95.6015 73.1965 96.0687 73.2633 95.994C73.9334 95.2169 74.4968 94.3464 75.3299 93.1635H78.4325C79.2201 94.2369 79.8876 95.1448 80.5525 96.0527C81.3535 95.0701 82.1572 94.0874 83.3667 92.6054V92.4986H83.3748ZM9.42733 99.6468C9.75308 97.3371 10.0548 95.2143 10.3538 93.0914C10.8158 93.022 11.2803 92.9526 11.7423 92.8831C12.1801 95.046 12.6181 97.2116 13.1094 99.6468H9.42733Z" fill="currentColor"/><path d="M26.6765 13.4228C26.6765 15.2092 26.6765 16.7552 26.6765 18.4081C25.6405 18.4081 24.6872 18.4081 23.6272 18.4081C23.6272 14.2719 23.6272 10.0824 23.6272 5.83937C25.9448 5.83937 28.2998 5.63375 30.6041 5.89543C32.9885 6.16779 34.0191 7.68182 33.9069 9.94351C33.8135 11.826 32.3743 13.2092 30.1715 13.4041C29.0741 13.5029 27.9634 13.4228 26.6765 13.4228ZM26.7325 11.0543C27.6697 11.0543 28.5482 11.1051 29.4159 11.041C30.2624 10.9769 30.7964 10.5309 30.8044 9.58834C30.8097 8.62973 30.2356 8.21052 29.4106 8.13576C28.5455 8.05832 27.6644 8.11705 26.7352 8.11705C26.7325 9.13707 26.7325 10.0423 26.7325 11.0543Z" fill="currentColor"/><path d="M9.92276 16.1595C12.2991 16.1595 14.291 16.1595 16.3897 16.1595C16.3897 16.9178 16.3897 17.6041 16.3897 18.4052C13.0387 18.4052 9.65308 18.4052 6.24073 18.4052C6.00577 17.1101 6.17935 16.0207 7.07115 14.9499C8.84941 12.8084 10.4782 10.544 12.3419 8.10076C10.2966 8.10076 8.50762 8.10076 6.64392 8.10076C6.64392 7.25162 6.64392 6.56003 6.64392 5.78833C9.85333 5.78833 13.0307 5.78833 16.2321 5.78833C16.5659 7.07004 16.2908 8.0954 15.4444 9.11542C13.6128 11.3237 11.8959 13.6254 9.92276 16.1595Z" fill="currentColor"/><path d="M21.3238 18.4756C20.3359 18.4756 19.4574 18.4756 18.4722 18.4756C18.4722 14.2486 18.4722 10.0617 18.4722 5.79199C19.3907 5.79199 20.3038 5.79199 21.3238 5.79199C21.3238 9.97624 21.3238 14.1632 21.3238 18.4756Z" fill="currentColor"/><path d="M44.208 76.204C35.9762 76.204 27.7417 76.2066 19.5099 76.2013C18.1294 76.2013 17.3845 75.6672 17.1709 74.5751C16.9733 73.5604 17.4673 72.6392 18.4472 72.3321C18.8904 72.1933 19.3817 72.1505 19.849 72.1505C36.0776 72.1425 52.3062 72.1425 68.5322 72.1505C68.9674 72.1505 69.4214 72.1933 69.8352 72.3161C70.7751 72.5911 71.3679 73.5177 71.2477 74.4176C71.1195 75.3655 70.3772 76.0918 69.416 76.1853C69.0796 76.2173 68.7351 76.204 68.396 76.204C60.3324 76.204 52.2716 76.204 44.208 76.204Z" fill="currentColor"/><path d="M44.2079 60.08C52.3035 60.08 60.4018 60.08 68.4974 60.0826C68.8712 60.0826 69.253 60.0666 69.6162 60.1307C70.5 60.2856 71.2262 61.0866 71.2476 61.9785C71.2716 62.9184 70.831 63.618 69.9339 63.9518C69.5921 64.0773 69.205 64.1334 68.8392 64.136C52.4076 64.1441 35.976 64.144 19.5444 64.144C19.3736 64.144 19.2027 64.1494 19.0345 64.128C17.8543 63.9758 17.0453 63.0893 17.0987 62.0159C17.1548 60.9077 17.9878 60.1067 19.2027 60.0933C21.6511 60.0666 24.1022 60.0853 26.5507 60.0826C32.4382 60.08 38.323 60.08 44.2079 60.08Z" fill="currentColor"/><path d="M44.1199 40.2627C36.0563 40.2627 27.9954 40.2627 19.9318 40.26C19.5259 40.26 19.1068 40.2734 18.7143 40.1933C17.7584 40.001 17.0962 39.1652 17.0989 38.228C17.1016 37.3255 17.705 36.5217 18.6288 36.3028C19.0507 36.2013 19.5046 36.204 19.9425 36.204C36.1017 36.1986 52.261 36.1986 68.4202 36.204C68.826 36.204 69.2426 36.1933 69.6377 36.2761C70.591 36.4763 71.2718 37.3255 71.2664 38.2387C71.2638 39.1893 70.5242 40.0518 69.5309 40.2173C69.1651 40.2787 68.786 40.26 68.4122 40.26C60.3112 40.2627 52.2156 40.2627 44.1199 40.2627Z" fill="currentColor"/><path d="M44.1463 52.2017C36.1575 52.2017 28.1686 52.2043 20.1798 52.1963C19.6725 52.1963 19.1572 52.1803 18.6579 52.0922C17.7688 51.932 17.1172 51.1095 17.0932 50.2097C17.0692 49.3205 17.6886 48.458 18.5671 48.2551C19.0237 48.1482 19.507 48.1109 19.9796 48.1109C36.0934 48.1029 52.2073 48.1029 68.3211 48.1109C68.7937 48.1109 69.2743 48.1482 69.7335 48.2497C70.6253 48.4473 71.2688 49.2884 71.2688 50.1669C71.2688 51.0855 70.5719 51.94 69.6347 52.1029C69.1702 52.183 68.6895 52.199 68.2143 52.2017C60.1907 52.2043 52.1672 52.2017 44.1463 52.2017Z" fill="currentColor"/>',
            attrs: fileIconsAttrsTemplates['88x116']
        },
        '7z': {
            contents: '<path d="M83.7978 93.4986H87.2075V91.0474H83.1677V90.7296C82.623 89.8217 82.0783 88.9138 81.5336 88.0033C80.6819 88.7002 79.8328 89.3971 78.981 90.0941C79.1065 90.3184 79.2321 90.5454 79.3602 90.7697H75.8437C75.0133 89.6909 74.3271 88.8017 73.6436 87.9152C72.9467 88.7857 72.2498 89.6562 71.3073 90.8337H68.3996C67.5398 89.763 66.7922 88.8337 66.0473 87.9045C65.4492 88.7536 64.8511 89.6001 64.026 90.775H60.9581C60.109 89.6775 59.4255 88.7937 58.7419 87.9098C58.0397 88.7884 57.3402 89.6642 56.395 90.8444H53.0574C52.8492 90.0727 52.8678 89.0447 52.3712 88.6281C51.936 88.2623 50.2752 88.5053 50.2618 88.6121C49.8987 91.5948 47.8321 91.0714 46.0645 90.8578C45.2581 89.8003 44.5238 88.8391 43.7896 87.8778C43.098 88.7697 42.4038 89.6642 41.488 90.8444H38.6791C37.8247 89.6989 37.1545 88.8044 36.4843 87.9098C35.7554 88.7456 35.0291 89.5814 33.9531 90.8177H31.2429C30.3725 89.7443 29.6196 88.8151 28.8639 87.8832C28.1777 88.7857 27.4915 89.6882 26.6051 90.8524H23.9297C22.9524 89.787 22.0953 88.8524 21.2356 87.9205C20.6455 88.7857 20.0554 89.6508 19.2571 90.8231H19.2277V91.0313H2.64392C2.39828 91.0687 2.15263 91.1034 1.90698 91.1275C1.90698 91.5707 1.90698 92.0166 1.90698 92.4599C1.90698 92.7483 1.90698 93.042 1.90698 93.3411H7.2578V94.0247C7.36994 94.1235 7.48209 94.2249 7.59423 94.3237C7.32456 96.6415 7.0869 98.9646 6.7745 101.277C6.51818 103.173 7.32722 103.899 9.18558 103.864C17.8259 103.71 16.9955 105.015 15.834 96.7349C15.7245 95.9499 15.7299 95.1462 15.6712 94.1555H19.1423C20.002 95.2022 20.7656 96.1315 21.5293 97.0581C22.2021 96.1742 22.8777 95.2904 23.7935 94.0888H26.4209C27.4835 95.2797 28.2792 96.1662 29.0722 97.0554C29.721 96.1422 30.3699 95.2289 31.1949 94.0727H34.0038C34.941 95.2797 35.6352 96.1742 36.3268 97.066C37.013 96.2169 37.7019 95.3678 38.7085 94.1235H41.5387C42.3718 95.1675 43.1301 96.1155 43.8884 97.0634C44.5559 96.1662 45.2208 95.269 46.0992 94.0861H48.7773C49.8614 95.269 50.665 96.1475 51.4687 97.026C52.0401 96.1689 52.6115 95.309 53.3885 94.1448H56.5258C57.3242 95.245 57.9837 96.1529 58.6432 97.0607C59.3321 96.2196 60.0209 95.3758 61.0382 94.1341H63.8632C64.7924 95.293 65.4919 96.1635 66.1915 97.0367C66.8616 96.1528 67.5291 95.2716 68.4183 94.0967C69.8734 94.0861 72.1884 92.9966 72.5195 96.3291C72.5462 96.6015 73.6196 97.0687 73.6863 96.994C74.3565 96.2169 74.9199 95.3464 75.753 94.1635H78.8556C79.6432 95.2369 80.3107 96.1448 80.9756 97.0527C81.7766 96.0701 82.5803 95.0874 83.7898 93.6054V93.4986H83.7978ZM9.85042 100.647C10.1762 98.3371 10.4779 96.2143 10.7769 94.0914C11.2389 94.022 11.7034 93.9526 12.1653 93.8831C12.6032 96.046 13.0412 98.2116 13.5325 100.647H9.85042Z" fill="currentColor"/><path d="M44.6311 77.204C36.3992 77.204 28.1648 77.2066 19.933 77.2013C18.5525 77.2013 17.8076 76.6672 17.594 75.5751C17.3964 74.5604 17.8904 73.6392 18.8703 73.3321C19.3135 73.1933 19.8048 73.1505 20.2721 73.1505C36.5007 73.1425 52.7293 73.1425 68.9553 73.1505C69.3905 73.1505 69.8445 73.1933 70.2583 73.3161C71.1982 73.5911 71.791 74.5177 71.6708 75.4176C71.5426 76.3655 70.8003 77.0918 69.8391 77.1853C69.5027 77.2173 69.1582 77.204 68.8191 77.204C60.7555 77.204 52.6947 77.204 44.6311 77.204Z" fill="currentColor"/><path d="M44.631 61.08C52.7266 61.08 60.8249 61.08 68.9205 61.0826C69.2943 61.0826 69.6761 61.0666 70.0393 61.1307C70.9231 61.2856 71.6493 62.0866 71.6707 62.9785C71.6947 63.9184 71.2541 64.618 70.357 64.9518C70.0152 65.0773 69.6281 65.1334 69.2623 65.136C52.8307 65.1441 36.3991 65.144 19.9675 65.144C19.7967 65.144 19.6258 65.1494 19.4576 65.128C18.2774 64.9758 17.4684 64.0893 17.5218 63.0159C17.5779 61.9077 18.4109 61.1067 19.6258 61.0933C22.0742 61.0666 24.5253 61.0853 26.9738 61.0826C32.8613 61.08 38.7461 61.08 44.631 61.08Z" fill="currentColor"/><path d="M44.543 41.2627C36.4794 41.2627 28.4185 41.2627 20.3549 41.26C19.949 41.26 19.5299 41.2734 19.1374 41.1933C18.1815 41.001 17.5193 40.1652 17.522 39.228C17.5247 38.3255 18.1281 37.5217 19.0519 37.3028C19.4738 37.2013 19.9277 37.204 20.3656 37.204C36.5248 37.1986 52.684 37.1986 68.8433 37.204C69.2491 37.204 69.6657 37.1933 70.0608 37.2761C71.0141 37.4763 71.6949 38.3255 71.6895 39.2387C71.6869 40.1893 70.9473 41.0518 69.954 41.2173C69.5882 41.2787 69.2091 41.26 68.8353 41.26C60.7343 41.2627 52.6387 41.2627 44.543 41.2627Z" fill="currentColor"/><path d="M44.5694 53.2017C36.5806 53.2017 28.5917 53.2043 20.6029 53.1963C20.0956 53.1963 19.5803 53.1803 19.081 53.0922C18.1919 52.932 17.5403 52.1095 17.5163 51.2097C17.4923 50.3205 18.1117 49.458 18.9902 49.2551C19.4468 49.1482 19.9301 49.1109 20.4027 49.1109C36.5165 49.1029 52.6303 49.1029 68.7442 49.1109C69.2168 49.1109 69.6973 49.1482 70.1566 49.2497C71.0484 49.4473 71.6919 50.2884 71.6919 51.1669C71.6919 52.0855 70.995 52.94 70.0578 53.1029C69.5932 53.183 69.1126 53.199 68.6373 53.2017C60.6138 53.2043 52.5903 53.2017 44.5694 53.2017Z" fill="currentColor"/><path d="M9.02288 24C8.78288 24 8.70288 23.888 8.78288 23.664L13.9909 10.248C14.0229 10.152 13.9909 10.104 13.8949 10.104H9.40688C9.32688 10.104 9.28688 10.144 9.28688 10.224V11.328C9.28688 11.408 9.25488 11.48 9.19088 11.544C9.14288 11.592 9.07888 11.616 8.99888 11.616H6.81488C6.73488 11.616 6.66288 11.592 6.59888 11.544C6.55088 11.48 6.52688 11.408 6.52688 11.328L6.55088 7.488C6.55088 7.408 6.57488 7.344 6.62288 7.296C6.68688 7.232 6.75888 7.2 6.83887 7.2H17.3269C17.4069 7.2 17.4709 7.232 17.5189 7.296C17.5829 7.344 17.6149 7.408 17.6149 7.488V9.912C17.6149 10.008 17.5909 10.128 17.5429 10.272L12.3589 23.784C12.3109 23.928 12.1989 24 12.0229 24H9.02288Z" fill="currentColor"/><path d="M0.846436 116.57C0.846436 78.0628 0.846436 39.5981 0.846436 1.016C1.19354 1.016 1.51394 1.016 1.83435 1.016C21.7423 1.016 41.6503 1.01869 61.5557 1C62.2525 1 62.7225 1.21896 63.2058 1.70494C71.3415 9.86783 79.4905 18.0174 87.6529 26.1535C88.0988 26.5995 88.2697 27.0427 88.2697 27.6622C88.2563 56.9813 88.259 86.3005 88.259 115.617C88.259 115.913 88.259 116.21 88.259 116.567C59.0805 116.57 29.9955 116.57 0.846436 116.57ZM2.38707 114.965C30.5669 114.965 58.5999 114.965 86.6649 114.965C86.6649 85.9533 86.6649 56.992 86.6649 27.9479C86.2351 27.9479 85.8773 27.9479 85.5195 27.9479C77.9872 27.9479 70.4523 27.9479 62.9201 27.9479C61.4168 27.9479 61.3474 27.8758 61.3474 26.3431C61.3474 18.8104 61.3474 11.275 61.3474 3.7423C61.3474 3.38983 61.3474 3.03738 61.3474 2.66889C41.645 2.66889 22.0601 2.66889 2.43511 2.66889C2.41642 2.91455 2.39241 3.09079 2.38974 3.26702C2.3043 10.2069 2.14139 17.1495 2.15207 24.0895C2.20013 50.3031 2.30429 76.5194 2.3844 102.733C2.39508 106.455 2.38707 110.178 2.38707 113.897C2.38707 114.22 2.38707 114.549 2.38707 114.965ZM85.1377 26.2951C77.7576 18.9012 70.3669 11.4967 63.0188 4.13485C63.0188 11.4379 63.0188 18.8531 63.0188 26.2951C70.4737 26.2951 77.8698 26.2951 85.1377 26.2951Z" fill="currentColor"/><path d="M21.777 21.3712C24.1534 21.3712 26.1452 21.3712 28.2439 21.3712C28.2439 22.1295 28.2439 22.8158 28.2439 23.6168C24.893 23.6168 21.5073 23.6168 18.095 23.6168C17.86 22.3218 18.0336 21.2323 18.9254 20.1616C20.7037 18.02 22.3324 15.7557 24.1961 13.3124C22.1508 13.3124 20.3619 13.3124 18.4982 13.3124C18.4982 12.4633 18.4982 11.7717 18.4982 11C21.7076 11 24.8849 11 28.0863 11C28.4201 12.2817 28.1451 13.3071 27.2987 14.3271C25.467 16.5354 23.7502 18.8371 21.777 21.3712Z" fill="currentColor"/><path d="M38.2043 18.6602C38.2043 20.4466 38.2043 21.9927 38.2043 23.6455C37.1683 23.6455 36.215 23.6455 35.155 23.6455C35.155 19.5094 35.155 15.3198 35.155 11.0768C37.4726 11.0768 39.8277 10.8712 42.1319 11.1329C44.5163 11.4052 45.5469 12.9192 45.4348 15.1809C45.3413 17.0634 43.9022 18.4466 41.6994 18.6415C40.602 18.7403 39.4913 18.6602 38.2043 18.6602ZM38.2603 16.2917C39.1975 16.2917 40.076 16.3425 40.9438 16.2784C41.7902 16.2143 42.3242 15.7684 42.3322 14.8258C42.3375 13.8672 41.7635 13.4479 40.9384 13.3732C40.0733 13.2957 39.1922 13.3545 38.263 13.3545C38.2604 14.3745 38.2603 15.2797 38.2603 16.2917Z" fill="currentColor"/><path d="M32.8516 23.713C31.8637 23.713 30.9853 23.713 30 23.713C30 19.486 30 15.2991 30 11.0294C30.9185 11.0294 31.8316 11.0294 32.8516 11.0294C32.8516 15.2137 32.8516 19.4006 32.8516 23.713Z" fill="currentColor"/>',
            attrs: {
                width: "89",
                height: "117",
                viewBox: "0 0 89 117",
                fill: "none"
            }
        },
        pdf: {
            contents: '<path d="M0.464355 115.57C0.464355 77.0628 0.464355 38.5982 0.464355 0.0160207C0.804803 0.0160207 1.11911 0.0160207 1.43337 0.0160207C20.9593 0.0160207 40.4853 0.0186916 60.0086 0C60.6922 0 61.1531 0.218946 61.6271 0.704928C69.6067 8.86782 77.5992 17.0174 85.605 25.1535C86.0423 25.5995 86.21 26.0427 86.21 26.6622C86.1969 55.9813 86.1995 85.3004 86.1995 114.617C86.1995 114.913 86.1995 115.21 86.1995 115.567C57.5809 115.57 29.0541 115.57 0.464355 115.57ZM1.97287 113.965C29.612 113.965 57.1069 113.965 84.6334 113.965C84.6334 84.9533 84.6334 55.992 84.6334 26.9479C84.2118 26.9479 83.8608 26.9479 83.5099 26.9479C76.1222 26.9479 68.732 26.9479 61.3443 26.9479C59.8699 26.9479 59.8017 26.8758 59.8017 25.3431C59.8017 17.8104 59.8017 10.275 59.8017 2.74231C59.8017 2.38984 59.8017 2.03738 59.8017 1.66889C40.4774 1.66889 21.2683 1.66889 2.01992 1.66889C2.00159 1.91455 1.97804 2.09079 1.97542 2.26702C1.89162 9.20695 1.72922 16.1495 1.74231 23.0895C1.78945 49.3031 1.89162 75.5194 1.97018 101.733C1.98066 105.455 1.97287 109.178 1.97287 112.897C1.97287 113.223 1.97287 113.549 1.97287 113.965ZM83.1381 25.2977C75.8996 17.9039 68.6508 10.4993 61.4438 3.13752C61.4438 10.4406 61.4438 17.8558 61.4438 25.2977C68.7555 25.2977 76.0096 25.2977 83.1381 25.2977Z" fill="currentColor"/><path d="M43.6049 82.0229C52.4905 82.0229 61.3789 82.0229 70.2646 82.0229C71.1838 82.0229 71.7075 82.4448 71.739 83.1818C71.7704 83.9401 71.1943 84.4715 70.3039 84.5009C70.2279 84.5035 70.152 84.4982 70.0787 84.4982C61.4444 84.4982 52.8075 84.4982 44.1733 84.4982C35.1357 84.4982 26.1007 84.5008 17.0632 84.4928C16.7437 84.4928 16.4005 84.4608 16.1124 84.338C15.5677 84.103 15.319 83.617 15.4212 83.0322C15.5154 82.4928 15.8454 82.0976 16.4242 82.0469C16.872 82.0069 17.325 82.0202 17.7781 82.0202C26.3888 82.0202 34.9994 82.0202 43.6101 82.0202C43.6049 82.0202 43.6049 82.0202 43.6049 82.0229Z" fill="currentColor"/><path d="M43.5871 100.122C52.1743 100.122 60.7587 100.122 69.3459 100.125C69.7963 100.125 70.2494 100.128 70.6972 100.173C71.3388 100.24 71.6898 100.654 71.7265 101.289C71.7631 101.925 71.4462 102.365 70.8386 102.539C70.6029 102.606 70.3437 102.614 70.0975 102.614C60.8085 102.619 51.5195 102.624 42.2305 102.614C39.4572 102.611 36.6813 102.539 33.9079 102.542C28.2644 102.55 22.6208 102.598 16.9773 102.595C16.5478 102.595 16.0083 102.419 15.7098 102.125C15.0446 101.471 15.4374 100.373 16.3488 100.184C16.6159 100.128 16.896 100.125 17.171 100.128C21.8901 100.141 26.6093 100.165 31.3284 100.176C35.4137 100.184 39.5018 100.178 43.5871 100.178C43.5871 100.157 43.5871 100.138 43.5871 100.122Z" fill="currentColor"/><path d="M11.6485 9.31912C11.5742 9.69186 11.5783 10.0845 11.4064 10.4316C11.1289 11.0064 10.1167 11.3109 9.2805 11.1344C8.19812 10.904 7.9285 10.3008 7.92069 9.56666C7.90897 8.32609 8.26457 7.74848 9.20628 7.53224C10.6013 7.20787 11.586 7.94482 11.6485 9.31912Z" fill="currentColor"/><path d="M19.105 9.31912C19.0308 9.69186 19.0348 10.0845 18.8629 10.4316C18.5855 11.0064 17.5733 11.3109 16.737 11.1344C15.6547 10.904 15.385 10.3008 15.3772 9.56666C15.3655 8.32609 15.7211 7.74848 16.6628 7.53224C18.0578 7.20787 19.0425 7.94482 19.105 9.31912Z" fill="currentColor"/><path d="M26.5611 9.31912C26.4868 9.69186 26.4909 10.0845 26.319 10.4316C26.0415 11.0064 25.0293 11.3109 24.1931 11.1344C23.1107 10.904 22.8411 10.3008 22.8333 9.56666C22.8216 8.32609 23.1772 7.74848 24.1189 7.53224C25.5139 7.20787 26.4986 7.94482 26.5611 9.31912Z" fill="currentColor"/><rect x="15" y="40" width="59.6491" height="26.0965" rx="1" fill="currentColor"/><path d="M33.8524 48.3192C34.5244 48.3192 35.1164 48.4578 35.6284 48.7352C36.1404 49.0125 36.5351 49.4072 36.8124 49.9192C37.1004 50.4205 37.2444 51.0018 37.2444 51.6632C37.2444 52.3138 37.1004 52.8898 36.8124 53.3912C36.5244 53.8925 36.1138 54.2818 35.5804 54.5592C35.0578 54.8258 34.4498 54.9592 33.7564 54.9592H31.1964C31.1431 54.9592 31.1164 54.9858 31.1164 55.0392V59.3432C31.1164 59.3965 31.0951 59.4445 31.0524 59.4872C31.0204 59.5192 30.9778 59.5352 30.9244 59.5352H29.4524C29.3991 59.5352 29.3511 59.5192 29.3084 59.4872C29.2764 59.4445 29.2604 59.3965 29.2604 59.3432V48.5112C29.2604 48.4578 29.2764 48.4152 29.3084 48.3832C29.3511 48.3405 29.3991 48.3192 29.4524 48.3192H33.8524ZM33.5804 53.4552C34.1244 53.4552 34.5618 53.2952 34.8924 52.9752C35.2231 52.6552 35.3884 52.2338 35.3884 51.7112C35.3884 51.1778 35.2231 50.7458 34.8924 50.4152C34.5618 50.0845 34.1244 49.9192 33.5804 49.9192H31.1964C31.1431 49.9192 31.1164 49.9458 31.1164 49.9992V53.3752C31.1164 53.4285 31.1431 53.4552 31.1964 53.4552H33.5804ZM39.064 59.5352C39.0107 59.5352 38.9627 59.5192 38.92 59.4872C38.888 59.4445 38.872 59.3965 38.872 59.3432V48.5272C38.872 48.4738 38.888 48.4312 38.92 48.3992C38.9627 48.3565 39.0107 48.3352 39.064 48.3352H42.968C43.7254 48.3352 44.392 48.4685 44.968 48.7352C45.544 49.0018 45.9867 49.3858 46.296 49.8872C46.616 50.3778 46.776 50.9538 46.776 51.6152V56.2552C46.776 56.9165 46.616 57.4978 46.296 57.9992C45.9867 58.4898 45.544 58.8685 44.968 59.1352C44.392 59.4018 43.7254 59.5352 42.968 59.5352H39.064ZM40.728 57.8552C40.728 57.9085 40.7547 57.9352 40.808 57.9352H43.048C43.6134 57.9352 44.0614 57.7592 44.392 57.4072C44.7334 57.0445 44.9094 56.5645 44.92 55.9672V51.9192C44.92 51.3112 44.7494 50.8312 44.408 50.4792C44.0667 50.1165 43.608 49.9352 43.032 49.9352H40.808C40.7547 49.9352 40.728 49.9618 40.728 50.0152V57.8552ZM56.3307 49.7432C56.3307 49.7965 56.3093 49.8445 56.2667 49.8872C56.2347 49.9192 56.192 49.9352 56.1387 49.9352H50.6987C50.6453 49.9352 50.6187 49.9618 50.6187 50.0152V53.0072C50.6187 53.0605 50.6453 53.0872 50.6987 53.0872H54.3627C54.416 53.0872 54.4587 53.1085 54.4907 53.1512C54.5333 53.1832 54.5547 53.2258 54.5547 53.2792V54.4952C54.5547 54.5485 54.5333 54.5965 54.4907 54.6392C54.4587 54.6712 54.416 54.6872 54.3627 54.6872H50.6987C50.6453 54.6872 50.6187 54.7138 50.6187 54.7672V59.3432C50.6187 59.3965 50.5973 59.4445 50.5547 59.4872C50.5227 59.5192 50.48 59.5352 50.4267 59.5352H48.9547C48.9013 59.5352 48.8533 59.5192 48.8107 59.4872C48.7787 59.4445 48.7627 59.3965 48.7627 59.3432V48.5272C48.7627 48.4738 48.7787 48.4312 48.8107 48.3992C48.8533 48.3565 48.9013 48.3352 48.9547 48.3352H56.1387C56.192 48.3352 56.2347 48.3565 56.2667 48.3992C56.3093 48.4312 56.3307 48.4738 56.3307 48.5272V49.7432Z" fill="white"/>',
            attrs: fileIconsAttrsTemplates['87x116']
        },
        txt: {
            contents: '<path d="M0.209961 115.57C0.209961 77.0628 0.209961 38.5982 0.209961 0.0160207C0.550408 0.0160207 0.864719 0.0160207 1.17898 0.0160207C20.7049 0.0160207 40.2309 0.0186916 59.7542 0C60.4378 0 60.8987 0.218946 61.3727 0.704928C69.3523 8.86782 77.3448 17.0174 85.3506 25.1535C85.7879 25.5995 85.9556 26.0427 85.9556 26.6622C85.9425 55.9813 85.9451 85.3004 85.9451 114.617C85.9451 114.913 85.9451 115.21 85.9451 115.567C57.3265 115.57 28.7997 115.57 0.209961 115.57ZM1.71847 113.965C29.3576 113.965 56.8525 113.965 84.379 113.965C84.379 84.9533 84.379 55.992 84.379 26.9479C83.9574 26.9479 83.6065 26.9479 83.2555 26.9479C75.8678 26.9479 68.4776 26.9479 61.0899 26.9479C59.6155 26.9479 59.5474 26.8758 59.5474 25.3431C59.5474 17.8104 59.5474 10.275 59.5474 2.74231C59.5474 2.38984 59.5474 2.03738 59.5474 1.66889C40.223 1.66889 21.0139 1.66889 1.76553 1.66889C1.7472 1.91455 1.72365 2.09079 1.72103 2.26702C1.63723 9.20695 1.47482 16.1495 1.48792 23.0895C1.53506 49.3031 1.63722 75.5194 1.71579 101.733C1.72626 105.455 1.71847 109.178 1.71847 112.897C1.71847 113.223 1.71847 113.549 1.71847 113.965ZM82.8837 25.2977C75.6452 17.9039 68.3964 10.4993 61.1894 3.13752C61.1894 10.4406 61.1894 17.8558 61.1894 25.2977C68.5011 25.2977 75.7552 25.2977 82.8837 25.2977Z" fill="currentColor"/><path d="M43.3505 82.0229C52.2361 82.0229 61.1245 82.0229 70.0102 82.0229C70.9294 82.0229 71.4531 82.4448 71.4846 83.1818C71.516 83.9401 70.9399 84.4715 70.0495 84.5009C69.9735 84.5035 69.8976 84.4982 69.8243 84.4982C61.19 84.4982 52.5531 84.4982 43.9189 84.4982C34.8813 84.4982 25.8463 84.5008 16.8088 84.4928C16.4893 84.4928 16.1461 84.4608 15.858 84.338C15.3133 84.103 15.0646 83.617 15.1668 83.0322C15.261 82.4928 15.591 82.0976 16.1698 82.0469C16.6176 82.0069 17.0706 82.0202 17.5237 82.0202C26.1344 82.0202 34.745 82.0202 43.3557 82.0202C43.3505 82.0202 43.3505 82.0202 43.3505 82.0229Z" fill="currentColor"/><path d="M43.3327 100.122C51.9199 100.122 60.5043 100.122 69.0915 100.125C69.5419 100.125 69.995 100.128 70.4428 100.173C71.0844 100.24 71.4354 100.654 71.4721 101.289C71.5087 101.925 71.1918 102.365 70.5842 102.539C70.3486 102.606 70.0893 102.614 69.8431 102.614C60.5541 102.619 51.2651 102.624 41.9761 102.614C39.2028 102.611 36.4269 102.539 33.6536 102.542C28.01 102.55 22.3664 102.598 16.7229 102.595C16.2934 102.595 15.7539 102.419 15.4554 102.125C14.7902 101.471 15.183 100.373 16.0944 100.184C16.3615 100.128 16.6416 100.125 16.9166 100.128C21.6357 100.141 26.3549 100.165 31.074 100.176C35.1594 100.184 39.2474 100.178 43.3327 100.178C43.3327 100.157 43.3327 100.138 43.3327 100.122Z" fill="currentColor"/><path d="M11.3941 9.31912C11.3198 9.69186 11.3239 10.0845 11.152 10.4316C10.8745 11.0064 9.86231 11.3109 9.0261 11.1344C7.94372 10.904 7.67411 10.3008 7.6663 9.56666C7.65457 8.32609 8.01017 7.74848 8.95188 7.53224C10.3469 7.20787 11.3316 7.94482 11.3941 9.31912Z" fill="currentColor"/><path d="M18.8506 9.31912C18.7764 9.69186 18.7804 10.0845 18.6085 10.4316C18.3311 11.0064 17.3189 11.3109 16.4826 11.1344C15.4003 10.904 15.1307 10.3008 15.1228 9.56666C15.1111 8.32609 15.4667 7.74848 16.4084 7.53224C17.8034 7.20787 18.7881 7.94482 18.8506 9.31912Z" fill="currentColor"/><path d="M26.3067 9.31912C26.2324 9.69186 26.2365 10.0845 26.0646 10.4316C25.7871 11.0064 24.7749 11.3109 23.9387 11.1344C22.8563 10.904 22.5867 10.3008 22.5789 9.56666C22.5672 8.32609 22.9228 7.74848 23.8645 7.53224C25.2595 7.20787 26.2442 7.94482 26.3067 9.31912Z" fill="currentColor"/><rect x="17" y="41" width="59.6491" height="26.0965" rx="1" fill="currentColor"/><path d="M38.732 49.3352C38.7854 49.3352 38.828 49.3565 38.86 49.3992C38.9027 49.4312 38.924 49.4738 38.924 49.5272V50.7592C38.924 50.8125 38.9027 50.8605 38.86 50.9032C38.828 50.9352 38.7854 50.9512 38.732 50.9512H35.788C35.7347 50.9512 35.708 50.9778 35.708 51.0312V60.3432C35.708 60.3965 35.6867 60.4445 35.644 60.4872C35.612 60.5192 35.5694 60.5352 35.516 60.5352H34.044C33.9907 60.5352 33.9427 60.5192 33.9 60.4872C33.868 60.4445 33.852 60.3965 33.852 60.3432V51.0312C33.852 50.9778 33.8254 50.9512 33.772 50.9512H30.94C30.8867 50.9512 30.8387 50.9352 30.796 50.9032C30.764 50.8605 30.748 50.8125 30.748 50.7592V49.5272C30.748 49.4738 30.764 49.4312 30.796 49.3992C30.8387 49.3565 30.8867 49.3352 30.94 49.3352H38.732ZM40.1737 60.5352C40.099 60.5352 40.0457 60.5192 40.0137 60.4872C39.9923 60.4445 40.003 60.3858 40.0457 60.3112L43.2297 54.9832C43.251 54.9512 43.251 54.9192 43.2297 54.8872L40.0457 49.5592C40.0243 49.4952 40.0137 49.4578 40.0137 49.4472C40.0137 49.3725 40.067 49.3352 40.1737 49.3352H41.7737C41.891 49.3352 41.971 49.3778 42.0137 49.4632L44.3497 53.4312C44.3817 53.4952 44.4137 53.4952 44.4457 53.4312L46.7977 49.4632C46.8403 49.3778 46.915 49.3352 47.0217 49.3352H48.6217C48.6963 49.3352 48.7443 49.3565 48.7657 49.3992C48.7977 49.4312 48.7923 49.4845 48.7497 49.5592L45.5657 54.8872C45.555 54.9192 45.555 54.9512 45.5657 54.9832L48.7497 60.3112C48.771 60.3752 48.7817 60.4125 48.7817 60.4232C48.7817 60.4978 48.7283 60.5352 48.6217 60.5352H47.0217C46.915 60.5352 46.8403 60.4925 46.7977 60.4072L44.4457 56.4552C44.4137 56.3912 44.3817 56.3912 44.3497 56.4552L41.9977 60.4072C41.955 60.4925 41.8803 60.5352 41.7737 60.5352H40.1737ZM57.857 49.3352C57.9104 49.3352 57.953 49.3565 57.985 49.3992C58.0277 49.4312 58.049 49.4738 58.049 49.5272V50.7592C58.049 50.8125 58.0277 50.8605 57.985 50.9032C57.953 50.9352 57.9104 50.9512 57.857 50.9512H54.913C54.8597 50.9512 54.833 50.9778 54.833 51.0312V60.3432C54.833 60.3965 54.8117 60.4445 54.769 60.4872C54.737 60.5192 54.6944 60.5352 54.641 60.5352H53.169C53.1157 60.5352 53.0677 60.5192 53.025 60.4872C52.993 60.4445 52.977 60.3965 52.977 60.3432V51.0312C52.977 50.9778 52.9504 50.9512 52.897 50.9512H50.065C50.0117 50.9512 49.9637 50.9352 49.921 50.9032C49.889 50.8605 49.873 50.8125 49.873 50.7592V49.5272C49.873 49.4738 49.889 49.4312 49.921 49.3992C49.9637 49.3565 50.0117 49.3352 50.065 49.3352H57.857Z" fill="white"/>',
            attrs: fileIconsAttrsTemplates['88x116']
        },
        log: {
            contents: '<path d="M0.955566 115.57C0.955566 77.0628 0.955566 38.5982 0.955566 0.0160207C1.29601 0.0160207 1.61032 0.0160207 1.92458 0.0160207C21.4506 0.0160207 40.9765 0.0186916 60.4999 0C61.1834 0 61.6443 0.218946 62.1183 0.704928C70.0979 8.86782 78.0904 17.0174 86.0962 25.1535C86.5335 25.5995 86.7012 26.0427 86.7012 26.6622C86.6881 55.9813 86.6907 85.3004 86.6907 114.617C86.6907 114.913 86.6907 115.21 86.6907 115.567C58.0721 115.57 29.5453 115.57 0.955566 115.57ZM2.46408 113.965C30.1032 113.965 57.5981 113.965 85.1246 113.965C85.1246 84.9533 85.1246 55.992 85.1246 26.9479C84.703 26.9479 84.3521 26.9479 84.0011 26.9479C76.6134 26.9479 69.2232 26.9479 61.8355 26.9479C60.3611 26.9479 60.293 26.8758 60.293 25.3431C60.293 17.8104 60.293 10.275 60.293 2.74231C60.293 2.38984 60.293 2.03738 60.293 1.66889C40.9686 1.66889 21.7595 1.66889 2.51113 1.66889C2.4928 1.91455 2.46925 2.09079 2.46663 2.26702C2.38283 9.20695 2.22043 16.1495 2.23352 23.0895C2.28066 49.3031 2.38283 75.5194 2.46139 101.733C2.47187 105.455 2.46408 109.178 2.46408 112.897C2.46408 113.223 2.46408 113.549 2.46408 113.965ZM83.6293 25.2977C76.3908 17.9039 69.142 10.4993 61.935 3.13752C61.935 10.4406 61.935 17.8558 61.935 25.2977C69.2467 25.2977 76.5008 25.2977 83.6293 25.2977Z" fill="currentColor"/><path d="M44.0961 82.0229C52.9818 82.0229 61.8701 82.0229 70.7558 82.0229C71.675 82.0229 72.1987 82.4448 72.2302 83.1818C72.2616 83.9401 71.6855 84.4715 70.7951 84.5009C70.7191 84.5035 70.6432 84.4982 70.5699 84.4982C61.9356 84.4982 53.2987 84.4982 44.6645 84.4982C35.6269 84.4982 26.5919 84.5008 17.5544 84.4928C17.2349 84.4928 16.8917 84.4608 16.6036 84.338C16.0589 84.103 15.8102 83.617 15.9124 83.0322C16.0066 82.4928 16.3366 82.0976 16.9154 82.0469C17.3632 82.0069 17.8163 82.0202 18.2693 82.0202C26.88 82.0202 35.4906 82.0202 44.1013 82.0202C44.0961 82.0202 44.0961 82.0202 44.0961 82.0229Z" fill="currentColor"/><path d="M44.0783 100.122C52.6655 100.122 61.2499 100.122 69.8371 100.125C70.2875 100.125 70.7406 100.128 71.1884 100.173C71.83 100.24 72.181 100.654 72.2177 101.289C72.2543 101.925 71.9374 102.365 71.3299 102.539C71.0942 102.606 70.8349 102.614 70.5887 102.614C61.2997 102.619 52.0107 102.624 42.7217 102.614C39.9484 102.611 37.1725 102.539 34.3992 102.542C28.7556 102.55 23.112 102.598 17.4685 102.595C17.039 102.595 16.4995 102.419 16.201 102.125C15.5358 101.471 15.9286 100.373 16.84 100.184C17.1071 100.128 17.3872 100.125 17.6622 100.128C22.3813 100.141 27.1005 100.165 31.8196 100.176C35.905 100.184 39.993 100.178 44.0783 100.178C44.0783 100.157 44.0783 100.138 44.0783 100.122Z" fill="currentColor"/><path d="M12.1397 9.31912C12.0654 9.69186 12.0695 10.0845 11.8976 10.4316C11.6201 11.0064 10.6079 11.3109 9.77171 11.1344C8.68933 10.904 8.41972 10.3008 8.4119 9.56666C8.40018 8.32609 8.75578 7.74848 9.69749 7.53224C11.0925 7.20787 12.0772 7.94482 12.1397 9.31912Z" fill="currentColor"/><path d="M19.5962 9.31912C19.522 9.69186 19.526 10.0845 19.3541 10.4316C19.0767 11.0064 18.0645 11.3109 17.2283 11.1344C16.1459 10.904 15.8763 10.3008 15.8684 9.56666C15.8567 8.32609 16.2123 7.74848 17.154 7.53224C18.549 7.20787 19.5337 7.94482 19.5962 9.31912Z" fill="currentColor"/><path d="M27.0523 9.31912C26.978 9.69186 26.9821 10.0845 26.8102 10.4316C26.5327 11.0064 25.5205 11.3109 24.6843 11.1344C23.6019 10.904 23.3323 10.3008 23.3245 9.56666C23.3128 8.32609 23.6684 7.74848 24.6101 7.53224C26.0051 7.20787 26.9898 7.94482 27.0523 9.31912Z" fill="currentColor"/><rect x="17" y="40" width="59.6491" height="26.0965" rx="1" fill="currentColor"/><path d="M31.3609 59.5352C31.3076 59.5352 31.2596 59.5192 31.2169 59.4872C31.1849 59.4445 31.1689 59.3965 31.1689 59.3432V48.5272C31.1689 48.4738 31.1849 48.4312 31.2169 48.3992C31.2596 48.3565 31.3076 48.3352 31.3609 48.3352H32.8329C32.8863 48.3352 32.9289 48.3565 32.9609 48.3992C33.0036 48.4312 33.0249 48.4738 33.0249 48.5272V57.8552C33.0249 57.9085 33.0516 57.9352 33.1049 57.9352H38.4649C38.5183 57.9352 38.5609 57.9565 38.5929 57.9992C38.6356 58.0312 38.6569 58.0738 38.6569 58.1272V59.3432C38.6569 59.3965 38.6356 59.4445 38.5929 59.4872C38.5609 59.5192 38.5183 59.5352 38.4649 59.5352H31.3609ZM44.0078 59.6952C43.2078 59.6952 42.4985 59.5352 41.8798 59.2152C41.2611 58.8845 40.7811 58.4205 40.4398 57.8232C40.1091 57.2258 39.9438 56.5378 39.9438 55.7592V52.1112C39.9438 51.3432 40.1145 50.6658 40.4558 50.0792C40.7971 49.4818 41.2718 49.0232 41.8798 48.7032C42.4985 48.3725 43.2078 48.2072 44.0078 48.2072C44.8185 48.2072 45.5278 48.3725 46.1358 48.7032C46.7545 49.0232 47.2345 49.4818 47.5758 50.0792C47.9171 50.6658 48.0878 51.3432 48.0878 52.1112V55.7592C48.0878 56.5378 47.9171 57.2258 47.5758 57.8232C47.2345 58.4205 46.7545 58.8845 46.1358 59.2152C45.5278 59.5352 44.8185 59.6952 44.0078 59.6952ZM44.0078 58.0952C44.6798 58.0952 45.2185 57.8872 45.6238 57.4712C46.0291 57.0552 46.2318 56.5058 46.2318 55.8232V52.0952C46.2318 51.4018 46.0291 50.8472 45.6238 50.4312C45.2185 50.0152 44.6798 49.8072 44.0078 49.8072C43.3465 49.8072 42.8131 50.0152 42.4078 50.4312C42.0025 50.8472 41.7998 51.4018 41.7998 52.0952V55.8232C41.7998 56.5058 42.0025 57.0552 42.4078 57.4712C42.8131 57.8872 43.3465 58.0952 44.0078 58.0952ZM53.8973 59.6632C53.0973 59.6632 52.3933 59.5085 51.7853 59.1992C51.1773 58.8792 50.708 58.4312 50.3773 57.8552C50.0466 57.2792 49.8813 56.6178 49.8813 55.8712V51.9992C49.8813 51.2418 50.0466 50.5805 50.3773 50.0152C50.708 49.4392 51.1773 48.9965 51.7853 48.6872C52.3933 48.3672 53.0973 48.2072 53.8973 48.2072C54.6866 48.2072 55.38 48.3618 55.9773 48.6712C56.5853 48.9805 57.0546 49.4018 57.3853 49.9352C57.716 50.4685 57.8813 51.0712 57.8813 51.7432V51.8712C57.8813 51.9245 57.86 51.9725 57.8173 52.0152C57.7853 52.0472 57.7426 52.0632 57.6893 52.0632H56.2333C56.18 52.0632 56.132 52.0472 56.0893 52.0152C56.0573 51.9725 56.0413 51.9245 56.0413 51.8712V51.7912C56.0413 51.2152 55.844 50.7405 55.4493 50.3672C55.0653 49.9938 54.548 49.8072 53.8973 49.8072C53.2466 49.8072 52.724 50.0045 52.3293 50.3992C51.9346 50.7832 51.7373 51.2952 51.7373 51.9352V55.9352C51.7373 56.5752 51.9453 57.0925 52.3613 57.4872C52.7773 57.8712 53.316 58.0632 53.9773 58.0632C54.6173 58.0632 55.1186 57.8978 55.4813 57.5672C55.8546 57.2258 56.0413 56.7618 56.0413 56.1752V55.1832C56.0413 55.1298 56.0146 55.1032 55.9613 55.1032H53.9933C53.94 55.1032 53.892 55.0872 53.8493 55.0552C53.8173 55.0125 53.8013 54.9645 53.8013 54.9112V53.7272C53.8013 53.6738 53.8173 53.6312 53.8493 53.5992C53.892 53.5565 53.94 53.5352 53.9933 53.5352H57.6893C57.7426 53.5352 57.7853 53.5565 57.8173 53.5992C57.86 53.6312 57.8813 53.6738 57.8813 53.7272V55.7752C57.8813 57.0018 57.5186 57.9565 56.7933 58.6392C56.0786 59.3218 55.1133 59.6632 53.8973 59.6632Z" fill="white"/>',
            attrs: fileIconsAttrsTemplates['87x116']
        },
        mp3: {
            contents: '<path d="M0 115.57C0 77.0628 0 38.5982 0 0.0160207C0.340447 0.0160207 0.654758 0.0160207 0.969017 0.0160207C20.495 0.0160207 40.0209 0.0186916 59.5443 0C60.2278 0 60.6888 0.218946 61.1628 0.704928C69.1423 8.86782 77.1349 17.0174 85.1406 25.1535C85.578 25.5995 85.7456 26.0427 85.7456 26.6622C85.7325 55.9813 85.7351 85.3004 85.7351 114.617C85.7351 114.913 85.7351 115.21 85.7351 115.567C57.1166 115.57 28.5897 115.57 0 115.57ZM1.50851 113.965C29.1476 113.965 56.6426 113.965 84.1691 113.965C84.1691 84.9533 84.1691 55.992 84.1691 26.9479C83.7474 26.9479 83.3965 26.9479 83.0456 26.9479C75.6579 26.9479 68.2676 26.9479 60.8799 26.9479C59.4055 26.9479 59.3374 26.8758 59.3374 25.3431C59.3374 17.8104 59.3374 10.275 59.3374 2.74231C59.3374 2.38984 59.3374 2.03738 59.3374 1.66889C40.0131 1.66889 20.8039 1.66889 1.55557 1.66889C1.53724 1.91455 1.51369 2.09079 1.51107 2.26702C1.42727 9.20695 1.26486 16.1495 1.27796 23.0895C1.3251 49.3031 1.42726 75.5194 1.50583 101.733C1.5163 105.455 1.50851 109.178 1.50851 112.897C1.50851 113.223 1.50851 113.549 1.50851 113.965ZM82.6737 25.2977C75.4353 17.9039 68.1864 10.4993 60.9794 3.13752C60.9794 10.4406 60.9794 17.8558 60.9794 25.2977C68.2912 25.2977 75.5453 25.2977 82.6737 25.2977Z" fill="currentColor"/><path d="M11.1841 9.31912C11.1099 9.69186 11.1139 10.0845 10.942 10.4316C10.6646 11.0064 9.65235 11.3109 8.81614 11.1344C7.73376 10.904 7.46415 10.3008 7.45633 9.56666C7.44461 8.32609 7.80021 7.74848 8.74192 7.53224C10.1369 7.20787 11.1216 7.94482 11.1841 9.31912Z" fill="currentColor"/><path d="M18.6407 9.31912C18.5664 9.69186 18.5705 10.0845 18.3985 10.4316C18.1211 11.0064 17.1089 11.3109 16.2727 11.1344C15.1903 10.904 14.9207 10.3008 14.9129 9.56666C14.9012 8.32609 15.2568 7.74848 16.1985 7.53224C17.5935 7.20787 18.5781 7.94482 18.6407 9.31912Z" fill="currentColor"/><path d="M26.0967 9.31912C26.0225 9.69186 26.0265 10.0845 25.8546 10.4316C25.5772 11.0064 24.565 11.3109 23.7287 11.1344C22.6464 10.904 22.3767 10.3008 22.3689 9.56666C22.3572 8.32609 22.7128 7.74848 23.6545 7.53224C25.0495 7.20787 26.0342 7.94482 26.0967 9.31912Z" fill="currentColor"/><rect x="12.5356" y="59.4648" width="59.6491" height="26.0965" rx="1" fill="currentColor"/><path d="M33.5924 67.928C33.6458 67.8427 33.7204 67.8 33.8164 67.8H35.2884C35.3418 67.8 35.3844 67.8213 35.4164 67.864C35.4591 67.896 35.4804 67.9387 35.4804 67.992V78.808C35.4804 78.8613 35.4591 78.9093 35.4164 78.952C35.3844 78.984 35.3418 79 35.2884 79H33.8164C33.7631 79 33.7151 78.984 33.6724 78.952C33.6404 78.9093 33.6244 78.8613 33.6244 78.808V71.176C33.6244 71.144 33.6084 71.1227 33.5764 71.112C33.5551 71.1013 33.5391 71.112 33.5284 71.144L31.5284 74.216C31.4751 74.3013 31.4004 74.344 31.3044 74.344H30.5684C30.4724 74.344 30.3978 74.3013 30.3444 74.216L28.3284 71.16C28.3178 71.128 28.2964 71.1173 28.2644 71.128C28.2431 71.1387 28.2324 71.16 28.2324 71.192V78.808C28.2324 78.8613 28.2111 78.9093 28.1684 78.952C28.1364 78.984 28.0938 79 28.0404 79H26.5684C26.5151 79 26.4671 78.984 26.4244 78.952C26.3924 78.9093 26.3764 78.8613 26.3764 78.808V67.992C26.3764 67.9387 26.3924 67.896 26.4244 67.864C26.4671 67.8213 26.5151 67.8 26.5684 67.8H28.0404C28.1364 67.8 28.2111 67.8427 28.2644 67.928L30.8724 71.88C30.8938 71.9013 30.9151 71.912 30.9364 71.912C30.9578 71.912 30.9738 71.9013 30.9844 71.88L33.5924 67.928ZM42.3099 67.784C42.9819 67.784 43.5739 67.9227 44.0859 68.2C44.5979 68.4773 44.9926 68.872 45.2699 69.384C45.5579 69.8853 45.7019 70.4667 45.7019 71.128C45.7019 71.7787 45.5579 72.3547 45.2699 72.856C44.9819 73.3573 44.5713 73.7467 44.0379 74.024C43.5153 74.2907 42.9073 74.424 42.2139 74.424H39.6539C39.6006 74.424 39.5739 74.4507 39.5739 74.504V78.808C39.5739 78.8613 39.5526 78.9093 39.5099 78.952C39.4779 78.984 39.4353 79 39.3819 79H37.9099C37.8566 79 37.8086 78.984 37.7659 78.952C37.7339 78.9093 37.7179 78.8613 37.7179 78.808V67.976C37.7179 67.9227 37.7339 67.88 37.7659 67.848C37.8086 67.8053 37.8566 67.784 37.9099 67.784H42.3099ZM42.0379 72.92C42.5819 72.92 43.0193 72.76 43.3499 72.44C43.6806 72.12 43.8459 71.6987 43.8459 71.176C43.8459 70.6427 43.6806 70.2107 43.3499 69.88C43.0193 69.5493 42.5819 69.384 42.0379 69.384H39.6539C39.6006 69.384 39.5739 69.4107 39.5739 69.464V72.84C39.5739 72.8933 39.6006 72.92 39.6539 72.92H42.0379ZM53.5216 73.672C53.7349 74.184 53.8416 74.7707 53.8416 75.432C53.8416 76.0293 53.7509 76.5573 53.5696 77.016C53.3242 77.688 52.9189 78.2107 52.3536 78.584C51.7882 78.9467 51.1056 79.128 50.3056 79.128C49.5162 79.128 48.8282 78.9307 48.2416 78.536C47.6656 78.1307 47.2549 77.5867 47.0096 76.904C46.8816 76.5733 46.8069 76.1413 46.7856 75.608C46.7856 75.48 46.8496 75.416 46.9776 75.416H48.4656C48.5936 75.416 48.6576 75.48 48.6576 75.608C48.6789 75.9493 48.7322 76.2213 48.8176 76.424C48.9136 76.7653 49.0896 77.0373 49.3456 77.24C49.6122 77.432 49.9322 77.528 50.3056 77.528C51.0096 77.528 51.4949 77.208 51.7616 76.568C51.9002 76.2587 51.9696 75.8587 51.9696 75.368C51.9696 74.824 51.8896 74.376 51.7296 74.024C51.4522 73.4267 50.9722 73.128 50.2896 73.128C50.1082 73.128 49.8629 73.2347 49.5536 73.448C49.5109 73.4693 49.4736 73.48 49.4416 73.48C49.3882 73.48 49.3349 73.448 49.2816 73.384L48.5456 72.36C48.5136 72.3067 48.4976 72.264 48.4976 72.232C48.4976 72.1787 48.5189 72.1307 48.5616 72.088L51.2016 69.496C51.2229 69.4747 51.2282 69.4533 51.2176 69.432C51.2069 69.4107 51.1856 69.4 51.1536 69.4H47.1536C47.1002 69.4 47.0522 69.384 47.0096 69.352C46.9776 69.3093 46.9616 69.2613 46.9616 69.208V67.992C46.9616 67.9387 46.9776 67.896 47.0096 67.864C47.0522 67.8213 47.1002 67.8 47.1536 67.8H53.5376C53.5909 67.8 53.6336 67.8213 53.6656 67.864C53.7082 67.896 53.7296 67.9387 53.7296 67.992V69.384C53.7296 69.48 53.6976 69.56 53.6336 69.624L51.3456 71.928C51.3029 71.9707 51.3242 72.0027 51.4096 72.024C52.4016 72.1627 53.1056 72.712 53.5216 73.672Z" fill="white"/><path d="M35.1584 50V37L47.1584 35V48" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M32.1584 53C33.8153 53 35.1584 51.6569 35.1584 50C35.1584 48.3431 33.8153 47 32.1584 47C30.5016 47 29.1584 48.3431 29.1584 50C29.1584 51.6569 30.5016 53 32.1584 53Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M44.1584 51C45.8153 51 47.1584 49.6569 47.1584 48C47.1584 46.3431 45.8153 45 44.1584 45C42.5016 45 41.1584 46.3431 41.1584 48C41.1584 49.6569 42.5016 51 44.1584 51Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>',
            attrs: fileIconsAttrsTemplates['86x116']
        },
        wma: {
            contents: '<path d="M0.491211 115.57C0.491211 77.0628 0.491211 38.5982 0.491211 0.0160207C0.831658 0.0160207 1.14597 0.0160207 1.46023 0.0160207C20.9862 0.0160207 40.5121 0.0186916 60.0355 0C60.719 0 61.18 0.218946 61.654 0.704928C69.6335 8.86782 77.6261 17.0174 85.6318 25.1535C86.0692 25.5995 86.2368 26.0427 86.2368 26.6622C86.2237 55.9813 86.2263 85.3004 86.2263 114.617C86.2263 114.913 86.2263 115.21 86.2263 115.567C57.6078 115.57 29.0809 115.57 0.491211 115.57ZM1.99972 113.965C29.6388 113.965 57.1338 113.965 84.6603 113.965C84.6603 84.9533 84.6603 55.992 84.6603 26.9479C84.2386 26.9479 83.8877 26.9479 83.5368 26.9479C76.1491 26.9479 68.7588 26.9479 61.3711 26.9479C59.8967 26.9479 59.8286 26.8758 59.8286 25.3431C59.8286 17.8104 59.8286 10.275 59.8286 2.74231C59.8286 2.38984 59.8286 2.03738 59.8286 1.66889C40.5043 1.66889 21.2952 1.66889 2.04678 1.66889C2.02845 1.91455 2.0049 2.09079 2.00228 2.26702C1.91848 9.20695 1.75607 16.1495 1.76917 23.0895C1.81631 49.3031 1.91847 75.5194 1.99704 101.733C2.00751 105.455 1.99972 109.178 1.99972 112.897C1.99972 113.223 1.99972 113.549 1.99972 113.965ZM83.1649 25.2977C75.9265 17.9039 68.6776 10.4993 61.4706 3.13752C61.4706 10.4406 61.4706 17.8558 61.4706 25.2977C68.7824 25.2977 76.0365 25.2977 83.1649 25.2977Z" fill="currentColor"/><path d="M11.6753 9.31912C11.6011 9.69186 11.6051 10.0845 11.4332 10.4316C11.1558 11.0064 10.1436 11.3109 9.30735 11.1344C8.22497 10.904 7.95536 10.3008 7.94755 9.56666C7.93582 8.32609 8.29142 7.74848 9.23313 7.53224C10.6281 7.20787 11.6128 7.94482 11.6753 9.31912Z" fill="currentColor"/><path d="M19.1319 9.31912C19.0576 9.69186 19.0617 10.0845 18.8898 10.4316C18.6123 11.0064 17.6001 11.3109 16.7639 11.1344C15.6815 10.904 15.4119 10.3008 15.4041 9.56666C15.3924 8.32609 15.748 7.74848 16.6897 7.53224C18.0847 7.20787 19.0694 7.94482 19.1319 9.31912Z" fill="currentColor"/><path d="M26.5879 9.31912C26.5137 9.69186 26.5177 10.0845 26.3458 10.4316C26.0684 11.0064 25.0562 11.3109 24.22 11.1344C23.1376 10.904 22.868 10.3008 22.8601 9.56666C22.8484 8.32609 23.204 7.74848 24.1457 7.53224C25.5407 7.20787 26.5254 7.94482 26.5879 9.31912Z" fill="currentColor"/><rect x="15.0269" y="56.4648" width="59.6491" height="26.0965" rx="1" fill="currentColor"/><path d="M31.2722 76C31.1549 76 31.0802 75.9467 31.0482 75.84L28.1362 65.008L28.1202 64.944C28.1202 64.848 28.1789 64.8 28.2962 64.8H29.8642C29.9815 64.8 30.0562 64.8533 30.0882 64.96L31.9122 72.256C31.9229 72.288 31.9389 72.304 31.9602 72.304C31.9815 72.304 31.9975 72.288 32.0082 72.256L33.7522 64.96C33.7842 64.8533 33.8535 64.8 33.9602 64.8H35.4962C35.6135 64.8 35.6882 64.8533 35.7202 64.96L37.5762 72.272C37.5869 72.304 37.6029 72.32 37.6242 72.32C37.6455 72.32 37.6615 72.304 37.6722 72.272L39.4642 64.96C39.4962 64.8533 39.5709 64.8 39.6882 64.8H41.1762C41.3255 64.8 41.3842 64.8693 41.3522 65.008L38.5842 75.84C38.5522 75.9467 38.4775 76 38.3602 76H36.8722C36.7549 76 36.6802 75.9467 36.6482 75.84L34.7762 68.208C34.7655 68.176 34.7495 68.16 34.7282 68.16C34.7069 68.1493 34.6909 68.1653 34.6802 68.208L32.8882 75.84C32.8562 75.9467 32.7869 76 32.6802 76H31.2722ZM50.1511 64.928C50.2044 64.8427 50.2791 64.8 50.3751 64.8H51.8471C51.9004 64.8 51.9431 64.8213 51.9751 64.864C52.0178 64.896 52.0391 64.9387 52.0391 64.992V75.808C52.0391 75.8613 52.0178 75.9093 51.9751 75.952C51.9431 75.984 51.9004 76 51.8471 76H50.3751C50.3218 76 50.2738 75.984 50.2311 75.952C50.1991 75.9093 50.1831 75.8613 50.1831 75.808V68.176C50.1831 68.144 50.1671 68.1227 50.1351 68.112C50.1138 68.1013 50.0978 68.112 50.0871 68.144L48.0871 71.216C48.0338 71.3013 47.9591 71.344 47.8631 71.344H47.1271C47.0311 71.344 46.9564 71.3013 46.9031 71.216L44.8871 68.16C44.8764 68.128 44.8551 68.1173 44.8231 68.128C44.8018 68.1387 44.7911 68.16 44.7911 68.192V75.808C44.7911 75.8613 44.7698 75.9093 44.7271 75.952C44.6951 75.984 44.6524 76 44.5991 76H43.1271C43.0738 76 43.0258 75.984 42.9831 75.952C42.9511 75.9093 42.9351 75.8613 42.9351 75.808V64.992C42.9351 64.9387 42.9511 64.896 42.9831 64.864C43.0258 64.8213 43.0738 64.8 43.1271 64.8H44.5991C44.6951 64.8 44.7698 64.8427 44.8231 64.928L47.4311 68.88C47.4524 68.9013 47.4738 68.912 47.4951 68.912C47.5164 68.912 47.5324 68.9013 47.5431 68.88L50.1511 64.928ZM61.3166 76C61.2099 76 61.1406 75.9467 61.1086 75.84L60.5806 74.128C60.5593 74.0853 60.5326 74.064 60.5006 74.064H56.2766C56.2446 74.064 56.2179 74.0853 56.1966 74.128L55.6686 75.84C55.6366 75.9467 55.5673 76 55.4606 76H53.8606C53.7966 76 53.7486 75.984 53.7166 75.952C53.6846 75.9093 53.6793 75.8507 53.7006 75.776L57.1726 64.96C57.2046 64.8533 57.2739 64.8 57.3806 64.8H59.3806C59.4873 64.8 59.5566 64.8533 59.5886 64.96L63.0766 75.776C63.0873 75.7973 63.0926 75.824 63.0926 75.856C63.0926 75.952 63.0339 76 62.9166 76H61.3166ZM56.6926 72.512C56.6819 72.576 56.7033 72.608 56.7566 72.608H60.0046C60.0686 72.608 60.0899 72.576 60.0686 72.512L58.4206 67.152C58.4099 67.1093 58.3939 67.088 58.3726 67.088C58.3513 67.088 58.3353 67.1093 58.3246 67.152L56.6926 72.512Z" fill="white"/><path d="M37.6497 47V34L49.6497 32V45" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M34.6497 50C36.3065 50 37.6497 48.6569 37.6497 47C37.6497 45.3431 36.3065 44 34.6497 44C32.9928 44 31.6497 45.3431 31.6497 47C31.6497 48.6569 32.9928 50 34.6497 50Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M46.6497 48C48.3065 48 49.6497 46.6569 49.6497 45C49.6497 43.3431 48.3065 42 46.6497 42C44.9928 42 43.6497 43.3431 43.6497 45C43.6497 46.6569 44.9928 48 46.6497 48Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>',
            attrs: fileIconsAttrsTemplates['87x116']
        },
        wav: {
            contents: '<path d="M0.745605 115.57C0.745605 77.0628 0.745605 38.5982 0.745605 0.0160207C1.08605 0.0160207 1.40036 0.0160207 1.71462 0.0160207C21.2406 0.0160207 40.7665 0.0186916 60.2899 0C60.9734 0 61.4344 0.218946 61.9084 0.704928C69.8879 8.86782 77.8805 17.0174 85.8862 25.1535C86.3236 25.5995 86.4912 26.0427 86.4912 26.6622C86.4781 55.9813 86.4807 85.3004 86.4807 114.617C86.4807 114.913 86.4807 115.21 86.4807 115.567C57.8622 115.57 29.3353 115.57 0.745605 115.57ZM2.25412 113.965C29.8932 113.965 57.3882 113.965 84.9147 113.965C84.9147 84.9533 84.9147 55.992 84.9147 26.9479C84.493 26.9479 84.1421 26.9479 83.7912 26.9479C76.4035 26.9479 69.0132 26.9479 61.6255 26.9479C60.1511 26.9479 60.083 26.8758 60.083 25.3431C60.083 17.8104 60.083 10.275 60.083 2.74231C60.083 2.38984 60.083 2.03738 60.083 1.66889C40.7587 1.66889 21.5495 1.66889 2.30117 1.66889C2.28284 1.91455 2.25929 2.09079 2.25667 2.26702C2.17287 9.20695 2.01047 16.1495 2.02356 23.0895C2.0707 49.3031 2.17287 75.5194 2.25143 101.733C2.26191 105.455 2.25412 109.178 2.25412 112.897C2.25412 113.223 2.25412 113.549 2.25412 113.965ZM83.4193 25.2977C76.1809 17.9039 68.932 10.4993 61.725 3.13752C61.725 10.4406 61.725 17.8558 61.725 25.2977C69.0368 25.2977 76.2909 25.2977 83.4193 25.2977Z" fill="currentColor"/><path d="M11.9297 9.31912C11.8555 9.69186 11.8595 10.0845 11.6876 10.4316C11.4102 11.0064 10.398 11.3109 9.56175 11.1344C8.47937 10.904 8.20975 10.3008 8.20194 9.56666C8.19022 8.32609 8.54582 7.74848 9.48753 7.53224C10.8825 7.20787 11.8672 7.94482 11.9297 9.31912Z" fill="currentColor"/><path d="M19.3863 9.31912C19.312 9.69186 19.3161 10.0845 19.1442 10.4316C18.8667 11.0064 17.8545 11.3109 17.0183 11.1344C15.9359 10.904 15.6663 10.3008 15.6585 9.56666C15.6468 8.32609 16.0024 7.74848 16.9441 7.53224C18.3391 7.20787 19.3238 7.94482 19.3863 9.31912Z" fill="currentColor"/><path d="M26.8423 9.31912C26.7681 9.69186 26.7721 10.0845 26.6002 10.4316C26.3228 11.0064 25.3106 11.3109 24.4743 11.1344C23.392 10.904 23.1224 10.3008 23.1145 9.56666C23.1028 8.32609 23.4584 7.74848 24.4001 7.53224C25.7951 7.20787 26.7798 7.94482 26.8423 9.31912Z" fill="currentColor"/><rect x="15.2812" y="59.4648" width="59.6491" height="26.0965" rx="1" fill="currentColor"/><path d="M30.1545 79C30.0372 79 29.9625 78.9467 29.9305 78.84L27.0185 68.008L27.0025 67.944C27.0025 67.848 27.0612 67.8 27.1785 67.8H28.7465C28.8638 67.8 28.9385 67.8533 28.9705 67.96L30.7945 75.256C30.8052 75.288 30.8212 75.304 30.8425 75.304C30.8638 75.304 30.8798 75.288 30.8905 75.256L32.6345 67.96C32.6665 67.8533 32.7358 67.8 32.8425 67.8H34.3785C34.4958 67.8 34.5705 67.8533 34.6025 67.96L36.4585 75.272C36.4692 75.304 36.4852 75.32 36.5065 75.32C36.5278 75.32 36.5438 75.304 36.5545 75.272L38.3465 67.96C38.3785 67.8533 38.4532 67.8 38.5705 67.8H40.0585C40.2078 67.8 40.2665 67.8693 40.2345 68.008L37.4665 78.84C37.4345 78.9467 37.3598 79 37.2425 79H35.7545C35.6372 79 35.5625 78.9467 35.5305 78.84L33.6585 71.208C33.6478 71.176 33.6318 71.16 33.6105 71.16C33.5892 71.1493 33.5732 71.1653 33.5625 71.208L31.7705 78.84C31.7385 78.9467 31.6692 79 31.5625 79H30.1545ZM47.1989 79C47.0922 79 47.0229 78.9467 46.9909 78.84L46.4629 77.128C46.4415 77.0853 46.4149 77.064 46.3829 77.064H42.1589C42.1269 77.064 42.1002 77.0853 42.0789 77.128L41.5509 78.84C41.5189 78.9467 41.4495 79 41.3429 79H39.7429C39.6789 79 39.6309 78.984 39.5989 78.952C39.5669 78.9093 39.5615 78.8507 39.5829 78.776L43.0549 67.96C43.0869 67.8533 43.1562 67.8 43.2629 67.8H45.2629C45.3695 67.8 45.4389 67.8533 45.4709 67.96L48.9589 78.776C48.9695 78.7973 48.9749 78.824 48.9749 78.856C48.9749 78.952 48.9162 79 48.7989 79H47.1989ZM42.5749 75.512C42.5642 75.576 42.5855 75.608 42.6389 75.608H45.8869C45.9509 75.608 45.9722 75.576 45.9509 75.512L44.3029 70.152C44.2922 70.1093 44.2762 70.088 44.2549 70.088C44.2335 70.088 44.2175 70.1093 44.2069 70.152L42.5749 75.512ZM53.0571 79C52.9504 79 52.8811 78.9467 52.8491 78.84L49.4891 68.024L49.4731 67.96C49.4731 67.8533 49.5318 67.8 49.6491 67.8H51.2331C51.3504 67.8 51.4251 67.8533 51.4571 67.96L53.8571 76.312C53.8678 76.344 53.8838 76.36 53.9051 76.36C53.9264 76.36 53.9424 76.344 53.9531 76.312L56.3371 67.96C56.3691 67.8533 56.4438 67.8 56.5611 67.8H58.1131C58.1771 67.8 58.2251 67.8213 58.2571 67.864C58.2891 67.9067 58.2944 67.96 58.2731 68.024L54.8651 78.84C54.8331 78.9467 54.7638 79 54.6571 79H53.0571Z" fill="white"/><path d="M37.9041 50V37L49.9041 35V48" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M34.9041 53C36.5609 53 37.9041 51.6569 37.9041 50C37.9041 48.3431 36.5609 47 34.9041 47C33.2472 47 31.9041 48.3431 31.9041 50C31.9041 51.6569 33.2472 53 34.9041 53Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M46.9041 51C48.5609 51 49.9041 49.6569 49.9041 48C49.9041 46.3431 48.5609 45 46.9041 45C45.2472 45 43.9041 46.3431 43.9041 48C43.9041 49.6569 45.2472 51 46.9041 51Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>',
            attrs: fileIconsAttrsTemplates['87x116']
        },
        wmv: {
            contents: '<path d="M0 115.57C0 77.0628 0 38.5982 0 0.0160207C0.340447 0.0160207 0.654758 0.0160207 0.969017 0.0160207C20.495 0.0160207 40.0209 0.0186916 59.5443 0C60.2278 0 60.6888 0.218946 61.1628 0.704928C69.1423 8.86782 77.1349 17.0174 85.1406 25.1535C85.578 25.5995 85.7456 26.0427 85.7456 26.6622C85.7325 55.9813 85.7351 85.3004 85.7351 114.617C85.7351 114.913 85.7351 115.21 85.7351 115.567C57.1166 115.57 28.5897 115.57 0 115.57ZM1.50851 113.965C29.1476 113.965 56.6426 113.965 84.1691 113.965C84.1691 84.9533 84.1691 55.992 84.1691 26.9479C83.7474 26.9479 83.3965 26.9479 83.0456 26.9479C75.6579 26.9479 68.2676 26.9479 60.8799 26.9479C59.4055 26.9479 59.3374 26.8758 59.3374 25.3431C59.3374 17.8104 59.3374 10.275 59.3374 2.74231C59.3374 2.38984 59.3374 2.03738 59.3374 1.66889C40.0131 1.66889 20.8039 1.66889 1.55557 1.66889C1.53724 1.91455 1.51369 2.09079 1.51107 2.26702C1.42727 9.20695 1.26486 16.1495 1.27796 23.0895C1.3251 49.3031 1.42726 75.5194 1.50583 101.733C1.5163 105.455 1.50851 109.178 1.50851 112.897C1.50851 113.223 1.50851 113.549 1.50851 113.965ZM82.6737 25.2977C75.4353 17.9039 68.1864 10.4993 60.9794 3.13752C60.9794 10.4406 60.9794 17.8558 60.9794 25.2977C68.2912 25.2977 75.5453 25.2977 82.6737 25.2977Z" fill="currentColor"/><path d="M11.1841 9.31912C11.1099 9.69186 11.1139 10.0845 10.942 10.4316C10.6646 11.0064 9.65235 11.3109 8.81614 11.1344C7.73376 10.904 7.46415 10.3008 7.45633 9.56666C7.44461 8.32609 7.80021 7.74848 8.74192 7.53224C10.1369 7.20787 11.1216 7.94482 11.1841 9.31912Z" fill="currentColor"/><path d="M18.6407 9.31912C18.5664 9.69186 18.5705 10.0845 18.3985 10.4316C18.1211 11.0064 17.1089 11.3109 16.2727 11.1344C15.1903 10.904 14.9207 10.3008 14.9129 9.56666C14.9012 8.32609 15.2568 7.74848 16.1985 7.53224C17.5935 7.20787 18.5781 7.94482 18.6407 9.31912Z" fill="currentColor"/><path d="M26.0967 9.31912C26.0225 9.69186 26.0265 10.0845 25.8546 10.4316C25.5772 11.0064 24.565 11.3109 23.7287 11.1344C22.6464 10.904 22.3767 10.3008 22.3689 9.56666C22.3572 8.32609 22.7128 7.74848 23.6545 7.53224C25.0495 7.20787 26.0342 7.94482 26.0967 9.31912Z" fill="currentColor"/><rect x="12.5356" y="62" width="59.6491" height="26.0965" rx="1" fill="currentColor"/><path d="M28.0857 80.5352C27.9684 80.5352 27.8937 80.4818 27.8617 80.3752L24.9497 69.5432L24.9337 69.4792C24.9337 69.3832 24.9924 69.3352 25.1097 69.3352H26.6777C26.795 69.3352 26.8697 69.3885 26.9017 69.4952L28.7257 76.7912C28.7364 76.8232 28.7524 76.8392 28.7737 76.8392C28.795 76.8392 28.811 76.8232 28.8217 76.7912L30.5657 69.4952C30.5977 69.3885 30.667 69.3352 30.7737 69.3352H32.3097C32.427 69.3352 32.5017 69.3885 32.5337 69.4952L34.3897 76.8072C34.4004 76.8392 34.4164 76.8552 34.4377 76.8552C34.459 76.8552 34.475 76.8392 34.4857 76.8072L36.2777 69.4952C36.3097 69.3885 36.3844 69.3352 36.5017 69.3352H37.9897C38.139 69.3352 38.1977 69.4045 38.1657 69.5432L35.3977 80.3752C35.3657 80.4818 35.291 80.5352 35.1737 80.5352H33.6857C33.5684 80.5352 33.4937 80.4818 33.4617 80.3752L31.5897 72.7432C31.579 72.7112 31.563 72.6952 31.5417 72.6952C31.5204 72.6845 31.5044 72.7005 31.4937 72.7432L29.7017 80.3752C29.6697 80.4818 29.6004 80.5352 29.4937 80.5352H28.0857ZM46.9646 69.4632C47.0179 69.3778 47.0926 69.3352 47.1886 69.3352H48.6606C48.7139 69.3352 48.7566 69.3565 48.7886 69.3992C48.8312 69.4312 48.8526 69.4738 48.8526 69.5272V80.3432C48.8526 80.3965 48.8312 80.4445 48.7886 80.4872C48.7566 80.5192 48.7139 80.5352 48.6606 80.5352H47.1886C47.1352 80.5352 47.0872 80.5192 47.0446 80.4872C47.0126 80.4445 46.9966 80.3965 46.9966 80.3432V72.7112C46.9966 72.6792 46.9806 72.6578 46.9486 72.6472C46.9272 72.6365 46.9112 72.6472 46.9006 72.6792L44.9006 75.7512C44.8472 75.8365 44.7726 75.8792 44.6766 75.8792H43.9406C43.8446 75.8792 43.7699 75.8365 43.7166 75.7512L41.7006 72.6952C41.6899 72.6632 41.6686 72.6525 41.6366 72.6632C41.6152 72.6738 41.6046 72.6952 41.6046 72.7272V80.3432C41.6046 80.3965 41.5832 80.4445 41.5406 80.4872C41.5086 80.5192 41.4659 80.5352 41.4126 80.5352H39.9406C39.8872 80.5352 39.8392 80.5192 39.7966 80.4872C39.7646 80.4445 39.7486 80.3965 39.7486 80.3432V69.5272C39.7486 69.4738 39.7646 69.4312 39.7966 69.3992C39.8392 69.3565 39.8872 69.3352 39.9406 69.3352H41.4126C41.5086 69.3352 41.5832 69.3778 41.6366 69.4632L44.2446 73.4152C44.2659 73.4365 44.2872 73.4472 44.3086 73.4472C44.3299 73.4472 44.3459 73.4365 44.3566 73.4152L46.9646 69.4632ZM54.0821 80.5352C53.9754 80.5352 53.9061 80.4818 53.8741 80.3752L50.5141 69.5592L50.4981 69.4952C50.4981 69.3885 50.5567 69.3352 50.6741 69.3352H52.2581C52.3754 69.3352 52.4501 69.3885 52.4821 69.4952L54.8821 77.8472C54.8927 77.8792 54.9087 77.8952 54.9301 77.8952C54.9514 77.8952 54.9674 77.8792 54.9781 77.8472L57.3621 69.4952C57.3941 69.3885 57.4687 69.3352 57.5861 69.3352H59.1381C59.2021 69.3352 59.2501 69.3565 59.2821 69.3992C59.3141 69.4418 59.3194 69.4952 59.2981 69.5592L55.8901 80.3752C55.8581 80.4818 55.7887 80.5352 55.6821 80.5352H54.0821Z" fill="white"/><g clip-path="url(#clip0_3_764)"><path d="M55.5889 38.5599C55.4305 37.9271 55.108 37.3473 54.6538 36.8791C54.1996 36.4109 53.6299 36.0708 53.0023 35.8933C50.7089 35.3333 41.5356 35.3333 41.5356 35.3333C41.5356 35.3333 32.3623 35.3333 30.0689 35.9466C29.4413 36.1242 28.8716 36.4642 28.4174 36.9325C27.9632 37.4007 27.6406 37.9805 27.4823 38.6133C27.0625 40.9407 26.8572 43.3017 26.8689 45.6666C26.854 48.0493 27.0593 50.4283 27.4823 52.7733C27.6569 53.3864 27.9867 53.9441 28.4398 54.3926C28.8929 54.841 29.454 55.165 30.0689 55.3333C32.3623 55.9466 41.5356 55.9466 41.5356 55.9466C41.5356 55.9466 50.7089 55.9466 53.0023 55.3333C53.6299 55.1557 54.1996 54.8156 54.6538 54.3474C55.108 53.8792 55.4305 53.2994 55.5889 52.6666C56.0054 50.3567 56.2107 48.0137 56.2023 45.6666C56.2172 43.2839 56.0119 40.9048 55.5889 38.5599V38.5599Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M38.5356 50.0266L46.2023 45.6666L38.5356 41.3066V50.0266Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></g><defs><clipPath id="clip0_3_764"><rect width="32" height="32" fill="white" transform="translate(25.5356 30)"/></clipPath></defs>',
            attrs: fileIconsAttrsTemplates['86x116']
        },
        avi: {
            contents: '<path d="M0.491211 115.57C0.491211 77.0628 0.491211 38.5982 0.491211 0.0160207C0.831658 0.0160207 1.14597 0.0160207 1.46023 0.0160207C20.9862 0.0160207 40.5121 0.0186916 60.0355 0C60.719 0 61.18 0.218946 61.654 0.704928C69.6335 8.86782 77.6261 17.0174 85.6318 25.1535C86.0692 25.5995 86.2368 26.0427 86.2368 26.6622C86.2237 55.9813 86.2263 85.3004 86.2263 114.617C86.2263 114.913 86.2263 115.21 86.2263 115.567C57.6078 115.57 29.0809 115.57 0.491211 115.57ZM1.99972 113.965C29.6388 113.965 57.1338 113.965 84.6603 113.965C84.6603 84.9533 84.6603 55.992 84.6603 26.9479C84.2386 26.9479 83.8877 26.9479 83.5368 26.9479C76.1491 26.9479 68.7588 26.9479 61.3711 26.9479C59.8967 26.9479 59.8286 26.8758 59.8286 25.3431C59.8286 17.8104 59.8286 10.275 59.8286 2.74231C59.8286 2.38984 59.8286 2.03738 59.8286 1.66889C40.5043 1.66889 21.2952 1.66889 2.04678 1.66889C2.02845 1.91455 2.0049 2.09079 2.00228 2.26702C1.91848 9.20695 1.75607 16.1495 1.76917 23.0895C1.81631 49.3031 1.91847 75.5194 1.99704 101.733C2.00751 105.455 1.99972 109.178 1.99972 112.897C1.99972 113.223 1.99972 113.549 1.99972 113.965ZM83.1649 25.2977C75.9265 17.9039 68.6776 10.4993 61.4706 3.13752C61.4706 10.4406 61.4706 17.8558 61.4706 25.2977C68.7824 25.2977 76.0365 25.2977 83.1649 25.2977Z" fill="currentColor"/><path d="M11.6753 9.31912C11.6011 9.69186 11.6051 10.0845 11.4332 10.4316C11.1558 11.0064 10.1436 11.3109 9.30735 11.1344C8.22497 10.904 7.95536 10.3008 7.94755 9.56666C7.93582 8.32609 8.29142 7.74848 9.23313 7.53224C10.6281 7.20787 11.6128 7.94482 11.6753 9.31912Z" fill="currentColor"/><path d="M19.1319 9.31912C19.0576 9.69186 19.0617 10.0845 18.8898 10.4316C18.6123 11.0064 17.6001 11.3109 16.7639 11.1344C15.6815 10.904 15.4119 10.3008 15.4041 9.56666C15.3924 8.32609 15.748 7.74848 16.6897 7.53224C18.0847 7.20787 19.0694 7.94482 19.1319 9.31912Z" fill="currentColor"/><path d="M26.5879 9.31912C26.5137 9.69186 26.5177 10.0845 26.3458 10.4316C26.0684 11.0064 25.0562 11.3109 24.22 11.1344C23.1376 10.904 22.868 10.3008 22.8601 9.56666C22.8484 8.32609 23.204 7.74848 24.1457 7.53224C25.5407 7.20787 26.5254 7.94482 26.5879 9.31912Z" fill="currentColor"/><rect x="13.0269" y="62" width="59.6491" height="26.0965" rx="1" fill="currentColor"/><path d="M38.8322 80.5352C38.7255 80.5352 38.6562 80.4818 38.6242 80.3752L38.0962 78.6632C38.0749 78.6205 38.0482 78.5992 38.0162 78.5992H33.7922C33.7602 78.5992 33.7335 78.6205 33.7122 78.6632L33.1842 80.3752C33.1522 80.4818 33.0829 80.5352 32.9762 80.5352H31.3762C31.3122 80.5352 31.2642 80.5192 31.2322 80.4872C31.2002 80.4445 31.1949 80.3858 31.2162 80.3112L34.6882 69.4952C34.7202 69.3885 34.7895 69.3352 34.8962 69.3352H36.8962C37.0029 69.3352 37.0722 69.3885 37.1042 69.4952L40.5922 80.3112C40.6029 80.3325 40.6082 80.3592 40.6082 80.3912C40.6082 80.4872 40.5495 80.5352 40.4322 80.5352H38.8322ZM34.2082 77.0472C34.1975 77.1112 34.2189 77.1432 34.2722 77.1432H37.5202C37.5842 77.1432 37.6055 77.1112 37.5842 77.0472L35.9362 71.6872C35.9255 71.6445 35.9095 71.6232 35.8882 71.6232C35.8669 71.6232 35.8509 71.6445 35.8402 71.6872L34.2082 77.0472ZM44.6905 80.5352C44.5838 80.5352 44.5145 80.4818 44.4825 80.3752L41.1225 69.5592L41.1065 69.4952C41.1065 69.3885 41.1651 69.3352 41.2825 69.3352H42.8665C42.9838 69.3352 43.0585 69.3885 43.0905 69.4952L45.4905 77.8472C45.5011 77.8792 45.5171 77.8952 45.5385 77.8952C45.5598 77.8952 45.5758 77.8792 45.5865 77.8472L47.9705 69.4952C48.0025 69.3885 48.0771 69.3352 48.1945 69.3352H49.7465C49.8105 69.3352 49.8585 69.3565 49.8905 69.3992C49.9225 69.4418 49.9278 69.4952 49.9065 69.5592L46.4985 80.3752C46.4665 80.4818 46.3971 80.5352 46.2905 80.5352H44.6905ZM51.7521 80.5352C51.6988 80.5352 51.6508 80.5192 51.6081 80.4872C51.5761 80.4445 51.5601 80.3965 51.5601 80.3432V69.5272C51.5601 69.4738 51.5761 69.4312 51.6081 69.3992C51.6508 69.3565 51.6988 69.3352 51.7521 69.3352H53.2241C53.2774 69.3352 53.3201 69.3565 53.3521 69.3992C53.3948 69.4312 53.4161 69.4738 53.4161 69.5272V80.3432C53.4161 80.3965 53.3948 80.4445 53.3521 80.4872C53.3201 80.5192 53.2774 80.5352 53.2241 80.5352H51.7521Z" fill="white"/><g clip-path="url(#clip0_3_799)"><path d="M56.0801 38.5599C55.9218 37.9271 55.5992 37.3473 55.145 36.8791C54.6908 36.4109 54.1211 36.0708 53.4935 35.8933C51.2001 35.3333 42.0268 35.3333 42.0268 35.3333C42.0268 35.3333 32.8535 35.3333 30.5601 35.9466C29.9325 36.1242 29.3628 36.4642 28.9086 36.9325C28.4544 37.4007 28.1319 37.9805 27.9735 38.6133C27.5538 40.9407 27.3485 43.3017 27.3601 45.6666C27.3452 48.0493 27.5505 50.4283 27.9735 52.7733C28.1481 53.3864 28.4779 53.9441 28.931 54.3926C29.3841 54.841 29.9452 55.165 30.5601 55.3333C32.8535 55.9466 42.0268 55.9466 42.0268 55.9466C42.0268 55.9466 51.2001 55.9466 53.4935 55.3333C54.1211 55.1557 54.6908 54.8156 55.145 54.3474C55.5992 53.8792 55.9218 53.2994 56.0801 52.6666C56.4966 50.3567 56.7019 48.0137 56.6935 45.6666C56.7084 43.2839 56.5031 40.9048 56.0801 38.5599V38.5599Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M39.0269 50.0266L46.6935 45.6666L39.0269 41.3066V50.0266Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></g><defs><clipPath id="clip0_3_799"><rect width="32" height="32" fill="white" transform="translate(26.0269 30)"/></clipPath></defs>',
            attrs: fileIconsAttrsTemplates['87x116']
        },
        mp4: {
            contents: '<path d="M0.236816 115.57C0.236816 77.0628 0.236816 38.5982 0.236816 0.0160207C0.577264 0.0160207 0.891574 0.0160207 1.20583 0.0160207C20.7318 0.0160207 40.2578 0.0186916 59.7811 0C60.4646 0 60.9256 0.218946 61.3996 0.704928C69.3792 8.86782 77.3717 17.0174 85.3774 25.1535C85.8148 25.5995 85.9824 26.0427 85.9824 26.6622C85.9693 55.9813 85.9719 85.3004 85.9719 114.617C85.9719 114.913 85.9719 115.21 85.9719 115.567C57.3534 115.57 28.8265 115.57 0.236816 115.57ZM1.74533 113.965C29.3844 113.965 56.8794 113.965 84.4059 113.965C84.4059 84.9533 84.4059 55.992 84.4059 26.9479C83.9842 26.9479 83.6333 26.9479 83.2824 26.9479C75.8947 26.9479 68.5044 26.9479 61.1167 26.9479C59.6423 26.9479 59.5742 26.8758 59.5742 25.3431C59.5742 17.8104 59.5742 10.275 59.5742 2.74231C59.5742 2.38984 59.5742 2.03738 59.5742 1.66889C40.2499 1.66889 21.0408 1.66889 1.79238 1.66889C1.77405 1.91455 1.7505 2.09079 1.74788 2.26702C1.66408 9.20695 1.50168 16.1495 1.51477 23.0895C1.56191 49.3031 1.66408 75.5194 1.74264 101.733C1.75312 105.455 1.74533 109.178 1.74533 112.897C1.74533 113.223 1.74533 113.549 1.74533 113.965ZM82.9105 25.2977C75.6721 17.9039 68.4232 10.4993 61.2162 3.13752C61.2162 10.4406 61.2162 17.8558 61.2162 25.2977C68.528 25.2977 75.7821 25.2977 82.9105 25.2977Z" fill="currentColor"/><path d="M11.4209 9.31912C11.3467 9.69186 11.3507 10.0845 11.1788 10.4316C10.9014 11.0064 9.88917 11.3109 9.05296 11.1344C7.97058 10.904 7.70097 10.3008 7.69315 9.56666C7.68143 8.32609 8.03703 7.74848 8.97874 7.53224C10.3737 7.20787 11.3584 7.94482 11.4209 9.31912Z" fill="currentColor"/><path d="M18.8775 9.31912C18.8032 9.69186 18.8073 10.0845 18.6354 10.4316C18.3579 11.0064 17.3457 11.3109 16.5095 11.1344C15.4271 10.904 15.1575 10.3008 15.1497 9.56666C15.138 8.32609 15.4936 7.74848 16.4353 7.53224C17.8303 7.20787 18.815 7.94482 18.8775 9.31912Z" fill="currentColor"/><path d="M26.3335 9.31912C26.2593 9.69186 26.2633 10.0845 26.0914 10.4316C25.814 11.0064 24.8018 11.3109 23.9656 11.1344C22.8832 10.904 22.6136 10.3008 22.6057 9.56666C22.594 8.32609 22.9496 7.74848 23.8913 7.53224C25.2863 7.20787 26.271 7.94482 26.3335 9.31912Z" fill="currentColor"/><rect x="12.7725" y="62" width="59.6491" height="26.0965" rx="1" fill="currentColor"/><path d="M35.6233 69.4632C35.6766 69.3778 35.7513 69.3352 35.8473 69.3352H37.3193C37.3726 69.3352 37.4153 69.3565 37.4473 69.3992C37.4899 69.4312 37.5113 69.4738 37.5113 69.5272V80.3432C37.5113 80.3965 37.4899 80.4445 37.4473 80.4872C37.4153 80.5192 37.3726 80.5352 37.3193 80.5352H35.8473C35.7939 80.5352 35.7459 80.5192 35.7033 80.4872C35.6713 80.4445 35.6553 80.3965 35.6553 80.3432V72.7112C35.6553 72.6792 35.6393 72.6578 35.6073 72.6472C35.5859 72.6365 35.5699 72.6472 35.5593 72.6792L33.5593 75.7512C33.5059 75.8365 33.4313 75.8792 33.3353 75.8792H32.5993C32.5033 75.8792 32.4286 75.8365 32.3753 75.7512L30.3593 72.6952C30.3486 72.6632 30.3273 72.6525 30.2953 72.6632C30.2739 72.6738 30.2633 72.6952 30.2633 72.7272V80.3432C30.2633 80.3965 30.2419 80.4445 30.1993 80.4872C30.1673 80.5192 30.1246 80.5352 30.0713 80.5352H28.5993C28.5459 80.5352 28.4979 80.5192 28.4553 80.4872C28.4233 80.4445 28.4073 80.3965 28.4073 80.3432V69.5272C28.4073 69.4738 28.4233 69.4312 28.4553 69.3992C28.4979 69.3565 28.5459 69.3352 28.5993 69.3352H30.0713C30.1673 69.3352 30.2419 69.3778 30.2953 69.4632L32.9033 73.4152C32.9246 73.4365 32.9459 73.4472 32.9673 73.4472C32.9886 73.4472 33.0046 73.4365 33.0153 73.4152L35.6233 69.4632ZM44.3408 69.3192C45.0128 69.3192 45.6048 69.4578 46.1168 69.7352C46.6288 70.0125 47.0234 70.4072 47.3008 70.9192C47.5888 71.4205 47.7328 72.0018 47.7328 72.6632C47.7328 73.3138 47.5888 73.8898 47.3008 74.3912C47.0128 74.8925 46.6021 75.2818 46.0688 75.5592C45.5461 75.8258 44.9381 75.9592 44.2448 75.9592H41.6848C41.6314 75.9592 41.6048 75.9858 41.6048 76.0392V80.3432C41.6048 80.3965 41.5834 80.4445 41.5408 80.4872C41.5088 80.5192 41.4661 80.5352 41.4128 80.5352H39.9408C39.8874 80.5352 39.8394 80.5192 39.7968 80.4872C39.7648 80.4445 39.7488 80.3965 39.7488 80.3432V69.5112C39.7488 69.4578 39.7648 69.4152 39.7968 69.3832C39.8394 69.3405 39.8874 69.3192 39.9408 69.3192H44.3408ZM44.0688 74.4552C44.6128 74.4552 45.0501 74.2952 45.3808 73.9752C45.7114 73.6552 45.8768 73.2338 45.8768 72.7112C45.8768 72.1778 45.7114 71.7458 45.3808 71.4152C45.0501 71.0845 44.6128 70.9192 44.0688 70.9192H41.6848C41.6314 70.9192 41.6048 70.9458 41.6048 70.9992V74.3752C41.6048 74.4285 41.6314 74.4552 41.6848 74.4552H44.0688ZM56.5444 75.9272C56.5977 75.9272 56.6404 75.9485 56.6724 75.9912C56.7151 76.0232 56.7364 76.0658 56.7364 76.1192V77.3992C56.7364 77.4525 56.7151 77.5005 56.6724 77.5432C56.6404 77.5752 56.5977 77.5912 56.5444 77.5912H55.8724C55.819 77.5912 55.7924 77.6178 55.7924 77.6712V80.3432C55.7924 80.3965 55.771 80.4445 55.7284 80.4872C55.6964 80.5192 55.6537 80.5352 55.6004 80.5352H54.1284C54.075 80.5352 54.027 80.5192 53.9844 80.4872C53.9524 80.4445 53.9364 80.3965 53.9364 80.3432V77.6712C53.9364 77.6178 53.9097 77.5912 53.8564 77.5912H48.9924C48.939 77.5912 48.891 77.5752 48.8484 77.5432C48.8164 77.5005 48.8004 77.4525 48.8004 77.3992V76.3752C48.8004 76.3112 48.8164 76.2312 48.8484 76.1352L51.8724 69.4792C51.915 69.3832 51.9897 69.3352 52.0964 69.3352H53.6644C53.739 69.3352 53.787 69.3565 53.8084 69.3992C53.8404 69.4312 53.8404 69.4845 53.8084 69.5592L50.9604 75.8312C50.9497 75.8525 50.9497 75.8738 50.9604 75.8952C50.971 75.9165 50.987 75.9272 51.0084 75.9272H53.8564C53.9097 75.9272 53.9364 75.9005 53.9364 75.8472V73.6712C53.9364 73.6178 53.9524 73.5752 53.9844 73.5432C54.027 73.5005 54.075 73.4792 54.1284 73.4792H55.6004C55.6537 73.4792 55.6964 73.5005 55.7284 73.5432C55.771 73.5752 55.7924 73.6178 55.7924 73.6712V75.8472C55.7924 75.9005 55.819 75.9272 55.8724 75.9272H56.5444Z" fill="white"/><g clip-path="url(#clip0_3_817)"><path d="M55.8257 38.5599C55.6674 37.9271 55.3448 37.3473 54.8906 36.8791C54.4364 36.4109 53.8667 36.0708 53.2391 35.8933C50.9457 35.3333 41.7724 35.3333 41.7724 35.3333C41.7724 35.3333 32.5991 35.3333 30.3057 35.9466C29.6781 36.1242 29.1084 36.4642 28.6542 36.9325C28.2 37.4007 27.8775 37.9805 27.7191 38.6133C27.2994 40.9407 27.0941 43.3017 27.1057 45.6666C27.0908 48.0493 27.2961 50.4283 27.7191 52.7733C27.8937 53.3864 28.2235 53.9441 28.6766 54.3926C29.1297 54.841 29.6908 55.165 30.3057 55.3333C32.5991 55.9466 41.7724 55.9466 41.7724 55.9466C41.7724 55.9466 50.9457 55.9466 53.2391 55.3333C53.8667 55.1557 54.4364 54.8156 54.8906 54.3474C55.3448 53.8792 55.6674 53.2994 55.8257 52.6666C56.2422 50.3567 56.4475 48.0137 56.4391 45.6666C56.454 43.2839 56.2487 40.9048 55.8257 38.5599V38.5599Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M38.7725 50.0266L46.4391 45.6666L38.7725 41.3066V50.0266Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></g><defs><clipPath id="clip0_3_817"><rect width="32" height="32" fill="white" transform="translate(25.7725 30)"/></clipPath></defs>',
            attrs: fileIconsAttrsTemplates['86x116']
        },
        mpg: {
            contents: '<path d="M0.728027 115.57C0.728027 77.0628 0.728027 38.5982 0.728027 0.0160207C1.06847 0.0160207 1.38279 0.0160207 1.69704 0.0160207C21.223 0.0160207 40.749 0.0186916 60.2723 0C60.9558 0 61.4168 0.218946 61.8908 0.704928C69.8704 8.86782 77.8629 17.0174 85.8687 25.1535C86.306 25.5995 86.4736 26.0427 86.4736 26.6622C86.4605 55.9813 86.4631 85.3004 86.4631 114.617C86.4631 114.913 86.4631 115.21 86.4631 115.567C57.8446 115.57 29.3178 115.57 0.728027 115.57ZM2.23654 113.965C29.8756 113.965 57.3706 113.965 84.8971 113.965C84.8971 84.9533 84.8971 55.992 84.8971 26.9479C84.4754 26.9479 84.1245 26.9479 83.7736 26.9479C76.3859 26.9479 68.9957 26.9479 61.6079 26.9479C60.1335 26.9479 60.0654 26.8758 60.0654 25.3431C60.0654 17.8104 60.0654 10.275 60.0654 2.74231C60.0654 2.38984 60.0654 2.03738 60.0654 1.66889C40.7411 1.66889 21.532 1.66889 2.28359 1.66889C2.26526 1.91455 2.24171 2.09079 2.2391 2.26702C2.15529 9.20695 1.99289 16.1495 2.00598 23.0895C2.05312 49.3031 2.15529 75.5194 2.23385 101.733C2.24433 105.455 2.23654 109.178 2.23654 112.897C2.23654 113.223 2.23654 113.549 2.23654 113.965ZM83.4017 25.2977C76.1633 17.9039 68.9144 10.4993 61.7074 3.13752C61.7074 10.4406 61.7074 17.8558 61.7074 25.2977C69.0192 25.2977 76.2733 25.2977 83.4017 25.2977Z" fill="currentColor"/><path d="M11.9122 9.31912C11.8379 9.69186 11.842 10.0845 11.67 10.4316C11.3926 11.0064 10.3804 11.3109 9.54417 11.1344C8.46179 10.904 8.19218 10.3008 8.18436 9.56666C8.17264 8.32609 8.52824 7.74848 9.46995 7.53224C10.8649 7.20787 11.8496 7.94482 11.9122 9.31912Z" fill="currentColor"/><path d="M19.3687 9.31912C19.2945 9.69186 19.2985 10.0845 19.1266 10.4316C18.8491 11.0064 17.8369 11.3109 17.0007 11.1344C15.9183 10.904 15.6487 10.3008 15.6409 9.56666C15.6292 8.32609 15.9848 7.74848 16.9265 7.53224C18.3215 7.20787 19.3062 7.94482 19.3687 9.31912Z" fill="currentColor"/><path d="M26.8247 9.31912C26.7505 9.69186 26.7546 10.0845 26.5826 10.4316C26.3052 11.0064 25.293 11.3109 24.4568 11.1344C23.3744 10.904 23.1048 10.3008 23.097 9.56666C23.0852 8.32609 23.4408 7.74848 24.3825 7.53224C25.7775 7.20787 26.7622 7.94482 26.8247 9.31912Z" fill="currentColor"/><rect x="13.2637" y="62" width="59.6491" height="26.0965" rx="1" fill="currentColor"/><path d="M35.8879 69.4632C35.9412 69.3778 36.0159 69.3352 36.1119 69.3352H37.5839C37.6372 69.3352 37.6799 69.3565 37.7119 69.3992C37.7546 69.4312 37.7759 69.4738 37.7759 69.5272V80.3432C37.7759 80.3965 37.7546 80.4445 37.7119 80.4872C37.6799 80.5192 37.6372 80.5352 37.5839 80.5352H36.1119C36.0586 80.5352 36.0106 80.5192 35.9679 80.4872C35.9359 80.4445 35.9199 80.3965 35.9199 80.3432V72.7112C35.9199 72.6792 35.9039 72.6578 35.8719 72.6472C35.8506 72.6365 35.8346 72.6472 35.8239 72.6792L33.8239 75.7512C33.7706 75.8365 33.6959 75.8792 33.5999 75.8792H32.8639C32.7679 75.8792 32.6932 75.8365 32.6399 75.7512L30.6239 72.6952C30.6132 72.6632 30.5919 72.6525 30.5599 72.6632C30.5386 72.6738 30.5279 72.6952 30.5279 72.7272V80.3432C30.5279 80.3965 30.5066 80.4445 30.4639 80.4872C30.4319 80.5192 30.3892 80.5352 30.3359 80.5352H28.8639C28.8106 80.5352 28.7626 80.5192 28.7199 80.4872C28.6879 80.4445 28.6719 80.3965 28.6719 80.3432V69.5272C28.6719 69.4738 28.6879 69.4312 28.7199 69.3992C28.7626 69.3565 28.8106 69.3352 28.8639 69.3352H30.3359C30.4319 69.3352 30.5066 69.3778 30.5599 69.4632L33.1679 73.4152C33.1892 73.4365 33.2106 73.4472 33.2319 73.4472C33.2532 73.4472 33.2692 73.4365 33.2799 73.4152L35.8879 69.4632ZM44.6054 69.3192C45.2774 69.3192 45.8694 69.4578 46.3814 69.7352C46.8934 70.0125 47.2881 70.4072 47.5654 70.9192C47.8534 71.4205 47.9974 72.0018 47.9974 72.6632C47.9974 73.3138 47.8534 73.8898 47.5654 74.3912C47.2774 74.8925 46.8667 75.2818 46.3334 75.5592C45.8107 75.8258 45.2027 75.9592 44.5094 75.9592H41.9494C41.8961 75.9592 41.8694 75.9858 41.8694 76.0392V80.3432C41.8694 80.3965 41.8481 80.4445 41.8054 80.4872C41.7734 80.5192 41.7307 80.5352 41.6774 80.5352H40.2054C40.1521 80.5352 40.1041 80.5192 40.0614 80.4872C40.0294 80.4445 40.0134 80.3965 40.0134 80.3432V69.5112C40.0134 69.4578 40.0294 69.4152 40.0614 69.3832C40.1041 69.3405 40.1521 69.3192 40.2054 69.3192H44.6054ZM44.3334 74.4552C44.8774 74.4552 45.3147 74.2952 45.6454 73.9752C45.9761 73.6552 46.1414 73.2338 46.1414 72.7112C46.1414 72.1778 45.9761 71.7458 45.6454 71.4152C45.3147 71.0845 44.8774 70.9192 44.3334 70.9192H41.9494C41.8961 70.9192 41.8694 70.9458 41.8694 70.9992V74.3752C41.8694 74.4285 41.8961 74.4552 41.9494 74.4552H44.3334ZM53.369 80.6632C52.569 80.6632 51.865 80.5085 51.257 80.1992C50.649 79.8792 50.1797 79.4312 49.849 78.8552C49.5184 78.2792 49.353 77.6178 49.353 76.8712V72.9992C49.353 72.2418 49.5184 71.5805 49.849 71.0152C50.1797 70.4392 50.649 69.9965 51.257 69.6872C51.865 69.3672 52.569 69.2072 53.369 69.2072C54.1584 69.2072 54.8517 69.3618 55.449 69.6712C56.057 69.9805 56.5264 70.4018 56.857 70.9352C57.1877 71.4685 57.353 72.0712 57.353 72.7432V72.8712C57.353 72.9245 57.3317 72.9725 57.289 73.0152C57.257 73.0472 57.2144 73.0632 57.161 73.0632H55.705C55.6517 73.0632 55.6037 73.0472 55.561 73.0152C55.529 72.9725 55.513 72.9245 55.513 72.8712V72.7912C55.513 72.2152 55.3157 71.7405 54.921 71.3672C54.537 70.9938 54.0197 70.8072 53.369 70.8072C52.7184 70.8072 52.1957 71.0045 51.801 71.3992C51.4064 71.7832 51.209 72.2952 51.209 72.9352V76.9352C51.209 77.5752 51.417 78.0925 51.833 78.4872C52.249 78.8712 52.7877 79.0632 53.449 79.0632C54.089 79.0632 54.5904 78.8978 54.953 78.5672C55.3264 78.2258 55.513 77.7618 55.513 77.1752V76.1832C55.513 76.1298 55.4864 76.1032 55.433 76.1032H53.465C53.4117 76.1032 53.3637 76.0872 53.321 76.0552C53.289 76.0125 53.273 75.9645 53.273 75.9112V74.7272C53.273 74.6738 53.289 74.6312 53.321 74.5992C53.3637 74.5565 53.4117 74.5352 53.465 74.5352H57.161C57.2144 74.5352 57.257 74.5565 57.289 74.5992C57.3317 74.6312 57.353 74.6738 57.353 74.7272V76.7752C57.353 78.0018 56.9904 78.9565 56.265 79.6392C55.5504 80.3218 54.585 80.6632 53.369 80.6632Z" fill="white"/><g clip-path="url(#clip0_3_854)"><path d="M56.317 38.5599C56.1586 37.9271 55.836 37.3473 55.3818 36.8791C54.9276 36.4109 54.358 36.0708 53.7303 35.8933C51.437 35.3333 42.2636 35.3333 42.2636 35.3333C42.2636 35.3333 33.0903 35.3333 30.797 35.9466C30.1693 36.1242 29.5996 36.4642 29.1454 36.9325C28.6912 37.4007 28.3687 37.9805 28.2103 38.6133C27.7906 40.9407 27.5853 43.3017 27.597 45.6666C27.582 48.0493 27.7873 50.4283 28.2103 52.7733C28.3849 53.3864 28.7147 53.9441 29.1678 54.3926C29.6209 54.841 30.182 55.165 30.797 55.3333C33.0903 55.9466 42.2636 55.9466 42.2636 55.9466C42.2636 55.9466 51.437 55.9466 53.7303 55.3333C54.358 55.1557 54.9276 54.8156 55.3818 54.3474C55.836 53.8792 56.1586 53.2994 56.317 52.6666C56.7334 50.3567 56.9387 48.0137 56.9303 45.6666C56.9452 43.2839 56.7399 40.9048 56.317 38.5599V38.5599Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M39.2637 50.0266L46.9303 45.6666L39.2637 41.3066V50.0266Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></g><defs><clipPath id="clip0_3_854"><rect width="32" height="32" fill="white" transform="translate(26.2637 30)"/></clipPath></defs>',
            attrs: fileIconsAttrsTemplates['87x116']
        },
        mpeg: {
            contents: '<path d="M0.473633 115.57C0.473633 77.0628 0.473633 38.5982 0.473633 0.0160207C0.81408 0.0160207 1.12839 0.0160207 1.44265 0.0160207C20.9686 0.0160207 40.4946 0.0186916 60.0179 0C60.7014 0 61.1624 0.218946 61.6364 0.704928C69.616 8.86782 77.6085 17.0174 85.6143 25.1535C86.0516 25.5995 86.2192 26.0427 86.2192 26.6622C86.2061 55.9813 86.2087 85.3004 86.2087 114.617C86.2087 114.913 86.2087 115.21 86.2087 115.567C57.5902 115.57 29.0634 115.57 0.473633 115.57ZM1.98214 113.965C29.6212 113.965 57.1162 113.965 84.6427 113.965C84.6427 84.9533 84.6427 55.992 84.6427 26.9479C84.2211 26.9479 83.8701 26.9479 83.5192 26.9479C76.1315 26.9479 68.7413 26.9479 61.3535 26.9479C59.8791 26.9479 59.811 26.8758 59.811 25.3431C59.811 17.8104 59.811 10.275 59.811 2.74231C59.811 2.38984 59.811 2.03738 59.811 1.66889C40.4867 1.66889 21.2776 1.66889 2.0292 1.66889C2.01087 1.91455 1.98732 2.09079 1.9847 2.26702C1.9009 9.20695 1.7385 16.1495 1.75159 23.0895C1.79873 49.3031 1.90089 75.5194 1.97946 101.733C1.98993 105.455 1.98214 109.178 1.98214 112.897C1.98214 113.223 1.98214 113.549 1.98214 113.965ZM83.1474 25.2977C75.9089 17.9039 68.66 10.4993 61.453 3.13752C61.453 10.4406 61.453 17.8558 61.453 25.2977C68.7648 25.2977 76.0189 25.2977 83.1474 25.2977Z" fill="currentColor"/><path d="M11.6578 9.31912C11.5835 9.69186 11.5876 10.0845 11.4156 10.4316C11.1382 11.0064 10.126 11.3109 9.28978 11.1344C8.20739 10.904 7.93778 10.3008 7.92997 9.56666C7.91824 8.32609 8.27384 7.74848 9.21556 7.53224C10.6105 7.20787 11.5952 7.94482 11.6578 9.31912Z" fill="currentColor"/><path d="M19.1143 9.31912C19.0401 9.69186 19.0441 10.0845 18.8722 10.4316C18.5947 11.0064 17.5825 11.3109 16.7463 11.1344C15.6639 10.904 15.3943 10.3008 15.3865 9.56666C15.3748 8.32609 15.7304 7.74848 16.6721 7.53224C18.0671 7.20787 19.0518 7.94482 19.1143 9.31912Z" fill="currentColor"/><path d="M26.5704 9.31912C26.4961 9.69186 26.5002 10.0845 26.3282 10.4316C26.0508 11.0064 25.0386 11.3109 24.2024 11.1344C23.12 10.904 22.8504 10.3008 22.8426 9.56666C22.8308 8.32609 23.1864 7.74848 24.1282 7.53224C25.5231 7.20787 26.5078 7.94482 26.5704 9.31912Z" fill="currentColor"/><rect x="13.0093" y="62" width="59.6491" height="26.0965" rx="1" fill="currentColor"/><path d="M31.7404 69.928C31.7938 69.8427 31.8684 69.8 31.9644 69.8H33.4364C33.4898 69.8 33.5324 69.8213 33.5644 69.864C33.6071 69.896 33.6284 69.9387 33.6284 69.992V80.808C33.6284 80.8613 33.6071 80.9093 33.5644 80.952C33.5324 80.984 33.4898 81 33.4364 81H31.9644C31.9111 81 31.8631 80.984 31.8204 80.952C31.7884 80.9093 31.7724 80.8613 31.7724 80.808V73.176C31.7724 73.144 31.7564 73.1227 31.7244 73.112C31.7031 73.1013 31.6871 73.112 31.6764 73.144L29.6764 76.216C29.6231 76.3013 29.5484 76.344 29.4524 76.344H28.7164C28.6204 76.344 28.5458 76.3013 28.4924 76.216L26.4764 73.16C26.4658 73.128 26.4444 73.1173 26.4124 73.128C26.3911 73.1387 26.3804 73.16 26.3804 73.192V80.808C26.3804 80.8613 26.3591 80.9093 26.3164 80.952C26.2844 80.984 26.2418 81 26.1884 81H24.7164C24.6631 81 24.6151 80.984 24.5724 80.952C24.5404 80.9093 24.5244 80.8613 24.5244 80.808V69.992C24.5244 69.9387 24.5404 69.896 24.5724 69.864C24.6151 69.8213 24.6631 69.8 24.7164 69.8H26.1884C26.2844 69.8 26.3591 69.8427 26.4124 69.928L29.0204 73.88C29.0418 73.9013 29.0631 73.912 29.0844 73.912C29.1058 73.912 29.1218 73.9013 29.1324 73.88L31.7404 69.928ZM40.4579 69.784C41.1299 69.784 41.7219 69.9227 42.2339 70.2C42.7459 70.4773 43.1406 70.872 43.4179 71.384C43.7059 71.8853 43.8499 72.4667 43.8499 73.128C43.8499 73.7787 43.7059 74.3547 43.4179 74.856C43.1299 75.3573 42.7193 75.7467 42.1859 76.024C41.6633 76.2907 41.0553 76.424 40.3619 76.424H37.8019C37.7486 76.424 37.7219 76.4507 37.7219 76.504V80.808C37.7219 80.8613 37.7006 80.9093 37.6579 80.952C37.6259 80.984 37.5833 81 37.5299 81H36.0579C36.0046 81 35.9566 80.984 35.9139 80.952C35.8819 80.9093 35.8659 80.8613 35.8659 80.808V69.976C35.8659 69.9227 35.8819 69.88 35.9139 69.848C35.9566 69.8053 36.0046 69.784 36.0579 69.784H40.4579ZM40.1859 74.92C40.7299 74.92 41.1673 74.76 41.4979 74.44C41.8286 74.12 41.9939 73.6987 41.9939 73.176C41.9939 72.6427 41.8286 72.2107 41.4979 71.88C41.1673 71.5493 40.7299 71.384 40.1859 71.384H37.8019C37.7486 71.384 37.7219 71.4107 37.7219 71.464V74.84C37.7219 74.8933 37.7486 74.92 37.8019 74.92H40.1859ZM53.0616 71.208C53.0616 71.2613 53.0402 71.3093 52.9976 71.352C52.9656 71.384 52.9229 71.4 52.8696 71.4H47.4136C47.3602 71.4 47.3336 71.4267 47.3336 71.48V74.472C47.3336 74.5253 47.3602 74.552 47.4136 74.552H51.0776C51.1309 74.552 51.1736 74.5733 51.2056 74.616C51.2482 74.648 51.2696 74.6907 51.2696 74.744V75.96C51.2696 76.0133 51.2482 76.0613 51.2056 76.104C51.1736 76.136 51.1309 76.152 51.0776 76.152H47.4136C47.3602 76.152 47.3336 76.1787 47.3336 76.232V79.32C47.3336 79.3733 47.3602 79.4 47.4136 79.4H52.8696C52.9229 79.4 52.9656 79.4213 52.9976 79.464C53.0402 79.496 53.0616 79.5387 53.0616 79.592V80.808C53.0616 80.8613 53.0402 80.9093 52.9976 80.952C52.9656 80.984 52.9229 81 52.8696 81H45.6696C45.6162 81 45.5682 80.984 45.5256 80.952C45.4936 80.9093 45.4776 80.8613 45.4776 80.808V69.992C45.4776 69.9387 45.4936 69.896 45.5256 69.864C45.5682 69.8213 45.6162 69.8 45.6696 69.8H52.8696C52.9229 69.8 52.9656 69.8213 52.9976 69.864C53.0402 69.896 53.0616 69.9387 53.0616 69.992V71.208ZM58.6903 81.128C57.8903 81.128 57.1863 80.9733 56.5783 80.664C55.9703 80.344 55.501 79.896 55.1703 79.32C54.8397 78.744 54.6743 78.0827 54.6743 77.336V73.464C54.6743 72.7067 54.8397 72.0453 55.1703 71.48C55.501 70.904 55.9703 70.4613 56.5783 70.152C57.1863 69.832 57.8903 69.672 58.6903 69.672C59.4797 69.672 60.173 69.8267 60.7703 70.136C61.3783 70.4453 61.8477 70.8667 62.1783 71.4C62.509 71.9333 62.6743 72.536 62.6743 73.208V73.336C62.6743 73.3893 62.653 73.4373 62.6103 73.48C62.5783 73.512 62.5357 73.528 62.4823 73.528H61.0263C60.973 73.528 60.925 73.512 60.8823 73.48C60.8503 73.4373 60.8343 73.3893 60.8343 73.336V73.256C60.8343 72.68 60.637 72.2053 60.2423 71.832C59.8583 71.4587 59.341 71.272 58.6903 71.272C58.0397 71.272 57.517 71.4693 57.1223 71.864C56.7277 72.248 56.5303 72.76 56.5303 73.4V77.4C56.5303 78.04 56.7383 78.5573 57.1543 78.952C57.5703 79.336 58.109 79.528 58.7703 79.528C59.4103 79.528 59.9117 79.3627 60.2743 79.032C60.6477 78.6907 60.8343 78.2267 60.8343 77.64V76.648C60.8343 76.5947 60.8077 76.568 60.7543 76.568H58.7863C58.733 76.568 58.685 76.552 58.6423 76.52C58.6103 76.4773 58.5943 76.4293 58.5943 76.376V75.192C58.5943 75.1387 58.6103 75.096 58.6423 75.064C58.685 75.0213 58.733 75 58.7863 75H62.4823C62.5357 75 62.5783 75.0213 62.6103 75.064C62.653 75.096 62.6743 75.1387 62.6743 75.192V77.24C62.6743 78.4667 62.3117 79.4213 61.5863 80.104C60.8717 80.7867 59.9063 81.128 58.6903 81.128Z" fill="white"/><g clip-path="url(#clip0_3_872)"><path d="M56.0626 38.5599C55.9042 37.9271 55.5816 37.3473 55.1274 36.8791C54.6733 36.4109 54.1036 36.0708 53.4759 35.8933C51.1826 35.3333 42.0092 35.3333 42.0092 35.3333C42.0092 35.3333 32.8359 35.3333 30.5426 35.9466C29.9149 36.1242 29.3452 36.4642 28.891 36.9325C28.4368 37.4007 28.1143 37.9805 27.9559 38.6133C27.5362 40.9407 27.3309 43.3017 27.3426 45.6666C27.3276 48.0493 27.5329 50.4283 27.9559 52.7733C28.1305 53.3864 28.4603 53.9441 28.9134 54.3926C29.3665 54.841 29.9277 55.165 30.5426 55.3333C32.8359 55.9466 42.0092 55.9466 42.0092 55.9466C42.0092 55.9466 51.1826 55.9466 53.4759 55.3333C54.1036 55.1557 54.6733 54.8156 55.1274 54.3474C55.5816 53.8792 55.9042 53.2994 56.0626 52.6666C56.479 50.3567 56.6843 48.0137 56.6759 45.6666C56.6909 43.2839 56.4855 40.9048 56.0626 38.5599V38.5599Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M39.0093 50.0266L46.6759 45.6666L39.0093 41.3066V50.0266Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></g><defs><clipPath id="clip0_3_872"><rect width="32" height="32" fill="white" transform="translate(26.0093 30)"/></clipPath></defs>',
            attrs: fileIconsAttrsTemplates['87x116']
        },
        docx: fileIconTemplate.word,
        doc: fileIconTemplate.word,
        rtf: fileIconTemplate.word,
        docm: fileIconTemplate.word,
        xls: fileIconTemplate.excel,
        xlsx: fileIconTemplate.excel,
        xlsm: fileIconTemplate.excel,
        xlw: fileIconTemplate.excel,
        ppt: fileIconTemplate.powerpoint,
        pptx: fileIconTemplate.powerpoint,
        pps: fileIconTemplate.powerpoint,
        default: {
            contents: '<path d="M44.0738 5.40308H67.6513L85.3345 21.6121V54.0301C85.3345 55.463 84.7135 56.8373 83.6081 57.8506C82.5026 58.8638 81.0034 59.4331 79.4401 59.4331H44.0738C42.5105 59.4331 41.0113 58.8638 39.9059 57.8506C38.8005 56.8373 38.1794 55.463 38.1794 54.0301V10.8061C38.1794 9.37311 38.8005 7.99884 39.9059 6.98558C41.0113 5.97232 42.5105 5.40308 44.0738 5.40308Z" stroke="currentColor" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/><path d="M67.6514 5.40308V21.6121H85.3345" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/><path d="M61.4294 42.1421V25.9331" stroke="currentColor" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/><path d="M52.5879 34.0403H70.271" stroke="currentColor" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/><path d="M84.3421 105.35C85.8159 103.891 86.644 101.912 86.644 99.8483V57.0565C86.644 54.993 85.8159 53.0141 84.3421 51.555C82.8682 50.0959 80.8692 49.2762 78.7848 49.2762H43.4185L35.5593 37.6057H15.9114C13.827 37.6057 11.828 38.4254 10.3541 39.8845C8.88026 41.3436 8.05225 43.3226 8.05225 45.386V99.8483C8.05225 101.912 8.88026 103.891 10.3541 105.35C11.828 106.809 13.827 107.629 15.9114 107.629H78.7848C80.8692 107.629 82.8682 106.809 84.3421 105.35Z" fill="white" stroke="currentColor" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>',
            attrs: {
                width: "98",
                height: "120",
                viewBox: "0 0 98 120",
                fill: "none"
            }
        }
    },
    getIcon: function (icon) {
        return this.icons[icon] ?? this.icons.default;
    }
}

const fileIconView = {
    render: function (link, icon) {
        const svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
        svg.innerHTML = icon.contents;
        for (var attributeKey in icon.attrs) {
            if (!icon.attrs.hasOwnProperty(attributeKey)) continue;
            console.log(`${attributeKey}: ${icon.attrs[attributeKey]}`);
            svg.setAttribute(attributeKey, icon.attrs[attributeKey]);
        }
        link.insertBefore(svg, link.firstChild);
    }
}