﻿const evidenciesAccordionController = {
    init: function () {
        const headers = document.querySelectorAll('.policy-evidence .accordion-header');
        headers.forEach(header => {
            header.querySelector('button').addEventListener('click', e => {
                e.preventDefault();
                if (header.classList.contains('open')) {
                    header.nextElementSibling.removeAttribute('style');
                } else {
                    header.nextElementSibling.setAttribute('style', `max-height: ${header.nextElementSibling.scrollHeight + 100}px`);
                }
                header.classList.toggle('open');
            })
        });
        if (typeof (feather) != "undefined") { feather?.replace(); }
    }
}

/**
 * Inicializa a lib de modais.
 */
document.addEventListener("DOMContentLoaded", function (event) {
    evidenciesAccordionController.init();
});