﻿class Api {
    static headers(type) {
        switch (type) {
            case 'application/json':
                return {
                    Accept: 'application/json',
                    'Content-Type': 'application/json',
                    dataType: 'json',
                }
            case 'multipart/form-data':
                return new Headers();
            default:
                return {
                    'Content-Type': 'text/plain',
                }
        }
    }

    static get(route, header, content_type = 'application/json') {
        return this.xhr(route, null, 'GET', header, content_type);
    }

    static put(route, params, header, content_type = 'application/json') {
        return this.xhr(route, params, 'PUT', header, content_type);
    }

    static post(route, params, header, content_type = 'application/json') {
        return this.xhr(route, params, 'POST', header, content_type);
    }

    static delete(route, params, header, content_type = 'application/json') {
        return this.xhr(route, params, 'DELETE', header, content_type);
    }

    static xhr(route, params, verb, header, content_type) {
        const url = `/api/v10${route}`;
        let options = content_type == 'multipart/form-data' ?
            {
                method: verb,
                body: params
            }
            :
            Object.assign(
                { method: verb },
                params ? { body: JSON.stringify(params) } : null,
            );
        options.headers = Api.headers(content_type);
        if (header) {
            content_type == 'multipart/form-data' ?
                options.headers.append("Authorization", header)
                :
                options.headers.Authorization = header;
        }
        return fetch(url, options).then(resp => {
            if (resp.status == 204) {
                return new Promise((resolve, _) => {
                    resolve([]);
                });
            }
            if (resp.ok) {
                return (content_type == 'application/json') ? resp.json() : resp.text();
            }
            return resp.json().then(err => {
                throw err;
            });
        });
    }
}
