﻿/**
 * Controlador do action icons
 */
var actionIcons = {
    init: function () {
        iconElements = document.querySelectorAll('.list-of-actions li a');
        actionIconsModel.init();
        actionIconsView.init(iconElements);
    },
    getIcons: function () {
        return actionIconsModel.getIcons();
    },
};

/**
 * Model dos dados da aplicação
 */
var actionIconsModel = {
    iconsList: {},
    init: function () {
        iconsList = {
            'documentacao': `<path d="M3.3335 5H13.3335C15.1016 5 16.7973 5.70238 18.0475 6.95262C19.2978 8.20286 20.0002 9.89856 20.0002 11.6667V35C20.0002 33.6739 19.4734 32.4021 18.5357 31.4645C17.598 30.5268 16.3262 30 15.0002 30H3.3335V5Z" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M36.6667 5H26.6667C24.8986 5 23.2029 5.70238 21.9526 6.95262C20.7024 8.20286 20 9.89856 20 11.6667V35C20 33.6739 20.5268 32.4021 21.4645 31.4645C22.4021 30.5268 23.6739 30 25 30H36.6667V5Z" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>`,
            'add': `<path d="M20.0002 36.6668C29.2049 36.6668 36.6668 29.2049 36.6668 20.0002C36.6668 10.7954 29.2049 3.3335 20.0002 3.3335C10.7954 3.3335 3.3335 10.7954 3.3335 20.0002C3.3335 29.2049 10.7954 36.6668 20.0002 36.6668Z" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M20 13.3335V26.6668" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M13.3335 20H26.6668" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>`,
            'edit': `<path d="M18.3335 6.6665H6.66683C5.78277 6.6665 4.93493 7.01769 4.30981 7.64281C3.68469 8.26794 3.3335 9.11578 3.3335 9.99984V33.3332C3.3335 34.2172 3.68469 35.0651 4.30981 35.6902C4.93493 36.3153 5.78277 36.6665 6.66683 36.6665H30.0002C30.8842 36.6665 31.7321 36.3153 32.3572 35.6902C32.9823 35.0651 33.3335 34.2172 33.3335 33.3332V21.6665" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M30.8335 4.16688C31.4965 3.50384 32.3958 3.13135 33.3335 3.13135C34.2712 3.13135 35.1705 3.50384 35.8335 4.16688C36.4965 4.82992 36.869 5.7292 36.869 6.66688C36.869 7.60456 36.4965 8.50384 35.8335 9.16688L20.0002 25.0002L13.3335 26.6669L15.0002 20.0002L30.8335 4.16688Z" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>`,
            'delete': `<path d="M5 10H8.33333H35" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M13.3335 10.0002V6.66683C13.3335 5.78277 13.6847 4.93493 14.3098 4.30981C14.9349 3.68469 15.7828 3.3335 16.6668 3.3335H23.3335C24.2176 3.3335 25.0654 3.68469 25.6905 4.30981C26.3156 4.93493 26.6668 5.78277 26.6668 6.66683V10.0002M31.6668 10.0002V33.3335C31.6668 34.2176 31.3156 35.0654 30.6905 35.6905C30.0654 36.3156 29.2176 36.6668 28.3335 36.6668H11.6668C10.7828 36.6668 9.93493 36.3156 9.30981 35.6905C8.68469 35.0654 8.3335 34.2176 8.3335 33.3335V10.0002H31.6668Z" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M16.6665 18.3335V28.3335" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M23.3335 18.3335V28.3335" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>`,
            'upload': `<path d="M35 25V31.6667C35 32.5507 34.6488 33.3986 34.0237 34.0237C33.3986 34.6488 32.5507 35 31.6667 35H8.33333C7.44928 35 6.60143 34.6488 5.97631 34.0237C5.35119 33.3986 5 32.5507 5 31.6667V25" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M28.3332 13.3333L19.9998 5L11.6665 13.3333" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M20 5V25" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>`,
            'download': `<path d="M35 25V31.6667C35 32.5507 34.6488 33.3986 34.0237 34.0237C33.3986 34.6488 32.5507 35 31.6667 35H8.33333C7.44928 35 6.60143 34.6488 5.97631 34.0237C5.35119 33.3986 5 32.5507 5 31.6667V25" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M11.6665 16.6665L19.9998 24.9998L28.3332 16.6665" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M20 25V5" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>`,
            'export': `<path d="M30.0001 26.6665L35.0001 31.6665L30.0001 36.6665M19.1667 33.3332H10.0001C9.11603 33.3332 8.26818 32.982 7.64306 32.3569C7.01794 31.7317 6.66675 30.8839 6.66675 29.9998V9.99984C6.66675 9.11578 7.01794 8.26794 7.64306 7.64281C8.26818 7.01769 9.11603 6.6665 10.0001 6.6665H30.0001C30.8841 6.6665 31.732 7.01769 32.3571 7.64281C32.9822 8.26794 33.3334 9.11578 33.3334 9.99984V22.4998L19.1667 33.3332ZM6.66675 16.6665H33.3334H6.66675ZM16.6667 6.6665V33.3332V6.6665ZM23.3334 31.6665H35.0001H23.3334Z" stroke-width="1.66667" stroke-linecap="round" stroke-linejoin="round"/>`,
            'refresh': `<path d="M28.3335 1.6665L35.0002 8.33317L28.3335 14.9998" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M5 18.3335V15.0002C5 13.2321 5.70238 11.5364 6.95262 10.2861C8.20286 9.03587 9.89856 8.3335 11.6667 8.3335H35" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M11.6667 38.3333L5 31.6667L11.6667 25" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M35 21.6665V24.9998C35 26.7679 34.2976 28.4636 33.0474 29.7139C31.7971 30.9641 30.1014 31.6665 28.3333 31.6665H5" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>`,
            'test': `<path d="M19.9999 38.182C30.0415 38.182 38.1818 30.0417 38.1818 20.0002C38.1818 9.95864 30.0415 1.81836 19.9999 1.81836C9.95839 1.81836 1.81812 9.95864 1.81812 20.0002C1.81812 30.0417 9.95839 38.182 19.9999 38.182Z" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M16.3635 12.7271L27.2726 19.9998L16.3635 27.2725V12.7271Z" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>`,
            'theme': `<path d="M5 34.9998V28.3332C5 27.0146 5.39099 25.7257 6.12354 24.6294C6.85608 23.533 7.89727 22.6786 9.11544 22.174C10.3336 21.6694 11.6741 21.5374 12.9673 21.7946C14.2605 22.0518 15.4484 22.6868 16.3807 23.6191C17.3131 24.5515 17.948 25.7394 18.2052 27.0326C18.4625 28.3258 18.3304 29.6662 17.8259 30.8844C17.3213 32.1026 16.4668 33.1438 15.3705 33.8763C14.2741 34.6088 12.9852 34.9998 11.6667 34.9998H5Z" stroke-width="1.66667" stroke-linecap="round" stroke-linejoin="round"/><path d="M35.0001 5C30.2431 5.65067 25.75 7.57357 21.9952 10.5657C18.2403 13.5579 15.3629 17.5083 13.6667 22" stroke-width="1.66667" stroke-linecap="round" stroke-linejoin="round"/><path d="M35 5C34.3493 9.75697 32.4264 14.25 29.4343 18.0049C26.4421 21.7598 22.4917 24.6372 18 26.3333" stroke-width="1.66667" stroke-linecap="round" stroke-linejoin="round"/><path d="M17.6667 15C20.9054 16.4948 23.5053 19.0947 25.0001 22.3333" stroke-width="1.66667" stroke-linecap="round" stroke-linejoin="round"/>`,
            'copy': `<path d="M33.3333 15H18.3333C16.4924 15 15 16.4924 15 18.3333V33.3333C15 35.1743 16.4924 36.6667 18.3333 36.6667H33.3333C35.1743 36.6667 36.6667 35.1743 36.6667 33.3333V18.3333C36.6667 16.4924 35.1743 15 33.3333 15Z" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M8.33325 25.0002H6.66659C5.78253 25.0002 4.93468 24.649 4.30956 24.0239C3.68444 23.3987 3.33325 22.5509 3.33325 21.6668V6.66683C3.33325 5.78277 3.68444 4.93493 4.30956 4.30981C4.93468 3.68469 5.78253 3.3335 6.66659 3.3335H21.6666C22.5506 3.3335 23.3985 3.68469 24.0236 4.30981C24.6487 4.93493 24.9999 5.78277 24.9999 6.66683V8.3335" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>`,
            'preview': `<path d="M1.66675 19.9998C1.66675 19.9998 8.33341 6.6665 20.0001 6.6665C31.6667 6.6665 38.3334 19.9998 38.3334 19.9998C38.3334 19.9998 31.6667 33.3332 20.0001 33.3332C8.33341 33.3332 1.66675 19.9998 1.66675 19.9998Z" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M20 25C22.7614 25 25 22.7614 25 20C25 17.2386 22.7614 15 20 15C17.2386 15 15 17.2386 15 20C15 22.7614 17.2386 25 20 25Z" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>`,
            'home': `<path d="M5 15.0002L20 3.3335L35 15.0002V33.3335C35 34.2176 34.6488 35.0654 34.0237 35.6905C33.3986 36.3156 32.5507 36.6668 31.6667 36.6668H8.33333C7.44928 36.6668 6.60143 36.3156 5.97631 35.6905C5.35119 35.0654 5 34.2176 5 33.3335V15.0002Z" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M15 36.6667V20H25V36.6667" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>`,
            'clear-cache': `<path fill-rule="evenodd" clip-rule="evenodd" d="M18.3849 21.3349L9.44154 4.51321C9.39016 4.41658 9.35832 4.31077 9.34783 4.20184C9.33734 4.0929 9.34841 3.98296 9.38041 3.8783C9.44503 3.66693 9.59097 3.48989 9.78613 3.38613C9.98128 3.28236 10.2097 3.26037 10.421 3.32499C10.5257 3.35699 10.623 3.40929 10.7075 3.4789C10.7919 3.54851 10.8618 3.63408 10.9132 3.73071L19.8574 20.5524L21.1257 19.8774C21.5123 19.6719 21.9355 19.5445 22.3713 19.5026C22.8071 19.4607 23.2469 19.505 23.6656 19.6331C24.0842 19.7612 24.4735 19.9705 24.8113 20.249C25.149 20.5276 25.4286 20.8699 25.634 21.2565L26.174 22.2715L31.8982 30.6507L20.024 36.964L16.2782 27.5324L15.739 26.5174C15.5335 26.1309 15.4061 25.7076 15.3641 25.2719C15.3222 24.8361 15.3664 24.3964 15.4944 23.9777C15.6224 23.5591 15.8316 23.1697 16.1101 22.832C16.3886 22.4942 16.7308 22.2145 17.1174 22.009L18.3857 21.3349H18.3849ZM17.899 23.4807L21.9074 21.3499C22.1006 21.2471 22.3122 21.1834 22.5301 21.1624C22.748 21.1414 22.9679 21.1636 23.1772 21.2276C23.3865 21.2916 23.5812 21.3962 23.7501 21.5354C23.919 21.6746 24.0588 21.8458 24.1615 22.039L24.7015 23.0532L17.749 26.7499L17.2099 25.7349C17.1071 25.5416 17.0434 25.33 17.0224 25.1121C17.0014 24.8942 17.0236 24.6744 17.0876 24.465C17.1516 24.2557 17.2562 24.0611 17.3954 23.8922C17.5346 23.7233 17.7058 23.5835 17.899 23.4807V23.4807ZM18.5907 28.8407L20.8849 34.6182L22.4132 33.8057L20.609 30.2932L22.0924 29.5315L23.8857 33.0232L29.4707 30.0532L25.964 24.9199L18.5907 28.8407V28.8407Z" /><path d="M13.6333 29.359C13.7174 29.289 13.8144 29.2362 13.9189 29.2037C14.0234 29.1711 14.1333 29.1595 14.2423 29.1695C14.3513 29.1794 14.4573 29.2107 14.5542 29.2616C14.651 29.3125 14.737 29.382 14.807 29.4661C14.877 29.5502 14.9298 29.6473 14.9624 29.7518C14.9949 29.8563 15.0065 29.9662 14.9966 30.0751C14.9866 30.1841 14.9553 30.2901 14.9044 30.387C14.8535 30.4839 14.784 30.5698 14.6999 30.6398L14.6991 30.6407L14.6974 30.6423L14.6949 30.644L14.6866 30.6507L14.6616 30.6715L14.5758 30.7373C14.5033 30.7915 14.4008 30.8657 14.2699 30.954C14.0074 31.129 13.6283 31.3573 13.1499 31.5857C11.9065 32.1823 10.5458 32.4946 9.16659 32.4998C8.94557 32.4998 8.73361 32.4121 8.57733 32.2558C8.42105 32.0995 8.33325 31.8875 8.33325 31.6665C8.33325 31.4455 8.42105 31.2335 8.57733 31.0773C8.73361 30.921 8.94557 30.8332 9.16659 30.8332C10.2978 30.8278 11.4137 30.5707 12.4333 30.0807C12.749 29.9311 13.0536 29.7593 13.3449 29.5665C13.4408 29.5031 13.5345 29.4364 13.6258 29.3665L13.6341 29.3582V29.359H13.6333ZM16.2958 34.8598C16.4796 34.7372 16.6073 34.5465 16.6506 34.3297C16.6938 34.113 16.6492 33.8879 16.5266 33.704C16.4039 33.5201 16.2132 33.3925 15.9965 33.3492C15.7797 33.3059 15.5546 33.3505 15.3708 33.4732L15.3691 33.4748L15.3524 33.4848L15.2808 33.5307C14.8469 33.7953 14.3965 34.0319 13.9324 34.239C13.0408 34.634 11.9158 34.9998 10.8333 34.9998C10.6122 34.9998 10.4003 35.0876 10.244 35.2439C10.0877 35.4002 9.99992 35.6122 9.99992 35.8332C9.99992 36.0542 10.0877 36.2662 10.244 36.4224C10.4003 36.5787 10.6122 36.6665 10.8333 36.6665C12.2516 36.6665 13.6249 36.199 14.6091 35.7615C15.1437 35.5234 15.6623 35.2509 16.1616 34.9457C16.1934 34.9259 16.2251 34.9059 16.2566 34.8857L16.2833 34.8682L16.2916 34.8632L16.2958 34.8598V34.8598Z" />`,
            'translations': `<path d="M24.4049 30H33.9283M3.33325 8.33333H14.9999H3.33325ZM26.6666 8.33333H22.4999H26.6666ZM14.9999 8.33333H22.4999H14.9999ZM14.9999 8.33333V5V8.33333ZM22.4999 8.33333C21.1333 12.8917 18.2683 17.2 14.9999 20.9883L22.4999 8.33333ZM6.66659 29.1667C9.30825 26.9017 12.2933 24.1233 14.9999 20.9883L6.66659 29.1667ZM14.9999 20.9883C13.3333 19.1667 10.6666 15.5 9.99992 14.1667L14.9999 20.9883ZM14.9999 20.9883L19.9999 25.8333L14.9999 20.9883ZM22.4999 35L24.4049 30L22.4999 35ZM35.8333 35L33.9283 30L35.8333 35ZM24.4049 30L29.1666 17.5L33.9283 30H24.4049Z" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>`,
            'rewind': '<path d="M18.3333 31.6667L3.33333 20L18.3333 8.33334V31.6667Z" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" /><path d="M36.6667 31.6667L21.6667 20L36.6667 8.33334V31.6667Z" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />',
        };
    },
    getIcons: function () {
        return iconsList;
    },
};

/**
 * Responsável por renderizar os ícones.
 */
var actionIconsView = {
    init: function (iconElements) {
        actionIconsView.render(actionIcons.getIcons(), iconElements);
    },
    render: function (actionIcons, iconElements) {
        const filledIcons = ['clear-cache'];
        iconElements.forEach(iconElement => {
            const iconName = iconElement.classList[0];
            const svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
            svg.innerHTML = actionIcons[iconName];
            svg.setAttribute("width", "40");
            svg.setAttribute("height", "40");
            svg.setAttribute("viewBox", "0 0 40 40");
            if (filledIcons.includes(iconName)) {
                svg.classList.add('fill');
            } else {
                svg.setAttribute('fill', 'none')
            }
            iconElement.appendChild(svg);
        })
    },
};
