﻿const accordionController = {
    init: function (initOpen = false) {
        const headers = document.querySelectorAll('.accordion-header');
        headers.forEach(header => {
            header.addEventListener('click', e => {
                e.preventDefault();
                if (header.classList.contains('open')) {
                    header.nextElementSibling.removeAttribute('style');
                } else {
                    header.nextElementSibling.setAttribute('style', `max-height: ${(2*header.nextElementSibling.scrollHeight) + 100}px`);
                }
                header.classList.toggle('open');
            })

            if (initOpen) {
                header.classList.add('open');
                header.nextElementSibling.setAttribute('style', `max-height: ${(2 * header.nextElementSibling.scrollHeight) + 100}px`);
                header.classList.remove('initOpen');
            }
        });
        if (typeof (feather) != 'undefined') { feather?.replace(); }
    },
}