﻿var enterMobileVersion = false;
function menuclick(e) {
    e.preventDefault();
    const page = getPage();
    if (verificarMenuFechado(page)) {
        openMenu(page);
    } else {
        closeMenu(page);
    }
}

function verificarMenuFechado(page) {
    return page.classList.contains('close') || page.classList.contains('initClosed');
}

function getPage() {
    return document.getElementById('collapsable-page');
}

function closeMenu(page) {
    localStorage.setItem('menuclose', true);
    page.classList.remove('open');
    page.classList.add('close');
}

function openMenu(page) {
    localStorage.removeItem('menuclose');
    page.classList.remove('close');
    page.classList.remove('initClosed');
    page.classList.add('open');
}

function portalClick(e) {
    e.preventDefault();
}

function studioClick(e) {
    e.preventDefault();
    const studiobutton = document.getElementById('WFPageBanner_CTWFPageBanner_btnadmin');
    studiobutton.click();
}

function clicklogoff(e) {
    e.preventDefault();
    const logoffbutton = document.getElementById('WFPageBanner_CTWFPageBanner_btlogoff');
    logoffbutton.click();
}

function clickmeusdados(e) {
    e.preventDefault();
    const meusdadosbutton = document.querySelector('a.user');
    meusdadosbutton.click();
}

function editClick() {
    let editbutton = document.getElementById('WFPageBanner_CTWFPageBanner_btnedit');
    if (!editbutton) {
        editbutton = document.getElementById('WFPageBanner_CTWFPageBanner_WFPageToolBar_CTWFPageToolBar_btnbrowse');
    }
    editbutton.click();
}

function dropdownfunction() {
    document.getElementById("myDropdown").classList.toggle('show');
}

function inicializaOMenuFechadoSeNecessario() {
    const menuClose = localStorage.getItem('menuclose');
    if (menuClose || window.innerWidth <= 1024) {
        enterMobileVersion = true;
        const page = getPage();
        page.classList.add('initClosed');
    }
}

function escondeSlideDeEdicaoSeNecessario() {
    const editbutton = document.getElementById('WFPageBanner_CTWFPageBanner_btnedit');
    const navigateButton = document.getElementById('WFPageBanner_CTWFPageBanner_WFPageToolBar_CTWFPageToolBar_btnbrowse');
    if (!editbutton && !navigateButton) {
        const editnav = document.querySelector('.edit-nav');
        editnav.style.display = "none";
    } else if (!editbutton) {
        document.getElementById('edit-switch-checkbox').checked = true;
    }
}

function escondeNavigationMasterSeNecessario() {
    const studiobutton = document.getElementById('WFPageBanner_CTWFPageBanner_btnadmin');
    if (!studiobutton) {
        const navMasterDiv = document.querySelector('.navigation-master');
        navMasterDiv.style.display = 'none';
    }
}

function adicionaListenerAItensDeMenuComFilhos() {
    const linksComFilhos = document.querySelectorAll('aside.nav nav > ul > li > a.wfmenuhandled');
    if (linksComFilhos.length > 0) {
        const page = getPage();
        linksComFilhos.forEach((item) => {
            item.addEventListener('click', (event) => {
                if (verificarMenuFechado(page)) {
                    openMenu(page)
                }
            })
        })
    }
}

function verificaMenusQueEstaoAbertos() {
    const linksComFilhos = document.querySelectorAll('aside.nav nav > ul a.wfmenuhandled');
    if (linksComFilhos.length > 0) {
        linksComFilhos.forEach((item) => {
            // pega a tag style da ul que é filha do item externo e verifica se está aberta.
            let siblingStyle = item.parentElement.children[1].getAttribute('style');
            if (siblingStyle.includes('display') && siblingStyle.includes('block')) {
                item.classList.add('aberto');
            }
        })
    }
}

function removeTitlePrefix() {
    const title = document.querySelector('header h2');
    const titleString = title.textContent;
    title.innerHTML = titleString.replace(/^(Zuri - )/, '');
}

function init() {
    feather.replace();

    inicializaOMenuFechadoSeNecessario();

    escondeSlideDeEdicaoSeNecessario();

    adicionaListenerAItensDeMenuComFilhos();

    escondeNavigationMasterSeNecessario();

    removeTitlePrefix();

    verificaMenusQueEstaoAbertos();
}

document.addEventListener("DOMContentLoaded", function (event) {
    init();
});

// limpa o dropdown se clicar fora
window.onclick = function (event) {
    if (!event.target.matches('.dropbtn') && !event.target.matches('.dropbtn polyline')) {
        var dropdowns = document.getElementsByClassName("dropdown-content");
        var i;
        for (i = 0; i < dropdowns.length; i++) {
            var openDropdown = dropdowns[i];
            if (openDropdown.classList.contains('show')) {
                openDropdown.classList.remove('show');
            }
        }
    }
}

window.addEventListener('resize', function () {
    const page = getPage();
    if (window.innerWidth < 1024) {
        if (!verificarMenuFechado(page) && !enterMobileVersion) {
            enterMobileVersion = true;
            closeMenu(page);
        }
    } else if (enterMobileVersion) {
        enterMobileVersion = false;
        openMenu(page);
    }
}, true);

if ('serviceWorker' in navigator) {
    navigator.serviceWorker.register("/serviceworker.js");
}

addEventListener("beforeunload", (_) => {
    if (window.outerWidth <= 511) {
        document.querySelector('body').classList.add('loading');
    }
});
