﻿<?xml version="1.0"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:ms="urn:schemas-microsoft-com:xslt" version="1.0">

  <xsl:output method="html"/>

  <xsl:template match="/">
    <html>
      <style type="text/css">
        table{
        border-spacing:0;
        border-collapse:collapse;
        border:solid 1px gray;
        }
        thead th, td{
        border:solid 1px gray;
        margin:0;
        padding:0;
        }
      </style>
      <body>
        <table>
          <thead>
            <tr>
              <th>Campo</th>
              <th>Data</th>
              <th>Usuário</th>
              <th>Valor</th>
            </tr>
          </thead>
          <xsl:apply-templates select="//Item/*">
            <xsl:sort select="name()" />
          </xsl:apply-templates>
        </table>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="Item/*">
    <xsl:variable name="n" select="name()" />
    <tr>
      <xsl:if test="ancestor::*[1] = //Item[1]">
        <td>
          <xsl:attribute name="rowspan">
            <xsl:value-of select="count(//Item/*[name()=$n])"/>
          </xsl:attribute>
          <xsl:value-of select="$n"/>
        </td>
      </xsl:if>
      <td>
        <xsl:value-of select="ms:format-date(@DataModificacao, 'dd/MM/yyyy ', 'pt-BR')"/> <xsl:value-of select="ms:format-time(@DataModificacao, 'HH:mm:ss', 'pt-BR')"/>
      </td>
      <td>
        <xsl:value-of select="@NomeUsuario"/>
      </td>
      <td>
        <xsl:value-of select="@Valor" disable-output-escaping="yes"/>
      </td>
    </tr>
  </xsl:template>

</xsl:stylesheet>