﻿function GetKeyCode(ev) {
    return ev.keyCode || ev.which;
}

//*--------------------------- Formatação de CPF ----------------------------------------*
function GetKeyCode(ev) {
    return ev.keyCode || ev.which;
}

function MaskCPF(src, intKeyCode) {
    if (parseInt(intKeyCode) != 13 &&
        parseInt(intKeyCode) != 8 && // Backspace
        parseInt(intKeyCode) != 9 && // Tab
        parseInt(intKeyCode) != 46 && // Delete
        parseInt(intKeyCode) != 37 && // Seta esquerda
        parseInt(intKeyCode) != 38 && // Seta para cima
        parseInt(intKeyCode) != 39 && // Seta direita
        parseInt(intKeyCode) != 40) { // Seta para baixo
        if ((parseInt(intKeyCode) < 48) || (parseInt(intKeyCode) > 57)) {
            return false
        }
        else {
            var mascara = '###.###.###-##';
            var campo = src.value.length;
            var saida = mascara.substring(0, 1);
            var texto = mascara.substring(campo);
            if (texto.substring(0, 1) != saida) {
                src.value += texto.substring(0, 1);
            }
        }
    }
    else {
        return true
    }
}
//*--------------------------------------------------------------------------------------*

//*--------------------------- Formatação de CNPJ ---------------------------------------*
function MaskCNPJ(src, intKeyCode) {
    if (parseInt(intKeyCode) != 13 &&
        parseInt(intKeyCode) != 8 && // Backspace
        parseInt(intKeyCode) != 9 && // Tab
        parseInt(intKeyCode) != 46 && // Delete
        parseInt(intKeyCode) != 37 && // Seta esquerda
        parseInt(intKeyCode) != 38 && // Seta para cima
        parseInt(intKeyCode) != 39 && // Seta direita
        parseInt(intKeyCode) != 40) { // Seta para baixo
        if ((parseInt(intKeyCode) < 48) || (parseInt(intKeyCode) > 57)) {
            return false
        }
        else {
            var mascara = '##.###.###/####-##';
            var campo = src.value.length;
            var saida = mascara.substring(0, 1);
            var texto = mascara.substring(campo);
            if (texto.substring(0, 1) != saida) {
                src.value += texto.substring(0, 1);
            }
        }
    }
    else {
        return true
    }
}
//*--------------------------------------------------------------------------------------*

//*--------------------------- Formatação de Datas --------------------------------------*
function MaskDate(objCampo, intKeyCode) {
    var isKeyCodeOk = false;
    var valor = objCampo.value;
    valor = valor.replace("/", "").replace("/", "");
    var intLengthValor = valor.length;
    if (parseInt(intKeyCode) == 13 ||
        parseInt(intKeyCode) == 8 || // Backspace
        parseInt(intKeyCode) == 9 || // Tab
        parseInt(intKeyCode) == 46 || // Delete
        parseInt(intKeyCode) == 37 || // Seta esquerda
        parseInt(intKeyCode) == 38 || // Seta para cima
        parseInt(intKeyCode) == 39 || // Seta direita
        parseInt(intKeyCode) == 40) // Seta para baixo
        return true;
    if ((parseInt(intKeyCode) >= 48) && (parseInt(intKeyCode) <= 57)) isKeyCodeOk = true;
    if (isKeyCodeOk) {
        if (intLengthValor > 4) valor = valor.substring(0, 2) + "/" + valor.substring(2, 4) + "/" + valor.substring(4);
        if (intLengthValor == 4) valor = valor.substring(0, 2) + "/" + valor.substring(2) + "/";
        if (intLengthValor == 3) valor = valor.substring(0, 2) + "/" + valor.substring(2);
        if (intLengthValor == 2) valor = valor + "/";
        objCampo.value = valor;
        if (intLengthValor == 8) return false;
        return true;
    }
    return false;
}

function MaskDateTime(objCampo, intKeyCode) {
    var isKeyCodeOk = false;
    var valor = objCampo.value;
    valor = valor.replace("/", "").replace("/", "").replace(" ", "").replace(":", "");
    var intLengthValor = valor.length;
    if (parseInt(intKeyCode) == 13 ||
        parseInt(intKeyCode) == 8 || // Backspace
        parseInt(intKeyCode) == 9 || // Tab
        parseInt(intKeyCode) == 46 || // Delete
        parseInt(intKeyCode) == 37 || // Seta esquerda
        parseInt(intKeyCode) == 38 || // Seta para cima
        parseInt(intKeyCode) == 39 || // Seta direita
        parseInt(intKeyCode) == 40) // Seta para baixo
        return true;
    if ((parseInt(intKeyCode) >= 48) && (parseInt(intKeyCode) <= 57)) isKeyCodeOk = true;
    if (isKeyCodeOk) {
        if (intLengthValor > 10) valor = valor.substring(0, 2) + "/" + valor.substring(2, 4) + "/" + valor.substring(4, 8) + " " + valor.substring(8, 10) + ":" + valor.substring(10);
        if (intLengthValor == 10) valor = valor.substring(0, 2) + "/" + valor.substring(2, 4) + "/" + valor.substring(4, 8) + " " + valor.substring(8) + ":";
        if (intLengthValor == 9) valor = valor.substring(0, 2) + "/" + valor.substring(2, 4) + "/" + valor.substring(4, 8) + " " + valor.substring(8);
        if (intLengthValor == 8) valor = valor.substring(0, 2) + "/" + valor.substring(2, 4) + "/" + valor.substring(4) + " ";
        if (intLengthValor > 4 && intLengthValor < 8) valor = valor.substring(0, 2) + "/" + valor.substring(2, 4) + "/" + valor.substring(4);
        if (intLengthValor == 4) valor = valor.substring(0, 2) + "/" + valor.substring(2) + "/";
        if (intLengthValor == 3) valor = valor.substring(0, 2) + "/" + valor.substring(2);
        if (intLengthValor == 2) valor = valor + "/";
        objCampo.value = valor;
        if (intLengthValor == 12) return false;
        return true;
    }
    return false;
}
//*--------------------------------------------------------------------------------------*

//*--------------------------- Formatação de Números ------------------------------------*
function MaskNumber(objCampo, intKeyCode) {
    if (parseInt(intKeyCode) != 13 &&
        parseInt(intKeyCode) != 8 && // Backspace
        parseInt(intKeyCode) != 9 && // Tab
        parseInt(intKeyCode) != 46 && // Delete
        parseInt(intKeyCode) != 37 && // Seta esquerda
        parseInt(intKeyCode) != 38 && // Seta para cima
        parseInt(intKeyCode) != 39 && // Seta direita
        parseInt(intKeyCode) != 40) { // Seta para baixo
        if ((parseInt(intKeyCode) < 48) || (parseInt(intKeyCode) > 57)) {
            return false
        }
        else {
            return true
        }
    }
    else {
        return true
    }
}
//*--------------------------------------------------------------------------------------*

documentall = document.all;

//*--------------------------- Formatação de Monetários R$ ---------------------------------*
function MaskCurrency(obj, e, p) {
    if (p == undefined) p = 2;
    var boolret = true;
    var intKeyCode = e.keyCode || e.which;
    if (parseInt(intKeyCode) != 13 &&
        parseInt(intKeyCode) != 8 && // Backspace
        parseInt(intKeyCode) != 9 && // Tab
        parseInt(intKeyCode) != 46 && // Delete
        parseInt(intKeyCode) != 37 && // Seta esquerda
        parseInt(intKeyCode) != 38 && // Seta para cima
        parseInt(intKeyCode) != 39 && // Seta direita
        parseInt(intKeyCode) != 40) { // Seta para baixo
        if ((parseInt(intKeyCode) < 48) || (parseInt(intKeyCode) > 57)) {
            boolret = false;
        }
    }

    if (boolret == true) {
        var whichCode = intKeyCode;
        /*
        Executa a formatação após o backspace nos navegadores !document.all
        */
        if (whichCode == 8) {
            /*
            Previne a ação padrão nos navegadores
            */
            if (e.preventDefault) { //standart browsers
                e.preventDefault();
            } else { // internet explorer
                e.returnValue = false;
            }
            var valor = obj.value;
            var x = valor.substring(0, valor.length - 1);
            obj.value = demaskvalue(x, true, p).formatCurrency(p);
            return false;
        }
        /*
        Executa o Formata Reais e faz o format currency novamente após o backspace
        */
        FormataReais(obj, '.', ',', e, p);
    }
    else {
        return false;
    }
} // end MaskCurrency

function formatamoney(c) {
    var t = this;
    if (c == undefined) c = 2;
    var p, d = (t = t.split("."))[1].substr(0, c);
    for (p = (t = t[0]).length; (p -= 3) >= 1;) {
        t = t.substr(0, p) + "." + t.substr(p);
    }
    return t + "," + d + Array(c + 1 - d.length).join(0);
}

String.prototype.formatCurrency = formatamoney

function demaskvalue(valor, currency, p) {
    /*
    * Se currency é false, retorna o valor sem apenas com os números. Se é true, os dois últimos caracteres são considerados as 
    * casas decimais
    */
    var val2 = '';
    var strCheck = '0123456789';
    var len = valor.length;
    var returnprefix = '0.';
    //returnprefix += p.join(0);

    if (len == 0) { return returnprefix + '0'.repeat(p); }

    if (currency == true) {
        /* Elimina os zeros à esquerda 
        * a variável  <i> passa a ser a localização do primeiro caractere após os zeros e 
        * val2 contém os caracteres (descontando os zeros à esquerda)
        */

        for (var i = 0; i < len; i++)
            if ((valor.charAt(i) != '0') && (valor.charAt(i) != ',')) break;

        for (; i < len; i++) {
            if (strCheck.indexOf(valor.charAt(i)) != -1) val2 += valor.charAt(i);
        }
        len = val2.length;
        if (len == 0) { return returnprefix + '0'.repeat(p); }

        if (len <= p) {
            return returnprefix + '0'.repeat(p - len) + val2;
        }

        var parte1 = val2.substring(0, val2.length - p);
        var parte2 = val2.substring(val2.length - p);
        var returnvalue = parte1 + "." + parte2;
        return returnvalue;

    }
    else {
        /* currency é false: retornamos os valores COM os zeros à esquerda, 
        * sem considerar os últimos 2 algarismos como casas decimais 
        */
        val3 = "";
        for (var k = 0; k < len; k++) {
            if (strCheck.indexOf(valor.charAt(k)) != -1) val3 += valor.charAt(k);
        }
        return val3;
    }
}

function backspace(obj, event) {
    /*
    Essa função basicamente altera o  backspace nos input com máscara reais para os navegadores IE e opera.
    O IE não detecta o keycode 8 no evento keypress, por isso, tratamos no keydown.
    Como o opera suporta o infame document.all, tratamos dele na mesma parte do código.
    */

    var whichCode = (window.Event) ? event.which : event.keyCode;
    if (whichCode == 8 && documentall) {
        var valor = obj.value;
        var x = valor.substring(0, valor.length - 1);
        var y = demaskvalue(x, true, 2).formatCurrency(2);

        obj.value = ""; //necessário para o opera
        obj.value += y;

        if (event.preventDefault) { //standart browsers
            event.preventDefault();
        } else { // internet explorer
            event.returnValue = false;
        }
        return false;

    } // end if		
} // end backspace

function FormataReais(fld, milSep, decSep, e, p) {
    var sep = 0;
    var key = '';
    var i = j = 0;
    var len = len2 = 0;
    var strCheck = '0123456789';
    var aux = aux2 = '';
    var whichCode = e.which || e.keyCode;

    if (whichCode == 0) return true;
    if (whichCode == 9) return true; //tecla tab
    if (whichCode == 13) return true; //tecla enter
    if (whichCode == 16) return true; //shift internet explorer
    if (whichCode == 17) return true; //control no internet explorer
    if (whichCode == 27) return true; //tecla esc
    if (whichCode == 34) return true; //tecla end
    if (whichCode == 35) return true; //tecla end
    if (whichCode == 36) return true; //tecla home
    if (whichCode == 8) return true; // Backspace
    if (whichCode == 46) return true; // Delete

    /*
    O trecho abaixo previne a ação padrão nos navegadores. Não estamos inserindo o caractere normalmente, mas via script
    */

    if (e.preventDefault) { //standart browsers
        e.preventDefault()
    } else { // internet explorer
        e.returnValue = false
    }

    var key = String.fromCharCode(whichCode);  // Valor para o código da Chave
    if (strCheck.indexOf(key) == -1) return false;  // Chave inválida

    /*
    Concatenamos ao value o keycode de key, se esse for um número
    */
    fld.value += key;

    var len = fld.value.length;
    var bodeaux = demaskvalue(fld.value, true, p).formatCurrency(p);
    fld.value = bodeaux;

    /*
    Essa parte da função tão somente move o cursor para o final no opera. Atualmente não existe como movê-lo no konqueror.
    */
    if (fld.createTextRange) {
        var range = fld.createTextRange();
        range.collapse(false);
        range.select();
    }
    else if (fld.setSelectionRange) {
        fld.focus();
        var length = fld.value.length;
        fld.setSelectionRange(length, length);
    }
    return false;

}
//*--------------------------------------------------------------------------------------*

//*--------------------------- Formatação de Monetários US$ ---------------------------------*

function MaskCurrencyEN(obj, e, p) {
    if (p == undefined) p = 2;
    var boolret = true;
    var intKeyCode = e.keyCode || e.which;
    if (parseInt(intKeyCode) != 13 &&
        parseInt(intKeyCode) != 8 && // Backspace
        parseInt(intKeyCode) != 9 && // Tab
        parseInt(intKeyCode) != 46 && // Delete
        parseInt(intKeyCode) != 37 && // Seta esquerda
        parseInt(intKeyCode) != 38 && // Seta para cima
        parseInt(intKeyCode) != 39 && // Seta direita
        parseInt(intKeyCode) != 40) { // Seta para baixo
        if ((parseInt(intKeyCode) < 48) || (parseInt(intKeyCode) > 57)) {
            boolret = false;
        }
    }

    if (boolret == true) {
        var whichCode = intKeyCode;
        /*
        Executa a formatação após o backspace nos navegadores !document.all
        */
        if (whichCode == 8) {
            /*
            Previne a ação padrão nos navegadores
            */
            if (e.preventDefault) { //standart browsers
                e.preventDefault();
            } else { // internet explorer
                e.returnValue = false;
            }
            var valor = obj.value;
            var x = valor.substring(0, valor.length - 1);
            obj.value = demaskvalueEN(x, true,p).formatCurrencyEN(p);
            return false;
        }
        FormataDolar(obj, '.', ',', e, p);
    }
    else {
        return false;
    }
} // end MaskCurrencyEN

function formatamoneyEN(c) {
    var t = this;
    if (c == undefined) c = 2;
    var p, d = (t = t.split(","))[1].substr(0, c);
    for (p = (t = t[0]).length; (p -= 3) >= 1;) {
        t = t.substr(0, p) + "," + t.substr(p);
    }
    return t + "." + d + Array(c + 1 - d.length).join(0);
}

String.prototype.formatCurrencyEN = formatamoneyEN

function demaskvalueEN(valor, currency,p) {
    /*
    * Se currency é false, retorna o valor sem apenas com os números. Se é true, os dois últimos caracteres são considerados as 
    * casas decimais
    */
    var val2 = '';
    var strCheck = '0123456789';
    var len = valor.length;
    var returnprefix = '0.';

    if (len == 0) { return returnprefix + '0'.repeat(p); }

    if (currency == true) {
        /* Elimina os zeros à esquerda 
        * a variável  <i> passa a ser a localização do primeiro caractere após os zeros e 
        * val2 contém os caracteres (descontando os zeros à esquerda)
        */

        for (var i = 0; i < len; i++)
            if ((valor.charAt(i) != '0') && (valor.charAt(i) != ',')) break;

        for (; i < len; i++) {
            if (strCheck.indexOf(valor.charAt(i)) != -1) val2 += valor.charAt(i);
        }

        len = val2.length;
        if (len == 0) { return returnprefix + '0'.repeat(p); }

        if (len <= p) {
            return returnprefix + '0'.repeat(p - len) + val2;
        }
        var parte1 = val2.substring(0, val2.length - p);
        var parte2 = val2.substring(val2.length - p);
        var returnvalue = parte1 + "," + parte2;
        return returnvalue;
    }
    else {
        /* currency é false: retornamos os valores COM os zeros à esquerda, 
        * sem considerar os últimos 2 algarismos como casas decimais 
        */
        val3 = "";
        for (var k = 0; k < len; k++) {
            if (strCheck.indexOf(valor.charAt(k)) != -1) val3 += valor.charAt(k);
        }
        return val3;
    }
}

function FormataDolar(fld, milSep, decSep, e, p) {
    var sep = 0;
    var key = '';
    var i = j = 0;
    var len = len2 = 0;
    var strCheck = '0123456789';
    var aux = aux2 = '';
    var whichCode = e.keyCode || e.which;

    if (whichCode == 0) return true;
    if (whichCode == 9) return true; //tecla tab
    if (whichCode == 13) return true; //tecla enter
    if (whichCode == 16) return true; //shift internet explorer
    if (whichCode == 17) return true; //control no internet explorer
    if (whichCode == 27) return true; //tecla esc
    if (whichCode == 34) return true; //tecla end
    if (whichCode == 35) return true; //tecla end
    if (whichCode == 36) return true; //tecla home
    if (whichCode == 8) return true; // Backspace
    if (whichCode == 46) return true; // Delete

    /*
    O trecho abaixo previne a ação padrão nos navegadores. Não estamos inserindo o caractere normalmente, mas via script
    */

    if (e.preventDefault) { //standart browsers
        e.preventDefault()
    } else { // internet explorer
        e.returnValue = false
    }

    var key = String.fromCharCode(whichCode);  // Valor para o código da Chave
    if (strCheck.indexOf(key) == -1) return false;  // Chave inválida

    /*
    Concatenamos ao value o keycode de key, se esse for um número
    */
    fld.value += key;

    var len = fld.value.length;
    var bodeaux = demaskvalueEN(fld.value, true, p).formatCurrencyEN(p);
    fld.value = bodeaux;

    /*
    Essa parte da função tão somente move o cursor para o final no opera. Atualmente não existe como movê-lo no konqueror.
    */
    if (fld.createTextRange) {
        var range = fld.createTextRange();
        range.collapse(false);
        range.select();
    }
    else if (fld.setSelectionRange) {
        fld.focus();
        var length = fld.value.length;
        fld.setSelectionRange(length, length);
    }
    return false;

}
//*--------------------------------------------------------------------------------------*