<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="PageToolbar.ascx.vb" Inherits="WebFoundations.WFPortal.UI.PageToolbar" %>
<script type="text/javascript" language="javascript">
    (function ($) {
        var handleDrag = function (target, handle) {
            handle = handle || target;

            var start = null;
            var origin = null;

            function delta(ev) {
                return { x: ~~(ev.clientX - start.x), y: ~~(ev.clientY - start.y) };
            }

            var mydown = function (ev) {
                var evtarget = ev.target || ev.srcElement;
                if (handle == evtarget || target == evtarget) {

                    if (document.addEventListener) {
                        document.addEventListener("mouseup", myup, true);
                        document.addEventListener("mousemove", mymove, true);
                    } else {
                        handle.setCapture(true);
                    }

                    start = { x: ev.clientX, y: ev.clientY };
                    origin = target.getBoundingClientRect();

                    if (ev.preventDefault) ev.preventDefault();
                    if (ev.stopPropagation) ev.stopPropagation();
                    if (ev.stopImmediatePropagation) ev.stopImmediatePropagation();
                    ev.returnValue = false;
                    return false;
                }
            };
            var myup = function (ev) {
                if (start) {
                    start = null;
                    if (document.removeEventListener) {
                        document.removeEventListener("mouseup", myup, true);
                        document.removeEventListener("mousemove", mymove, true);
                    } else {
                        handle.releaseCapture();
                    }
                    if (ev.preventDefault) ev.preventDefault();
                    if (ev.stopPropagation) ev.stopPropagation();
                    if (ev.stopImmediatePropagation) ev.stopImmediatePropagation();
                    ev.returnValue = false;
                    return false;
                }
            };
            var mymove = function (ev) {
                if (start) {
                    var d = delta(ev);
                    var p = { x: Math.max(0, ~~(origin.left + d.x)), y: Math.max(0, ~~(origin.top + d.y)) };

                    target.style.top = p.y + "px";
                    target.style.left = p.x + "px";

                    if (ev.preventDefault) ev.preventDefault();
                    if (ev.stopPropagation) ev.stopPropagation();
                    if (ev.stopImmediatePropagation) ev.stopImmediatePropagation();
                    ev.returnValue = false;
                    return false;
                }
            };

            if (handle) {
                if (handle.addEventListener) {
                    handle.addEventListener("mousedown", mydown, false);
                } else {
                    handle.attachEvent("onmousedown", mydown);
                    handle.attachEvent("onmouseup", myup);
                    handle.attachEvent("onmousemove", mymove);
                }
            }
        };

        //''script para corrigir problema de dropdowns desabilitados pela RadWindow acima do IE8
        //''http://www.telerik.com/forums/radwindow-is-disabling-dropdowns-on-parent-page-after-popup-is-closed-ie-8-only
        var fixRadWindowsClose = function () {
            try {
                if (RadWindowNamespace && RadWindowNamespace.RadWindowModal) {
                    RadWindowNamespace.RadWindowModal.prototype.RestoreInputElementsState = function () {
                        if (this.Window.IsIE) {
                            this.DisabledDrodpowns = false;
                            for (var i = 0; i < this.InputElementsState.length; i++) {
                                var _o = this.InputElementsState[i];
                                if (_o.isEnabled) {
                                    _o.inputElement.removeAttribute("disabled");
                                }
                            }
                        }
                    }
                    RadWindowNamespace.RadWindowModal.prototype.DisableInputElements = function () {
                        if (this.Window.IsIE && !this.DisabledDrodpowns) {
                            this.InputElementsState = [];
                            var lists = document.getElementsByTagName("SELECT");
                            for (var i = 0; i < lists.length; i++) {
                                this.InputElementsState[i] = {
                                    inputElement: lists[i],
                                    isEnabled: !(lists[i].getAttribute("disabled"))
                                };

                                lists[i].setAttribute("disabled", "disabled");
                            }
                            this.DisabledDrodpowns = true;
                        }
                    }
                }
            } catch (error) { }
        };

        var loadFunction = function () {
            fixRadWindowsClose();
            handleDrag(document.getElementById("wftoolbar"), document.getElementById("wftoolbar-mover"));
            window.focus();
        };


        if ($) {
            $(document).ready(function () {
                loadFunction();
                try {
                    $(document.body).addClass("wf-edit-mode");
                } catch (error) { }
            });
        } else {
            if (document.addEventListener) {
                document.addEventListener("DOMContentLoaded", loadFunction, false);
            }
        }
        setTimeout(function () {
            $('[name="WFPageBanner$CTWFPageBanner$WFPageToolBar$CTWFPageToolBar$btninsert"]').removeAttr('onclick');
            $('[name="WFPageBanner$CTWFPageBanner$WFPageToolBar$CTWFPageToolBar$btninsert"]').attr('onclick', "__doPostBack('WFPageBanner$CTWFPageBanner$WFPageToolBar$CTWFPageToolBar$btninsert','')")

            $('[name="WFPageBanner$CTWFPageBanner$WFPageToolBar$CTWFPageToolBar$btnpublish"]').removeAttr('onclick');
            $('[name="WFPageBanner$CTWFPageBanner$WFPageToolBar$CTWFPageToolBar$btnpublish"]').attr('onclick', "__doPostBack('WFPageBanner$CTWFPageBanner$WFPageToolBar$CTWFPageToolBar$btnpublish','')")
        },500)      

    })(jQuery);
</script>
<style type="text/css">
    .wftoolbox, .wftoolbox * {
        -moz-box-sizing: border-box !important;
        -webkit-box-sizing: border-box !important;
        box-sizing: border-box !important;
    }

    .wftoolbox {
        position: fixed !important;
        z-index: 100000;
        font-family: 'Segoe UI', Verdana, Geneva, 'DejaVu Sans', sans-serif !important;
        font-size: 13px !important;
        color: #444 !important;
        border: solid 1px #a9a9a9 !important;
        background-color: rgb(230,230,220) !important;
        background-color: rgba(230,230,220,.90) !important;
        left: .5em;
        top: .5em;
        min-width: 312px !important;
        min-width: 24em !important;
        padding-bottom: 1em !important;
        box-shadow: 0 0 1em #888;
    }

    .wftoolbox h2 {
        color: inherit !important;
        padding: .2em .7em !important;
        background-color: rgb(158,158,158);
        background-color: rgba(50,50,50,.30);
        cursor: move !important;
    }

    .wftoolbox input[type=button], .wftoolbox input[type=submit], .wftoolbox input[type=reset], .wftoolbox button {
        text-transform: lowercase;
        min-width: 7em !important;
        background-color: #444 !important;
        color: #fff !important;
        border: none !important;
        padding: .3em .6em !important;
    }

    .wftoolbox .mod input[type=button], 
    .wftoolbox .mod input[type=submit], 
    .wftoolbox .mod input[type=reset], 
    .wftoolbox .mod button{
        width:calc(50% - .2em) !important;
    }

    .wftoolbox .pag input[type=button], 
    .wftoolbox .pag input[type=submit], 
    .wftoolbox .pag input[type=reset], 
    .wftoolbox .pag button{
        width:calc(33.3% - .2em) !important;
    }

    .wftoolbox .mod input[type=submit].fullsize{
        width:100% !important;
    }

    .wftoolbox fieldset {
        padding: .3em 1em !important;
        border: none !important;
        color:inherit !important;
        /*-moz-user-select: none;
        -ms-user-select: none;
        -webkit-user-select: none;
        user-select: none;*/
    }

    .wftoolbox legend {
        font-size: 1.2em !important;
        font-style: italic !important;
        color:#444 !important;
    }

    .wftoolbox fieldset > label {
        display: block !important;
        margin-bottom: 5px !important;
    }

    .wftoolbox label > span:first-child {
        display: inline-block !important;
        min-width: 6em !important;
    }

    .wftoolbox input + label {
        margin-top: 1em !important;
    }

    .wftoolbox label input, .Toolbox label select {
        min-width: 15em !important;
    }

    /*fix para o radwindow abrir corretamente no IE*/
    tr.RadWTitleRow, tr.RadWTitleRow ~ tr {
        height: auto;
    }

    input[type=checkbox] + label.wftoolbarmin{
        position:absolute;
        top:5px;
        right:5px;
        display:block;
        padding:0 !important;
        margin:0 !important;
        width:1.5rem !important;
        height:1.5rem !important;
        text-align:center !important;
        font-weight:600;
        background:#444 !important;
        color:#fff !important;
        cursor:pointer !important;
    }

    label.wftoolbarmin:after{
        content:"-";
        vertical-align:middle;
    }

    #wftoolbarmin{
        display:none !important;
    }

    #wftoolbarmin:checked + label.wftoolbarmin:after{
        content:"+";
    }

    #wftoolbarmin:checked ~ fieldset{
        display:none;
    } 
</style>
<asp:Panel ID="pnlconfig" runat="server">
    <div id="wftoolbar" class="wftoolbox">
        <h2 id="wftoolbar-mover"><asp:Label ID="lbltoolbartitle" runat="server" /></h2>
        <input type="checkbox" id="wftoolbarmin" />
        <label class="wftoolbarmin" for="wftoolbarmin" title="minimizar/maximizar"></label>
        <fieldset class="mod">
            <legend>Mdulos</legend>
            <input id="btnexpand" type="button" runat="server" namekey="expand" />
            <input id="btncollapse" type="button" runat="server" namekey="collapse" />

            <label><asp:Label ID="lblmodule" runat="server" namekey="msgmodule" /><asp:DropDownList ID="lstmodules" runat="server" /></label>
            <label><asp:Label ID="lblarea" runat="server" namekey="area" /><asp:DropDownList ID="lstareas" runat="server" /></label>
            <asp:PlaceHolder ID="phcontainer" runat="server">
            <label><asp:Label ID="lblcontainer" runat="server" namekey="container" /><asp:DropDownList ID="lstcontainers" runat="server" /></label>
            </asp:PlaceHolder>
            <label><asp:Label ID="lbltitle" runat="server" namekey="title" /><asp:TextBox ID="txttitle" runat="server" MaxLength="100" /></label>
            <label><asp:Label ID="lbldates" runat="server" namekey="datevariation" /><asp:DropDownList ID="lstdates" runat="server" /></label>
            <asp:Button ID="btninsert" runat="server" namekey="insert" CssClass="fullsize" />
        </fieldset>
        <fieldset class="pag">
            <legend>Pgina</legend>
            <input id="btnbrowse" type="button" runat="server" namekey="browse" />
            <input id="btntest" type="button" runat="server" namekey="test" />
            <asp:Button ID="btnpublish" runat="server" namekey="publish" />
        </fieldset>
    </div>
</asp:Panel>

<asp:Panel ID="pnlapprove" runat="server">
    <div id="wftoolbar" class="wftoolbox">
        <h2 id="wftoolbar-mover"><asp:Label ID="lblapprovetitle" runat="server" /></h2>
        <fieldset>
            <asp:Button ID="btnapprove" runat="server" namekey="approve" />
            <input id="btnreport" type="button" runat="server" namekey="approvalreport" />
        </fieldset>
    </div>
</asp:Panel>
