﻿<%@ Page Language="vb" AutoEventWireup="false" CodeBehind="roottemplate.aspx.vb" Inherits="WebFoundations.WFPortal.UI.roottemplate" EnableSessionState="True" %>

<%@ Register Assembly="WebFoundations.WFPortal.Controls" Namespace="WebFoundations.WFPortal.Controls.Content" TagPrefix="WFC" %>
<%@ Register Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" TagPrefix="WFF" %>
<%@ Register Src="~/WFContent/Templates/Tutorial.ascx" TagPrefix="uc1" TagName="Tutorial" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>


<!DOCTYPE html>
<html>
<head runat="server">
    <meta http-equiv="X-UA-Compatible" content="IE=Edge" />
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="format-detection" content="telephone=no">

    <script src="/%%PORTAL%%theme/html5" type="text/javascript"></script>
    <link href="/%%PORTAL%%theme/styles" rel="stylesheet" type="text/css" />

    <link rel="shortcut icon" href="/favicon.ico?v=2" type="image/x-icon" />
    <script src="/%%PORTAL%%theme/scripts"></script>
    <uc1:tutorial runat="server" id="Tutorial" />
</head>
<body>
    <form runat="server">
        <asp:ScriptManager runat="server" />
        <wfc:manager runat="server" />

        <wfc:pagebanner id="WFPageBanner" runat="server" />

        <header>
            <a href="/" title="Home" class="logo">
                <h1><%:WebFoundations.WFPortal.Management.Settings.AppSettings.SiteTitle%></h1>
            </a>
            <aside>
                <wfc:headerfooter runat="server" alias="header" />
            </aside>
            <nav>
                <wff:menu menualias="public" runat="server" nosurroundingdiv="true" />
            </nav>
        </header>

        <main>
            <div class="wfrepo wfrepo-top">
                <wfc:repository id="Top" runat="server" width="100%" />
            </div>
            <div class="wfrepo wfrepo-left">
                <wfc:repository id="Left" runat="server" width="100%" />
            </div>
            <div class="wfrepo wfrepo-main">
                <wfc:repository id="Main" runat="server" width="100%" />
            </div>
            <div class="wfrepo wfrepo-bottom">
                <wfc:repository id="Bottom" runat="server" width="100%" />
            </div>
        </main>

        <footer>
            <wfc:headerfooter runat="server" alias="footer" />
            <a class="mobile-version" runat="server" href="~/mobile/">Zuri Mobile</a>
            <telerik:radwindow id="BaseWindow" cssclass="zuri-window" runat="server" />
        </footer>
    </form>
</body>
</html>
