﻿<%@ Page Language="vb" AutoEventWireup="false" CodeBehind="WFMarker.aspx.vb" Inherits="WebFoundations.WFWorkflow.UI.WFMarker1" %>

<%@ Register Assembly="WebFoundations.WFPortal.Controls" Namespace="WebFoundations.WFPortal.Controls.Content" TagPrefix="WFC" %>
<%@ Register Assembly="WebFoundations.WFWorkflow.UI" Namespace="WebFoundations.WFWorkflow.UI" TagPrefix="WFF" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register Src="~/WFAdmin/TagHeadAdmin.ascx" TagPrefix="wf" TagName="TagHeadAdmin" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <wf:TagHeadAdmin runat="server" />
    <style>
        .rcbImage {
            width: 20px !important;
        }

        .acstyle {
            width: 23em !important;
            vertical-align: top !important;
        }

        .racTokenList {
            min-height: 34px;
            overflow: auto !important;
        }

        .racInput {
            width: auto !important;
            min-width: 40%;
            width: 10px;
        }
    </style>
</head>
<body class="wf-admin-modal">
    <form id="form1" runat="server">
        <asp:ScriptManager ID="ScriptManager1" runat="server" />
        <WFC:EditorManager ID="EditorManager1" runat="server" />
        <div style="width: 100%;">
            <telerik:RadTabStrip runat="server" RenderMode="Lightweight" Width="100%" ID="configTab" Orientation="HorizontalTop" SelectedIndex="0" MultiPageID="configPages">
                <Tabs>
                    <telerik:RadTab Text="Configurações" />
                    <telerik:RadTab Text="Campos" />
                    <telerik:RadTab Text="Filtros" />
                    <telerik:RadTab Text="Agrupamento" />
                    <telerik:RadTab Text="Listagem" />
                    <telerik:RadTab Text="Compartilhamento de Dados" />
                </Tabs>
            </telerik:RadTabStrip>
            <telerik:RadMultiPage runat="server" ID="configPages" SelectedIndex="0" CssClass="multiPage">
                <telerik:RadPageView runat="server" ID="configPage">
                    <div class="fields no-columns">
                        <div>
                            <asp:Label ID="lblProcesso" runat="server" />
                            <div style="margin-bottom: 5px;">
                                <asp:DropDownList ID="ddlProcesso" Width="90%" runat="server" />
                                <span style="width: 5%; text-align: center; margin-left: 10px;">
                                    <asp:LinkButton ID="btnAdd" CssClass="add-item" Width="20px" runat="server">&nbsp;</asp:LinkButton></span>
                            </div>
                        </div>
                        <div>
                            <asp:Label ID="lblProcessos" runat="server"></asp:Label>
                            <asp:Repeater ID="rptProcessos" runat="server">
                                <AlternatingItemTemplate>
                                    <asp:HiddenField ID="hidProcId" runat="server" />
                                    <div>
                                        <asp:Label ID="lblProcName" runat="server"></asp:Label>
                                        <asp:ImageButton ID="removeProc" ImageUrl="~/WFResources/Common/Images/Icons/delete.png" runat="server" />
                                    </div>
                                </AlternatingItemTemplate>
                                <ItemTemplate>
                                    <asp:HiddenField ID="hidProcId" runat="server" />
                                    <div>
                                        <asp:Label ID="lblProcName" runat="server"></asp:Label>
                                        <asp:ImageButton ID="removeProc" ImageUrl="~/WFResources/Common/Images/Icons/delete.png" runat="server" />
                                    </div>
                                </ItemTemplate>
                            </asp:Repeater>
                        </div>
                        <label>
                            <asp:Label ID="lblExport" runat="server"></asp:Label>
                            <asp:FileUpload ID="importFile" Width="100%" runat="server" /><asp:Button ID="btnImport" runat="server" />
                        </label>
                        <asp:UpdatePanel ID="pnlExecute" class="fill-width" runat="server" UpdateMode="Conditional">
                            <ContentTemplate>
                                <div>
                                    <asp:Button ID="btnExport" Visible="false" runat="server" />

                                </div>
                                <div>
                                    <asp:Button ID="btnForceUpdate" Visible="false" runat="server" />
                                </div>
                            </ContentTemplate>

                        </asp:UpdatePanel>

                    </div>
                </telerik:RadPageView>
                <telerik:RadPageView runat="server" ID="fieldsPage">
                    <div class="fields no-columns">
                        <div>
                            <asp:Label ID="lblCampo" runat="server" />
                            <div style="margin-bottom: 5px;">
                                <telerik:RadComboBox ID="lstCampos" Width="90%" runat="server" />
                                <span style="width: 5%; text-align: center; margin-left: 10px;">
                                    <asp:LinkButton ID="btnAddCampo" CssClass="add-item" Width="20px" runat="server">&nbsp;</asp:LinkButton></span>
                            </div>
                        </div>
                        <label>
                            <asp:Label ID="lblCampos" runat="server" />
                            <telerik:RadGrid runat="server" ID="grdCampos" AllowPaging="False" AllowMultiRowSelection="true" Width="100%">
                                <MasterTableView>
                                    <Columns>
                                        <telerik:GridDragDropColumn HeaderStyle-Width="2%" Visible="true" />
                                        <telerik:GridTemplateColumn UniqueName="Principal">
                                            <ItemTemplate>
                                                <WFF:GroupRadioButton ID="btnMain" GroupName="MainMarker" runat="server" />
                                            </ItemTemplate>
                                        </telerik:GridTemplateColumn>
                                        <telerik:GridTemplateColumn HeaderStyle-Width="25%" HeaderText="Campo" UniqueName="NOMECAMPO">
                                            <ItemTemplate>
                                                <asp:HiddenField ID="identificador" runat="server" />
                                                <asp:Image ID="imgCampo" Style="width: 20px;" runat="server" />
                                                <asp:Label ID="lblCampo" runat="server" />
                                            </ItemTemplate>
                                        </telerik:GridTemplateColumn>
                                        <telerik:GridTemplateColumn HeaderStyle-Width="5%" HeaderText="Mostrar" UniqueName="MOSTRAR">
                                            <ItemTemplate>
                                                <asp:CheckBox ID="chkMostrar" runat="server" />
                                            </ItemTemplate>
                                        </telerik:GridTemplateColumn>
                                        <telerik:GridTemplateColumn HeaderStyle-Width="5%" HeaderText="Unico" UniqueName="UNICO">
                                            <ItemTemplate>
                                                <asp:CheckBox ID="chkUnico" runat="server" />
                                            </ItemTemplate>
                                        </telerik:GridTemplateColumn>
                                        <telerik:GridTemplateColumn HeaderStyle-Width="15%" HeaderText="Titulo" UniqueName="TITULOCAMPO">
                                            <ItemTemplate>
                                                <asp:TextBox ID="txtTitulo" Width="99%" runat="server"></asp:TextBox>
                                            </ItemTemplate>
                                        </telerik:GridTemplateColumn>
                                        <telerik:GridTemplateColumn HeaderStyle-Width="15%" HeaderText="ToolTip" UniqueName="TOOLTIP">
                                            <ItemTemplate>
                                                <asp:TextBox ID="txtTooltip" Width="99%" runat="server"></asp:TextBox>
                                            </ItemTemplate>
                                        </telerik:GridTemplateColumn>
                                        <telerik:GridTemplateColumn HeaderStyle-Width="15%" HeaderText="Busca" UniqueName="BUSCA">
                                            <ItemTemplate>
                                                <asp:DropDownList ID="ddlBusca" Width="100%" runat="server"></asp:DropDownList>
                                            </ItemTemplate>
                                        </telerik:GridTemplateColumn>
                                        <telerik:GridTemplateColumn HeaderStyle-Width="15%" HeaderText="Formato" UniqueName="FORMATO">
                                            <ItemTemplate>
                                                <asp:DropDownList ID="ddlFormato" Width="100%" runat="server"></asp:DropDownList>
                                            </ItemTemplate>
                                        </telerik:GridTemplateColumn>
                                        <telerik:GridTemplateColumn HeaderStyle-Width="3%" HeaderText="" UniqueName="EXCLUIR">
                                            <ItemTemplate>
                                                <asp:ImageButton ID="removeCampo" ImageUrl="~/WFResources/Common/Images/Icons/delete.png" runat="server" />
                                            </ItemTemplate>
                                        </telerik:GridTemplateColumn>
                                    </Columns>
                                </MasterTableView>
                                <ClientSettings AllowRowsDragDrop="True" AllowColumnsReorder="false" ReorderColumnsOnClient="false">
                                    <Selecting AllowRowSelect="True" EnableDragToSelectRows="false" />
                                    <Scrolling AllowScroll="false" />
                                </ClientSettings>
                            </telerik:RadGrid>
                        </label>
                    </div>
                </telerik:RadPageView>
                <telerik:RadPageView runat="server" ID="filterPage">
                    <asp:UpdatePanel ID="pnlFilters" runat="server">
                        <ContentTemplate>
                            <div class="fields no-columns">
                                <label>
                                    <asp:Label ID="lblFilter" runat="server" />
                                    <div>
                                        <asp:DropDownList ID="ddlFilters" AutoPostBack="True" runat="server" />
                                        <asp:DropDownList ID="ddlOperacao" AutoPostBack="True" runat="server" />
                                        <asp:TextBox ID="txtOperador1" CssClass="txt-txt" runat="server" />
                                        <asp:Label ID="lblConect" runat="server" />
                                        <asp:TextBox ID="txtOperador2" CssClass="txt-txt" runat="server" />
                                        <telerik:RadAutoCompleteBox runat="server" ID="itemsList" DataTextField="Text" DataValueField="Value" AllowCustomEntry="True" MinFilterLength="200" CssClass="acstyle" />
                                        <span style="width: 5%; text-align: center; margin-left: 10px;">
                                            <asp:LinkButton ID="lnkAddFilter" CssClass="add-item" Width="20px" runat="server">&nbsp;</asp:LinkButton></span>
                                    </div>
                                </label>
                                <label>
                                    <asp:Label ID="lblFilters" CssClass="txt-label" runat="server"></asp:Label>
                                    <asp:Repeater ID="rptFilters" runat="server">
                                        <HeaderTemplate>
                                            <table border="0" width="100%" cellpadding="0" cellspacing="0">
                                        </HeaderTemplate>
                                        <AlternatingItemTemplate>
                                            <tr class="item-lista2">
                                                <td>
                                                    <asp:HiddenField ID="Identificador" runat="server" />
                                                    <asp:Label ID="lblFieldName" runat="server" />
                                                </td>
                                                <td>
                                                    <asp:Label ID="lblOperador" runat="server" /></td>
                                                <td>
                                                    <asp:Label ID="lblDescricao" runat="server" /></td>
                                                <td>
                                                    <asp:ImageButton ID="removeFiltro" ImageUrl="~/WFResources/Common/Images/Icons/delete.png" runat="server" /></td>
                                            </tr>
                                        </AlternatingItemTemplate>
                                        <ItemTemplate>
                                            <tr class="item-lista">
                                                <td>
                                                    <asp:HiddenField ID="Identificador" runat="server" />
                                                    <asp:Label ID="lblFieldName" runat="server" />
                                                </td>
                                                <td>
                                                    <asp:Label ID="lblOperador" runat="server" /></td>
                                                <td>
                                                    <asp:Label ID="lblDescricao" runat="server" /></td>
                                                <td>
                                                    <asp:ImageButton ID="removeFiltro" ImageUrl="~/WFResources/Common/Images/Icons/delete.png" runat="server" /></td>
                                            </tr>
                                        </ItemTemplate>
                                        <FooterTemplate></table></FooterTemplate>
                                    </asp:Repeater>
                                </label>
                            </div>
                        </ContentTemplate>
                    </asp:UpdatePanel>
                </telerik:RadPageView>
                <telerik:RadPageView runat="server" ID="groupPage">
                    <asp:UpdatePanel ID="pnlAgrupamento" runat="server">
                        <ContentTemplate>
                            <div class="fields no-columns">
                                <label>
                                    <asp:Label ID="lblGroupShow" runat="server" />
                                    <asp:DropDownList ID="ddlGroupShow" runat="server" CausesValidation="false" AutoPostBack="True" />
                                </label>
                                <label>
                                    <asp:Label ID="lblAgrupamento" runat="server" />
                                    <asp:DropDownList ID="ddlAgrupamento" CausesValidation="false" AutoPostBack="True" runat="server" />
                                </label>
                                <label>
                                    <asp:Label ID="lblTipoAgrupamento" runat="server" />
                                    <asp:DropDownList ID="ddlTipoAgrupamento" runat="server" CausesValidation="false" AutoPostBack="True" />
                                </label>
                                <asp:Panel ID="pnlValAgrupa" runat="server">
                                    <asp:Label ID="lblValoresAgrupamento" runat="server" />
                                    <asp:DropDownList ID="ddlValoresAgrupamento" runat="server" />
                                </asp:Panel>
                                <label>
                                    <asp:CheckBox ID="chkMostrarTabela" runat="server" />
                                </label>
                                <label>
                                    <asp:CheckBox ID="chkAddTotal" Text="Adicionar Totais" runat="server" />
                                </label>
                                <label>
                                    <asp:CheckBox ID="chkAddPct" runat="server" />
                                </label>
                                <label>
                                    <asp:CheckBox ID="chkBindOnLoad" Text="Listar ao carregar" runat="server" />
                                </label>
                                <label>
                                    <asp:Label ID="lblGrafico" runat="server" />
                                    <asp:DropDownList ID="ddlTipoGrafico" runat="server" CausesValidation="false" AutoPostBack="True" />
                                </label>
                                <asp:Panel ID="pnlGraph" runat="server">
                                    <label>
                                        <asp:CheckBox ID="chktitle" runat="server" />
                                    </label>
                                    <label>
                                        <asp:Label ID="lblGraphWidth" runat="server" />
                                        <asp:TextBox ID="txtGraphWidth" MaxLength="4" runat="server" />
                                        <asp:RegularExpressionValidator ID="vlWidth" runat="server" ControlToValidate="txtGraphWidth"
                                            Display="Dynamic" ValidationExpression="\d*" />
                                    </label>
                                    <label>
                                        <asp:Label ID="lblGraphHeight" runat="server" />
                                        <asp:TextBox ID="txtGraphHeight" MaxLength="4" runat="server" />
                                        <asp:RegularExpressionValidator ID="vlHeight" runat="server" ControlToValidate="txtGraphHeight"
                                            Display="Dynamic" ValidationExpression="\d*" />
                                    </label>
                                </asp:Panel>
                            </div>
                        </ContentTemplate>
                    </asp:UpdatePanel>
                </telerik:RadPageView>
                <telerik:RadPageView runat="server" ID="listPage">
                    <div class="fields no-columns">
                        <label>
                            <asp:Label ID="lblListagem" runat="server" />
                            <asp:DropDownList ID="ddlTipoListagem" CausesValidation="false" AutoPostBack="True" runat="server" />
                        </label>
                        <label>
                            <asp:CheckBox ID="chkBindListOnLoad" Text="Listar ao carregar" runat="server" />
                        </label>
                        <label>
                            <asp:CheckBox ID="chkAllowExport" Text="Permitir Exportação" runat="server" />
                        </label>
                        <label>
                            <asp:CheckBox ID="chkAllowSort" Text="Permitir Ordenação" runat="server" />
                        </label>
                        <label>
                            <asp:CheckBox ID="chkIncludeFinished" Text="Incluir itens finalizados" runat="server" />
                        </label>
                        <label>
                            <asp:CheckBox ID="chkExibirHistoricoItem" Text="Exibir histórico do item" runat="server" />
                        </label>
                        <label>
                            <asp:Label ID="lblSortField" runat="server"></asp:Label>
                            <asp:DropDownList ID="ddlSort" runat="server" />
                        </label>
                        <label>
                            <asp:CheckBox ID="chkDescending" runat="server" />
                        </label>
                        <label>
                            <asp:Label ID="lblPageSize" Text="Tamanho da página" runat="server" />
                            <asp:TextBox ID="txtPageSize" MaxLength="4" runat="server" />
                            <asp:RegularExpressionValidator ID="vlPageSize" runat="server" ControlToValidate="txtPageSize"
                                Display="Dynamic" ValidationExpression="\d*" />
                        </label>
                        <label>
                            <asp:Label ID="lblPopupType" Text="Configuração de abertura" runat="server" />
                            <asp:DropDownList ID="ddlPopUps" runat="server" />
                        </label>
                    </div>
                </telerik:RadPageView>
                <telerik:RadPageView runat="server" ID="dataPage">
                    <div class="fields no-columns">
                        <asp:Button ID="btnPasteLink" runat="server" Width="150" OnClick="btnCreateLink_Click" />
                        <br />
                        <label>
                            <asp:CheckBox ID="chkUseFieldTitles" runat="server" />
                        </label>
                        <br />
                        <asp:Label ID="lblCreatedLink" runat="server" />
                    </div>
                </telerik:RadPageView>
            </telerik:RadMultiPage>
            <section class="actions">
                <asp:Button ID="btnPrevious" runat="server" CssClass="b_nav" />
                <asp:Button ID="btnOK" runat="server" />
                <input id="btncancel" type="button" onclick="javascript: CancelEdit();" runat="server" />
                <asp:Button ID="btnNext" runat="server" CssClass="b_nav" />
            </section>
        </div>
    </form>
</body>
</html>
