﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="WFMarker.ascx.vb" Inherits="WebFoundations.WFWorkflow.UI.WFMarker" %>
<%@ Register Assembly="WebFoundations.ServerControls" Namespace="WebFoundations.ServerControls" TagPrefix="WFC" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register Src="~/WFContent/Modules/WFWorkflow/ItemProcesso/ZuriLoader.ascx" TagPrefix="uc1" TagName="ZuriLoader" %>
<%@ Register Src="~/WFContent/Modules/WFWorkflow/WFMarkerList.ascx" TagPrefix="uc1" TagName="WFMarkerList" %>

<section class="zuri-workspace contAreaTrabalho">
    <asp:UpdatePanel ID="pnlMarkers" runat="server" UpdateMode="Conditional">
        <ContentTemplate>
            <asp:Timer ID="refreshTimer" Interval="10000" Enabled="false" runat="server" />
            <asp:HiddenField ID="updValue" runat="server" />
            <asp:LinkButton ID="updateButton" runat="server" Style="display: none;" />
            <section id="pnlFiltros" class="wacont-Main" runat="server">
                <asp:Panel ID="pnlCntFiltros" DefaultButton="btnFiltrar" CssClass="wabusca-avancada" runat="server" Style="display: block;">
                    <fieldset>
                        <legend class="walegend">
                            <asp:Label ID="lblFiltros" CssClass="txt-buscar" runat="server" /></legend>
                        <div class="wabusca-avancadaTB row">
                            <asp:Repeater ID="rptFiltros" runat="server">
                                <ItemTemplate>
                                    <div id="flData" class="waFilter col-3 col-lg-4 col-md-6 col-xs-12" runat="server">
                                        <asp:HiddenField ID="hidIdentificador" runat="server" />
                                        <asp:Label ID="lblNomeFiltro" CssClass="labelItem" runat="server" />
                                        <div>
                                            <asp:TextBox ID="txtFiltroNome" Width="100%" runat="server" />
                                            <asp:DropDownList ID="ddlFiltro" Width="100%" runat="server" />
                                            <asp:CheckBox ID="chkFiltro" CssClass="busca-check01" runat="server" />
                                            <div class="datefield-container" runat="server" id="datefieldContainer">
                                                <div class="wadatefield">
                                                    <WFC:DatePicker ID="dateFrom" DisableLowerValuesFor="dateTo" ValidationGroup="Inbox" runat="server" />
                                                    <asp:TextBox ID="txtFiltro1" CssClass="busca-id wainput-text" runat="server" />
                                                    <asp:RegularExpressionValidator ID="vlFiltro1" runat="server" CssClass="validador" ControlToValidate="txtFiltro1" Display="Dynamic" ValidationExpression="\d*" />
                                                </div>
                                                <asp:Label ID="lblTo" CssClass="wainput-date-to labelItem" runat="server" />
                                                <div class="wadatefield">
                                                    <WFC:DatePicker ID="dateTo" ValidationGroup="Inbox" runat="server" />
                                                    <asp:TextBox ID="txtFiltro2" CssClass="busca-id wainput-text" runat="server" />
                                                    <asp:RegularExpressionValidator ID="vlFiltro2" runat="server" CssClass="validador" ControlToValidate="txtFiltro2" Display="Dynamic" ValidationExpression="\d*" />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </ItemTemplate>
                            </asp:Repeater>
                            <div class="col-3 col-lg-4  col-md-6 col-xs-12 d-flex align-end">
                                <asp:Button ID="btnFiltrar" runat="server" CssClass="wainput-submit search" />
                            </div>
                        </div>
                    </fieldset>
                </asp:Panel>
            </section>



            <asp:Panel ID="pnlTiles" CssClass="listGroup listSections" Style="width: 100%; display: inline-block;" runat="server">
                <asp:Repeater ID="rptTiles" runat="server">
                    <HeaderTemplate>
                        <ul class="panel">
                    </HeaderTemplate>
                    <FooterTemplate></ul></FooterTemplate>
                    <ItemTemplate>
                        <li id="itemTile" class="rectangle-tile" runat="server">
                            <asp:LinkButton ID="lnkFilter" OnClick="TileFilter_Click" runat="server">
                                <asp:HiddenField ID="hidItemIdentifier" runat="server" />
                                <asp:Label ID="lblItemName" runat="server" />
                                <asp:Label ID="lblWatermark" CssClass="watermark" runat="server" />
                            </asp:LinkButton></li>
                    </ItemTemplate>
                </asp:Repeater>
            </asp:Panel>
            <asp:Panel ID="pnlAgrupado" Style="width: 100%; display: flex; flex-direction: column; align-items: center;" runat="server">
                <center style="max-width: 100%;">
                    <div class="reportDate">
                        <asp:Label ID="lblReportDate" runat="server"></asp:Label>
                        <asp:Label ID="lblChartReportDate" runat="server"></asp:Label>
                    </div>
                    <div style="position: relative; vertical-align: middle;">
                        <div style="max-width: 100%; overflow-x: auto; overflow-y: hidden">
                            <telerik:RadHtmlChart runat="server" ID="chtAgrupado" Visible="false">
                                <ChartTitle>
                                    <Appearance Align="Center" Position="Top">
                                        <TextStyle Bold="true" FontFamily="Segoe UI,Verdana,Geneva,DejaVu Sans,sans-serif" Italic="false" Color="Black" Margin="5" Padding="5" />
                                    </Appearance>
                                </ChartTitle>
                                <PlotArea>
                                    <XAxis>
                                        <MinorGridLines Visible="false" />
                                        <MajorGridLines Visible="false" />
                                    </XAxis>
                                    <YAxis>
                                        <MinorGridLines Visible="false" />
                                    </YAxis>
                                </PlotArea>
                            </telerik:RadHtmlChart>
                        </div>
                        <asp:Repeater ID="rptAgrupado" runat="server">
                            <HeaderTemplate>
                                <div class="table-responsive">
                                    <table class="stripes report-legend">
                                        <thead>
                                            <tr>
                                                <th>
                                                    <asp:Label ID="lblCampo" runat="server" /></th>
                                                <th>
                                                    <asp:Label ID="lblValor" runat="server" /></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                            </HeaderTemplate>
                            <FooterTemplate>
                                <tr>
                                    <td>
                                        <asp:LinkButton ID="lnkCampo" runat="server" /></td>
                                    <td style="text-align: center;">
                                        <asp:LinkButton ID="lnkValor" runat="server" /></td>
                                </tr>
                                </tbody>
                                </div>
                            </table>
                            </FooterTemplate>
                            <ItemTemplate>
                                <tr>
                                    <td>
                                        <asp:LinkButton ID="lnkCampo" runat="server" /></td>
                                    <td style="text-align: center;">
                                        <asp:LinkButton ID="lnkValor" runat="server" /></td>
                                </tr>
                            </ItemTemplate>
                        </asp:Repeater>
                        <asp:LinkButton ID="lnkViewAll" runat="server" />
                    </div>
                </center>
            </asp:Panel>
            <asp:Label ID="lblNoItemsFound" CssClass="processing-report" Visible="false" runat="server" />
            <asp:Label ID="lblExecuting" CssClass="processing-report" Visible="false" runat="server" />
            <asp:Panel ID="pnlDetalhe" runat="server">
                <uc1:WFMarkerList runat="server" id="WFMarkerList" />
                <div style="text-align: center; margin-top: 1em;">
                    <asp:Button ID="btnVoltar" runat="server" />&nbsp;&nbsp;
                    <asp:Button ID="btnExport" runat="server" />&nbsp;&nbsp;
                    <asp:Button ID="btnExportCSV" runat="server" />
                </div>
            </asp:Panel>
        </ContentTemplate>
        <Triggers>
            <asp:PostBackTrigger ControlID="btnExport" />
            <asp:PostBackTrigger ControlID="btnExportCSV" />
        </Triggers>
    </asp:UpdatePanel>
</section>
<uc1:ZuriLoader runat="server" ID="ZuriLoader" />
<telerik:RadWindow RenderMode="Lightweight" ID="ListPopUp" runat="server" Width="700px" Height="500px" Modal="true"
    VisibleStatusbar="false" AutoSize="true" AutoSizeBehaviors="Height, Width" />
