﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="WFEstatistica.ascx.vb" Inherits="WebFoundations.WFWorkflow.UI.WFEstatistica" %>
<%@ Register Assembly="WebFoundations.ServerControls" Namespace="WebFoundations.ServerControls" TagPrefix="wf" %>
<%@ Register Namespace="WebFoundations.WFPortal.Controls" Assembly="WebFoundations.WFPortal.Controls" TagPrefix="wff" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<section class="wf-statistics modulo-estatisticas">
    <div class="wabusca-avancada" style="display: block;">
        <fieldset class="filter">
            <div class="row">
                <div class="col-12">
                    <div class="row">
                        <div class="waFilter col-3 col-lg-4 col-md-6 col-xs-12">
                            <asp:Label CssClass="filtertitle" runat="server" ID="lblPeriod" />
                            <asp:DropDownList runat="server" ID="ddlPeriod" ValidationGroup="filter" AutoPostBack="true" />
                        </div>
                        <div class="col-3 col-lg-4 col-md-6 col-xs-12 d-flex align-center">
                            <span class="labelItem">
                                <asp:Literal ID="lblDtInterval" runat="server" />
                            </span>
                            <asp:Panel runat="server" ID="pnCustomPeriod" CssClass="w-100">
                                <asp:Label ID="lblDtSearch" Text="Data de término" runat="server" CssClass="labelItem" />
                                <div class="datefield-container">
                                    <div class="wadatefield">
                                        <wf:DatePicker ID="datefrom" ValidationGroup="filter" DisableLowerValuesFor="dateto" runat="server" />
                                    </div>
                                    <asp:Label ID="lblto" CssClass="wainput-date-to labelItem" Text="até" runat="server" />
                                    <div class="wadatefield">
                                        <wf:DatePicker ID="dateto" ValidationGroup="filter" runat="server" />
                                    </div>
                                </div>
                            </asp:Panel>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="row">
                        <div class="col-3 col-lg-4 col-md-6 col-xs-12 d-flex align-end">
                            <asp:Button ID="btnsearch" ValidationGroup="filter" CssClass="search" runat="server" />
                        </div>
                    </div>
                </div>
            </div>
        </fieldset>
    </div>
    <h2 id="h2proc" runat="server">
        <asp:Literal ID="lblprocesses" runat="server" /></h2>
    <asp:Repeater ID="rptProcesses" runat="server">
        <HeaderTemplate>
            <ul class="tiles">
        </HeaderTemplate>
        <FooterTemplate></ul></FooterTemplate>
        <ItemTemplate>
            <li class="process statItem <%#Eval("IsSelected")%>">
                <asp:LinkButton runat="server" CommandArgument='<%#Eval("Id")%>' OnClick="Process_Click">
                        <asp:Label runat="server" Text='<%#Eval("Watermark")%>' CssClass="watermark" />
                        <h5><%#Eval("Name")%></h5>
                        <asp:Label runat="server" Text='<%#Eval("Average")%>' CssClass="biggest-queue" />
                        <asp:Label runat="server" Text='<%#Eval("SLA")%>' CssClass="sla" />
                        <asp:Label runat="server" Text='<%#Eval("UserName")%>' CssClass="biggest-queue" />
                        <asp:Label runat="server" Text='<%#Eval("Last")%>' CssClass="last" />
                        <asp:Label runat="server" Text='<%#Eval("ItemsCount")%>' CssClass="count" />
                        <i data-feather="arrow-right" class="calltoaction"></i>
                        <i data-feather="check-square" class="selectedicon"></i>
                </asp:LinkButton>
            </li>
        </ItemTemplate>
    </asp:Repeater>
    <h2 id="h2slaproc" runat="server">
        <asp:Literal ID="lblslaproc" runat="server" />
    </h2>
    <asp:Repeater ID="rptSLAProc" runat="server">
        <HeaderTemplate>
            <ul class="tiles">
        </HeaderTemplate>
        <FooterTemplate></ul></FooterTemplate>
        <ItemTemplate>
            <li class="sla statItem unhover" style='background-color: <%#Eval("Color")%>; color: <%#Eval("FontColor")%>; --sla-color: <%#Eval("Color")%>;'>
                <a href="#">
                    <asp:Label runat="server" Text='<%#Eval("Watermark")%>' CssClass="watermark" />
                    <h5 style='color: <%#Eval("FontColor")%>;'><%#Eval("Name")%></h5>
                    <asp:Label runat="server" Text='<%#Eval("Percentual")%>' CssClass="sla" />
                    <asp:Label runat="server" Text='<%#Eval("Count")%>' CssClass="count" />
                </a>
            </li>
        </ItemTemplate>
    </asp:Repeater>
    <h2 id="h2etapas" runat="server">
        <asp:Literal ID="lbletapa" runat="server" /></h2>
    <asp:Repeater ID="rptStages" runat="server">
        <HeaderTemplate>
            <ul class="tiles">
        </HeaderTemplate>
        <FooterTemplate></ul></FooterTemplate>
        <ItemTemplate>
            <li class="stage statItem <%#Eval("IsSelected")%>">
                <asp:LinkButton runat="server" CommandArgument='<%#Eval("Id")%>' OnClick="Stage_Click">
                        <asp:Label runat="server" Text='<%#Eval("Watermark")%>' CssClass="watermark" />
                        <h5><%#Eval("Name")%></h5>
                        <asp:Label runat="server" Text='<%#Eval("Average")%>' CssClass="biggest-queue"/>
                        <asp:Label runat="server" Text='<%#Eval("SLA")%>' CssClass="sla" />
                        <asp:Label runat="server" Text='<%#Eval("UserName")%>' CssClass="biggest-queue" />
                        <asp:Label runat="server" Text='<%#Eval("Last")%>' CssClass="last" />
                        <asp:Label runat="server" Text='<%#Eval("ItemsCount")%>' CssClass="count" />
                        <i data-feather="arrow-right" class="calltoaction"></i>
                        <i data-feather="check-square" class="selectedicon"></i>
                </asp:LinkButton>
            </li>
        </ItemTemplate>
    </asp:Repeater>
    <h2 id="h2slaletapa" runat="server">
        <asp:Literal ID="lblslaetapa" runat="server" /></h2>
    <asp:Repeater ID="rptSLAStage" runat="server">
        <HeaderTemplate>
            <ul class="tiles">
        </HeaderTemplate>
        <FooterTemplate></ul></FooterTemplate>
        <ItemTemplate>
            <li class="sla statItem unhover" style='background-color: <%#Eval("Color")%>; color: <%#Eval("FontColor")%>; --sla-color: <%#Eval("Color")%>;'>
                <a href="#">
                    <asp:Label runat="server" Text='<%#Eval("Watermark")%>' CssClass="watermark" />
                    <h5 style='color: <%#Eval("FontColor")%>;'><%#Eval("Name")%></h5>
                    <asp:Label runat="server" Text='<%#Eval("Percentual")%>' CssClass="sla" />
                    <asp:Label runat="server" Text='<%#Eval("Count")%>' CssClass="count" />
                </a>
            </li>
        </ItemTemplate>
    </asp:Repeater>
    <h2 id="h2produtividadeusuarios" runat="server">
        <asp:Literal ID="lblprodutividadeusuarios" runat="server" /></h2>
    <asp:Repeater ID="rptUsers" runat="server">
        <HeaderTemplate>
            <ul class="tiles">
        </HeaderTemplate>
        <FooterTemplate></ul></FooterTemplate>
        <ItemTemplate>
            <li class="user statItem unhover">
                <a href="#">
                    <asp:Label runat="server" Text='<%#Eval("Watermark")%>' CssClass="watermark" />
                    <div class="d-flex align-center">
                        <wff:UserAvatar runat="server" rel="user" ID="avatar" target="_blank" AlwaysShowPhoto="true" Mode="ImageOnly" UserId='<%#Eval("Id")%>' />
                        <h5><%#Eval("Name")%></h5>
                    </div>
                    <asp:Label runat="server" Text='<%#Eval("Average")%>' CssClass="biggest-queue mt-half" />
                    <asp:Label runat="server" Text='<%#Eval("SLA")%>' CssClass="sla" />
                    <asp:Label runat="server" Text='<%#Eval("Last")%>' CssClass="last" />
                    <asp:Label runat="server" Text='<%#Eval("ItemsCount")%>' CssClass="count" />
                </a>
            </li>
        </ItemTemplate>
    </asp:Repeater>
    <script>
        /**
         * Inicializa a lib.
         */
        document.addEventListener("DOMContentLoaded", function (event) {

            feather.replace();

            var PainelTileTarget = document.querySelector('.wf-statistics.modulo-estatisticas');
            PainelTileTarget = PainelTileTarget.parentNode;

            // cria uma nova instância de observador
            var observerPainelTiles = new MutationObserver(function (mutations) {
                mutations.forEach(function (mutation) {
                    console.log("ta tendo mudança?", mutation)
                    feather.replace();
                });
            });


            // configuração do observador:
            var config = { attributes: true, childList: true, characterData: true };

            // passar o nó alvo, bem como as opções de observação
            observerPainelTiles.observe(PainelTileTarget, config);
        });
    </script>
</section>

