﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="SocialMessage.ascx.vb" Inherits="WebFoundations.WFWorkflow.UI.SocialMessage" %>
<%@ Register Namespace="WebFoundations.WFPortal.Controls" Assembly="WebFoundations.WFPortal.Controls" TagPrefix="wf" %>

<article id="<%=ClientID%>">    
    <div class="general-info">
        <wf:UserAvatar runat="server" rel="author" ID="avatar" AlwaysShowPhoto="true" />
        <h5>
            <asp:Literal runat="server" ID="lTitle" />
        </h5>
        <h6><asp:Label runat="server" ID="lSubject" CssClass="subject" /></h6>
        <p>
            <asp:Literal ID="lMessage" runat="server" />
        </p>
        <asp:Literal ID="lTime" runat="server" />
        <span class="timeDiff">
            <asp:Literal ID="timeDiff" runat="server" />
        </span>
        <asp:HiddenField runat="server" ID="readField" />
    </div>
    <menu class="actions d-flex justify-between" type="list">
        <asp:LinkButton runat="server" ID="lnkLike" OnClick="Like_Click" />
        <asp:LinkButton runat="server" ID="lnkComments" OnClick="Comments_Click" />
        <asp:LinkButton runat="server" ID="lnkUnread" OnClick="Unread_Click" />
        <asp:LinkButton runat="server" ID="lnkFlagged" OnClick="Flag_Click" />
        <asp:LinkButton runat="server" ID="lnkRemove" OnClick="Remove_Click" />
    </menu>

    <asp:PlaceHolder runat="server" ID="phComments" Visible="false">
        <asp:PlaceHolder runat="server" ID="phLoadAll" Visible="false">
            <aside class="load load-previous">
                <asp:LinkButton runat="server" CssClass="button" Text="Visualizar comentários anteriores" ID="lnkLoadPrevious" OnClick="LoadPrevious_Click" />
            </aside>
        </asp:PlaceHolder>

        <asp:Repeater runat="server" ID="rptComments">
            <ItemTemplate>
                <article>
                    <wf:UserAvatar runat="server" rel="author" ID="msgCommentAvatar" AlwaysShowPhoto="true" />
                    <asp:Literal runat="server" ID="msgComment" />
                    <asp:LinkButton runat="server" ID="lnkRemoveComment" CssClass="remove" OnClick="RemoveComment_Click" />
                </article>
            </ItemTemplate>
        </asp:Repeater>

        <aside class="comment">
            <asp:TextBox Rows="1" runat="server" ID="txtComment" TextMode="MultiLine" placeholder="Responder" />
            <asp:RequiredFieldValidator ControlToValidate="txtComment" Display="Dynamic" runat="server" Text="*" ValidationGroup="comment" />
            <asp:Button runat="server" ID="bntComment" Text="Comentar" OnClick="Comment_Click" ValidationGroup="comment" />
        </aside>
    </asp:PlaceHolder>
    <script>
        document.querySelector("#<%=ClientID%>").classList.add(
            document.querySelector("#<%=ClientID%> .general-info input[type='hidden']").value
        )
    </script>
</article>
