﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="Social.ascx.vb" Inherits="WebFoundations.WFWorkflow.UI.Social" %>
<%@ Register Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Namespace="WebFoundations.WFPortal.Controls" Assembly="WebFoundations.WFPortal.Controls" TagPrefix="wf" %>
<%@ Register Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" TagPrefix="wf" %>
<%@ Register Src="~/WFContent/Modules/WFWorkflow/SocialMessage.ascx" TagPrefix="wf" TagName="SocialMessage" %>

<wf:ExtendedUpdatePanel runat="server" Tag="div" CssClass="zuri-social">
    <ContentTemplate>
        <div class="share">
            <wf:UserAvatar runat="server" rel="author" ShowCurrentUser="true" AlwaysShowPhoto="true" Mode="ImageOnly" />
            <asp:TextBox runat="server" TextMode="MultiLine" ID="txtShare" />
            <div class="d-flex justify-between wrap">
                <telerik:RadComboBox ID="rcbProcShare" CssClass="process" runat="server" />
                <asp:Button ID="btShare" runat="server" Text="Compartilhar" OnClick="Share_Click" />
            </div>
        </div>

        <div class="filter-comments">
            <telerik:RadComboBox ID="rcbProcFilter" CssClass="process" runat="server" placeholder="Todos os processos" AutoPostBack="true" />
            <div class="d-flex justify-between flex-1 flags wrap">
                <asp:LinkButton runat="server" ID="lnkUnreadFilter" CssClass="unread" Text="Comentários não lidos" OnClick="UnreadOnly_Click" />
                <asp:LinkButton runat="server" ID="lnkFlaggedFilter" CssClass="flagged" Text="Publicações marcadas" OnClick="FlaggedOnly_Click" />
            </div>
        </div>

        <div class="social-body">
            <div class="body-title">
                <h2>
                    <asp:Literal ID="notificationsTitle" runat="server" />
                </h2>
            </div>

            <asp:PlaceHolder ID="phLoadNew" runat="server">
                <aside class="load load-new">
                    <asp:LinkButton runat="server" CssClass="button" ID="lnkLoadNew" Text="Exibir novas mensagens" OnClick="LoadNew_Click" />
                </aside>
            </asp:PlaceHolder>

            <wf:ExtendedRepeater runat="server" ID="rptMessages">
                <ItemTemplate>
                    <wf:SocialMessage ID="msg" runat="server" />
                </ItemTemplate>
            </wf:ExtendedRepeater>

            <asp:PlaceHolder ID="phLoadMore" runat="server">
                <div class="load load-more">
                    <asp:LinkButton ID="btLoadMore" CssClass="button" runat="server" Text="Carregar mais mensagens" OnClick="LoadMore_Click" />
                </div>
            </asp:PlaceHolder>
        </div>

    </ContentTemplate>
</wf:ExtendedUpdatePanel>

<script>
    if (!isNewTemplate) {
        var isNewTemplate = document.querySelector('body.new-template') != null;
        if (isNewTemplate) {
            document.querySelector('.zuri-social .share textarea')?.setAttribute('rows', 3);
        }
    }
</script>

