﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="WFPainelTiles.ascx.vb" Inherits="WebFoundations.WFWorkflow.UI.WFPainelTiles" %>
<%@ Register Src="~/WFContent/Modules/WFWorkflow/PainelControle/WFPainelItems.ascx" TagPrefix="uc1" TagName="WFPainelItems" %>
<%@ Register Namespace="WebFoundations.WFPortal.Controls" Assembly="WebFoundations.WFPortal.Controls" TagPrefix="wf" %>


<section class="wf-statistics painel-tiles">
    <asp:PlaceHolder ID="phProcesses" runat="server">
        <div class="accordion-header light initOpen minusPlusIndicator showHover d-flex align-center g-1">
            <i data-feather="minus" class="minus"></i>
            <i data-feather="plus" class="plus"></i>
            <h2>
                <asp:Literal ID="litprocesses" runat="server" />&nbsp;&nbsp;
            </h2>
            <span class="total">
                <asp:Literal ID="litProcessCount" runat="server" />
            </span>
        </div>
        <div class="accordion-body no-padding">
            <asp:Repeater ID="rptProcesses" runat="server">
                <HeaderTemplate>
                    <ul class="filter-cards">
                </HeaderTemplate>
                <FooterTemplate></ul></FooterTemplate>
                <ItemTemplate>
                    <li class="process statItem <%#Eval("IsSelected")%>  <%#Eval("IsStopped")%>">
                        <asp:LinkButton runat="server" CommandArgument='<%#Eval("Id")%>' OnClick="Process_Click">
                            <h5>#<%#Eval("Id")%> - <%#Eval("Name")%> </h5>
                            <span class="grafic-container">
                                <span class="flex-1">
                                    <span class="percentage-message"><%#Eval("SLAMsg")%></span>
                                    <span class="grafic">
                                        <hr class="grafic-percentage" style="width:<%#Eval("SLAPCT")%>%" />
                                    </span>
                                </span>
                                <span class="percentage"><%#Eval("SLAPCT")%>%</span>
                            </span>
                            <span class="d-flex align-center justify-between">
                                <span class="d-flex g-1 mt-1 mb-1 align-center">
                                    <span class="items">
                                        <b><%#Eval("ItemsCount")%></b>&nbsp;<%#Eval("ItemsCountMsg")%>
                                    </span>
                                    <span class="pendencies">
                                        <b><%#Eval("PendenciesCount")%></b>&nbsp;<%#Eval("PendenciesCountMsg")%>
                                    </span>
                                    <span class="stopped-title"><%#Eval("StoppedTitle")%></span>
                                </span>
                                <i data-feather="alert-triangle" class="stoppedicon" ></i>
                            </span>
                            <span class="<%#Eval("ViewMode")%> biggest-queue"><%#Eval("MostPendenciesMsg")%>: <b><%#Eval("MostPendenciesUser")%></b></span>
                            <span class="<%#Eval("ViewMode")%> last-created"><%#Eval("LastCreatedMsg")%>: <%#Eval("LastCreated")%></span>
                            <span class="watermark"><%#Eval("Watermark")%></span>
                            <i data-feather="arrow-right" class="calltoaction"></i>
                        </asp:LinkButton>
                    </li>
                </ItemTemplate>
            </asp:Repeater>
        </div>
    </asp:PlaceHolder>
    <asp:PlaceHolder ID="phProcessSLA" runat="server">
        <div class="accordion-header light initOpen minusPlusIndicator showHover d-flex align-center g-1">
            <i data-feather="minus" class="minus"></i>
            <i data-feather="plus" class="plus"></i>
            <h2>
                <asp:Literal ID="litslaproc" runat="server" /></h2>
        </div>
        <div class="accordion-body no-padding">
            <asp:Repeater ID="rptSLAProc" runat="server">
                <HeaderTemplate>
                    <ul class="filter-cards sla-cards">
                </HeaderTemplate>
                <FooterTemplate></ul></FooterTemplate>
                <ItemTemplate>
                    <li class="sla statItem <%#Eval("IsSelected")%>" style='background-color: <%#Eval("Color")%>; --sla-color: <%#Eval("Color")%>;'>
                        <asp:LinkButton runat="server" CommandArgument='<%#Eval("Id")%>' OnClick="SLAProcess_Click">
                            <span class="d-flex justify-between align-center mb-1">
                                <h5><%#Eval("Name")%></h5>
                                <span class="percentage"><%#Eval("SLAPCT")%>%</span>
                            </span>
                            <span class="grafic-container">
                                <span class="flex-1">
                                    <span class="grafic">
                                        <hr class="grafic-percentage" style="width:<%#Eval("SLAPCT")%>%;" />
                                    </span>
                                </span>
                            </span>
                            <span class="d-flex g-1 mt-1 mb-1 align-center cardItemCounters">
                                <span class="items">
                                    <b><%#Eval("ItemsCount")%></b>&nbsp;<%#Eval("ItemsCountMsg")%>
                                </span>
                                <span class="pendencies">
                                    <b><%#Eval("PendenciesCount")%></b>&nbsp;<%#Eval("PendenciesCountMsg")%>
                                </span>
                            </span>
                            <span class="watermark"><%#Eval("Watermark")%></span>
                        </asp:LinkButton>
                    </li>
                </ItemTemplate>
            </asp:Repeater>
        </div>
    </asp:PlaceHolder>
    <asp:PlaceHolder ID="phSteps" runat="server">
        <div class="accordion-header light initOpen minusPlusIndicator showHover d-flex align-center g-1">
            <i data-feather="minus" class="minus"></i>
            <i data-feather="plus" class="plus"></i>
            <h2>
                <asp:Literal ID="lbletapa" runat="server" /></h2>
        </div>
        <div class="accordion-body no-padding">
            <asp:Repeater ID="rptSteps" runat="server">
                <HeaderTemplate>
                    <ul class="filter-cards">
                </HeaderTemplate>
                <FooterTemplate></ul></FooterTemplate>
                <ItemTemplate>
                    <li class="stage statItem <%#Eval("IsSelected")%>">
                        <asp:LinkButton runat="server" CommandArgument='<%#Eval("Id")%>' OnClick="Step_Click">
                            <h5><%#Eval("Name")%> </h5>
                            <span class="grafic-container">
                                <span class="flex-1">
                                    <span class="percentage-message"><%#Eval("SLAMsg")%></span>
                                    <span class="grafic">
                                        <hr class="grafic-percentage" style="width:<%#Eval("SLAPCT")%>%" />
                                    </span>
                                </span>
                                <span class="percentage"><%#Eval("SLAPCT")%>%</span>
                            </span>
                            <span class="d-flex g-1 mt-1 mb-1 align-center">
                                <span class="items">
                                    <b><%#Eval("ItemsCount")%></b>&nbsp;<%#Eval("ItemsCountMsg")%>
                                </span>
                                <span class="pendencies">
                                    <b><%#Eval("PendenciesCount")%></b>&nbsp;<%#Eval("PendenciesMsg")%>
                                </span>
                            </span>
                            <span class="watermark"><%#Eval("Watermark")%></span>
                            <span class="biggest-queue"><%#Eval("MostPendenciesMsg")%>: <b><%#Eval("MostPendenciesUser")%></b></span>
                            <span class="last-created"><%#Eval("LastStartMsg")%>: <%#Eval("LastStart")%></span>
                        </asp:LinkButton>
                    </li>
                </ItemTemplate>
            </asp:Repeater>
        </div>
    </asp:PlaceHolder>
    <asp:PlaceHolder ID="phStepsSLA" runat="server">
        <div class="accordion-header light initOpen minusPlusIndicator showHover d-flex align-center g-1">
            <i data-feather="minus" class="minus"></i>
            <i data-feather="plus" class="plus"></i>
            <h2>
                <asp:Literal ID="lblslaetapa" runat="server" /></h2>
        </div>
        <div class="accordion-body no-padding">
            <asp:Repeater ID="rptSLAStep" runat="server">
                <HeaderTemplate>
                    <ul class="filter-cards sla-cards">
                </HeaderTemplate>
                <FooterTemplate></ul></FooterTemplate>
                <ItemTemplate>
                    <li class="sla statItem <%#Eval("IsSelected")%>" style='background-color: <%#Eval("Color")%>; --sla-color: <%#Eval("Color")%>;'>
                        <asp:LinkButton runat="server" CommandArgument='<%#Eval("Id")%>' OnClick="SLAStep_Click">
                            <span class="d-flex justify-between align-center mb-1">
                                <h5><%#Eval("Name")%></h5>
                                <span class="percentage"><%#Eval("SLAPCT")%>%</span>
                            </span>
                            <span class="grafic-container">
                                <span class="flex-1">
                                    <span class="grafic">
                                        <hr class="grafic-percentage" style="width:<%#Eval("SLAPCT")%>%;" />
                                    </span>
                                </span>
                            </span>
                            <span class="d-flex mb-1 mt-1 cardItemCounters">
                                <span class="pendencies">
                                    <b><%#Eval("PendenciesCount")%></b>&nbsp;<%#Eval("PendenciesCountMsg")%>
                                </span>
                            </span>

                            <span class="watermark"><%#Eval("Watermark")%></span>
                        </asp:LinkButton>
                    </li>
                </ItemTemplate>
            </asp:Repeater>
        </div>
    </asp:PlaceHolder>
    <asp:PlaceHolder ID="phUserProductivity" runat="server">
        <div class="accordion-header light initOpen minusPlusIndicator showHover d-flex align-center g-1">
            <i data-feather="minus" class="minus"></i>
            <i data-feather="plus" class="plus"></i>
            <h2><asp:Literal ID="lblprodutividadeusuarios" runat="server" /></h2>
            <span class="tooltip-container">
                <i data-feather="info"></i>
                <span class="tooltip-body solid bigger bottom">
                    
                    
                    <p><b><asp:Literal ID="tooltipAttachedLbl" runat="server" />:</b>&nbsp;<asp:Literal ID="tooltipAttached" runat="server" /></p>
                    <p><b><asp:Literal ID="tooltipUnboundLbl" runat="server" />:</b>&nbsp;<asp:Literal ID="tooltipUnbound" runat="server" /></p>
                </span>
            </span>
        </div>
        <div class="accordion-body no-padding">
            <asp:Repeater ID="rptUsers" runat="server">
                <HeaderTemplate>
                    <ul class="filter-cards productivity">
                </HeaderTemplate>
                <FooterTemplate></ul></FooterTemplate>
                <ItemTemplate>
                    <li class="user statItem <%#Eval("IsSelected")%>">
                        <asp:LinkButton runat="server" CommandArgument='<%#Eval("Id")%>' OnClick="User_Click">
                            <span class="watermark"><%#Eval("Watermark")%></span>
                            <span class="d-flex align-center justify-between g-1">
                                <h5><%#Eval("Name")%></h5>
                                <wf:UserAvatar runat="server" rel="user" ID="avatar" target="_blank" AlwaysShowPhoto="true" Mode="ImageOnly" UserId='<%#Eval("Id")%>' />
                            </span>
                            <span class="d-flex g-1 align-center mt-1 mb-1">
                                <span class="pendencies">
                                    <b><%#Eval("PendenciesCount")%></b>&nbsp;<%#Eval("PendenciesCountMsg")%>
                                </span>
                                <span class="stepsCount">
                                    <b><%#Eval("StepCount")%></b>&nbsp;<%#Eval("StepCountMsg")%>
                                </span>
                            </span>
                            <span class="grafic-container">
                                <span class="flex-1">
                                    <span class="grafic">
                                        <hr class="grafic-percentage" style="width: <%#Eval("PCTAttached")%>%;" />
                                    </span>
                                </span>
                            </span>
                            <span class="d-flex mt-1 mb-1 g-1 cardItemCounters">
                                <span class="linked">
                                    <b><%#Eval("AttachedCount")%></b>&nbsp;<%#Eval("AttachedCountMsg")%>
                                </span>
                                <span class="unbound">
                                    <b><%#Eval("NonAttachedCount")%></b>&nbsp;<%#Eval("NonAttachedCountMsg")%>
                                </span>
                            </span>
                        </asp:LinkButton>
                    </li>
                </ItemTemplate>
            </asp:Repeater>
        </div>
    </asp:PlaceHolder>
    <asp:PlaceHolder ID="phFilter" runat="server">
        <section class="zuri-workspace contAreaTrabalho" style="width: 100%!important; margin-bottom: 1em;">
            <section class="wacont-Main">
                <asp:Panel ID="pnlFilter" runat="server" CssClass="wabuscar row" DefaultButton="btnsearch">
                    <div class="col-3 col-md-6 col-sm-12 input-col">
                        <div class="busca-input-container">
                            <asp:TextBox ID="txtSearchText" CssClass="wainput-busca" runat="server" />
                            <asp:Button ID="btnsearch" CssClass="wainput-submit buscasimples" runat="server" />
                        </div>
                    </div>
                </asp:Panel>
            </section>
        </section>
    </asp:PlaceHolder>
    <script>
        /**
         * Inicializa a lib.
         */
        document.addEventListener("DOMContentLoaded", function (event) {
            if (typeof (feather) != 'undefined') {
                feather.replace();
            }

            var PainelTileTarget = document.querySelector('.wf-statistics.painel-tiles');
            PainelTileTarget = PainelTileTarget.parentNode;

            // cria uma nova instância de observador
            var observerPainelTiles = new MutationObserver(function (mutations) {
                mutations.forEach(function (mutation) {
                    if (typeof (feather) != 'undefined') {
                        feather.replace();
                    }
                    accordionController.init();
                });
            });


            // configuração do observador:
            var config = { attributes: true, childList: true, characterData: true };

            // passar o nó alvo, bem como as opções de observação
            observerPainelTiles.observe(PainelTileTarget, config);
            /**
                ACCORDIONS
             */
            //accordionController.init(true);
        });
    </script>
</section>
<uc1:WFPainelItems runat="server" ID="WFPainelItems" />
