﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="ControlItem.ascx.vb" Inherits="WebFoundations.WFWorkflow.UI.ControlItem" %>
<%@ Register Assembly="WebFoundations.ServerControls" Namespace="WebFoundations.ServerControls" TagPrefix="wff" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<div class="controle-item row">
    <asp:UpdatePanel ID="pnlObservers" UpdateMode="Conditional" class="col-4 col-md-6 col-xs-12 mt-3" Visible="false" runat="server">
        <ContentTemplate>
            <asp:Panel ID="groupObservers" Visible="true" runat="server" DefaultButton="btnobserv" CssClass="div-observer">
                <asp:Timer ID="refreshTimer" Interval="10000" Enabled="false" runat="server" />
                <table class="table-observer">
                    <tr>
                        <td>
                            <h4>
                                <asp:Literal ID="lblobserv" runat="server" /></h4>
                        </td>
                    </tr>
                    <asp:PlaceHolder ID="phExecObs" runat="server">
                        <tr>
                            <td>
                                <asp:Label ID="lblFilterobs" runat="server" /><br />
                                <asp:DropDownList ID="ddlFilterobs" runat="server" /></td>
                        </tr>
                        <tr>
                            <td>
                                <asp:Label ID="lblcriacao" CssClass="labelItem" runat="server" /><br />
                                <div class="datefield-container">
                                    <div class="wadatefield">
                                        <wff:DatePicker ID="datefrom" runat="server" />
                                    </div>
                                    <asp:Label ID="lblto" CssClass="textoData" runat="server" />
                                    <div class="wadatefield">
                                        <wff:DatePicker ID="dateto" runat="server" />
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div class="mb-2">
                                    <asp:CheckBox ID="chkFinished" runat="server" />
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <asp:Label ID="lblrole" runat="server" /><br />
                                <div class="mt-half">
                                    <wff:AccessList id="listaAcesso" DisableItems="-7;-6;-5;-4;-3" EnableUser="true" EnableRole="true" EnableRoleGroup="true" runat="server" />
                                </div>
                            </td>
                        </tr>
                    </asp:PlaceHolder>
                    <asp:PlaceHolder ID="phWaitOBS" runat="server" Visible="false">
                        <tr>
                            <td>
                                <div class="mb-2"><br />
                                    <h4>
                                        <asp:Label ID="lblWaitMessage" runat="server" />
                                    </h4>
                                </div>
                            </td>
                        </tr>
                    </asp:PlaceHolder>
                </table>
                <div class="ItemControl-btn">
                    <asp:Button ID="btnobserv" runat="server" CausesValidation="false" CssClass="CaixabtnFiltrar" />
                </div>
            </asp:Panel>
        </ContentTemplate>
    </asp:UpdatePanel>
    <asp:UpdatePanel ID="pnlReassign" Visible="false" class="col-4 col-md-6 col-xs-12 mt-3" UpdateMode="Conditional" runat="server">
        <ContentTemplate>
            <asp:Panel ID="groupReassign" runat="server" DefaultButton="btnAssign" CssClass="div-reassign">
                <table class="table-reassign">
                    <tr>
                        <td>
                            <h4>
                                <asp:Literal ID="lblReassign" runat="server" /></h4>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Label ID="lblFromUser" runat="server" /><br />
                            <wff:userpicker id="usrFrom" runat="server" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Label ID="lblToUser" runat="server" /><br />
                            <wff:userpicker id="usrTo" runat="server" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Label ID="lblprocess" runat="server" /><br />
                            <asp:DropDownList ID="ddlprocess" runat="server"></asp:DropDownList></td>
                    </tr>
                    <tr>
                        <td>&nbsp;</td>
                    </tr>
                </table>
                <div class="ItemControl-btn">
                    <asp:Button ID="btnAssign" runat="server" CausesValidation="false" CssClass="CaixabtnFiltrar" />
                </div>
            </asp:Panel>
        </ContentTemplate>
    </asp:UpdatePanel>
    <asp:UpdatePanel ID="pnlRestart" Visible="false" class="col-4 col-md-6 col-xs-12 mt-3" UpdateMode="Conditional" runat="server">
        <ContentTemplate>
            <asp:Panel ID="groupRestart" runat="server" DefaultButton="btnRestart" CssClass="div-restart">
                <table class="table-restart">
                    <tr>
                        <td>
                            <h4>
                                <asp:Literal ID="lblTitRestart" runat="server" /></h4>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Label ID="lblSelProcess" runat="server" /><br />
                            <asp:DropDownList ID="ddlRstProcess" runat="server"></asp:DropDownList></td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Label ID="lblfindItem" runat="server" /><br />
                            <div class="d-flex">
                                <div class="flex-1">
                                    <asp:TextBox ID="txtItemId" runat="server"></asp:TextBox>
                                    <asp:RegularExpressionValidator ID="vlItemId" CssClass="avisoErro" runat="server" ControlToValidate="txtItemId"
                                        ValidationExpression="0*[1-9][0-9]*" Display="Dynamic"></asp:RegularExpressionValidator>
                                </div>
                                <asp:Button ID="btnSearch" runat="server" CssClass="CaixabtnBuscar ml-2" />
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Label ID="lblItemInfo" runat="server" CssClass="TituloBusca" /><br />
                            <asp:Label ID="lblSearchResult" runat="server" CssClass="ResultadoBusca" />
                            <div class="mt-2">
                                <asp:Label ID="lblSelStep" runat="server" />
                                <asp:DropDownList ID="ddlSteps" runat="server"></asp:DropDownList>
                            </div>
                        </td>
                    </tr>
                </table>
                <div class="ItemControl-btn">
                    <asp:Button ID="btnRestart" runat="server" CssClass="CaixabtnFiltrar" />
                </div>
            </asp:Panel>
        </ContentTemplate>
    </asp:UpdatePanel>
</div>
