﻿<%@ Page Language="vb" MaintainScrollPositionOnPostback="true" AutoEventWireup="false" CodeBehind="ZuriItem.aspx.vb" Inherits="WebFoundations.WFWorkflow.UI.ZuriItem" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <meta http-equiv="X-UA-Compatible" content="IE=Edge" />
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="format-detection" content="telephone=no">
    <script type="text/javascript">
        (function () {
            try {
                var storage = window.sessionStorage;
                if (storage) {
                    storage.setItem("zuri-no-mobile-redirect", "true");
                    console.log("redirecionamento para mobile desligado");
                }
            } catch (ex) {
                console.log("erro tentando desabilitar mobile na ZuriItem.aspx", ex);
            }
        })();
    </script>
    <script src="/theme/html5" type="text/javascript"></script>
    <link href="/theme/styles" rel="stylesheet" type="text/css" />
    <link rel="shortcut icon" href="/favicon.ico?v=2" type="image/x-icon" />
    <script src="/theme/scripts"></script>
    <script type="text/javascript">
        function CloseWindow() {
            try {
                self.close();
            } catch (error) { }
        }
        function pageLoad(sender, args) {
            try {
                clearLoadingPanel();
            } catch (erro) { console.log(erro); }
        }

        function clearLoadingPanel() {
            try {
                $("#zuri-itemexec.loading").removeClass("loading");
            } catch (erro) { console.log(erro); }
        }

        //substitui a função window.open padrão do browser por uma versão capaz de gerenciar as janelas que são abertas e 
        //fechá-las se a janela pai fechar ou navegar/postback.
        (function (window) {
            try {
                if (window && window.open) {
                    var o = window.open;//armazena a versão original da função window.open para usar adiante
                    var windows = [];//array para armazenar as janelas abertas

                    //substitui a window.open pela nova função
                    window.open = function (url, target, features, replace) {
                        try {
                            var w = o(url, target, features, replace);//chama a função original e armazena a referencia à janela aberta
                            windows.push(w);
                            w.focus();//coloca o foco na janela aberta
                            return w;
                        } catch (error) {
                            console.log("ZuriItem.aspx - erro abrindo popup: " + error);
                        }
                    };

                    //assina o evento que ocorre antes da página descarregar (fechando ou navegando)
                    //nesse evento serão fechadas quaisquer popups filhas que ainda estejam abertas
                    window.onbeforeunload = function () {
                        try {
                            if (windows && windows.length) {
                                for (var i = 0; i < windows.length; i++) {
                                    var w = windows[i];
                                    if (w && w.close && !w.closed) {
                                        w.close();
                                    }
                                }
                            }
                        } catch (error) { console.log("ZuriItem.aspx - erro fechando popups: " + error); }
                    }
                }
            } catch (erro2) { console.log("erro tentando substituir window.open ou assinar window.onbeforeunload: " + erro2) }
        })(window);
    </script>
    <script type="text/javascript" language="javascript">
        Sys.WebForms.PageRequestManager.getInstance().add_initializeRequest(InitRequestHandler);
        Sys.WebForms.PageRequestManager.getInstance().add_endRequest(EndRequestHandler);
        function InitRequestHandler(sender, args) {
            saveScrollPos();
        }
        function EndRequestHandler(sender, args) {
            setScrollPos();
        }
        function saveScrollPos() {
            document.getElementById("scrollPos").value =
                document.getElementById("zuri-itemexec").scrollTop;
        }
        function setScrollPos() {
            document.getElementById("zuri-itemexec").scrollTop =
                document.getElementById("scrollPos").value;
        }
    </script>
    <script type="text/javascript">
        (function () {
            window.onload = function () {
                try {
                    Sys.WebForms.PageRequestManager.getInstance().add_pageLoaded(clearLoadingPanel);
                } catch (erro) { console.log(erro); }
            };
        })();
    </script>
</head>
<body class="wfprocess-item <%:GetText("zzitemcss") %>  <%:GetText("newTemplateCss")%>">
    <form runat="server">
        <asp:ScriptManager runat="server" />
        <header class="theme-bg itemHeader">
            <div class="headerContent">
                <a href="#" title="Home" class="logo">
                    <h1>Zuri
                    </h1>
                </a>
                <div class="headerInfo">
                    <span class="label">
                        <asp:Literal ID="codigolbl" runat="server" />:
                    </span>
                    <span class="info">
                        <asp:Literal ID="itemidinfo" runat="server" />
                    </span>
                </div>
                <div class="headerInfo">
                    <span class="label">
                        <%:GetText("zzprocessname") %>
                    </span>
                    <span class="info">- <%:GetText("zzitemname") %>
                    </span>
                </div>
                <div class="headerInfo">
                    <span class="label">
                        <asp:Literal ID="etapalbl" runat="server" />
                    </span>
                    <span class="info">
                        <asp:Literal ID="etapainfo" runat="server" />
                    </span>
                </div>
                <asp:PlaceHolder ID="phsubprocess" runat="server">
                    <div class="headerInfo">
                        <span class="label">
                            <asp:Label runat="server" ID="lblSubProcessTitle" Text="Subprocesso: " />
                        </span>
                        <span class="info">
                            <asp:Label runat="server" ID="lblSubProcess" Text="" />
                        </span>
                    </div>
                </asp:PlaceHolder>
            </div>
            <div class="closebutton">
                <asp:LinkButton ID="btnClose" runat="server">
                    <i data-feather="x"></i>
                </asp:LinkButton>
            </div>
        </header>
        <asp:Repeater ID="rptTabs" runat="server">
            <HeaderTemplate>
                <menu>
            </HeaderTemplate>
            <ItemTemplate>
                <li>
                    <asp:LinkButton ID="tabLink" CausesValidation="false" runat="server" /></li>
            </ItemTemplate>
            <FooterTemplate></menu></FooterTemplate>
        </asp:Repeater>
        <input type="hidden" id="scrollPos" name="scrollPos" value="0" runat="server" />
        <asp:HiddenField runat="server" ID="hidDecisionClicked" />
        <main>
            <h1>
                <asp:Label runat="server" ID="lblTabTitle" Text="" /></h1>
            <div id="zuri-itemexec">
                <asp:PlaceHolder runat="server" ID="phExec" />
                <asp:PlaceHolder runat="server" ID="phDetails" />
            </div>
        </main>
        <asp:LinkButton ID="lnkClose" CssClass="close" runat="server" />
        <input id="hidSIId" type="hidden" fieldname="StepItemId" runat="server" />
    </form>
    <script type="text/javascript" src="/WFResources/Process/js/itemscript.js"></script>
    <script>
        document.addEventListener("DOMContentLoaded", function (event) {
            document.querySelector('a.logo').addEventListener('click', e => {
                e.preventDefault();
                document.getElementById('btnClose').click();
            })
            setScrollPos()
            document.querySelector('.new-template-selected main').setAttribute('style', `max-height: ${window.innerHeight - 112}px`);
        });
        //document.addEventListener("wheel", function(event) {
        //	saveScrollPos();
        //});
        document.querySelector('.new-template-selected main')
            .addEventListener('scroll', function () {
                saveScrollPos();
            }, false);
        window.addEventListener('resize', e => {
            document.querySelector('.new-template-selected main').setAttribute('style', `max-height: ${window.innerHeight - 112}px`);
        })
        function saveScrollPos() {
            document.getElementById("scrollPos").value = document.querySelector('.new-template-selected main').scrollTop;
        }
        function setScrollPos() {
            document.querySelector('.new-template-selected main').scrollTop = document.getElementById("scrollPos").value;
        }
    </script>
</body>
</html>
