﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="Mensagens.ascx.vb" Inherits="WebFoundations.WFWorkflow.UI.Mensagens" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register Namespace="WebFoundations.WFPortal.Controls" Assembly="WebFoundations.WFPortal.Controls" TagPrefix="wf" %>

<div class="messages">
    <asp:Panel runat="server" ID="pnlNewMessages" CssClass="new-message">
        <h2>
            <asp:Literal ID="newconversationlbl" runat="server" />
        </h2>
        <div id="new-message-form" class="new-message-form">
            <div class="to field">
                <asp:Button runat="server" ID="btnTo" Text="Para..." />
                <telerik:RadAutoCompleteBox runat="server" ID="acbTo" DataTextField="UserFullName" DataValueField="UserId" AllowCustomToken="true" />
            </div>
            <div class="cc field">
                <asp:Button runat="server" ID="btnCC" Text="CC..." />
                <telerik:RadAutoCompleteBox runat="server" ID="acbCC" DataTextField="UserFullName" DataValueField="UserId" AllowCustomToken="true" />
            </div>
            <div class="subject field">
                <asp:Label ID="lblSubject" runat="server" Text="Assunto" />
                <asp:TextBox ID="txtSubject" runat="server" MaxLength="50" />
            </div>
            <div class="message field">
                <asp:TextBox ID="txtMessage" Rows="6
                "
                    runat="server" TextMode="MultiLine" />
            </div>
            <asp:Button runat="server" ID="btnSend" CssClass="send" Text="Enviar" />
        </div>
    </asp:Panel>
    <asp:Panel runat="server" ID="pnlContent" CssClass="message-list">
        <h2>
            <asp:Literal ID="lblconversas" runat="server" />
        </h2>
        <asp:Repeater runat="server" ID="rptHeader">
            <ItemTemplate>
                <a href='#msg-<%# Eval("Id") %>' class="conversation" data-msgid='<%# Eval("Id") %>'>
                    <div class="d-flex align-start">
                        <div class="icon-container">
                            <i class="conversation-icon" data-feather="message-square"></i>
                        </div>
                        <div>
                            <h4>
                                <asp:Label runat="server" ID="lblMsgSubject" />
                            </h4>
                            <h5>
                                <asp:Label runat="server" ID="lblMsgTotal" />
                            </h5>
                            <h6 class="newmessagescount">
                                <asp:Label CssClass="new-msg-count" runat="server" ID="lblMsgNew" />
                                <asp:Label runat="server" ID="lblNew" />
                            </h6>
                        </div>
                    </div>
                    <i class="open-conversation" data-feather="chevron-down"></i>
                </a>
                <div id='msg-<%# Eval("Id") %>' class="full-conversation">
                    <div class="chat">
                        <asp:Repeater runat="server" ID="rptContent">
                            <ItemTemplate>
                                <article class="message <%# If(Eval("CurrentUserId") = Eval("SenderId"), "current", "") %>">
                                    <wf:UserAvatar runat="server" rel="author" ID="sender" UserId='<%#Eval("SenderId")%>' AlwaysShowPhoto="true" />
                                    <div class="content">
                                        <div class="to">
                                            <span><%#Eval("ToLabel")%></span>: 
                                            <span><%#Eval("RecipientName")%></span>
                                        </div>
                                        <div class="cc" style="<%# If(String.IsNullOrWhiteSpace(TryCast(Eval("CCName"), String)), "display:none", "")%>">
                                            <span><%#Eval("CCLabel")%></span>: 
                                            <span><%#Eval("CCName")%></span>
                                        </div>
                                        <p><%#Eval("Message")%></p>
                                        <time><%#Eval("DateCreated")%></time>
                                    </div>
                                    <%--(<%#Eval("StepLabel")%>: <%#Eval("SenderStep")%>)--%>
                                </article>
                            </ItemTemplate>
                        </asp:Repeater>
                    </div>
                    <asp:Panel runat="server" ID="pnlResposta" CssClass="reply">
                        <asp:TextBox runat="server" TextMode="MultiLine" Rows="1" ID="txtReply" placeholder="reply..." />
                        <asp:Button CssClass="reply" runat="server" ID="btnReply" />
                    </asp:Panel>
                </div>
            </ItemTemplate>
        </asp:Repeater>
    </asp:Panel>
    <asp:Panel runat="server" ID="pnlUsers" Visible="False" CssClass="pick-users">
        <div class="users-list">
            <h4>
                <asp:Literal ID="lblUserTitle" runat="server" /></h4>
            <ol>
                <asp:Repeater ID="rptUsers" runat="server">
                    <ItemTemplate>
                        <li>
                            <div>
                                <div class="name">
                                    <asp:Label ID="lblUserFullName" runat="server" Text='<%#Eval("UserFullName")%>' />
                                    <asp:Label ID="lblUserMail" runat="server" Text='<%#Eval("UserMail")%>' />
                                </div>
                                <ul class="steps">
                                    <asp:Repeater ID="rptUsersSteps" runat="server" OnItemDataBound="rptItemDataBound">
                                        <ItemTemplate>
                                            <li>
                                                <asp:Label ID="lblUserSteps" runat="server" Text='<%# Eval("Text")%>' /></li>
                                        </ItemTemplate>
                                    </asp:Repeater>
                                </ul>
                            </div>
                            <asp:Button ID="btnUserAdd" CssClass="add stylized" runat="server" Text="+" />
                        </li>
                    </ItemTemplate>
                </asp:Repeater>
            </ol>
            <telerik:RadAutoCompleteBox runat="server" ID="acbUserTo" DataTextField="UserFullName" DataValueField="UserId" AllowCustomToken="true" />
            <telerik:RadAutoCompleteBox runat="server" ID="acbUserCC" DataTextField="UserFullName" DataValueField="UserId" AllowCustomToken="true" />
            <section class="actions">
                <asp:Button runat="server" CssClass="stylized" ID="btnUsersOK" />
                <asp:Button runat="server" CssClass="stylized" ID="btnUsersCancel" />
            </section>
        </div>
    </asp:Panel>
</div>
<script type="text/javascript">
    var Sys;
    (function () {
        function load() {
            $(".full-conversation").hide();

            $("a.conversation").not(".wftogglehandled").addClass("wftogglehandled").click(function () {
                var h = $(this).attr("href");
                var visible = $(h).is(":visible");
                $(h).slideToggle("fast");
                if (!visible) {
                    $(this).addClass("open");
                    if (MarkReadMessages) {
                        var msgId = $(this).attr("data-msgid");
                        MarkReadMessages(msgId, this);
                    }
                } else {
                    $(this).removeClass("open");
                }
                return false;
            });
        }

        if (!window.zuriMessage) {
            window.zuriMessage = true;

            window.AfterCallBack = function (arg, context) {
                $(".new-msg-count", context).text("0");
            }

            $(document).ready(function () {
                load();
                if (Sys && Sys.WebForms && Sys.WebForms.PageRequestManager) {
                    var requestManager = Sys.WebForms.PageRequestManager.getInstance();

                    requestManager.add_endRequest(function (sender, args) {
                        try {
                            load();
                        } catch (erro) { }
                    });
                }
            });
        }
    })();
</script>


