﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="WFAnalytics.ascx.vb" Inherits="WebFoundations.WFWorkflow.UI.WFAnalytics" %>

<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register Assembly="WebFoundations.WFWorkflow.Services" Namespace="WebFoundations.WFWorkflow.Services.UI" TagPrefix="wff" %>
<%@ Register Assembly="WebFoundations.ServerControls" Namespace="WebFoundations.ServerControls" TagPrefix="wff" %>
<%@ Register Src="~/WFContent/Modules/WFWorkflow/ItemProcesso/ZuriLoader.ascx" TagPrefix="uc1" TagName="ZuriLoader" %>
<%@ Register Src="~/WFContent/Modules/WFWorkflow/WFPainel.ascx" TagPrefix="wf" TagName="Painel" %>


<div class="painel_advanced_header with-tags">
    <wf:Painel runat="server" id="Painel" notShowControlPanel />

    <section class="zuri-workspace contAreaTrabalho">
        <div style="display: flex; flex-direction: column;">
            <asp:Panel ID="pnlBusca" runat="server" Style="order: 2;" CssClass="mt-3 mb-1">
                <section class="wacont-Main">
                    <asp:Panel ID="pnlBuscaSimples" CssClass="wabuscar row" DefaultButton="btnBusca" runat="server">
                        <div class="col-3 col-md-6 col-sm-12 input-col">
                            <div class="busca-input-container">
                                <asp:TextBox ID="txtBusca" CssClass="wainput-busca" runat="server" />
                                <asp:Button ID="btnBusca" runat="server" CssClass="wainput-submit buscasimples" />
                            </div>
                        </div>
                        <div class="col-9 col-md-6 col-sm-12 d-flex c-xs-reverse-flex">
                            <div class="flex-1 controles">
                                <asp:PlaceHolder ID="lnkAvancada" runat="server">
                                    <asp:LinkButton ID="searchtoggle" runat="server" CssClass="advsearch"></asp:LinkButton>
                                </asp:PlaceHolder>
                            </div>
                            <div class="controles c-xs-flex">
                                <span id="finished1" class="mr-2" runat="server">
                                    <asp:CheckBox ID="chkfinished" runat="server" CssClass="cb" OnCheckedChanged="chkitens_Changed" AutoPostBack="True" />
                                </span>
                                <span id="started1" class="mt-xs-2" runat="server">
                                    <asp:CheckBox ID="chkstarted" runat="server" CssClass="cb" Checked="true" OnCheckedChanged="chkitens_Changed" AutoPostBack="True" />
                                </span>
                            </div>
                        </div>
                    </asp:Panel>
                    <asp:Panel ID="pnlBuscaAvancada" CssClass="wabusca-avancada" DefaultButton="btnBuscaAdv" runat="server">
                        <fieldset>
                            <div class="wabusca-avancadaTB row">
                                <asp:Panel ID="pnlStarted" runat="server" CssClass="col-12" Visible="false">
                                    <div class="row">
                                        <div class="waFilter col-3 col-lg-4 col-md-6 col-xs-12">
                                            <asp:Label CssClass="labelItem" ID="lblPeriodStarted" runat="server"></asp:Label>
                                            <asp:DropDownList ID="ddlPeriodStarted" CssClass="ddlfilter" runat="server" OnSelectedIndexChanged="ddlPeriod_OnTextChanged" AutoPostBack="true"></asp:DropDownList>
                                        </div>
                                        <div class="col-3 col-lg-4 col-md-6 col-xs-12 d-flex align-center">
                                            <asp:Label CssClass="labelItem" ID="lblDtIntervalStarted" runat="server"></asp:Label>
                                            <div style="margin-bottom: 16px !important;" class="datefield-container unpadding row">
                                                <div class="wadatefield col-6">
                                                    <asp:Label CssClass="labelItem" ID="lblFromStarted" runat="server" Visible="false"></asp:Label>
                                                    <wff:DatePicker ID="datefromstarted" CssClass="wainput-date" ValidationGroup="Inbox" runat="server" visible="false" />
                                                </div>
                                                <div class="wadatefield col-6">
                                                    <asp:Label CssClass="labelItem" ID="lblUntilStarted" runat="server" Visible="false"></asp:Label>
                                                    <wff:DatePicker ID="datetostarted" CssClass="wainput-date" ValidationGroup="Inbox" runat="server" visible="false" />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </asp:Panel>
                                <asp:Panel ID="pnlFinished" runat="server" CssClass="col-12" Visible="false">
                                    <div class="row">
                                        <div class="waFilter col-3 col-lg-4 col-md-6 col-xs-12">
                                            <asp:Label CssClass="labelItem" ID="lblPeriodFinished" runat="server"></asp:Label>
                                            <asp:DropDownList ID="ddlPeriodFinished" CssClass="ddlfilter" runat="server" OnSelectedIndexChanged="ddlPeriod_OnTextChanged" AutoPostBack="true"></asp:DropDownList>
                                        </div>
                                        <div class="col-3 col-lg-4 col-md-6 col-xs-12 d-flex align-center">
                                            <asp:Label CssClass="labelItem" ID="lblDtIntervalFinished" runat="server"></asp:Label>
                                            <div style="margin-bottom: 16px !important;" class="datefield-container unpadding row">
                                                <div class="wadatefield col-6">
                                                    <asp:Label CssClass="labelItem" ID="lblFromFinished" runat="server" Visible="false"></asp:Label>
                                                    <wff:DatePicker ID="datefromfinished" CssClass="wainput-date" ValidationGroup="" runat="server" visible="false" />
                                                </div>
                                                <div class="wadatefield col-6">
                                                    <asp:Label CssClass="labelItem" ID="lblUntilFinished" runat="server" Visible="false"></asp:Label>
                                                    <wff:DatePicker ID="datetofinished" CssClass="wainput-date" ValidationGroup="" runat="server" visible="false" />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </asp:Panel>
                                <div class="col-12">
                                    <div class="row">
                                        <div class="col-3 col-lg-4 col-md-6 col-xs-12 d-flex align-end">
                                            <asp:Button ID="btnBuscaAdv" runat="server" OnClick="CarregaLista" style="float: none;" CssClass="wainput-submit search" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </fieldset>
                    </asp:Panel>
                </section>
            </asp:Panel>
            <asp:Panel ID="pnlListType" CssClass="listGroup tabs" runat="server">
                <ul class="panel">
                    <li id="ProcessTile" class="panel-tile theme-bg" runat="server">
                        <asp:LinkButton ID="lnkProcess" OnClick="listType_Click" runat="server">
                            <asp:Label ID="lblProcess" runat="server" />
                            <asp:Label ID="ProcessWM" CssClass="watermark" runat="server" />
                            <asp:Label ID="lblProcessCount" CssClass="count" runat="server" />
                        </asp:LinkButton></li>
                    <li id="GroupsTile" class="panel-tile theme-bglight" runat="server">
                        <asp:LinkButton ID="lnkGroups" OnClick="listType_Click" runat="server">
                            <asp:Label ID="lblGroups" runat="server" />
                            <asp:Label ID="GroupsWM" CssClass="watermark" runat="server" />
                            <asp:Label ID="lblGroupsCount" CssClass="count" runat="server" />
                        </asp:LinkButton></li>
                    <li id="UsersTile" class="panel-tile theme-bgdarker" runat="server">
                        <asp:LinkButton ID="lnkUsers" OnClick="listType_Click" runat="server">
                            <asp:Label ID="lblUsers" runat="server" />
                            <asp:Label ID="UsersWM" CssClass="watermark" runat="server" />
                            <asp:Label ID="lblUsersCount" CssClass="count" runat="server" />
                        </asp:LinkButton></li>
                </ul>
            </asp:Panel>
        </div>
        <%--<div class="tags">
            <div title="Esta funcionalidade  está sujeita a comportamentos não esperados"><span>beta</span></div>
            <a href="mailto:feedback@zuri.wf?subject=Módulo de Analytics - Sugestão de melhoria ou feedback">
                <span>Feedback</span>
                <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M7.65625 5.65625V3H6.34375V5.65625H7.65625ZM7.65625 8.34375V7H6.34375V8.34375H7.65625ZM12.3438 0.34375C12.6979 0.34375 13 0.479167 13.25 0.75C13.5208 1 13.6562 1.30208 13.6562 1.65625V9.65625C13.6562 10.0104 13.5208 10.3229 13.25 10.5938C13 10.8646 12.6979 11 12.3438 11H3L0.34375 13.6562V1.65625C0.34375 1.30208 0.46875 1 0.71875 0.75C0.989583 0.479167 1.30208 0.34375 1.65625 0.34375H12.3438Z" fill="#fff"></path>
                </svg>
            </a>
        </div>--%>
        <asp:UpdatePanel ID="pnlAreaTrabalho" UpdateMode="Always" runat="server">
            <Triggers>
                <asp:AsyncPostBackTrigger ControlID="btnBusca" EventName="Click" />
            </Triggers>
            <ContentTemplate>
                <asp:Timer ID="contentTimer" runat="server" Enabled="False" Interval="600000" />

                <asp:Panel runat="Server" ID="pnlBreadcrumb" CssClass="breadcrumbs">
                    <asp:HiddenField runat="server" ID="hddLevel2Id" />
                    <asp:LinkButton runat="Server" ID="lnkLevel2" Visible="False"></asp:LinkButton><asp:Label runat="Server" ID="lblLevel1Spacer" Visible="False" Text=" > "></asp:Label>
                    <asp:LinkButton runat="Server" ID="lnkLevel3" Visible="False"></asp:LinkButton><asp:Label runat="Server" ID="lblLevel2Spacer" Visible="False" Text=" > "></asp:Label>
                    <asp:HiddenField runat="server" ID="hddLevel1Id" />
                    <asp:Label runat="Server" ID="lblLevel1"></asp:Label>
                </asp:Panel>
                <div class="watabela-itens analitcs-table">

                    <telerik:RadGrid ID="grdProcesses" runat="server"
                        AutoGenerateColumns="false" AllowSorting="true" GridLines="None"
                        GroupingEnabled="False" HorizontalAlign="Center" AllowMultiRowSelection="true" OnSortCommand="grid_SortCommandClick">
                        <HeaderStyle CssClass="bgHeaderAreaTrabalho" />
                        <AlternatingItemStyle CssClass="CxEntrada_linha02" />
                        <ItemStyle CssClass="CxEntrada_linha01" />
                        <MasterTableView AllowCustomSorting="true">
                            <Columns>
                                <telerik:GridTemplateColumn UniqueName="PROCESSNAME" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" Visible="false" AllowSorting="true" DataField="ProcessName" SortExpression="ProcessName">
                                    <ItemTemplate>
                                        <asp:LinkButton runat="server" ID="lnkProcessName"></asp:LinkButton>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn UniqueName="PROCESSOWNERS" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" Visible="false" AllowSorting="true">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="lblOwners" />
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridBoundColumn HeaderText="" DataField="ActiveItemsCount" UniqueName="ACTIVEITEMSCOUNT" Visible="false" />
                                <telerik:GridBoundColumn HeaderText="" DataField="ClosedItemsCount" UniqueName="CLOSEDITEMSCOUNT" Visible="false" />
                            </Columns>
                        </MasterTableView>
                        <ClientSettings EnablePostBackOnRowClick="true">
                            <Selecting AllowRowSelect="true" />
                        </ClientSettings>
                    </telerik:RadGrid>

                    <telerik:RadGrid ID="grdProcessSteps" runat="server"
                        AutoGenerateColumns="false" AllowSorting="true" GridLines="None"
                        GroupingEnabled="False" HorizontalAlign="Center" AllowMultiRowSelection="true" OnSortCommand="grid_SortCommandClick">
                        <HeaderStyle CssClass="bgHeaderAreaTrabalho" />
                        <AlternatingItemStyle CssClass="CxEntrada_linha02" />
                        <ItemStyle CssClass="CxEntrada_linha01" />
                        <MasterTableView AllowCustomSorting="true">
                            <Columns>
                                <telerik:GridTemplateColumn UniqueName="STEPNAME" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" Visible="false" AllowSorting="true" DataField="StepName" SortExpression="StepName">
                                    <ItemTemplate>
                                        <asp:LinkButton runat="server" ID="lnkStepName"></asp:LinkButton>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn UniqueName="STEPOWNERS" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" Visible="false" AllowSorting="true">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="lblOwners" />
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridBoundColumn HeaderText="" DataField="ItemsCount" UniqueName="ITEMSCOUNT" Visible="false" />
                                <telerik:GridBoundColumn HeaderText="" DataField="ExecutionCount" UniqueName="EXECUTIONCOUNT" Visible="false" />
                            </Columns>
                        </MasterTableView>
                        <ClientSettings EnablePostBackOnRowClick="true">
                            <Selecting AllowRowSelect="true" />
                        </ClientSettings>
                    </telerik:RadGrid>

                    <telerik:RadGrid ID="grdRoles" runat="server"
                        AutoGenerateColumns="false" AllowSorting="true" GridLines="None"
                        GroupingEnabled="False" HorizontalAlign="Center" AllowMultiRowSelection="true" OnSortCommand="grid_SortCommandClick">
                        <HeaderStyle CssClass="bgHeaderAreaTrabalho" />
                        <AlternatingItemStyle CssClass="CxEntrada_linha02" />
                        <ItemStyle CssClass="CxEntrada_linha01" />
                        <MasterTableView AllowCustomSorting="true">
                            <Columns>
                                <telerik:GridTemplateColumn UniqueName="ROLENAME" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" Visible="false" AllowSorting="true" DataField="RoleName" SortExpression="RoleName">
                                    <ItemTemplate>
                                        <asp:LinkButton runat="server" ID="lnkRoleName"></asp:LinkButton>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridBoundColumn HeaderText="" DataField="AttachedItemCount" UniqueName="ATTACHEDITEMCOUNT" Visible="false" />
                                <telerik:GridBoundColumn HeaderText="" DataField="UnattachedItemCount" UniqueName="UNATTACHEDITEMCOUNT" Visible="false" />
                            </Columns>
                        </MasterTableView>
                        <ClientSettings EnablePostBackOnRowClick="true">
                            <Selecting AllowRowSelect="true" />
                        </ClientSettings>
                    </telerik:RadGrid>

                    <telerik:RadGrid ID="grdRoleUsers" runat="server"
                        AutoGenerateColumns="false" AllowSorting="true" GridLines="None"
                        GroupingEnabled="False" HorizontalAlign="Center" AllowMultiRowSelection="true" OnSortCommand="grid_SortCommandClick">
                        <HeaderStyle CssClass="bgHeaderAreaTrabalho" />
                        <AlternatingItemStyle CssClass="CxEntrada_linha02" />
                        <ItemStyle CssClass="CxEntrada_linha01" />
                        <MasterTableView AllowCustomSorting="true">
                            <Columns>
                                <telerik:GridTemplateColumn UniqueName="USERNAME" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" Visible="false" AllowSorting="true" DataField="UserName" SortExpression="UserName">
                                    <ItemTemplate>
                                        <asp:LinkButton runat="server" ID="lnkUserName"></asp:LinkButton>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridBoundColumn HeaderText="" DataField="AttachedItemCount" UniqueName="ATTACHEDITEMCOUNT" Visible="false" />
                                <telerik:GridBoundColumn HeaderText="" DataField="UnattachedItemCount" UniqueName="UNATTACHEDITEMCOUNT" Visible="false" />
                            </Columns>
                        </MasterTableView>
                        <ClientSettings EnablePostBackOnRowClick="true">
                            <Selecting AllowRowSelect="true" />
                        </ClientSettings>
                    </telerik:RadGrid>

                    <telerik:RadGrid ID="grdUserRequests" runat="server"
                        AutoGenerateColumns="false" AllowSorting="true" GridLines="None"
                        GroupingEnabled="False" HorizontalAlign="Center" AllowMultiRowSelection="true" OnSortCommand="grid_SortCommandClick" OnItemDataBound="Requests_ItemDataBound">
                        <HeaderStyle CssClass="bgHeaderAreaTrabalho" />
                        <AlternatingItemStyle CssClass="CxEntrada_linha02" />
                        <ItemStyle CssClass="CxEntrada_linha01" />
                        <MasterTableView AllowCustomSorting="true">
                            <Columns>
                                <telerik:GridClientSelectColumn UniqueName="MARKER" />
                                <telerik:GridBoundColumn HeaderText="" DataField="ItemWorkflowId" UniqueName="ITEMWORKFLOWID" Visible="false" />
                                <telerik:GridTemplateColumn HeaderText="" UniqueName="ITEMNAME" Visible="false" SortExpression="ITEMNAME">
                                    <ItemTemplate>
                                        <asp:HyperLink ID="itemLink" runat="server" />
                                    </ItemTemplate>
                                    <ItemStyle HorizontalAlign="Center" />
                                </telerik:GridTemplateColumn>
                                <telerik:GridBoundColumn HeaderText="" DataField="ProcessName" UniqueName="PROCESSNAME" Visible="false" />
                                <telerik:GridBoundColumn HeaderText="" DataField="StepName" UniqueName="STEPNAME" Visible="false" />
                                <telerik:GridTemplateColumn UniqueName="STEPASSIGNEDUSERS" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" Visible="false" AllowSorting="true">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="lblOwners" />
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn UniqueName="ELAPSEDTIME" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" Visible="false" AllowSorting="true" DataField="ElapsedTime" SortExpression="ElapsedTime">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="lblElapsedTime" />
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn UniqueName="ISSTEPACTIVE" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" Visible="false" AllowSorting="true" DataField="IsStepActive" SortExpression="IsStepActive">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="lblIsStepActive" />
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn UniqueName="ISACTIVE" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" Visible="false" AllowSorting="true" DataField="IsActive" SortExpression="IsActive">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="lblIsActive" />
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn UniqueName="PROCESSSLANAME" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" Visible="false" AllowSorting="true" SortExpression="sevira_PROCESSSLANAME">
                                    <ItemTemplate>
                                        <asp:Panel runat="server" ID="pnlBackProcess">
                                            <asp:Literal runat="server" ID="lblProcessSLAName" />
                                        </asp:Panel>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn UniqueName="STEPSLANAME" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" Visible="false" AllowSorting="true" SortExpression="sevira_STEPSLANAME">
                                    <ItemTemplate>
                                        <asp:Panel runat="server" ID="pnlBackStep">
                                            <asp:Literal runat="server" ID="lblStepSLAName" />
                                        </asp:Panel>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn HeaderText="" UniqueName="HIDDENCOL" HeaderStyle-Width="1px">
                                    <ItemTemplate>
                                        <asp:HiddenField ID="hiddenitemid" runat="server" />
                                        <asp:HiddenField ID="hiddenetiid" runat="server" />
                                    </ItemTemplate>
                                    <ItemStyle HorizontalAlign="Center" />
                                </telerik:GridTemplateColumn>
                            </Columns>
                        </MasterTableView>
                        <ClientSettings AllowColumnsReorder="false" AllowDragToGroup="false" AllowColumnHide="false"
                            Selecting-AllowRowSelect="true">
                            <Selecting EnableDragToSelectRows="true" />
                        </ClientSettings>
                    </telerik:RadGrid>

                    <telerik:RadGrid ID="grdUsers" runat="server"
                        AutoGenerateColumns="false" AllowSorting="true" GridLines="None"
                        GroupingEnabled="False" HorizontalAlign="Center" AllowMultiRowSelection="true" OnSortCommand="grid_SortCommandClick">
                        <HeaderStyle CssClass="bgHeaderAreaTrabalho" />
                        <AlternatingItemStyle CssClass="CxEntrada_linha02" />
                        <ItemStyle CssClass="CxEntrada_linha01" />
                        <MasterTableView AllowCustomSorting="true">
                            <Columns>
                                <telerik:GridTemplateColumn UniqueName="USERNAME" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" Visible="false" AllowSorting="true" DataField="Username" SortExpression="Username">
                                    <ItemTemplate>
                                        <asp:LinkButton runat="server" ID="lnkUserName"></asp:LinkButton>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridBoundColumn HeaderText="" DataField="AttachedItemCount" UniqueName="ATTACHEDITEMCOUNT" Visible="false" />
                                <telerik:GridBoundColumn HeaderText="" DataField="UnattachedItemCount" UniqueName="UNATTACHEDITEMCOUNT" Visible="false" />
                            </Columns>
                        </MasterTableView>
                        <ClientSettings EnablePostBackOnRowClick="true">
                            <Selecting AllowRowSelect="true" />
                        </ClientSettings>
                    </telerik:RadGrid>
                </div>
                <div style="text-align: center; margin-top: 1em; width: 97%;">
                    <asp:Button ID="btnexport" runat="server" CssClass="wainput-execute" />
                    <asp:Button ID="btndelitems" runat="server" CssClass="wainput-execute" />
                    <asp:Button ID="btnfinishitems" CssClass="wainput-execute" runat="server" />
                    <asp:Button ID="btndetach" CssClass="wainput-execute" runat="server" />
                </div>
                <asp:HiddenField ID="PostBackHidden" runat="server"></asp:HiddenField>
                <asp:HiddenField ID="hidGrafico" runat="server"></asp:HiddenField>
                <telerik:RadToolTipManager RenderMode="Lightweight" runat="server" ID="myTooltipManager" Position="BottomCenter"
                    RelativeTo="Element" Width="240px" Height="140px" Animation="Resize" HideEvent="LeaveTargetAndToolTip" CssClass="users-tooltip" ContentScrolling="Y"
                    Skin="Default" RenderInPageRoot="true" AnimationDuration="200" EnableDataCaching="true">
                    <WebServiceSettings Method="GetToolTipData" Path="/WFContent/Modules/WFWorkflow/ItemProcesso/WorkArea.asmx" />
                </telerik:RadToolTipManager>
            </ContentTemplate>
            <Triggers>
                <asp:PostBackTrigger ControlID="btnexport" />
            </Triggers>
        </asp:UpdatePanel>
    </section>
    <uc1:ZuriLoader runat="server" id="ZuriLoader" />
    <telerik:RadWindowManager ID="CustomWindowManager" runat="server" ReloadOnShow="True" Modal="true" ShowContentDuringLoad="True"
        VisibleStatusbar="False" KeepInScreenBounds="True" DestroyOnClose="True" MinWidth="250" MinHeight="300" Width="350" Height="500">
        <Windows>
            <telerik:RadWindow ID="WFListCustom" runat="server" />
        </Windows>
    </telerik:RadWindowManager>
