﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="RelatorioDinamico.ascx.vb" Inherits="WebFoundations.WFReports.UI.RelatorioDinamico" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="System.Web.DataVisualization, Version=4.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35" Namespace="System.Web.UI.DataVisualization.Charting" TagPrefix="asp" %>
<%@ Register TagPrefix="wff" Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" %>

<script src="../../../wfresources/formsweb/Scripts/WFForms.Masks.js" type="text/javascript"></script>
<script language="javascript" type="text/javascript">
    function OpenEditor<%= Me.ClientID %>(PortalId, FormId, AreaId, CodigoAutomatico, Page, Edit) {
        window.radopen('%%PORTAL%%WFContent/Modules/WFReports/' + Page + '?Edit=' + Edit + '&CodigoAutomatico=' + CodigoAutomatico + '&PortalID=' + PortalId + '&FormID=' + FormId + '&AreaId=' + AreaId, 'EditDialog');
        return false;
    }

    function refreshGrid() {
        var hiddenField = $get('<%= Me.hidField.ClientID %>');
        if (hiddenField) {
            hiddenField.value = (new Date()).getTime();
            document.getElementById('<%= Me.hidBusca.ClientId %>').value = 'true';
            __doPostBack('<%= Me.hidField.ClientID %>', '');
        }
    }

    function AbreModalForm<%= Me.ClientID %>(PortalId, FormId, AreaId, CodigoAutomatico, Page, Edit) {
        var Retorno = window.showModalDialog('%%PORTAL%%WFContent/Modules/WFReports/' + Page + '?Edit=' + Edit + '&CodigoAutomatico=' + CodigoAutomatico + '&PortalID=' + PortalId + '&FormID=' + FormId + '&AreaId=' + AreaId, 'Preview', 'dialogHeight: 600px; dialogWidth 500px; edge: Raised; center: Yes; help: No; resizable: Yes; status: No; scroll: Auto;');
        if (Retorno == 'Ok') {
            document.getElementById('<%= Me.hidBusca.ClientId %>').value = 'true';
        }
    }


    function Valida_Numeros() {
        var eKeyCode = GetKeyCode(event);
        if (eKeyCode < 48 || eKeyCode > 57) {
            event.returnValue = false;
        }

    }

    function Formatadata(Campo, teclapres) {
        var eKeyCode = GetKeyCode(event);
        if (eKeyCode < 48 || eKeyCode > 57) {
            event.returnValue = false;
        }

        var tecla = teclapres.keyCode || teclapres.which;
        var vr = new String(Campo.value);
        vr = vr.replace("/", "");
        vr = vr.replace("/", "");
        vr = vr.replace("/", "");
        tam = vr.length + 1;
        if (tecla != 8 && tecla != 8) {
            if (tam > 0 && tam < 2) {
                Campo.value = vr.substr(0, 2);
            }
            if (tam > 2 && tam < 4) {
                Campo.value = vr.substr(0, 2) + '/' + vr.substr(2, 2);
            }
            if (tam > 4 && tam < 7) {
                Campo.value = vr.substr(0, 2) + '/' + vr.substr(2, 2) + '/' + vr.substr(4, 7);
            }
        }
    }


    function displayDiv() {
        var divstyle = new String();
        divstyle = document.getElementById("div1").style.display;
        if (divstyle.toLowerCase() == 'none' || divstyle == '') {
            document.getElementById("div1").style.display = 'block';
            document.getElementById("btnErro").value = 'Ocultar Erro';

        }
        else {
            document.getElementById("div1").style.display = 'none';
            document.getElementById("btnErro").value = 'Exibir Erro';
        }
    }

    (function () {
        //função para arrumar o colspan da paginação do reports devido a um bug no DataGrid quando usa colunas automáticas a partir do .NET 2
        var fixReportPagerColspan = function () {
            if ($("table.wfreport").has("tr.pager")) {
                var span = 3;
                $("table.wfreport tr").each(function () {
                    span = Math.max(span, $("td", this).length);
                });
                $("tr.pager td").attr("colspan", span);
            }
        };

        if ($) {
            try {
                $(document).ready(function () {
                    fixReportPagerColspan();
                });
            } catch (error) { }
        }
    })();
</script>
<input id="hidBusca" type="hidden" name="hidBusca" runat="server" />
<asp:label id="lblFormID" visible="False" runat="server" />

<h2 class="wfreport-header">
    <asp:label id="lblNomeForm" runat="server" />
    <asp:label id="lblNomeTabela" runat="server" visible="False" />
    <asp:label id="lblInvisiveis" runat="server" visible="False" />
    <asp:label id="lblTipoRelatorio" runat="server" visible="False" text="0" />
</h2>

<asp:panel id="pnlSearchBox" defaultbutton="btnBusca" runat="server" cssclass="wfreport-search wfrep-part wabusca-avancada">
    <asp:placeholder id="phRelatorioDinamico" runat="server" enableviewstate="True" />
    <div class="d-flex align-end">
        <asp:button id="btnBusca" runat="server" class="wainput-submit search" text="btnBusca" />
    </div>
</asp:panel>
<asp:panel id="pnlAddNew" defaultbutton="btnAddNew" visible="false" runat="server" cssclass="wfreport-actions actions wfrep-part mt-4">
    <asp:button causesvalidation="false" cssclass="wfreport-action add" id="btnAddNew" runat="server" />
</asp:panel>
<asp:panel id="pnlErro" runat="server" visible="false" cssclass="wfreport-error wfrep-part">
    <asp:label id="lblErro" runat="server"></asp:label>
    <p />
</asp:panel>

<asp:panel id="pnlErrosDetalhes" runat="server" visible="false" cssclass="wfreport-error-details wfrep-part">
    <input id="btnErro" type="button" value="Exibir Erro" onclick="displayDiv();" />
    <div id="div1" class="divStyle" style="display: none; width: 100%; margin: 0px auto;">
        <asp:label id="lblErrorDetalhes" runat="server"></asp:label>
    </div>
</asp:panel>

<asp:panel id="pnlReport" runat="server" cssclass="wfreport-chart wfrep-part" visible="False">
    <telerik:radhtmlchart runat="server" id="chtRelatorio" visible="true">
        <charttitle>
            <appearance position="Top" />
        </charttitle>
        <plotarea>
            <xaxis>
                <minorgridlines visible="false" />
                <majorgridlines visible="false" />
            </xaxis>
            <yaxis>
                <minorgridlines visible="false" />
            </yaxis>
        </plotarea>
    </telerik:radhtmlchart>
</asp:panel>

<div class="table-responsive">
    <asp:datagrid id="dtgRelatorio" runat="server" cssclass="wfreport results wfrep-part w-100" gridlines="None" useaccessibleheader="true" borderstyle="NotSet" allowpaging="True">
        <columns>
            <asp:templatecolumn>
                <itemstyle horizontalalign="Center" width="18px" />
                <itemtemplate>
                    <asp:linkbutton id="ibtnExcluir" commandname="Excluir" runat="server">
                        <img src="%%PORTAL%%WFResources/Common/Images/Icons/delete.png" border="0">
                        <i data-feather="trash-2"></i>
                    </asp:linkbutton>
                </itemtemplate>
            </asp:templatecolumn>
            <asp:templatecolumn>
                <itemstyle horizontalalign="Center" width="18px" />
                <itemtemplate>
                    <asp:linkbutton id="ibtnEditar" commandname="Editar" runat="server">
                        <img src="%%PORTAL%%WFResources/Common/Images/Icons/edit.png" border="0">
                        <i data-feather="edit"></i>
                    </asp:linkbutton>
                </itemtemplate>
            </asp:templatecolumn>
            <asp:templatecolumn>
                <itemstyle horizontalalign="Center" width="18px" />
                <itemtemplate>
                    <asp:linkbutton id="ibtnPreview" commandname="Preview" runat="server">
                        <img src="%%PORTAL%%WFResources/Common/Images/icons/view.png" border="0">
                        <i data-feather="eye"></i>
                    </asp:linkbutton>
                </itemtemplate>
            </asp:templatecolumn>
        </columns>
        <pagerstyle mode="NumericPages" cssclass="pager" />
    </asp:datagrid>
</div>

<wff:windowmanager id="EditWindow" runat="server">
    <windows>
        <telerik:radwindow id="EditDialog" runat="server" height="1024px" width="764px" reloadonshow="false" modal="true" />
    </windows>
</wff:windowmanager>
<asp:hiddenfield id="hidField" runat="server" />

<section class="wfreport-actions actions wfrep-part mt-4">
    <asp:button causesvalidation="false" cssclass="wfreport-action txt" id="btnGerartxt" runat="server" />
    <asp:button causesvalidation="false" cssclass="wfreport-action csv" id="btnGerarcsv" runat="server" />
    <asp:button causesvalidation="false" cssclass="wfreport-action xls" id="btnGerarexcel" runat="server" />
</section>
