﻿<%@ Page Language="vb" MasterPageFile="~/wfcontent/modules/moduleconfig.master" AutoEventWireup="false" CodeBehind="GeraRelatorio.aspx.vb" Inherits="WebFoundations.WFReports.UI.GeraRelatorio" %>

<%@ Register Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" TagPrefix="wf" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="WebFoundations.WFPortal.Controls" Namespace="WebFoundations.WFPortal.Controls.Content" TagPrefix="WFC" %>

<asp:Content runat="server" ContentPlaceHolderID="TagHead">
    <style type="text/css">
        .fields .options > .checkbox {
            display: inline-block;
            margin-right: 1em;
        }

        .divStyle {
            width: 100%;
            margin: 0px auto;
        }

        .filters select, .filters input {
            margin-right: .5em;
        }

        .grid td > input[type=text], .grid td > select {
            width: 100%;
            display: inline-block;
            min-width: 6em;
        }

            .grid td > input[type=text][style*=width] {
                min-width: 0;
            }

        .grid td > input[type=date], .grid td > input.input-date {
            width: 100%;
            text-align: center;
        }

        .grid td input[type=checkbox] {
            display: block;
            margin: 0 auto;
        }

        .grid .center {
            text-align: center;
        }
    </style>

    <script type="text/javascript">
        function displayDiv() {
            var divstyle = new String();
            divstyle = document.getElementById("div1").style.display;
            if (divstyle.toLowerCase() == "none" || divstyle == "") {
                document.getElementById("div1").style.display = "block";
                document.getElementById("btnErro").value = "Ocultar Erro";
            } else {
                document.getElementById("div1").style.display = "none";
                document.getElementById("btnErro").value = "Exibir Erro";
            }

        }
    </script>

    <script type="text/javascript">
        function Valida_Numeros() {
            var eKeyCode = GetKeyCode(event);
            if (eKeyCode < 48 || eKeyCode > 57) {
                event.returnValue = false;
            }

        }
        function checkLength(len, ele) {
            var fieldLength = ele.value.length;
            if (fieldLength <= len) {
                return true;
            }
            else {
                var str = ele.value;
                str = str.substring(0, str.length - 1);
                ele.value = str;
            }
        }

        function Numeros(evt) {
            var theEvent = evt || window.event;

            if (theEvent.type === 'paste') {
                key = event.clipboardData.getData('text/plain');
            } else {
                var key = theEvent.keyCode || theEvent.which;
                key = String.fromCharCode(key);
            }
            var regex = /[0-9]|\./;
            if ((!regex.test(key)) && (theEvent.keyCode != 8)) {
                theEvent.returnValue = false;
                if (theEvent.preventDefault) theEvent.preventDefault();
            }
        }

        function Formatadata(Campo, teclapres) {
            var eKeyCode = GetKeyCode(event);
            if (eKeyCode < 48 || eKeyCode > 57) {
                event.returnValue = false;
            }

            var tecla = teclapres.keyCode || teclapres.which;
            var vr = new String(Campo.value);
            vr = vr.replace("/", "");
            vr = vr.replace("/", "");
            vr = vr.replace("/", "");
            tam = vr.length + 1;
            if (tecla != 8 && tecla != 8) {
                if (tam > 0 && tam < 2)
                    Campo.value = vr.substr(0, 2);
                if (tam > 2 && tam < 4)
                    Campo.value = vr.substr(0, 2) + '/' + vr.substr(2, 2);
                if (tam > 4 && tam < 7)
                    Campo.value = vr.substr(0, 2) + '/' + vr.substr(2, 2) + '/' + vr.substr(4, 7);
            }
        }

        function CloseAndRebind() {
            GetRadWindow().Close();
            GetRadWindow().BrowserWindow.refreshGrid();
        }
        function GetRadWindow() {
            var oWindow = null;
            if (window.radWindow) oWindow = window.radWindow; //Will work in Moz in all cases, including clasic dialog
            else if (window.frameElement.radWindow) oWindow = window.frameElement.radWindow; //IE (and Moz az well)
            return oWindow;
        }
    </script>
</asp:Content>

<asp:Content runat="server" ContentPlaceHolderID="MainContent">
    <wf:extendedupdatepanel id="configpnl" runat="server" tag="main" cssclass="wf-reports-config">
        <contenttemplate>
            <WFC:editormanager id="EditorManager1" runat="server" />
            <asp:ValidationSummary ID="summary" runat="server" />

            <telerik:radtabstrip id="navegacao" runat="server" autopostback="true" multipageid="radMultiPage" selectedindex="0">
                <tabs>
                    <telerik:radtab id="tabconfig" text="Configurações" />
                    <telerik:radtab id="tabfiltros" text="Filtros" />
                    <telerik:radtab id="tabcampos" text="Campos" />
                    <telerik:radtab id="tabgraficos" text="Gráfico" />
                </tabs>
            </telerik:radtabstrip>

            <telerik:radmultipage id="radMultiPage" runat="server" selectedindex="0">
                <telerik:radpageview id="PageConfiguracoes" runat="server">
                    <asp:Panel ID="pnlError" runat="server" Visible="false">
                        <asp:Label ID="lblError" runat="server" />
                        <input id="btnErro" type="button" value="Exibir Erro" onclick="displayDiv()" />
                        <div id="div1" class="divStyle" style="display: none;">
                            <asp:Label ID="lblErroDetalhes" runat="server" />
                        </div>
                    </asp:Panel>
                    <asp:Panel ID="pnlConfiguracoes" runat="server" CssClass="fields">
                        <div class="options">
                            <asp:Label ID="lblRelatorioEm" runat="server" Text="Criar relatório baseado em: " />
                            <asp:RadioButton ID="rdbFormulario" CssClass="checkbox" runat="server" Text="Formulário" GroupName="TipoFormulario" Checked="true" AutoPostBack="true" />
                            <asp:RadioButton ID="rdbProcedure" CssClass="checkbox" runat="server" Text="Procedure" GroupName="TipoFormulario" AutoPostBack="true" />
                        </div>
                        <asp:Panel ID="pnlFormulario" runat="server">
                            <asp:Label ID="lblFormulario" runat="server" />
                            <asp:DropDownList ID="ddlForm" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlForm_SelectedIndexChanged" />
                            <asp:RequiredFieldValidator ID="rfvFormulario" runat="server" ControlToValidate="ddlForm" InitialValue="-1" Text="*" ErrorMessage="Selecione um formulário!" Display="dynamic" />
                        </asp:Panel>
                        <asp:PlaceHolder ID="pnlProcedure" runat="server">
                            <label>
                                <asp:Label ID="lblConnection" runat="server" />
                                <asp:DropDownList ID="ddlConnection" runat="server" AutoPostBack="true" />
                            </label>
                            <label>
                                <asp:Label ID="lblStoredProcedure" runat="server" />
                                <asp:DropDownList ID="ddlProcedure" AutoPostBack="True" runat="server" OnSelectedIndexChanged="ddlProcedure_SelectedIndexChanged" />
                            </label>
                            <asp:Panel ID="pnlOld" runat="server" Visible="false">
                                <asp:TextBox ID="txtParametros" runat="server" Width="300" />
                            </asp:Panel>
                        </asp:PlaceHolder>
                        <label>
                            <asp:Label ID="lbltituloreport" runat="server" />
                            <asp:TextBox ID="txttituloreport" runat="server" />
                        </label>
                        <asp:Panel ID="pnlEdicao" runat="server">
                            <div>
                                <asp:Label ID="lblGrupos" runat="server" />
                                <wf:accesslist id="listaacesso" disableitems="-7;-6;-5;-4;-3;-2;" enableuser="true" enablerole="true" enablerolegroup="true" runat="server" />
                            </div>
                            <div>
                                <asp:Label ID="lblGruposExclusao" runat="server" />
                                <wf:accesslist id="ListaAcessoExclusao" disableitems="-7;-6;-5;-4;-3;-2;" enableuser="true" enablerole="true" enablerolegroup="true" runat="server" />
                            </div>
                        </asp:Panel>
                    </asp:Panel>
                </telerik:radpageview>
                <telerik:radpageview id="PageFiltros" runat="server">
                    <asp:PlaceHolder ID="pnlFiltro" runat="server">
                        <div class="fields no-columns">
                            <div>
                                <asp:Label ID="lblPreFiltros" runat="server" />
                                <p class="filters">
                                    <asp:DropDownList ID="dplCampos" runat="server" />

                                    <asp:DropDownList ID="dplOperador" runat="server">
                                        <asp:ListItem Value="1">&gt;</asp:ListItem>
                                        <asp:ListItem Value="2">&lt;</asp:ListItem>
                                        <asp:ListItem Value="3">&gt;=</asp:ListItem>
                                        <asp:ListItem Value="4">&lt;=</asp:ListItem>
                                        <asp:ListItem Value="5">=</asp:ListItem>
                                        <asp:ListItem Value="6">&lt;&gt;</asp:ListItem>
                                    </asp:DropDownList>

                                    <asp:TextBox ID="txtComparador" runat="server" />

                                    <asp:Label ID="lblComparador" runat="server" Visible="False" Font-Size="X-Small"
                                        Font-Bold="True" ForeColor="Red" />
                                    <asp:DropDownList ID="ddlTipoComparacao" runat="server">
                                        <asp:ListItem Value="T">lblTexto</asp:ListItem>
                                        <asp:ListItem Value="N">lblN&#250;mero</asp:ListItem>
                                        <asp:ListItem Value="D">lblData</asp:ListItem>
                                        <asp:ListItem Value="M">lblMonet&#225;rio</asp:ListItem>
                                    </asp:DropDownList>

                                    <asp:Button ID="btnInserirFiltro" runat="server" Text="btnInserirFiltro" />
                                </p>
                            </div>
                        </div>
                        <asp:DataGrid ID="dtgFiltros" runat="server" Visible="False" CssClass="grid" GridLines="None" UseAccessibleHeader="true" BorderStyle="NotSet" AutoGenerateColumns="False" ShowHeader="False">
                            <Columns>
                                <asp:TemplateColumn>
                                    <ItemStyle Width="10px"></ItemStyle>
                                    <ItemTemplate>
                                        <asp:ImageButton ID="btnExcluir" runat="server" ImageUrl="~/WFResources/Common/Images/Icons/delete.png"
                                            CommandName="Exclui" CommandArgument='<%# Container.DataItem("FIL_N_CODIGO") %>' />
                                    </ItemTemplate>
                                </asp:TemplateColumn>
                                <asp:BoundColumn DataField="FIL_C_CAM_C_ALIAS"></asp:BoundColumn>
                                <asp:BoundColumn DataField="FIL_C_OPERACAO"></asp:BoundColumn>
                                <asp:BoundColumn DataField="FIL_C_VALOR_COMPARACAO"></asp:BoundColumn>
                            </Columns>
                        </asp:DataGrid>
                    </asp:PlaceHolder>
                    <asp:Panel ID="pnlParametros" runat="server">
                        <asp:Panel ID="pnlParamErro" runat="server" Visible="false">
                            <asp:Label ID="lblErrosParametros" runat="server" />
                        </asp:Panel>
                        <asp:DataGrid ID="dtgParametros" CssClass="grid" GridLines="None" UseAccessibleHeader="true" BorderStyle="NotSet" runat="server" AutoGenerateColumns="False">
                            <HeaderStyle HorizontalAlign="Center" />
                            <Columns>
                                <asp:BoundColumn DataField="Parametro" HeaderText="Nome" />
                                <asp:BoundColumn DataField="TipoParametro" HeaderText="Tipo" />
                                <asp:BoundColumn DataField="ParametroDefault" HeaderText="CampoNulo" Visible="false" />
                                <asp:TemplateColumn HeaderText="Filtro">
                                    <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                                    <ItemTemplate>
                                        <asp:CheckBox ID="pchkFiltro" runat="server" />
                                    </ItemTemplate>
                                </asp:TemplateColumn>
                                <asp:TemplateColumn HeaderText="Título">
                                    <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                                    <ItemTemplate>
                                        <asp:TextBox ID="ptxtTitulo" runat="server" MaxLength="50" />
                                    </ItemTemplate>
                                </asp:TemplateColumn>
                                <asp:TemplateColumn HeaderText="Valor Default">
                                    <ItemStyle HorizontalAlign="Center" />
                                    <ItemTemplate>
                                        <asp:TextBox ID="ptxtValorDefault" runat="server" />
                                        <asp:CustomValidator ID="cvValidator" runat="server" Display="dynamic" />
                                    </ItemTemplate>
                                </asp:TemplateColumn>
                            </Columns>
                        </asp:DataGrid>
                    </asp:Panel>
                </telerik:radpageview>
                <telerik:radpageview id="PageCampos" runat="server">
                    <asp:Panel ID="pnlCampos" runat="server" Visible="False">
                        <p>
                            <asp:Label ID="lblCampos" runat="server" />
                            <asp:Label ID="lblNomeFormulario" runat="server" Visible="True" />
                            <asp:Label ID="lblrelatorioId" runat="server" Visible="False" Text="0" />
                            <asp:Label ID="lblTipoRelatorio" runat="server" Visible="False" />
                        </p>
                        <div class="table-responsive">
                            <asp:DataGrid ID="dtgCampos" runat="server" Visible="False" AutoGenerateColumns="False" GridLines="None" UseAccessibleHeader="true" BorderStyle="NotSet">
                                <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                                <Columns>
                                    <asp:BoundColumn Visible="False" HeaderText="TIPOCAMPO" />
                                    <asp:BoundColumn Visible="False" HeaderText="VALIDACAO" />
                                    <asp:BoundColumn Visible="False" HeaderText="CODIGO" />
                                    <asp:BoundColumn DataField="Name" HeaderText="lblCAMPO" />
                                    <asp:TemplateColumn HeaderText="lblMOSTRAR">
                                        <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                                        <ItemTemplate>
                                            <asp:CheckBox ID="chkMostra" runat="server" />
                                        </ItemTemplate>
                                    </asp:TemplateColumn>
                                    <asp:TemplateColumn HeaderText="lblT&#205;TULO">
                                        <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                                        <ItemTemplate>
                                            <asp:TextBox Width="150" ID="txtTitulo" runat="server" MaxLength="50" />
                                        </ItemTemplate>
                                    </asp:TemplateColumn>
                                    <asp:TemplateColumn HeaderText="lblGRUPO">
                                        <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                                        <ItemTemplate>
                                            <asp:DropDownList DataSource="<%# PopulaComboGrupos() %>" DataTextField="Name" DataValueField="Id"
                                                ID="dplGrupo" runat="server">
                                            </asp:DropDownList>
                                        </ItemTemplate>
                                    </asp:TemplateColumn>
                                    <asp:TemplateColumn HeaderText="lblORDENAR">
                                        <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                                        <ItemTemplate>
                                            <asp:TextBox Width="35" ID="txtOrderBy" runat="server" MaxLength="3" />
                                        </ItemTemplate>
                                    </asp:TemplateColumn>
                                    <asp:TemplateColumn HeaderText="lblLARGURA">
                                        <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                                        <ItemTemplate>
                                            <asp:TextBox Width="40" ID="txtLargura" runat="server" MaxLength="3" />
                                            %
                                        </ItemTemplate>
                                    </asp:TemplateColumn>
                                    <asp:TemplateColumn HeaderText="lblRANGE">
                                        <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                                        <ItemTemplate>
                                            <asp:CheckBox ID="chkRange" runat="server" />
                                        </ItemTemplate>
                                    </asp:TemplateColumn>
                                    <asp:TemplateColumn HeaderText="lblBUSCA">
                                        <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                                        <ItemTemplate>
                                            <asp:CheckBox ID="chkBusca" runat="server" />
                                        </ItemTemplate>
                                    </asp:TemplateColumn>
                                    <asp:TemplateColumn HeaderText="lblFILTRAR">
                                        <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                                        <ItemTemplate>
                                            <asp:CheckBox ID="chkFiltro" runat="server" />
                                        </ItemTemplate>
                                    </asp:TemplateColumn>
                                    <asp:TemplateColumn SortExpression="CAM_N_ORDEM" HeaderText="lblORDENA&#199;&#195;O">
                                        <HeaderStyle HorizontalAlign="Center" />
                                        <ItemStyle HorizontalAlign="Center" />
                                        <ItemTemplate>
                                            <asp:ImageButton ID="btnSobeCampo" ImageUrl="~/WFResources/Common/Images/icons/move-up.png"
                                                runat="server" CommandName="Sobe" />
                                            <asp:ImageButton ID="btnDesceCampo" ImageUrl="~/WFResources/Common/Images/icons/move-down.png"
                                                runat="server" CommandName="Desce" />
                                        </ItemTemplate>
                                    </asp:TemplateColumn>
                                    <asp:BoundColumn HeaderText="ORDEM" Visible="False" />
                                    <asp:BoundColumn HeaderText="TipoCampo" Visible="False" />
                                </Columns>
                            </asp:DataGrid>
                        </div>

                        <asp:Label ID="lblNomedaProcedure" runat="server" Visible="True"></asp:Label>
                        <asp:DataGrid ID="dtgProcedure" runat="server" Visible="False" AutoGenerateColumns="False" CssClass="grid" GridLines="None" UseAccessibleHeader="true" BorderStyle="NotSet">
                            <Columns>
                                <asp:BoundColumn DataField="Nome" HeaderText="lblCAMPO" />
                                <asp:TemplateColumn HeaderText="lblMOSTRAR">
                                    <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                                    <ItemTemplate>
                                        <asp:CheckBox ID="pchkMostra" runat="server" />
                                    </ItemTemplate>
                                </asp:TemplateColumn>
                                <asp:TemplateColumn HeaderText="lblT&#205;TULO">
                                    <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                                    <ItemTemplate>
                                        <asp:TextBox ID="ptxtTitulo" runat="server" MaxLength="50" />
                                    </ItemTemplate>
                                </asp:TemplateColumn>
                                <asp:TemplateColumn HeaderText="lblGRUPO">
                                    <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                                    <ItemTemplate>
                                        <asp:DropDownList DataSource="<%# PopulaComboGrupos() %>" DataTextField="Name" DataValueField="Id" ID="pdplGrupo" runat="server">
                                        </asp:DropDownList>
                                    </ItemTemplate>
                                </asp:TemplateColumn>
                                <asp:TemplateColumn HeaderText="lblLARGURA">
                                    <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                                    <ItemTemplate>
                                        <asp:TextBox Width="40" ID="ptxtLargura" runat="server" MaxLength="3" />
                                        %
                                    </ItemTemplate>
                                </asp:TemplateColumn>
                            </Columns>
                        </asp:DataGrid>
                        <label>
                            <asp:Label ID="lblNumLinhas" runat="server" />
                            <asp:TextBox ID="txtPaginacao" runat="server" Width="60px" MaxLength="2" />
                            <asp:CompareValidator ID="cpvPginacao" runat="server" Display="Dynamic" ControlToValidate="txtPaginacao"
                                ErrorMessage="* O valor deve ser um numero inteiro" Font-Size="X-Small" Font-Bold="True"
                                Operator="DataTypeCheck" Type="Integer" />
                        </label>
                    </asp:Panel>
                </telerik:radpageview>
                <telerik:radpageview id="PageGraficos" runat="server">
                    <asp:CheckBox ID="chkExibeGraficos" runat="server" AutoPostBack="true" />
                    <asp:Panel ID="pnlGraficos" runat="server" Visible="False" CssClass="fields">
                        <label>
                            <asp:Label ID="lblTitulo" runat="server" />
                            <asp:TextBox ID="txtTitulo" runat="server" />
                            <asp:RequiredFieldValidator ID="rfvTitulo" runat="server" ControlToValidate="txtTitulo" Text="*" ErrorMessage="Digite o título!" Display="dynamic" />
                        </label>
                        <label>
                            <asp:Label ID="lblTipoGrafico" runat="server" />
                            <asp:DropDownList ID="ddlTipoGrafico" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlTipo_SelectedIndexChanged" />
                        </label>
                        <label>
                            <asp:Label ID="lblLargura" runat="server" />
                            <asp:TextBox ID="txtLargura" runat="server" onfocus="this.select();" onmouseup="return false;" onKeyPress="javascript:return Numeros(event);" onInput="checkLength(4,this);" />
                            <asp:RequiredFieldValidator ID="rfvLargura" runat="server" ControlToValidate="txtLargura"
                                Text="*" ErrorMessage="Digite a largura!" Display="dynamic" />
                        </label>
                        <label>
                            <asp:Label ID="lblAltura" runat="server" />

                            <asp:TextBox ID="txtAltura" runat="server" onfocus="this.select();" onmouseup="return false;" onKeyPress="javascript:return Numeros(event);" onInput="checkLength(4,this);" />
                        </label>
                        <asp:CheckBox CssClass="checkbox" ID="chkMostrarValores" runat="server" />
                        <label>
                            <asp:Label ID="lblCampoNome" runat="server" />
                            <asp:DropDownList ID="ddlCampoNome" runat="server" />
                        </label>
                        <label>
                            <asp:Label ID="lblCampoValor" runat="server" />
                            <asp:DropDownList ID="ddlCampoValor" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlValue_SelectedIndexChanged" />
                        </label>
                        <label>
                            <asp:Label ID="lblPosicaoLegenda" runat="server" />
                            <asp:DropDownList ID="ddlPosicaoLegenda" runat="server" />
                        </label>
                        <asp:PlaceHolder ID="pnlFuncaoAgrupamento" runat="server">
                            <label>
                                <asp:Label ID="lblFuncaoAgrupamento" runat="server" />
                                <asp:DropDownList ID="ddlFuncaoAgrupamento" runat="server" />
                            </label>
                        </asp:PlaceHolder>
                        <asp:PlaceHolder ID="pnlCampoAgrupamento" runat="server">
                            <label>
                                <asp:Label ID="lblCampoAgrupamento" runat="server" />
                                <asp:DropDownList ID="ddlCampoAgrupamento" runat="server" />
                            </label>
                        </asp:PlaceHolder>
                    </asp:Panel>
                </telerik:radpageview>
            </telerik:radmultipage>

            <asp:Label ID="lblErro" runat="server" EnableViewState="False" />

            <section class="actions">
                <asp:Button ID="btnok" runat="server" CssClass="button" />
                <input id="btncancel" type="button" class="button" onclick="CancelEdit();" runat="server" />
            </section>
        </contenttemplate>
    </wf:extendedupdatepanel>
</asp:Content>

