﻿<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFContent/Modules/ModuleConfig.Master" CodeBehind="UserBookConfig.aspx.vb" Inherits="WebFoundations.WFPortal.BaseModules.UI.UserBookConfig" ViewStateMode="Enabled" %>

<%@ Register Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" TagPrefix="wf" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register Assembly="WebFoundations.WFPortal.Controls" Namespace="WebFoundations.WFPortal.Controls.Content" TagPrefix="WFC" %>
<%@ Register Src="~/WFContent/Modules/UserBook/UserList.ascx" TagPrefix="wf" TagName="UserList" %>
<%@ Register Src="~/WFContent/Modules/UserBook/UserListEdit.ascx" TagPrefix="wf" TagName="UserListEdit" %>


<asp:Content ContentPlaceHolderID="TagHead" runat="server">
    <style>
        body {
            min-height: 100vh;
        }

        main {
            display: flex;
            -ms-flex-direction: column;
            -webkit-flex-direction: column;
            flex-direction: column;
            min-height: calc(100vh - 2em);
        }

        .config-page {
            flex: 1 1 auto;
        }

        .book-fields input[type=text], .book-fields select {
            width: 100%;
        }

        .book-fields td.display, .book-fields td.link {
            text-align: center;
        }

        tr.image td.rgDragCol a, tr.image input.title {
            display: none;
        }

        ol.users{
            padding:0;
            margin:1em 0;
        }

        ol.users li{
            list-style:none;
            padding:.2em 0;
        }

        ol.users li a{
            margin:0 .5em 0 0;
        }

        ol.users li:nth-child(2n+1){
            background:#ededed;
        }
    </style>
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <wf:ExtendedUpdatePanel runat="server" tag="main" CssClass="wf-userbook-config">
        <contenttemplate>
            <WFC:EditorManager ID="EditorManager1" runat="server" />

            <telerik:RadTabStrip CssClass="config-tabs" ID="configTabs" runat="server" Orientation="HorizontalTop" MultiPageID="configPages" AutoPostBack="True" SelectedIndex="0">
                <Tabs>
                    <telerik:RadTab runat="server" Text="Campos" Value="fields" ID="tabFields" />
                    <telerik:RadTab runat="server" Text="Modo de Exibição" Value="mode" ID="tabMode" />
                    <telerik:RadTab runat="server" Text="Ítens" Value="items" ID="tabItems" Visible="false"/>
                </Tabs>
            </telerik:RadTabStrip>

            <telerik:RadMultiPage CssClass="config-page" runat="server" ID="configPages" SelectedIndex="0">
                <telerik:RadPageView runat="server" ID="pgFields">
                    <telerik:RadGrid runat="server" ID="grdFields" CssClass="book-fields" AllowPaging="False" AutoGenerateColumns="false">
                        <MasterTableView>
                            <Columns>
                                <telerik:GridDragDropColumn HeaderStyle-Width="18px" UniqueName="drag" />
                                <telerik:GridTemplateColumn UniqueName="name" >
                                    <ItemTemplate>
                                        <asp:HiddenField runat="server" id="hdKey" />
                                        <asp:Literal runat="server" id="litName" />
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn ItemStyle-CssClass="display" UniqueName="list">
                                    <ItemTemplate>
                                        <asp:Checkbox runat="server" id="chkList" />
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn ItemStyle-CssClass="display" UniqueName="detail" >
                                    <ItemTemplate>
                                        <asp:Checkbox runat="server" id="chkDetail" />
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn ItemStyle-CssClass="link" UniqueName="link" >
                                    <ItemTemplate>
                                        <asp:DropDownList runat="server" ID="ddlLink" />
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn UniqueName="title" >
                                    <ItemTemplate>
                                        <asp:Textbox runat="server" CssClass="title" id="txtTitle" />
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                            </Columns>
                        </MasterTableView>
                                <ClientSettings AllowRowsDragDrop="True" AllowColumnsReorder="false" ReorderColumnsOnClient="false">
                                    <Selecting AllowRowSelect="true" EnableDragToSelectRows="false" />
                                    <Scrolling AllowScroll="false"/>
                                </ClientSettings>
                    </telerik:RadGrid>
                </telerik:RadPageView>
                <telerik:RadPageView runat="server" ID="pgMode">
                    <div class="fields">
                        <div>
                            <asp:checkbox runat="server" id="chkCustomList" cssclass="checkbox" text="Usar lista personalizada" autopostback="true" />
                            <asp:label runat="server" id="lblCustomList" text="Permite cadastrar a lista a ser exibida ao invés de usar a lista de usuários do Zuri." />
                        </div>
                        <div><asp:checkbox cssclass="checkbox" id="chkAllowSearch" runat="server" text="Exibir campo de busca" /></div>
<%--                        <div><asp:checkbox cssclass="checkbox" id="chkListInPopup" runat="server" text="Exibir lista em nova janela" /></div>--%>
                        <div><asp:checkbox cssclass="checkbox" id="chkListInactive" runat="server" text="Exibir usuários inativos" /></div>
                        <div><asp:checkbox cssclass="checkbox" id="chkListSystem" runat="server" text="Exibir usuários do sistema" /></div>
                        <div><asp:checkbox cssclass="checkbox" id="chkListOnLoad" runat="server" text="Exibir lista ao carregar" /></div>
                        <label>
                            <asp:label runat="server" text="Agrupamento" />
                            <asp:dropdownlist id="ddlGrouping" runat="server" />
                        </label>
                    </div>
                </telerik:RadPageView>
                <telerik:RadPageView runat="server" ID="pgItems">
                    <wf:UserListEdit runat="server" id="itemEditor" />
                    <wf:UserList id="itemsList" runat="server" />
                </telerik:RadPageView>
            </telerik:RadMultiPage>

            <section class="actions">
                <asp:button runat="server" id="btOk" text="OK" />
            </section>
        </contenttemplate>
    </wf:ExtendedUpdatePanel>
</asp:Content>
