<%@ Page Language="vb" MasterPageFile="ModuleConfig.master" AutoEventWireup="false" CodeBehind="ModuleConfig.aspx.vb" Inherits="WebFoundations.WFPortal.UI.ModuleConfig" %>
<%@ Register Src="~/WFAdmin/TagHeadAdmin.ascx" TagPrefix="wf" TagName="TagHeadAdmin" %>
<%@ Register Assembly="WebFoundations.ServerControls" Namespace="WebFoundations.ServerControls" TagPrefix="cc1" %>
<%@ Register Assembly="WebFoundations.WFPortal.Controls" Namespace="WebFoundations.WFPortal.Controls.Content" TagPrefix="WFC" %>
<%@ Register Src="~/WFControls/IndexControl/Indexer.ascx" TagName="Indexer" TagPrefix="uc3" %>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <WFC:EditorManager ID="EditorManager1" runat="server" />
    <div class="fields">
        <label>
            <asp:Label ID="lbltitle" runat="server" />
            <asp:TextBox ID="txttitle" runat="server" MaxLength="100" />
        </label>
        <label>
            <asp:Label ID="lblcss" runat="server" />
            <asp:TextBox ID="txtcss" runat="server" MaxLength="255" />
        </label>
        <label>
            <asp:Label ID="lblheight" runat="server" />
            <asp:TextBox ID="txtheight" runat="server" MaxLength="10" />
        </label>
        <label>
            <asp:Label ID="lblwidth" runat="server" />
            <asp:TextBox ID="txtwidth" runat="server" MaxLength="10" />
        </label>
        <div>
            <asp:Label ID="lblstart" runat="server" />
            <div>
                <div style="float: left; margin-right: 4px;">
                    <cc1:DatePicker ID="dpkstart" MinToday="true" runat="server" />
                </div>
                <asp:TextBox ID="txtstarttime" runat="server" MaxLength="5" Width="80px" placeholder="HH:MM"/>               
                <asp:RegularExpressionValidator ID="vlstarttime" runat="server" ControlToValidate="txtstarttime"
                    Display="Dynamic" ValidationExpression="([0-1]?[0-9]|2[0-3]):([0-5]?[0-9])" />
            </div>
        </div>
        <div>
            <asp:Label ID="lblend" runat="server" />
            <div>
                <div style="float: left; margin-right: 4px;">
                    <cc1:DatePicker ID="dpkend" MinToday="true" runat="server" />
                </div>
                <asp:TextBox ID="txtendtime" runat="server" MaxLength="5" Width="80px" placeholder="HH:MM" />                
                <asp:RegularExpressionValidator ID="vlendtime" runat="server" ControlToValidate="txtendtime"
                    Display="Dynamic" ValidationExpression="([0-1]?[0-9]|2[0-3]):([0-5]?[0-9])" />
            </div>
        </div>
        <label>
            <asp:Label ID="lblcontainer" runat="server" />
            <asp:DropDownList ID="lstcontainer" runat="server" />
        </label>
        <asp:PlaceHolder ID="indexcontrol" runat="server">
            <label>
                <asp:Label ID="lblindex" runat="server" />
                <uc3:Indexer ID="idxIndexer" runat="server" />
            </label>
        </asp:PlaceHolder>
        <div>
            <asp:Label ID="lblreaders" runat="server" />
            <cc1:AccessList ID="lstreaders" AnonymousValue="-6" EnableRole="true" EnableRoleGroup="true" runat="server" />
        </div>
        <div>
            <asp:Label ID="lbleditors" runat="server" />
            <cc1:AccessList ID="lsteditors" EnableRole="true" EnableRoleGroup="true" runat="server" />
        </div>
    </div>
    <section class="actions">
        <asp:Button ID="btnok" runat="server" CssClass="button" />
        <input id="btncancel" type="button" class="button" runat="server" onclick="javascript: CancelEdit();" />
    </section>

</asp:Content>
