﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="MenuView.ascx.vb" Inherits="WebFoundations.WFPortal.BaseModules.UI.MenuView" %>

<script>
    function onClickFather(menu, item) {
        item.classList.toggle('open');
        if (item.classList.contains('open')) {
            openAllNeedChildren(menu, item, 500);
        } else {
            closeAllChildren(menu, item, 500);
        }
    }

    function closeAllChildren(menu, item, delay = 0) {
        const children = menu.querySelectorAll(`li[data-father="${item.getAttribute('data-identifier')}"]`);
        children.forEach(child => {
            child.style.whiteSpace = 'nowrap';
            child.classList.remove('show');
            setTimeout(() => {
                child.style.display = 'none';
            }, delay);
            if (menu.querySelector(`li[data-father="${child.getAttribute('data-identifier')}"]`)) {
                return closeAllChildren(menu, child, delay);
            }
        })
    }

    function openAllNeedChildren(menu, item, delay = 0) {
        const children = menu.querySelectorAll(`li[data-father="${item.getAttribute('data-identifier')}"]`);
        children.forEach(child => {
            child.style.display = 'list-item';
            setTimeout(() => {
                child.classList.add('show');
            }, 2);
            setTimeout(() => {
                child.style.whiteSpace = 'unset';
            }, delay);

            if (child.classList.contains('open')) {
                openAllNeedChildren(menu, child, delay);
            }
        })
    }

    function openFathers(menu, identifier) {
        const item = menu.querySelector(`li[data-identifier="${identifier}"]`);
        item.classList.add('open');
        const children = menu.querySelectorAll(`li[data-father="${identifier}"]`);
        children.forEach(child => {
            child.style.display = 'list-item';
            child.classList.add('show');
        })
        if (item.getAttribute('data-father') != "") {
            return openFathers(menu, item.getAttribute('data-father'));
        }
    }

    document.addEventListener("DOMContentLoaded", function (event) {
        const menus = document.querySelectorAll('ul.wfmenu.internal');

        menus.forEach(menu => {
            const items = menu.querySelectorAll('li');

            items.forEach(item => {
                let currentOpen = false;

                const children = menu.querySelectorAll(`li[data-father="${item.getAttribute('data-identifier')}"]`);

                if (children.length > 0) {
                    item.addEventListener('click', e => {
                        e.preventDefault();
                        onClickFather(menu, item);
                    })
                }
                children.forEach(child => {
                    if (child.querySelector('a')?.classList.contains('atual')) {
                        currentOpen = true;
                        openFathers(menu, item.getAttribute('data-identifier'));
                    } else if (!currentOpen) {
                        child.style.display = 'none';
                    }
                })
            })
        })
    });
</script>
