﻿<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/AdmMaster.Master" CodeBehind="RepositorioRegras.aspx.vb" Inherits="WebFoundations.WFWorkflow.UI.RepositorioRegras" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TagHead" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ActionContent" runat="server">
    <ul class="list-of-actions">
        <li>
            <a id="open-modal-edit-create" class="add" href="#">
                <asp:Literal ID="lnkadd" runat="server" />
            </a>
        </li>
        <li>
            <a id="open-delete-dialog" class="delete" href="#">
                <asp:Literal ID="lnkdelete" runat="server" />
            </a>
        </li>
        <li>
            <a class="download" href="#">
                <asp:Literal ID="lnkdownload" runat="server" />
            </a>
        </li>
        <li>
            <a class="upload" href="#">
                <asp:Literal ID="lnkupload" runat="server" />
            </a>
        </li>
    </ul>
    <script>
        actionIcons.init();
    </script>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="FilterContent" runat="server">
    <div class="container-filtro">
        <fieldset>
            <div>
                <asp:Label ID="lblsubportal" runat="server" />
                <asp:Label ID="lblarea" runat="server" />
                <asp:Label ID="lbltitulo" runat="server" />
            </div>
            <div class="inputs">
                <select id="subportal-select">
                </select>
                <select id="area-select">
                </select>
                <input type="text" id="title" value="" />
            </div>
        </fieldset>
        <button id="search-rules-button">
            <asp:Literal Text="Buscar" runat="server" />
        </button>
    </div>
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="MainContent" runat="server">
    <div id="delete-dialog" class="wf-dialog">
        <div class="dialog-header">
            <a id="close-delete-dialog" href="#">
                <i data-feather="x"></i>
            </a>
        </div>
        <div class="dialog-body">
            <h2>
                <asp:Literal Text="Confirma a exclusão do registro?" runat="server" />
            </h2>
        </div>
        <div class="dialog-footer">
            <button class="secondary" id="cancel-delete">
                <asp:Literal ID="cancellabel1" runat="server" />
            </button>
            <button id="confirm-delete-button">
                <asp:Literal ID="confirmlabel1" runat="server" />
            </button>
        </div>
    </div>
    <div id="new-version-dialog" class="wf-dialog">
        <div class="dialog-header">
            <a id="close-new-version-dialog" href="#">
                <i data-feather="x"></i>
            </a>
        </div>
        <div class="dialog-body">
            <h3>
                <asp:Literal Text="Ao confirmar esta edição você criará uma nova versão desse repositório." runat="server" />
            </h3>
            <h2>
                <asp:Literal Text="Deseja continuar com a criação?" runat="server" />
            </h2>
        </div>
        <div class="dialog-footer">
            <button class="secondary" id="cancel-new-version">
                <asp:Literal ID="cancellabel2" runat="server" />
            </button>
            <button id="confirm-new-version-button">
                <asp:Literal ID="confirmlabel2" runat="server" />
            </button>
        </div>
    </div>
    <div id="import-success-dialog" class="wf-dialog">
        <div class="dialog-header">
            <a id="close-import-success-dialog" href="#">
                <i data-feather="x"></i>
            </a>
        </div>
        <div class="dialog-body">
            <h2>
                <asp:Literal ID="successimport" runat="server" />
            </h2>
        </div>
        <div class="dialog-footer">
            <button id="confirm-import-success-dialog">
                OK
            </button>
        </div>
    </div>

    <div class="table-responsive loadable">
        <table class="hoverable left-aligned" id="rules-table">
            <thead>
                <tr>
                    <th></th>
                    <th></th>
                    <th data-filter="Id" class="filter">
                        <asp:Literal Text="Código" runat="server" />
                    </th>
                    <th data-filter="Name" class="filter">
                        <asp:Literal Text="Título" runat="server" />
                    </th>
                    <th data-filter="Version" class="filter">
                        <asp:Literal Text="Versão" runat="server" />
                    </th>
                    <th data-filter="Publisher" class="filter">
                        <asp:Literal Text="Publicador" runat="server" />
                    </th>
                    <th data-filter="PublishDate" class="filter">
                        <asp:Literal Text="Data da publicação" runat="server" />
                    </th>
                    <th>
                        <asp:Literal Text="Políticas que utilizam" runat="server" />
                    </th>
                </tr>
            </thead>
            <tbody>
            </tbody>
            <tfoot class="empty-state">
                <tr>
                    <td colspan="8">
                        <h6>Nenhum registro encontrado
                        </h6>
                    </td>
                </tr>
            </tfoot>
        </table>
        <div id="table-loader" class="loader-container">
            <i data-feather="loader"></i><span>Carregando dados...</span>
        </div>
        <template id="table-line-template">
            <tr>
                <td>
                    <div data-render="openButton"></div>
                </td>
                <td>
                    <div data-render="status"></div>
                </td>
                <td>
                    <div data-render="cod"></div>
                </td>
                <td>
                    <div data-render="title"></div>
                </td>
                <td>
                    <div data-render="version"></div>
                </td>
                <td>
                    <div data-render="creator"></div>
                </td>
                <td>
                    <div data-render="createdAt"></div>
                </td>
                <td>
                    <div data-render="policies">
                    </div>
                </td>
            </tr>
        </template>
        <template id="multiplas-politicas-template">
            <div class="tooltip-container">
                <asp:Literal ID="multiplepolicylbl" runat="server" />
                <i data-feather="info"></i>
                <div class="tooltip-body bottom solid listed big">
                    <ul>
                    </ul>
                </div>
            </div>
        </template>
    </div>

    <input type="hidden" id="titlemodalimport" data-render="title-modal-import" value="Importação Repositório de Regras" runat="server" />
    <div id="importar_repositorio_regras" class="wf-modal">
        <div class="cadastrar-editar-modal-body" data-render="import-container"></div>
    </div>

    <template id="form-iniciar-importacao">
        <fieldset>
            <div>
                <label class="labelItem">
                    <asp:Literal ID="loadafilelbl" runat="server" />
                </label>
                <input class="block" type="file" data-render="arquivo_importacao" name="arquivo_importacao" value="" />
            </div>
            <div>
                <label class="labelItem">
                    <asp:Literal ID="subportaldestinylbl" runat="server" />
                </label>
                <select class="block" data-render="import-subportal-select" name="import-subportal-select">
                    <option selected disabled value="">
                        <asp:Literal ID="selportaloption" runat="server" />
                    </option>
                </select>
            </div>
            <div id="import-select-area-container">
            </div>
            <div class="d-flex align-center justify-center mt-2">
                <button data-render="submit-init-form" class="mr-2" disabled>
                    <i class="mr-half" data-feather="upload"></i>
                    <asp:Literal Text="Fazer upload" runat="server" />
                </button>
                <button data-render="cancel-init-form" class="secondary">
                    <i class="mr-half" data-feather="x-circle"></i>
                    <asp:Literal ID="cancellabel3" runat="server" />
                </button>
            </div>
        </fieldset>
    </template>

    <template id="form-decision-importacao">
        <fieldset>
            <label class="labelItem">
                <asp:Literal ID="importrepoconflitmessagelbl" Text="Um repositório " runat="server" />
            </label>
            <div class="mt-2 mb-2">
                <div class="mb-1 d-flex align-center">
                    <input id="decisionnew" type="radio" name="decisionimport" value="true" checked />
                    <label for="decisionnew" class="labelItem">
                        <asp:Literal ID="createnewdecisionlbl" runat="server" />
                    </label>
                </div>
                <div class="d-flex align-center">
                    <input id="decisionupdate" type="radio" name="decisionimport" value="false" />
                    <label for="decisionupdate" class="labelItem">
                        <asp:Literal ID="updatedecisionlbl" runat="server" />
                    </label>
                </div>
            </div>
            <div class="d-flex align-center mt-2">
                <button data-render="submit-decision-form" class="mr-2">
                    OK
                </button>
            </div>
        </fieldset>
    </template>

    <template id="import-select-area-template">
        <label class="labelItem">
            <asp:Literal ID="areadestinylbl" Text="Selecione a área de destino" runat="server" />
        </label>
        <select class="block" data-render="import-area-select" name="import-area-select">
            <option disabled selected value="">
                <asp:Literal ID="selareaoption" runat="server" />
            </option>
        </select>
    </template>

    <div id="cadastrar_editar_repositorio_regras" class="wf-modal">
        <div class="new-version-container">
            <span>
                <asp:Literal Text="Somente visualização" runat="server" />
            </span>
            <button id="new-version-open">
                <i class="mr-1" data-feather="edit"></i>
                <asp:Literal Text="Editar" runat="server" />
            </button>
        </div>
        <div class="cadastrar-editar-modal-body">
            <div class="tab-system">
                <ul class="tab-links">
                    <li data-link="1" class="link">
                        <div class="number">1</div>
                        <i class="icon-done" data-feather="check-square"></i>
                        <span class="rtsLink">
                            <asp:Literal ID="lblcadastro" runat="server" />
                        </span>
                    </li>
                    <li data-link="2" class="link">
                        <div class="number">2</div>
                        <i class="icon-done" data-feather="check-square"></i>
                        <span class="rtsLink">
                            <asp:Literal ID="lblparametros" runat="server" />
                        </span>
                    </li>
                    <li data-link="3" class="link">
                        <div class="number">3</div>
                        <i class="icon-done" data-feather="check-square"></i>
                        <span class="rtsLink">
                            <asp:Literal ID="lblregras" runat="server" />
                        </span>
                    </li>
                </ul>
                <div class="tab-pages">
                    <div data-page="1" class="page">
                        <fieldset>
                            <label class="labelItem" for="name">
                                <asp:Literal Text="Nome" runat="server" />
                            </label>
                            <input id="name-input" maxlength="150" placeholder="Digite o nome do seu repositório" type="text" name="name" value="" />
                        </fieldset>
                    </div>
                    <div data-page="2" class="page">
                    </div>
                    <div data-page="3" class="page">
                        <h1>Página 3</h1>
                    </div>
                </div>
            </div>
            <div class="buttons-container">
                <div>
                    <%-- O cancel button aparece apenas quando estiver no primeiro passo, o voltar aparece a partir do segundo --%>
                    <button id="cancel-button" class="secondary">
                        <i class="mr-1" data-feather="x-circle"></i>
                        <asp:Literal ID="cancellabel4" runat="server" />
                    </button>
                    <button id="back-button" class="secondary"><i data-feather="chevron-left"></i>Voltar</button>
                </div>
                <div>
                    <button id="save-and-close"><i class="mr-1" data-feather="save"></i>Salvar e Fechar</button>
                </div>
                <div>
                    <button id="next-page-button"><i data-feather="chevron-right"></i>Próximo</button>
                    <button id="publish-button"><i class="mr-1" data-feather="upload"></i>Publicar</button>
                </div>
            </div>
        </div>
    </div>

    <div id="delete-parameter-dialog" class="wf-dialog">
        <div class="dialog-header">
            <a id="close-delete-parameter-dialog" href="#">
                <i data-feather="x"></i>
            </a>
        </div>
        <div class="dialog-body">
            <h2>
                <asp:Literal Text="Confirma a exclusão do registro?" runat="server" />
            </h2>
        </div>
        <div class="dialog-footer">
            <button class="secondary" id="cancel-delete-parameter">
                <asp:Literal ID="cancellabel5" runat="server" />
            </button>
            <button id="confirm-delete-parameter-button">
                <asp:Literal ID="confirmlabel4" runat="server" />
            </button>
        </div>
    </div>

    <div id="delete-register-dialog" class="wf-dialog">
        <div class="dialog-header">
            <a id="close-delete-register-dialog" href="#">
                <i data-feather="x"></i>
            </a>
        </div>
        <div class="dialog-body">
            <h2>
                <asp:Literal Text="Confirma a exclusão do registro?" runat="server" />
            </h2>
        </div>
        <div class="dialog-footer">
            <button class="secondary" id="cancel-delete-register">
                <asp:Literal ID="cancellabel6" runat="server" />
            </button>
            <button id="confirm-delete-register-button">
                <asp:Literal ID="confirmlabel5" runat="server" />
            </button>
        </div>
    </div>

    <div id="cancel-condition-config-dialog" class="wf-dialog">
        <div class="dialog-header">
            <a id="close-cancel-condition-config-dialog" href="#">
                <i data-feather="x"></i>
            </a>
        </div>
        <div class="dialog-body">
            <h2>
                <asp:Literal Text="Ao cancelar, todas alterações serão perdidas. Deseja continuar?" runat="server" />
            </h2>
        </div>
        <div class="dialog-footer">
            <button class="secondary" id="cancel-condition-config-button">
                <asp:Literal Text="Não" runat="server" />
            </button>
            <button id="confirm-cancel-condition-config-button">
                <asp:Literal Text="Sim" runat="server" />
            </button>
        </div>
    </div>

    <template id="empty-state-parametros">
        <div class="empty-fields">
            <img src="data:image/png;base64,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" alt="Imagem de empty state de parametros" />
            <h3>
                <asp:Literal Text="Parâmetros" runat="server" />
            </h3>
            <h4>
                <asp:Literal Text="Os parâmetros são variáveis que serão utilizadas para validação das regras." runat="server" />
            </h4>
            <h5>
                <asp:Literal Text="Você ainda não tem parâmetros ativos " runat="server" />
            </h5>
            <button class="secondary">
                <i data-feather="plus-square" class="mr-1"></i>
                <asp:Literal Text="Criar parâmetros" runat="server" />
            </button>
        </div>
    </template>
    <template id="empty-state-regras">
        <div class="empty-fields">
            <img src="data:image/png;base64,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" alt="Imagem de empty state de regras" />
            <h3>
                <asp:Literal Text="Regras" runat="server" />
            </h3>
            <h4>
                <asp:Literal Text="As regras são um conjunto de condições;" runat="server" />
            </h4>
            <h5>
                <asp:Literal Text="Você ainda não tem regras ativas. Crie suas regras. " runat="server" />
            </h5>
            <button class="secondary">
                <i data-feather="plus-square" class="mr-1"></i>
                <asp:Literal ID="labelcreaterules1" runat="server" />
            </button>
        </div>
    </template>
    <template id="empty-state-condicoes">
        <div class="empty-fields">
            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAQgAAABpCAYAAADGKb20AAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAVkSURBVHgB7d1RTttIGMDxb+w0TqKU2mq0S6t94AjlJr1Cj9CTcASu0J4EjsBDRakWsAkh2Cb27MzQoErbqZop7Kb2/ydZjh/gLX++8ZhEifE5z/cSFR9qkTfmMhUAvaVEPlS6ef8qy06UjcNQxUfjJElHyTNRSgmAftJaS1WvZFmWRa2b/YGZHA7Go5GLA4B+swOCbYHWbaqq+lBdFHOd7UyZHAA8sJNEPl8Ukb0gDgC+9bUJaSQA4EEgAHgRCABeBAKA10AAdEpZ38nipnavh8NYJqOhDOL7WWDVtA+vfwaBADrmsljKZHwfBRuL4vpWIrMp0Zqty8jsTvz1Z/bTvysoEJ++5O68O3uxUY0APL1WtzKdJO69ac/WatWa6aGR82Kxya8KvQeh3Khydn7lzgC222AQmSOWTQUFYne2Y+oUEwmg44KWGHZ0sZE4O5+7scVG4kfLjZPTCwGe2t7rl4J7l1c35n5D9K+blJsKvkm5jsTp3/cTxOX8Rv7InguA/9/w2eC7NyltLDbxS7sYi2UpbXu/vBgO2BABtsX3blJa9l7EJoLf1cX10pXJSp9PzDEWANtp0zA8/JwE2DQOrA2B/46dGqLocf5DOzAQTA7AtrLvy8cSFIhZOnXn9foGQDcFBYIwAP3Ac9IAvAgEAC8CAcCLQADwIhAAvGwgCvsZ+ACwtm6Cfd7quKxqAYC16u7ORuKjyvN8r1Xx0WSUpMmQ7+YE+sxODmVdy21ZFZFu910NbCQaFR+Yi7cCoMd0oUUdx7p5l2XZiQAAAAAAAAAAAGwlt8352WxzJio+1CJvzGUqAHrLROFDpZv3r8w2p7JxGKr4aJwk6SjhQSmgz+yDUlW9kmVZFrVu9gdmcjgYj0YuDgD6zQ4ItgVat6mq6kN1Ucx1tjNlcgDwwE4S+XxRuH/3Jg4AvvW1CSmfBwHAi0AA8CIQALwIBAAvAgHAi0AA8Ar66r1PX3J33p29kEFMY4CuCnx3K1k1rZydX7kzgG4KCsTubMdMDjGRADouaIlhlxU2EmfncxOHxkXiR8uNk9MLAZ7a3uuXgscVfANhHYkoitwEcTm/EQDd8kt3GBfLUtr2fnkxHAQNIwC2WHAgiuulOW7d6/T5xBxjAdAtQX/2N40Da0Pg9xQ0QTA5AP0QNEHM0qk7TyeJAOiuoEAQBqAfeE4agBeBAOBFIAB4EQgAXgQCgJcNRGE/Ax8A1tZNiJTIcVnVAgBr1d2djcRHlef5Xqvio8koSZMh380J9JmdHMq6ltuyKiLd7rsa2Eg0Kj4wF28FQI/pQos6jnXzLsuyEwEAAAAAAAAAANhKbpvzs9nmTFR8qEXemMtUAPSWicKHSjfvX5ltTmXjMFTx0ThJ0lHCg1JAn9kHpap6JcuyLGrd7A/M5HAwHo1cHAD0mx0QbAu0blNV1YfqopjrbGfK5ADggZ0k8vmicP/uTRwAfOtrE1I+DwKAF4EA4EUgAHgRCABeBAKAF4EA4BX01XufvuTuvDt7IYOYxgBdFfjuVrJqWjk7v3JnAN0UFIjd2Y6ZHGIiAXRc0BLDLitsJM7O5yYOjYvEj5YbJ6cXAjy1vdcvBY8r+AbCOhJRFLkJ4nJ+IwC65ZfuMC6WpbTt/fJiOAgaRgBsseBAFNdLc9y61+nziTnGAqBbgv7sbxoH1obA7ylogmByAPohaIKYpVN3nk4SAdBdQYEgDEA/8Jw0AC8CAcCLQADwIhAAvAgEAC8biMJ+Bj4ArK2bECmR47KqBQDWqrs7G4mPKs/zvVbFR5NRkiZDvpsT6DM7OZR1LbdlVUS63Xc1sJFoVHxgLt4KgB7ThRZ1HOvmXZZlJ/8AAWT5lc6wWC8AAAAASUVORK5CYII=" alt="Imagem de empty state de condicoes" />
            <h3>
                <asp:Literal Text="Condições" runat="server" />
            </h3>
            <h4>
                <asp:Literal Text="As condições são validações por operação lógica dos parâmetros criados." runat="server" />
            </h4>
            <h5>
                <asp:Literal Text="Ainda não há condições nesta regra" runat="server" />
            </h5>
            <button class="secondary">
                <i data-feather="plus-square" class="mr-1"></i>
                <asp:Literal Text="Criar condições" runat="server" />
            </button>
        </div>
    </template>

    <template id="param-radio-type">
        <div class="mr-2 d-flex align-center">
            <input type="radio" />
            <label class="labelItem">
            </label>
        </div>
    </template>

    <template id="item-listagem-parametros">
        <li>
            <div class="accordion-header d-flex justify-between">
                <div class="d-flex align-center">
                    <button data-render="accordion-trigger" class="icon-button">
                        <i class="arrow" data-feather="chevron-right"></i>
                    </button>
                    <span data-render="nome_parametro"></span>
                </div>
                <button class="icon-button danger delete off-in-view-mode">
                    <i data-feather="trash-2"></i>
                </button>
            </div>
            <div class="accordion-body parametro-form">
                <fieldset>
                    <label class="labelItem">
                        <asp:Literal Text="Nome do parâmetro" runat="server" />
                    </label>
                    <input type="text" name="nome_parametro" maxlength="150" placeholder="Dê um nome para o seu parâmetro" value="" />
                    <label class="labelItem">
                        <asp:Literal Text="Defina o tipo do parâmetro" runat="server" />
                    </label>
                    <div data-render="radios-types" class="d-flex align-center mb-2 mt-half">
                    </div>
                    <label class="labelItem">
                        <asp:Literal Text="Valor Padrão" runat="server" />
                        <span class="tooltip-container">
                            <i data-feather="info"></i>
                            <span class="tooltip-body">Este valor será utilizado caso o parâmetro não seja passado para a regra.
                            </span>
                        </span>
                    </label>
                    <input type="text" maxlength="150" placeholder="Digite o valor padrão" name="default_value" value="" />
                    <div class="d-none align-center default-value-options mb-2 mt-half"></div>
                </fieldset>
            </div>
        </li>
    </template>

    <template id="listagem-parametros">
        <div>
            <input type="text" name="busca-parametros" placeholder="Buscar parâmetro" class="search" value="" />
        </div>
        <ul class="lista-parametros">
        </ul>
        <button id="add-new-parameter-button" class="secondary block mt-2 off-in-view-mode">
            <i data-feather="plus-square" class="mr-1"></i>
            <asp:Literal Text="ADICIONAR PARÂMETRO" runat="server" />
        </button>
    </template>

    <template id="rule-template">
        <div class="rule">
            <div>
                <div class="status">
                    <i class="edit" data-feather="edit"></i>
                    <i class="done" data-feather="check-square"></i>
                </div>
                <input type="text" readonly value="" />
            </div>
            <div class="more off-in-view-mode">
                <div class="tooltip-container">
                    <i data-feather="more-horizontal"></i>
                    <div style="padding: 0 4px; top: -10px;" class="tooltip-body solid left">
                        <button data-render="delete-rule-button" class="minimal block">
                            <i class="mr-1" data-feather="trash-2"></i>
                            <asp:Literal Text="Excluir" runat="server" />
                        </button>
                        <button data-render="enable-edit-rule" class="minimal block">
                            <i class="mr-1" data-feather="edit"></i>
                            <asp:Literal Text="Alterar Nome" runat="server" />
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </template>

    <%-- Template para os item de um parametro do tipo lista --%>
    <template id="param-option-item">
        <li class="d-flex align-center">
            <span class="mr-1" data-render="text"></span>
            <button class="minimal icon-button">
                <i data-feather="x"></i>
            </button>
        </li>
    </template>

    <template id="condicoes-template">
        <div class="condicao-container">
            <div data-render="condicao-up" class="nova-condicao-container up">
                <div></div>
                <button class="minimal">
                    <i data-feather="plus-circle" class="mr-half"></i>
                    <asp:Literal Text="Adicionar condição" runat="server" />
                </button>
                <div></div>
            </div>
            <div class="condicao">
                <div class="d-flex justify-end">
                    <button data-render="delete-condicao" class="icon-button medium danger">
                        <i data-feather="trash-2"></i>
                    </button>
                </div>
                <fieldset>
                    <div class="operadores-container">
                        <label class="labelItem">
                            <asp:Literal Text="SE" runat="server" />
                        </label>
                        <select value="" data-render="parameters">
                            <option disabled value="">
                                <asp:Literal ID="lblselectparameter" runat="server" />
                            </option>
                        </select>
                    </div>
                    <div class="campo-container">
                        <label class="labelItem">
                            <asp:Literal Text="FOR" runat="server" />
                        </label>
                        <select value="" data-render="operators">
                            <option disabled value="">
                                <asp:Literal ID="lblselectoperator" runat="server" />
                            </option>
                        </select>
                    </div>
                    <div class="campo-container" data-render="parameter1">
                        <fieldset data-render="param-1">
                            <ul class="d-none param-option-list mb-2 mt-half">
                            </ul>
                            <input type="text" value="" />
                            <div class="d-none align-center default-value-options mb-2 mt-half"></div>
                        </fieldset>
                    </div>
                    <div class="campo-container" data-render="parameter2">
                        <fieldset data-render="param-2">
                            <input type="text" value="" />
                        </fieldset>
                    </div>
                </fieldset>
            </div>
            <div data-render="condicao-down" class="nova-condicao-container">
                <div></div>
                <button class="minimal">
                    <i class="mr-half" data-feather="plus-circle"></i>
                    <asp:Literal Text="Adicionar condição" runat="server" />
                </button>
                <div></div>
            </div>
        </div>

    </template>

    <template id="logical-operator-template">
        <div class="zuri-radio-inputs">
        </div>
    </template>

    <template id="layout-text-condicoes">
        <div class="container-listagem-condicoes">
            <div class="header-listagem-condicoes">
                <h6 data-render="Alias"></h6>
            </div>
            <div class="text-condicoes">
                <span data-render="Text"></span>
                <button class="ml-2 icon-button medium off-in-view-mode">
                    <i data-feather="edit"></i>
                </button>
            </div>
        </div>
    </template>

    <template id="layout-listagem-condicoes">
        <div class="container-listagem-condicoes">
            <div class="header-listagem-condicoes">
                <h6 data-render="Alias"></h6>
            </div>
            <div class="listagem-condicoes"></div>
            <div class="footer-listagem-condicoes mt-2">
                <button class="secondary block" data-render="adicionar-condicoes">
                    <i class="mr-1" data-feather="plus-square"></i>
                    <asp:Literal Text="ADICIONAR CONDIÇÕES" runat="server" />
                </button>
                <div class="d-flex justify-end mt-2">
                    <button data-render="cancel-condicoes" class="secondary centered mr-2">
                        <asp:Literal ID="cancellabel7" runat="server" />
                    </button>
                    <button data-render="salvar-condicoes" class="primary centered">
                        <asp:Literal ID="confirmlabel3" runat="server" />
                    </button>
                </div>
            </div>
        </div>
    </template>

    <template id="cadastro-regras-layout">
        <div class="cadastro-regras-layout-container">
            <div class="cadastro-regras">
                <div class="cadastro-regras-header">
                    <div>
                        <h4>
                            <asp:Literal Text="Regras" runat="server" />
                            <span class="tooltip-container">
                                <i data-feather="info"></i>
                                <span class="tooltip-body solid big centered bottom">
                                    <asp:Literal Text="Regras são conjuntos de condições com validações por operação lógica dos parâmetros criados." runat="server" />
                                </span>
                            </span>
                        </h4>
                    </div>
                    <div>
                        <input placeholder="Buscar regra" data-render="input-busca-regra" type="hidden" name="name" class="search minimal" value="" />
                    </div>
                </div>
                <div class="cadastro-regras-listagem-container">
                </div>
                <div class="cadastro-regras-form-container off-in-view-mode">
                    <fieldset class="fieldwithbutton">
                        <input ID="novaregrainput" type="text" name="nova-regra" data-render="nova-regra" value="" runat="server" />
                        <button id="nova-regra-button">
                            <i class="mr-1" data-feather="plus-square"></i>
                        </button>
                    </fieldset>
                </div>
            </div>
            <div class="cadastro-condicoes"></div>
        </div>
    </template>

    <script>
        var rulesRepositoryModel = {
            rules: [],
            areas: [],
            subPortals: [],
            operators: [],
            logicaloperators: [],
            selected: null, // repositório de regras selecionado
            selectedRule: null, // regra selecionada
            openRepository: null,
            loading: false,
            token: null,
            lastAddedConditionIndex: null,
            orderBy: {
                fieldName: null,
                ascending: null
            },
            setOrderBy: function (fieldName, ascending) {
                rulesRepositoryModel.orderBy.fieldName = fieldName;
                if (ascending == 'false') {
                    rulesRepositoryModel.orderBy.ascending = false;
                } else {
                    rulesRepositoryModel.orderBy.ascending = (ascending != null) ? !!ascending : null;

                }
            },
            getOrderBy: function () {
                return rulesRepositoryModel.orderBy;
            },
            getRules: function () {
                return rulesRepositoryModel.rules;
            },
            setRules: function (rules) {
                rulesRepositoryModel.rules = rules;
            },
            getLoading: function () {
                return rulesRepositoryModel.loading;
            },
            setLoading: function (loading) {
                rulesRepositoryModel.loading = loading;
            },
            getSelected: function () {
                return rulesRepositoryModel.selected;
            },
            setSelected: function (selected) {
                rulesRepositoryModel.selected = selected;
            },
            getOpen: function () { // return the rule repository that is open
                return rulesRepositoryModel.openRepository;
            },
            setOpen: function (item) {
                rulesRepositoryModel.openRepository = item;
            },
            getToken: function () {
                return rulesRepositoryModel.token;
            },
            setToken: function (token) {
                rulesRepositoryModel.token = token;
            },
            setParamTypes: function (types) {
                rulesRepositoryModel.paramTypes = types;
            },
            getParamTypes: function () {
                return rulesRepositoryModel.paramTypes;
            },
            setAreas: function (areas) {
                rulesRepositoryModel.areas = areas;
            },
            getAreas: function () {
                return rulesRepositoryModel.areas;
            },
            setSubPortals: function (subPortals) {
                rulesRepositoryModel.subPortals = subPortals;
            },
            getSubPortals: function () {
                return rulesRepositoryModel.subPortals;
            },
            setSelectedRule: function (rule) {
                rulesRepositoryModel.selectedRule = rule;
            },
            getSelectedRule: function () {
                return rulesRepositoryModel.selectedRule;
            },
            setOperators: function (operators) {
                rulesRepositoryModel.operators = operators;
            },
            getOperators: function () {
                return rulesRepositoryModel.operators;
            },
            setLogicalOperators: function (logicaloperators) {
                rulesRepositoryModel.logicaloperators = logicaloperators;
            },
            getLogicalOperators: function () {
                return rulesRepositoryModel.logicaloperators;
            },
            setLastAddedConditionIndex: function (index) {
                rulesRepositoryModel.lastAddedConditionIndex = index;
            },
            getLastAddedConditionIndex: function () {
                return rulesRepositoryModel.lastAddedConditionIndex;
            }
        }
        var rulesRepositoryController = {
            init: function () {
                rulesRepositoryModel.setLoading(true);
                this.getOrderFromCookie();
                Api.get('/CA834727-8779-40C8-827B-717FDB87D652', null, 'text/plain').then(resp => {
                    rulesRepositoryModel.setToken(resp);
                    pagePickerCookieController.init();
                    searchFormView.init();
                    rulesRepositoryController.fetchSubPortals()
                        .then(subportals => {
                            rulesRepositoryModel.setSubPortals(subportals);
                            searchFormView.renderSubportals(subportals);
                            if (subportals.length > 0) {
                                let currentSubPortal = pagePickerCookieController.getCurrentPortal();
                                if (currentSubPortal) {
                                    currentSubPortal = subportals.find(el => el.Id == currentSubPortal);
                                }
                                rulesRepositoryController.fetchAreas(currentSubPortal ? currentSubPortal.EncId : subportals[0].EncId).then(areas => {
                                    searchFormView.renderAreas(areas);
                                    rulesRepositoryModel.setAreas(areas);
                                    rulesRepositoryController.fetchRules();
                                });
                            }
                        });
                    rulesRepositoryController.fetchParamTypes();
                    rulesRepositoryController.fetchOperators();
                    rulesRepositoryController.fetchLogicalOperators();
                });
                rulesRepositoryView.init();
                createEditModalView.init();
                deleteView.init();
                newVersionView.init();
                deleteParameterView.init();
                deleteRegisterView.init();
                cancelConditionConfigView.init();
                importExportView.init();
                importSuccessView.init();
                tabSystem.init();
            },
            getOrderFromCookie: function () {
                rulesRepositoryModel.setOrderBy(cookieController.get('ruleRepositoryOrderByFieldName'), cookieController.get('ruleRepositoryOrderByAscending'));
            },
            setOrderBy: function (fieldName, ascending) {
                rulesRepositoryModel.setOrderBy(fieldName, ascending);
                cookieController.set('ruleRepositoryOrderByFieldName', (fieldName == null) ? ';Max-Age=-99999999;' : fieldName);
                cookieController.set('ruleRepositoryOrderByAscending', (ascending == null) ? ';Max-Age=-99999999;' : ascending);
                this.fetchRules();
            },
            getOrderBy: function () {
                return rulesRepositoryModel.getOrderBy();
            },
            fetchRules: function () {
                const token = rulesRepositoryModel.getToken();
                const areaSelect = document.getElementById('area-select');
                const titleInput = document.getElementById('title');
                const areaEncId = rulesRepositoryModel.getAreas().find(area => area.Id == areaSelect.value).EncId;
                const orderBy = rulesRepositoryModel.getOrderBy();
                rulesRepositoryModel.setLoading(true);
                rulesRepositoryView.render([]);
                Api.get(`/rulerepository?areaid=${areaEncId}&title=${titleInput.value}&frontOrderbyFieldName=${orderBy.fieldName ?? ''}&frontOrderAscending=${orderBy.ascending ?? true}`, `Bearer ${token}`)
                    .then(rules => {
                        rulesRepositoryModel.setLoading(false);
                        rulesRepositoryController.changeRules(rules);
                    })
            },
            fetchSubPortals: function () {
                const token = rulesRepositoryModel.getToken();
                return Api.get('/portal', `Bearer ${token}`)
            },
            fetchAreas: function (subportalId) {
                const token = rulesRepositoryModel.getToken();
                return Api.get(`/areas?category=AdminArea&portalId=${subportalId}`, `Bearer ${token}`);
            },
            fetchParamTypes: function () {
                const token = rulesRepositoryModel.getToken();
                Api.get(`/paramtypesdef`, `Bearer ${token}`)
                    .then(resp => {
                        rulesRepositoryModel.setParamTypes(resp);
                    })
            },
            fetchOperators: function () {
                const token = rulesRepositoryModel.getToken();
                Api.get(`/operators`, `Bearer ${token}`)
                    .then(resp => {
                        rulesRepositoryModel.setOperators(resp);
                    })
            },
            fetchLogicalOperators: function () {
                const token = rulesRepositoryModel.getToken();
                Api.get(`/logicaloperators`, `Bearer ${token}`)
                    .then(resp => {
                        rulesRepositoryModel.setLogicalOperators(resp);
                    })
            },
            changeRules: function (rules) { // sempre utilizar esse método para atualizar as regras pois ele obriga o render após as atualizações.
                rulesRepositoryModel.setRules(rules);
                rulesRepositoryView.render(rules);
            },
            getOpen: function () {
                return rulesRepositoryModel.getOpen();
            },
            setOpen: function (item) {
                rulesRepositoryModel.setOpen(item);
            },
            getLoading: function () {
                return rulesRepositoryModel.getLoading();
            },
            getParamTypes: function () {
                return rulesRepositoryModel.getParamTypes();
            },
            getOperators: function () {
                return rulesRepositoryModel.getOperators();
            },
            getLogicalOperators: function () {
                return rulesRepositoryModel.getLogicalOperators();
            },
            getLastAddedConditionIndex: function () {
                return rulesRepositoryModel.getLastAddedConditionIndex();
            },
            handleSelectChange: function (selected) {
                rulesRepositoryModel.setSelected(selected);
            },
            handleOpenItem: function (item = null) {
                const open = JSON.parse(JSON.stringify(item));
                rulesRepositoryModel.setOpen(open);
                createEditModalView.open(open);
            },
            handleCloseItem: function () {
                rulesRepositoryModel.setOpen(null);
                rulesRepositoryModel.setSelectedRule(null);
            },
            handleDeleteItem: function () {
                const selected = rulesRepositoryModel.getSelected();
                const token = rulesRepositoryModel.getToken();
                rulesRepositoryModel.setLoading(true);
                rulesRepositoryView.render([]);
                Api.delete(`/rulerepository/${selected.EncId}`, null, `Bearer ${token}`)
                    .then(_ => {
                        this.fetchRules();
                        deleteView.closeDialog();
                    })
                    .catch(err => {
                        if (err?.exceptionMessage) {
                            toasterController.launch("Erro", err.exceptionMessage, "error", false, 3000, 'body');
                        }
                        this.fetchRules();
                        deleteView.closeDialog();
                    })
            },
            handleSubPortalChange: function (id) {
                const subPortals = rulesRepositoryModel.getSubPortals();
                rulesRepositoryController.fetchAreas(subPortals.find(el => el.Id == id).EncId)
                    .then(areas => {
                        rulesRepositoryModel.setAreas(areas);
                        searchFormView.renderAreas(areas);
                    });
            },
            handleSearchClick: function () {
                const subportalsSelect = document.getElementById('subportal-select');
                const areasSelect = document.getElementById('area-select');
                pagePickerCookieController.setCurrentPortal(subportalsSelect.value);
                pagePickerCookieController.setCurrentArea(areasSelect.value);
                this.fetchRules();
            },
            handleOpenDelete: function () {
                const selected = rulesRepositoryModel.getSelected();
                if (selected) {
                    deleteView.openDialog();
                }
            },
            addNewParameter: function () {
                const open = rulesRepositoryModel.getOpen();
                const newParameter = {
                    Name: '',
                    Type: rulesRepositoryModel.getParamTypes()[0].Type,
                    DefaultValue: ''
                };
                open.Parameters ? open.Parameters.push(newParameter) : open.Parameters = [newParameter];
                rulesRepositoryModel.setOpen(open);
                this.validateParameterList(open.Parameters);
                return newParameter;
            },
            updateParameter: function (attribute, value, index) {
                const open = rulesRepositoryModel.getOpen();
                open.Parameters[index][attribute] = value;
                rulesRepositoryModel.setOpen(open);
                this.validateParameterList(open.Parameters);
            },
            handleDeleteParameter: function (index) {
                const open = rulesRepositoryModel.getOpen();
                open.Parameters = open.Parameters.filter((element, i) => i != index);
                rulesRepositoryModel.setOpen(open);
                if (open.Parameters.length > 0) {
                    createEditModalView.renderParameters(open.Parameters);
                    this.validateParameterList(open.Parameters);
                } else {
                    createEditModalView.renderPage2(open);
                }
                deleteParameterView.closeDialog();
            },
            validateParameterList: function (parameters = []) {
                if (parameters?.length > 0) {
                    const hasEmptyNames = parameters.find(parameter => parameter.Name == '');
                    createEditModalView.changeSaveAndNextButton(hasEmptyNames);
                } else {
                    createEditModalView.changeNextButton(true);
                }
            },
            addNewRule: function (Name) {
                return new Promise((resolve, reject) => {
                    const open = rulesRepositoryModel.getOpen();
                    const token = rulesRepositoryModel.getToken();
                    const toSend = {
                        alias: Name
                    }
                    Api.post(`/rulerepository/${open.EncId}/rule`, toSend, `Bearer ${token}`)
                        .then(newRule => {
                            open.Rules.push(newRule);
                            rulesRepositoryModel.setOpen(open);
                            createEditModalView.buscaRegraHabilitada(true);
                            createEditModalView.validateRulesList();
                            this.fetchRules();
                            resolve(newRule);
                        })
                        .catch(err => {
                            resolve();
                        })
                })
            },
            enableRulesEdit: function () {
                const open = rulesRepositoryModel.getOpen();
                open.Rules = [];
                rulesRepositoryModel.setOpen(open);
            },
            editRule: function (value, index) {
                return new Promise((resolve, reject) => {
                    const open = rulesRepositoryModel.getOpen();
                    const token = rulesRepositoryModel.getToken();
                    const toSend = {
                        alias: value,
                        content: open.Rules[index].content
                    }
                    Api.put(`/rulerepository/${open.EncId}/rule/${open.Rules[index].EncId}`, toSend, `Bearer ${token}`)
                        .then(editedRule => {
                            open.Rules[index].Alias = editedRule.Alias;
                            rulesRepositoryModel.setOpen(open);
                            this.fetchRules();
                            resolve(editedRule);
                        })
                        .catch(err => {
                            resolve();
                        })
                })
            },
            handleDeleteRule: function (index) {
                const open = rulesRepositoryModel.getOpen();
                const token = rulesRepositoryModel.getToken();
                const selectedRule = rulesRepositoryModel.getSelectedRule();
                Api.delete(`/rulerepository/${open.EncId}/rule/${open.Rules[index].EncId}`, null, `Bearer ${token}`)
                    .then(_ => {
                        if (selectedRule.Id == open.Rules[index].Id) {
                            this.setSelectedRule(null);
                        }
                        open.Rules = open.Rules.filter((element, i) => i != index);
                        rulesRepositoryModel.setOpen(open);
                        createEditModalView.renderRules(open.Rules);
                        if (open.Rules.length == 0) this.setSelectedRule(null);
                        deleteRegisterView.closeDialog();
                        this.fetchRules();
                    })
            },
            setSelectedRule: function (rule) {
                const selectedRule = JSON.parse(JSON.stringify(rule))
                rulesRepositoryModel.setSelectedRule(selectedRule);
                if (tabSystem.getPage() == 3) {
                    createEditModalView.renderLayoutCondicoes();
                }
            },
            getSelectedRule: function () {
                return rulesRepositoryModel.getSelectedRule();
            },
            getSubPortals: function () {
                return rulesRepositoryModel.getSubPortals();
            },
            getOperatorFromAlias: function (alias) {
                const operators = rulesRepositoryModel.getOperators();
                return operators.find(operator => operator.Alias == alias);
            },
            addNewCondition: function (position = 'down', index = null, level = null) {
                const logicalOperators = rulesRepositoryModel.getLogicalOperators();
                const selectedRule = rulesRepositoryModel.getSelectedRule();
                const newConditionTemplate = {
                    "Level": level ?? 1,
                    "OperatorAlias": "",
                    "Variable": "",
                    "Param1": ""
                }
                const newLogicalConditionTemplate = {
                    "Level": level ?? 1,
                    "OperatorAlias": logicalOperators[0].Alias,
                }
                if (!selectedRule.Content) { // primeiro item da listagem
                    selectedRule.Content = [{ ...newConditionTemplate }]
                    rulesRepositoryModel.setLastAddedConditionIndex(null);
                } else if (index != null) { // itens em posições específicas
                    if (position == 'down') { // adiciona abaixo do index
                        selectedRule.Content.splice(index + 1, 0, newLogicalConditionTemplate);
                        selectedRule.Content.splice(index + 2, 0, newConditionTemplate);
                        rulesRepositoryModel.setLastAddedConditionIndex(index + 2);
                    } else { // adiciona acima
                        selectedRule.Content.splice(index, 0, newConditionTemplate);
                        selectedRule.Content.splice(index + 1, 0, newLogicalConditionTemplate);
                        rulesRepositoryModel.setLastAddedConditionIndex(index);
                    }
                } else { // itens adicionados ao final
                    selectedRule.Content.push({ ...newLogicalConditionTemplate });
                    selectedRule.Content.push({ ...newConditionTemplate });
                    rulesRepositoryModel.setLastAddedConditionIndex(selectedRule.Content.length - 1);
                }
                rulesRepositoryModel.setSelectedRule(selectedRule);
                createEditModalView.renderLayoutCondicoes(selectedRule);

            },
            updateCondition: function (index, name, value) {
                const selectedRule = rulesRepositoryModel.getSelectedRule();
                selectedRule.Content[index][name] = value;
                // remove as tags de Param se necessário
                if (name == "OperatorAlias") {
                    const operator = this.getOperatorFromAlias(value);
                    if (!operator?.HasParam1) {
                        delete selectedRule.Content[index].Param1;
                    } else {
                        selectedRule.Content[index].Param1 = selectedRule.Content[index].Param1 ?? '';
                    }
                    if (!operator?.HasParam2) {
                        delete selectedRule.Content[index].Param2;
                    } else {
                        selectedRule.Content[index].Param2 = selectedRule.Content[index].Param2 ?? '';
                    }
                }

                // limpa os valores de inicialização vindos da api
                delete selectedRule.Content[index].Param1Name;
                delete selectedRule.Content[index].Param2Name;
                if (name == 'Variable') delete selectedRule.Content[index].VariableName;

                rulesRepositoryModel.setSelectedRule(selectedRule);
            },
            handleDeleteCondition: function (index) {
                rulesRepositoryModel.setLastAddedConditionIndex(null); // seta para null para previnir erros da renderização tentar fazer o scroll para um item que não está mais na tela
                const selectedRule = rulesRepositoryModel.getSelectedRule();
                selectedRule.Content.splice(index == 0 ? index : (index - 1), 2); // remove duas posições pois precisa remover a condição lógica
                if (selectedRule.Content.length == 0) {
                    selectedRule.Content = null // seta para nulo pois o método de adicionar utiliza esse estado de nulo para inicializar o array
                    this.updateSelectedRuleConditions()
                } else {
                    rulesRepositoryModel.setSelectedRule(selectedRule);
                    createEditModalView.renderLayoutCondicoes(selectedRule);
                }
                deleteRegisterView.closeDialog();
            },
            updateSelectedRuleConditions: function () {
                return new Promise((resolve, reject) => {
                    const selectedRule = rulesRepositoryModel.getSelectedRule();
                    const open = rulesRepositoryModel.getOpen();
                    const token = rulesRepositoryModel.getToken();
                    Api.put(`/rulerepository/${open.EncId}/rule/${selectedRule.EncId}`, selectedRule, `Bearer ${token}`)
                        .then(editedRule => {
                            this.fetchRules();
                            for (i = 0; i < open.Rules.length; i++) {
                                if (open.Rules[i].Id == selectedRule.Id) {
                                    open.Rules[i].Text = editedRule.Text;
                                    open.Rules[i].Content = editedRule.Content;
                                    selectedRule.Text = editedRule.Text;
                                    selectedRule.Content = editedRule.Content;
                                }
                            }
                            rulesRepositoryModel.setOpen(open);
                            createEditModalView.renderRules(open.Rules);
                            createEditModalView.renderLayoutCondicoes();
                            resolve(editedRule);
                        })
                        .catch(err => {
                            resolve();
                        })
                });
            },
            enableConditionsEdit: function () {
                const selectedRule = rulesRepositoryModel.getSelectedRule();
                selectedRule.Text = null;
                rulesRepositoryModel.setSelectedRule(selectedRule);
                createEditModalView.renderLayoutCondicoes(selectedRule);
            },
            cancelConditionConfig: function () {
                const open = rulesRepositoryModel.getOpen();
                const selectedRule = rulesRepositoryModel.getSelectedRule();
                for (i = 0; i < open.Rules.length; i++) {
                    if (open.Rules[i].Id == selectedRule.Id) {
                        this.setSelectedRule(open.Rules[i]);
                    }
                }
                cancelConditionConfigView.closeDialog();
            },
            handleEditCreateRepository: function () {
                return new Promise((resolve, reject) => {
                    const item = rulesRepositoryModel.getOpen();
                    const token = rulesRepositoryModel.getToken();
                    const toSend = {
                        name: document.getElementById('name-input').value,
                        areaId: document.getElementById('area-select').value
                    }
                    if (item) { // edit
                        Api.put(`/rulerepository/${item.EncId}`, toSend, `Bearer ${token}`)
                            .then(resp => {
                                this.fetchRules();
                                resolve(resp);
                            })
                            .catch(err => {
                                resolve();
                            })
                    } else { // create
                        Api.post('/rulerepository', toSend, `Bearer ${token}`)
                            .then(resp => {
                                this.fetchRules();
                                resolve(resp);
                            })
                            .catch(err => {
                                resolve();
                            })
                    }
                })
            },
            handleUpdateParameters: function () {
                return new Promise((resolve, reject) => {
                    const item = rulesRepositoryModel.getOpen();
                    const token = rulesRepositoryModel.getToken();
                    Api.put(`/rulerepository/${item.EncId}/params`, item.Parameters ?? [], `Bearer ${token}`)
                        .then(resp => {
                            this.fetchRules();
                            resolve(resp);
                        })
                        .catch(err => {
                            resolve();
                        })
                });
            },
            handleNewVersion: function () {
                const token = rulesRepositoryModel.getToken();
                const open = rulesRepositoryModel.getOpen();
                rulesRepositoryModel.setLoading(true);
                rulesRepositoryView.render([]);
                Api.post(`/rulerepository/${open.Identifier}`, null, `Bearer ${token}`)
                    .then(newItem => {
                        this.fetchRules();
                        newVersionView.closeDialog();
                        createEditModalView.close();
                        this.handleOpenItem(newItem);
                    })
            },
            publishRepository: function () {
                return new Promise((resolve, reject) => {
                    const open = rulesRepositoryModel.getOpen();
                    const token = rulesRepositoryModel.getToken();
                    Api.put(`/rulerepository/${open.EncId}/publish`, {}, `Bearer ${token}`)
                        .then(resp => {
                            this.fetchRules();
                            resolve(resp);
                        })
                        .catch(err => {
                            resolve();
                        })
                });
            },
            handleExport: function () {
                const selectedRepository = rulesRepositoryModel.getSelected();
                if (selectedRepository) {
                    const token = rulesRepositoryModel.getToken();
                    Api.get(`/rulerepository/${selectedRepository.EncId}/export`, `Bearer ${token}`)
                        .then(downloadtoken => {
                            window.open(`${window.location.origin}/api/v10/rulerepository/${downloadtoken}/download`, '_blank').focus()
                        })
                        .catch(err => console.log(err));
                }
            },
            handleInitImport: function (file, areaId) {
                const area = rulesRepositoryModel.getAreas().find(el => el.Id == areaId);
                const token = rulesRepositoryModel.getToken();
                const toSend = new FormData();
                toSend.append('file', file, file.name);
                Api.post(`/rulerepository/${area.EncId}/checkimport`, toSend, `Bearer ${token}`, 'multipart/form-data')
                    .then(res => {
                        if (res == 'true') {
                            importExportView.renderDecisionForm(toSend, area.EncId);
                        } else {
                            this.finishImport(toSend, area.EncId);
                        }
                    })
                    .catch(err => console.log(err));
            },
            finishImport: function (toSend, areaId, newRepFamily = false) {
                const token = rulesRepositoryModel.getToken();
                Api.post(`/rulerepository/${areaId}/import?newName&asNewRepFamily=${newRepFamily}`, toSend, `Bearer ${token}`, 'multipart/form-data')
                    .then(_ => {
                        this.fetchRules();
                        importExportView.closeWithSucces();
                    });
            }
        }
        // controla a view de exportar e importar repositórios
        const importExportView = {
            init: function () {
                this.initializeExportButton();
                this.initilizeImportButton();
            },
            initializeExportButton: function () {
                document.querySelector('a.download').addEventListener('click', e => {
                    e.preventDefault();
                    rulesRepositoryController.handleExport();
                })
            },
            initilizeImportButton: function () {
                document.querySelector('a.upload').addEventListener('click', e => {
                    e.preventDefault();
                    modalController.abrirModal('importar_repositorio_regras');
                    modalController.changeModalTitle('importar_repositorio_regras', document.querySelector('input[data-render="title-modal-import"]').value);
                    modalController.disableModalDisposal('importar_repositorio_regras');
                    this.renderModal();
                })
            },
            renderModal: function () {
                const container = document.querySelector('div[data-render="import-container"]');
                container.innerHTML = '';
                const modalFormTemplate = document.importNode(document.getElementById('form-iniciar-importacao').content, true);

                const subportals = rulesRepositoryController.getSubPortals();
                const subportalsSelect = modalFormTemplate.querySelector('select[name="import-subportal-select"]');
                subportals.forEach(subportal => {
                    let option = document.createElement('option');
                    option.value = subportal.EncId;
                    option.text = subportal.Alias;
                    subportalsSelect.appendChild(option);
                })

                subportalsSelect.addEventListener('input', e => {
                    rulesRepositoryController.fetchAreas(e.target.value)
                        .then(areas => {
                            this.renderAreasSelect(areas);
                        });
                });

                modalFormTemplate.querySelector('fieldset').addEventListener('input', e => {
                    if (e.target.getAttribute('data-render') == 'import-subportal-select') {
                        this.initFormSubmitEnabled(false);
                    } else {
                        this.validateInitForm();
                    }
                });

                modalFormTemplate.querySelector('button[data-render="submit-init-form"]').addEventListener('click', e => {
                    e.preventDefault();
                    const container = document.querySelector('div[data-render="import-container"]');
                    const fileinput = container.querySelector('input[data-render="arquivo_importacao"]');
                    const areaSelect = container.querySelector('select[data-render="import-area-select"]');
                    rulesRepositoryController.handleInitImport(fileinput.files[0], areaSelect.value);
                })

                modalFormTemplate.querySelector('button[data-render="cancel-init-form"]').addEventListener('click', e => {
                    e.preventDefault();
                    modalController.closeModal('importar_repositorio_regras');
                });

                container.appendChild(modalFormTemplate);
                this.renderAreasSelect([]);

                feather.replace();
            },
            renderDecisionForm: function (formdata, areaId) {
                const container = document.querySelector('div[data-render="import-container"]');
                container.innerHTML = '';
                const decisionFormTemplate = document.importNode(document.getElementById('form-decision-importacao').content, true);
                decisionFormTemplate.querySelector('button').addEventListener('click', e => {
                    e.preventDefault();
                    rulesRepositoryController.finishImport(formdata, areaId, document.querySelector('input[name="decisionimport"]:checked').value);
                })

                container.appendChild(decisionFormTemplate);
            },
            renderAreasSelect: function (areas) {
                const container = document.getElementById('import-select-area-container');
                const selectAreaTemplate = document.importNode(document.getElementById('import-select-area-template').content, true);
                const select = selectAreaTemplate.querySelector('select');
                container.innerHTML = '';

                areas.forEach(area => {
                    let option = document.createElement('option');
                    option.value = area.Id;
                    option.text = area.Name;
                    select.appendChild(option);
                });

                container.appendChild(selectAreaTemplate);
            },
            validateInitForm: function () {
                const container = document.querySelector('div[data-render="import-container"]');
                const fileinput = container.querySelector('input[data-render="arquivo_importacao"]');
                const areaSelect = container.querySelector('select[data-render="import-area-select"]');

                if (fileinput.files[0] && areaSelect.value) {
                    this.initFormSubmitEnabled(true);
                }
            },
            initFormSubmitEnabled: function (enabled) {
                const submitButton = document.querySelector('div[data-render="import-container"] button[data-render="submit-init-form"]');

                if (enabled) {
                    submitButton.removeAttribute('disabled');
                } else {
                    submitButton.setAttribute('disabled', '');
                }
            },
            closeWithSucces: function () {
                modalController.closeModal('importar_repositorio_regras');
                importSuccessView.openDialog();
            }
        }
        var importSuccessView = {
            init: function () {
                document.getElementById('close-import-success-dialog').addEventListener('click', (e) => {
                    e.preventDefault();
                    dialogController.closeDialog('import-success-dialog');
                });
                document.getElementById('confirm-import-success-dialog').addEventListener('click', (e) => {
                    e.preventDefault();
                    dialogController.closeDialog('import-success-dialog');
                })
            },
            openDialog: function () {
                dialogController.openDialog('import-success-dialog');
            },
        }
        // controla o diálogo de excluir repositórios de regra
        var deleteView = {
            init: function () {
                document.getElementById('open-delete-dialog').addEventListener('click', (e) => {
                    e.preventDefault();
                    rulesRepositoryController.handleOpenDelete();
                });
                document.getElementById('close-delete-dialog').addEventListener('click', (e) => {
                    e.preventDefault();
                    document.getElementById('delete-dialog').classList.remove('show');
                });
                document.getElementById('cancel-delete').addEventListener('click', (e) => {
                    e.preventDefault();
                    document.getElementById('delete-dialog').classList.remove('show');
                });
                document.getElementById('confirm-delete-button').addEventListener('click', (e) => {
                    e.preventDefault();
                    rulesRepositoryController.handleDeleteItem();
                })
            },
            openDialog: function () {
                dialogController.openDialog('delete-dialog');
            },
            closeDialog: function () {
                dialogController.closeDialog('delete-dialog');
            }
        }
        var newVersionView = {
            init: function () {
                document.getElementById('close-new-version-dialog').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.closeDialog();
                });
                document.getElementById('cancel-new-version').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.closeDialog();
                });
                document.getElementById('confirm-new-version-button').addEventListener('click', (e) => {
                    e.preventDefault();
                    rulesRepositoryController.handleNewVersion();
                })
            },
            openDialog: function () {
                dialogController.openDialog('new-version-dialog');
            },
            closeDialog: function () {
                dialogController.closeDialog('new-version-dialog');
            }
        }
        var deleteParameterView = {
            init: function () {
                document.getElementById('close-delete-parameter-dialog').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.closeDialog();
                });
                document.getElementById('cancel-delete-parameter').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.closeDialog();
                });
                document.getElementById('confirm-delete-parameter-button').addEventListener('click', (e) => {
                    e.preventDefault();
                    rulesRepositoryController.handleDeleteParameter(e.target.getAttribute('data-parameter-index'));
                })
            },
            openDialog: function (id) {
                document.getElementById('confirm-delete-parameter-button').setAttribute('data-parameter-index', id);
                dialogController.openDialog('delete-parameter-dialog');
            },
            closeDialog: function () {
                dialogController.closeDialog('delete-parameter-dialog');
            }
        }
        // diálogo para deleter registros dentro de repositósios
        var deleteRegisterView = {
            init: function () {
                document.getElementById('close-delete-register-dialog').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.closeDialog();
                });
                document.getElementById('cancel-delete-register').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.closeDialog();
                });
                document.getElementById('confirm-delete-register-button').addEventListener('click', (e) => {
                    e.preventDefault();
                    const method = e.target.getAttribute('data-register-method');
                    rulesRepositoryController[method](e.target.getAttribute('data-register-index'));
                })
            },
            openDialog: function (id, method) {
                document.getElementById('confirm-delete-register-button').setAttribute('data-register-index', id);
                document.getElementById('confirm-delete-register-button').setAttribute('data-register-method', method);
                dialogController.openDialog('delete-register-dialog');
            },
            closeDialog: function () {
                dialogController.closeDialog('delete-register-dialog');
            }
        }

        // diálogo para cancelar a edição das condições de uma regra
        var cancelConditionConfigView = {
            init: function () {
                document.getElementById('close-cancel-condition-config-dialog').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.closeDialog();
                });
                document.getElementById('cancel-condition-config-button').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.closeDialog();
                });
                document.getElementById('confirm-cancel-condition-config-button').addEventListener('click', (e) => {
                    e.preventDefault();
                    rulesRepositoryController.cancelConditionConfig();
                })
            },
            openDialog: function () {
                dialogController.openDialog('cancel-condition-config-dialog');
            },
            closeDialog: function () {
                dialogController.closeDialog('cancel-condition-config-dialog');
            }
        }

        var searchFormView = {
            init: function () {
                const subportalsSelect = document.getElementById('subportal-select');
                subportalsSelect.addEventListener('change', (e) => {
                    rulesRepositoryController.handleSubPortalChange(e.target.value);
                })
                const searchButton = document.getElementById('search-rules-button');
                searchButton.addEventListener('click', (e) => {
                    e.preventDefault();
                    rulesRepositoryController.handleSearchClick();
                });
            },
            renderSubportals: function (subportals) {
                const subportalsSelect = document.getElementById('subportal-select');
                const selectedPortal = pagePickerCookieController.getCurrentPortal();
                subportals.forEach(subportal => {
                    let option = document.createElement('option');
                    option.value = subportal.Id;
                    option.text = subportal.Alias;
                    if (selectedPortal == subportal.Id) option.selected = true;
                    subportalsSelect.appendChild(option);
                })
            },
            renderAreas: function (areas) {
                const areasSelect = document.getElementById('area-select');
                const selectedArea = pagePickerCookieController.getCurrentArea();
                areasSelect.innerHTML = '';
                areas.forEach(area => {
                    let option = document.createElement('option');
                    option.value = area.Id;
                    option.text = area.Name;
                    if (selectedArea == area.Id) option.selected = true;
                    areasSelect.appendChild(option);
                })
            }
        }

        var createEditModalView = {
            init: function () {
                this.addEventToOpener();
                this.replaceModalHandlers();
                this.initializeButtons();
                tabSystem.enableSteps();
            },
            addEventToOpener: function () {
                document.getElementById('open-modal-edit-create').addEventListener('click', (e) => {
                    e.preventDefault();
                    rulesRepositoryController.handleOpenItem();
                })
            },
            replaceModalHandlers: function () {
                modalController.changeCloseModalMethod('cadastrar_editar_repositorio_regras', (e) => {
                    e.preventDefault();
                    this.close();
                })
                modalController.disableModalDisposal('cadastrar_editar_repositorio_regras');
            },
            initializeButtons: function () {
                document.getElementById('cancel-button').addEventListener('click', (e) => {
                    e.preventDefault();
                    modalController.closeModal('cadastrar_editar_repositorio_regras');
                });
                document.getElementById('save-and-close').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.saveAndCloseHandler();
                });
                document.getElementById('back-button').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.backButtonHandler();
                });
                document.getElementById('next-page-button').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.nextStepHandler();
                });
                document.getElementById('new-version-open').addEventListener('click', (e) => {
                    e.preventDefault();
                    newVersionView.openDialog();
                });
                document.getElementById('publish-button').addEventListener('click', (e) => {
                    e.preventDefault();
                    rulesRepositoryController.publishRepository()
                        .then(_ => {
                            this.close();
                        });
                });
            },
            backButtonHandler: function () {
                const item = rulesRepositoryController.getOpen();
                switch (tabSystem.getPage()) {
                    case 3:
                        this.renderPage2(item);
                        rulesRepositoryController.setSelectedRule(null);
                        break;
                    default:
                        this.renderPage1(item);
                        break;
                }
            },
            saveAndCloseHandler: function () {
                this.enterLoadingState();
                switch (tabSystem.getPage()) {
                    case 1:
                        rulesRepositoryController.handleEditCreateRepository()
                            .then(resp => {
                                this.close();
                            });
                        break;
                    case 2:
                        rulesRepositoryController.handleUpdateParameters()
                            .then(resp => {
                                this.close();
                            });
                        break;
                    case 3:
                        this.close();
                        break;
                }
            },
            nextStepHandler: function () {
                this.enterLoadingState();
                switch (tabSystem.getPage()) {
                    case 1:
                        rulesRepositoryController.handleEditCreateRepository()
                            .then(resp => {
                                rulesRepositoryController.setOpen(resp);
                                this.updateTitle(resp);
                                tabSystem.setStepDone(1);
                                this.renderPage2(resp);
                                this.leaveLoadingState();
                            });
                        break;
                    case 2:
                        rulesRepositoryController.handleUpdateParameters()
                            .then(resp => {
                                tabSystem.setStepDone(2);
                                this.renderPage3(rulesRepositoryController.getOpen());
                                this.leaveLoadingState();
                                this.leaveLoadingState();
                            });
                        break;
                    case 3:
                        break;
                }
            },
            render: function (item) {
                if (item) {
                    if (item.PublishDate != '') {
                        this.renderPage3(item);
                        this.renderPage2(item);
                        this.renderPage1(item);
                        this.enableViewMode();
                    } else if (item.Parameters == null) {
                        tabSystem.setStepDone(1);
                        this.renderPage2(item);
                    } else {
                        tabSystem.setStepDone(1);
                        tabSystem.setStepDone(2);
                        this.renderPage3(item);
                    }
                } else {
                    this.changeSaveAndNextButton(true);
                    this.changeCancelBackButton(false);
                    this.disableViewMode();
                    this.renderPage1(item);
                }
            },
            enableViewMode: function () {
                modalController.addClassToModalBody('cadastrar_editar_repositorio_regras', 'view-mode');
                tabSystem.enableTabs();
                tabSystem.disableSteps();
                document.querySelectorAll('.cadastrar-editar-modal-body fieldset').forEach(fieldset => {
                    fieldset.setAttribute('disabled', '');
                });
            },
            disableViewMode: function () {
                modalController.removeClassFromModalBody('cadastrar_editar_repositorio_regras', 'view-mode');
                tabSystem.disableTabs();
                tabSystem.enableSteps();
                document.querySelectorAll('.cadastrar-editar-modal-body fieldset').forEach(fieldset => {
                    fieldset.removeAttribute('disabled');
                });
            },
            renderPage1: function (item) {
                document.getElementById('cancel-button').setAttribute('style', 'display: flex');
                document.getElementById('back-button').setAttribute('style', 'display: none');
                document.getElementById('next-page-button').setAttribute('style', 'display: flex');
                document.getElementById('publish-button').setAttribute('style', 'display: none');
                const nameInput = document.getElementById('name-input');
                nameInput.value = item ? item.Name : '';
                nameInput.removeEventListener('input', this.nameChangeHandler);
                nameInput.addEventListener('input', this.nameChangeHandler);
                if (item?.Name) this.changeSaveAndNextButton(false);
                tabSystem.setPage(1);
            },
            renderPage2: function (item) {
                document.getElementById('cancel-button').setAttribute('style', 'display: none');
                document.getElementById('back-button').setAttribute('style', 'display: flex');
                document.getElementById('next-page-button').setAttribute('style', 'display: flex');
                document.getElementById('publish-button').setAttribute('style', 'display: none');
                const pageContainer = document.querySelector('div[data-page="2"]');
                pageContainer.innerHTML = '';
                this.changeSaveButton(false);
                if (!item.Parameters || (item.Parameters?.length == 0)) {
                    const emptyStateTemplate = document.importNode(document.getElementById('empty-state-parametros').content, true);
                    emptyStateTemplate.querySelector('button').addEventListener('click', (e) => {
                        e.preventDefault();
                        rulesRepositoryController.addNewParameter()
                        this.renderPage2(item);
                    })
                    pageContainer.appendChild(emptyStateTemplate);
                    this.changeNextButton(true);
                } else {
                    const listTemplate = document.importNode(document.getElementById('listagem-parametros').content, true);
                    listTemplate.querySelector('input[name="busca-parametros"]').addEventListener('keydown', (e) => { // previne que o usuário dê um submit no form da página através do input de busca
                        if (e.key == "Enter" || e.keyCode == 13) {
                            e.preventDefault();
                        }
                    });
                    listTemplate.querySelector('input[name="busca-parametros"]').addEventListener('input', (e) => {
                        this.renderParameters(item.Parameters);
                    })
                    listTemplate.getElementById('add-new-parameter-button').addEventListener('click', e => {
                        e.preventDefault();
                        const newItem = rulesRepositoryController.addNewParameter();
                        const newIndex = rulesRepositoryController.getOpen()?.Parameters?.length;
                        this.renderParameterItem(newItem, newIndex - 1, true, document.querySelector('input[name="busca-parametros"]').value);
                    })
                    pageContainer.appendChild(listTemplate);
                    this.renderParameters(item.Parameters);
                    rulesRepositoryController.validateParameterList(item.Parameters);
                }
                feather.replace();
                tabSystem.setPage(2);
            },
            renderParameters: function (parameters) {
                const filter = document.querySelector('input[name="busca-parametros"]').value;
                document.querySelector('ul.lista-parametros').innerHTML = '';
                parameters.forEach((parameter, p_index) => {
                    this.renderParameterItem(parameter, p_index, p_index == (parameters.length - 1), filter);
                })
            },
            renderParameterItem: function (parameter, index, open = false, filter) {
                const filterRegex = new RegExp(filter, 'g');
                // caso esteja ocorrendo um filtro, verifica se o item atual faz parte da filtragem
                if (filter != '' && !parameter.Name.match(filterRegex)) {
                    return;
                }
                const container = document.querySelector('ul.lista-parametros');
                const openRepository = rulesRepositoryController.getOpen();
                const itemTemplate = document.importNode(document.getElementById('item-listagem-parametros').content, true);
                //decide se abre o header
                const li = itemTemplate.querySelector('li');
                li.setAttribute('id', `parameter-${index}`);
                const accordionHeader = itemTemplate.querySelector('.accordion-header');
                if (open && !openRepository.PublishDate) accordionHeader.classList.add('open');

                // adiciona radio types
                const paramTypes = rulesRepositoryController.getParamTypes();
                if (paramTypes?.length > 0) {
                    const paramTypeRadioTemplate = document.getElementById('param-radio-type').content;
                    paramTypes.forEach((paramType, param_index) => {
                        const typeRadioTemplateNode = document.importNode(paramTypeRadioTemplate, true);
                        const radio = typeRadioTemplateNode.querySelector('input[type=radio]');
                        const label = typeRadioTemplateNode.querySelector('label');
                        radio.setAttribute('id', `type-${paramType.Name}-${index}`);
                        radio.setAttribute('data-index', index);
                        radio.setAttribute('name', `type-${index}`);
                        radio.value = paramType.Type;
                        label.setAttribute('for', `type-${paramType.Name}-${index}`);
                        label.innerHTML = paramType.Name;
                        if (param_index == 0) radio.checked = true;
                        itemTemplate.querySelector('div[data-render="radios-types"]').appendChild(typeRadioTemplateNode);
                    })

                    if (parameter.Type) itemTemplate.querySelector(`input[name="type-${index}"][value="${parameter.Type}"]`).checked = true;
                }

                //bind de dados se for um parametro previamente cadastrado.
                const nameInput = itemTemplate.querySelector('input[name="nome_parametro"]');
                nameInput.value = parameter.Name ?? '';
                nameInput.setAttribute('data-index', index);
                if (parameter.Name != '') li.classList.add('done');
                const headerName = itemTemplate.querySelector('span[data-render="nome_parametro"]');
                headerName.innerHTML = parameter.Name ?? '';
                const defaultValueInput = itemTemplate.querySelector('input[name="default_value"]');
                defaultValueInput.value = parameter.DefaultValue ?? '';
                defaultValueInput.setAttribute('data-index', index);


                const optionsContainer = itemTemplate.querySelector('.default-value-options');
                const updateDefaultValueType = (type) => {
                    const paramType = paramTypes.find(el => el.Type == type);
                    optionsContainer.innerHTML = '';
                    defaultValueInput.removeEventListener('keypress', this.permitirApenasNumerosKeyPressEvent);
                    defaultValueInput.removeEventListener('keypress', this.permitirDecimalKeyPressEvent);
                    defaultValueInput.removeAttribute('step');


                    if (paramType.InputType == 'radio') { // se é um parametro do tipo radio, renderiza os radios e esconde o input de default
                        defaultValueInput.setAttribute('type', 'hidden');
                        paramType.InputOptions.forEach(paramOption => {
                            const containerDiv = document.createElement('div');
                            containerDiv.classList.add('d-flex', 'mr-2', 'align-center');
                            const optionRadio = document.createElement('input');
                            const optionLabel = document.createElement('label');
                            const paramOptionId = `paramoption-${index}-${paramOption.Value}`;
                            optionLabel.innerText = paramOption.Text;
                            optionLabel.setAttribute('for', paramOptionId);
                            optionLabel.classList.add('labelItem');
                            optionRadio.setAttribute('id', paramOptionId);
                            optionRadio.setAttribute('type', 'radio');
                            optionRadio.value = paramOption.Value;
                            optionRadio.setAttribute('name', `paramoption-${index}`);
                            optionRadio.setAttribute('data-index', index);

                            if (parameter.DefaultValue === paramOption.Value) optionRadio.checked = true;

                            containerDiv.appendChild(optionRadio);
                            containerDiv.appendChild(optionLabel);
                            optionsContainer.appendChild(containerDiv);

                        })
                        optionsContainer.classList.add('d-flex');
                    } else {
                        optionsContainer.classList.remove('d-flex');
                        defaultValueInput.setAttribute('type', paramType.InputType);


                        if (paramType.InputType == 'number') {
                            if (paramType.Step) {
                                defaultValueInput.setAttribute('step', paramType.Step);
                                defaultValueInput.addEventListener('keypress', this.permitirDecimalKeyPressEvent);
                                // input do tipo decimal
                            } else {
                                // input do tipo number
                                defaultValueInput.addEventListener('keypress', this.permitirApenasNumerosKeyPressEvent);
                            }
                        }
                    }
                };
                updateDefaultValueType(parameter.Type);

                // adiciona eventos
                itemTemplate.querySelector('button[data-render="accordion-trigger"]').addEventListener('click', e => { //adiciona listener para a abertura do accordion
                    e.preventDefault();
                    accordionHeader.classList.toggle('open');
                })
                nameInput.addEventListener('input', (e) => { // listener para mudanças no input de nome
                    headerName.innerHTML = e.target.value;
                })
                itemTemplate.querySelector('button.delete').addEventListener('click', (e) => {
                    e.preventDefault();
                    deleteParameterView.openDialog(index);
                })
                itemTemplate.querySelector('fieldset').addEventListener('input', (e) => {
                    const name = e.target.getAttribute('name');
                    let attribute = '';
                    if (name == 'nome_parametro') {
                        attribute = "Name";
                    } else if (name.match(/type-/g)) {
                        attribute = "Type";
                        updateDefaultValueType(e.target.value);
                        rulesRepositoryController.updateParameter("DefaultValue", "", e.target.getAttribute('data-index'));
                        defaultValueInput.value = '';
                    } else {
                        attribute = "DefaultValue";
                    }
                    rulesRepositoryController.updateParameter(attribute, e.target.value, e.target.getAttribute('data-index'));
                })

                container.appendChild(itemTemplate);
                // se o usuário não estiver filtrando, da foco no botão.
                if (open && filter == '' && !openRepository.PublishDate) document.querySelector(`#parameter-${index} input[name="nome_parametro"]`).scrollIntoView();
                feather.replace();
            },
            renderPage3: function (item) {
                document.getElementById('cancel-button').setAttribute('style', 'display: none');
                document.getElementById('back-button').setAttribute('style', 'display: flex');
                document.getElementById('next-page-button').setAttribute('style', 'display: none');
                document.getElementById('publish-button').setAttribute('style', 'display: flex');
                const pageContainer = document.querySelector('div[data-page="3"]');
                this.changeSaveButton(false);
                pageContainer.innerHTML = '';
                if (!item.Rules) {
                    const emptyStateTemplate = document.importNode(document.getElementById('empty-state-regras').content, true);
                    emptyStateTemplate.querySelector('button').addEventListener('click', (e) => {
                        e.preventDefault();
                        rulesRepositoryController.enableRulesEdit();
                        this.renderPage3(item);
                    })
                    pageContainer.appendChild(emptyStateTemplate);
                    this.changeNextButton(true);
                } else {
                    const rulesLayout = document.importNode(document.getElementById('cadastro-regras-layout').content, true);
                    const novaRegraInput = rulesLayout.querySelector('input[data-render="nova-regra"]');
                    novaRegraInput.addEventListener('keydown', (e) => {
                        if (e.key == "Enter" || e.keyCode == 13) {
                            e.preventDefault();
                            this.handleNewRule();
                        }
                    });
                    novaRegraInput.addEventListener('blur', (e) => {
                        setTimeout(() => {
                            novaRegraInput.value = "";
                        }, 500)
                    });
                    rulesLayout.querySelector('input[data-render="input-busca-regra"]').addEventListener('keydown', (e) => { // previne que o usuário dê um submit no form da página através do input de busca
                        if (e.key == "Enter" || e.keyCode == 13) {
                            e.preventDefault();
                        }
                    });
                    rulesLayout.querySelector('input[data-render="input-busca-regra"]').addEventListener('input', (e) => {
                        this.renderRules(item.Rules);
                    });
                    rulesLayout.getElementById('nova-regra-button').addEventListener('click', (e) => {
                        e.preventDefault();
                        this.handleNewRule();
                    });
                    pageContainer.appendChild(rulesLayout);
                    this.renderRules(item.Rules);
                }
                feather.replace();
                tabSystem.setPage(3);
            },
            renderRules: function (rules) { // renderiza o layout da página de regras e condições. Associa os comportamentos de criar novas regras, selecionar regra e 
                document.querySelector('.cadastro-regras-listagem-container').innerHTML = '';
                this.buscaRegraHabilitada(rules.length > 0);
                rules.forEach((rule, index) => {
                    this.renderRule(rule, index);
                });
                this.validateRulesList();
            },
            renderRule: function (rule, index) {
                const filter = document.querySelector('.cadastro-regras-header input[data-render="input-busca-regra"]').value;
                const selectedRule = rulesRepositoryController.getSelectedRule();
                const open = rulesRepositoryController.getOpen();
                const filterRegex = new RegExp(filter.toLowerCase(), 'g');
                // caso esteja ocorrendo um filtro, verifica se o item atual faz parte da filtragem
                if (filter != '' && !rule.Alias.toLowerCase().match(filterRegex)) {
                    return;
                }
                const container = document.querySelector('.cadastro-regras-listagem-container');
                const ruleLayout = document.importNode(document.getElementById('rule-template').content, true);
                const ruleContainer = ruleLayout.querySelector('.rule');
                const nameInput = ruleLayout.querySelector('input');

                // set attributes
                ruleContainer.setAttribute('rule-index', index);
                nameInput.setAttribute('rule-index', index);

                // data binding
                nameInput.value = rule.Alias;
                if (rule.Text) ruleLayout.querySelector('.status').classList.add('done');

                // checa se essa regra é a regra selecionada
                if (rule.Id == selectedRule?.Id) {
                    const currentSelected = document.querySelector('.rule.selected');
                    if (currentSelected) currentSelected.classList.remove('selected');

                    ruleContainer.classList.add('selected');
                }

                // adiciona os eventos necessários
                // adiciona evento de click à primeira porção da regra para evitar evento de click no dropdown de opções.
                ruleContainer.querySelector('div:first-of-type').addEventListener('click', (e) => {
                    e.preventDefault();
                    if (ruleContainer.classList.contains('selected')) {
                        ruleContainer.classList.remove('selected');
                        rulesRepositoryController.setSelectedRule(null);
                    } else {
                        const currentSelected = document.querySelector('.rule.selected');
                        if (currentSelected) currentSelected.classList.remove('selected');

                        ruleContainer.classList.add('selected');
                        rulesRepositoryController.setSelectedRule(rule);
                    }
                });
                if (!open.PublishDate) {
                    nameInput.addEventListener('keydown', (e) => {
                        if (e.key == "Enter" || e.keyCode == 13) {
                            e.preventDefault();
                            e.target.setAttribute('readonly', "");
                            e.target.blur();
                        }
                    });
                    nameInput.addEventListener('blur', (e) => {
                        if (e.target.value != rule.Alias) {
                            rulesRepositoryController.editRule(e.target.value, index);
                        }
                        e.target.setAttribute('readonly', "");
                    });
                    nameInput.addEventListener('dblclick', () => {
                        nameInput.removeAttribute('readonly');
                    })
                }
                ruleLayout.querySelector('button[data-render="delete-rule-button"]').addEventListener('click', (e) => {
                    e.preventDefault();
                    deleteRegisterView.openDialog(index, 'handleDeleteRule');
                });
                ruleLayout.querySelector('button[data-render="enable-edit-rule"]').addEventListener('click', (e) => {
                    e.preventDefault();
                    nameInput.removeAttribute('readonly');
                    nameInput.focus();
                });
                container.appendChild(ruleLayout);
                feather.replace();
            },
            handleNewRule: function () {
                const input = document.querySelector('div[data-page="3"] input[data-render="nova-regra"]');
                if (input.value != '') {
                    rulesRepositoryController.addNewRule(input.value).then(newRule => {
                        const newIndex = rulesRepositoryController.getOpen()?.Rules?.length;
                        input.value = '';
                        if (newRule) {
                            rulesRepositoryController.setSelectedRule(newRule);
                            createEditModalView.renderRule(newRule, newIndex - 1);
                        }
                    })
                }
            },
            buscaRegraHabilitada: function (habilitada) {
                if (habilitada) {
                    document.querySelector('.cadastro-regras-header input[data-render="input-busca-regra"]').setAttribute('type', 'text');
                } else {
                    document.querySelector('.cadastro-regras-header input[data-render="input-busca-regra"]').setAttribute('type', 'hidden');
                }
            },
            validateRulesList: function () {
                const open = rulesRepositoryController.getOpen();
                if (open.Rules?.length > 0) {
                    this.changeNextButton(false);
                    open.Rules.forEach(rule => {
                        if (!rule.Text) {
                            this.changeNextButton(true);
                            return;
                        }
                    })
                } else {
                    this.changeNextButton(true);
                }
            },
            renderLayoutCondicoes: function () {
                const rule = rulesRepositoryController.getSelectedRule();
                const conditionsContainer = document.querySelector('div[data-page="3"] .cadastro-condicoes');
                conditionsContainer.innerHTML = '';
                if (!rule) return;
                if (!rule.Content || (rule.Content?.length == 0)) { // empty state de condições
                    const emptyStateTemplate = document.importNode(document.getElementById('empty-state-condicoes').content, true);
                    emptyStateTemplate.querySelector('button').addEventListener('click', (e) => {
                        e.preventDefault();
                        rulesRepositoryController.addNewCondition();
                        this.renderLayoutCondicoes(rule);
                    });
                    conditionsContainer.appendChild(emptyStateTemplate);
                } else if (rule.Text) {
                    const textTemplate = document.importNode(document.getElementById('layout-text-condicoes').content, true);
                    // data bind
                    textTemplate.querySelector('h6[data-render="Alias"]').innerHTML = rule.Alias;
                    textTemplate.querySelector('span[data-render="Text"]').innerHTML = rule.Text;

                    // adiciona evento de habilitar edição
                    textTemplate.querySelector('button').addEventListener('click', (e) => {
                        e.preventDefault();
                        rulesRepositoryController.enableConditionsEdit();
                    });

                    conditionsContainer.appendChild(textTemplate);
                } else {
                    // renderiza a listagem de condições.
                    const layoutTemplate = document.importNode(document.getElementById('layout-listagem-condicoes').content, true);
                    layoutTemplate.querySelector('h6[data-render="Alias"]').innerHTML = rule.Alias;
                    layoutTemplate.querySelector('button[data-render="adicionar-condicoes"]').addEventListener('click', (e) => {
                        e.preventDefault();
                        rulesRepositoryController.addNewCondition();
                    });
                    layoutTemplate.querySelector('button[data-render="salvar-condicoes"]').addEventListener('click', (e) => {
                        e.preventDefault();
                        e.target.setAttribute('disabled', '');
                        rulesRepositoryController.updateSelectedRuleConditions()
                            .then(_ => {
                                e.target.removeAttribute('disabled');
                            });
                    });
                    layoutTemplate.querySelector('button[data-render="cancel-condicoes"]').addEventListener('click', (e) => {
                        e.preventDefault();
                        cancelConditionConfigView.openDialog();
                    })
                    conditionsContainer.appendChild(layoutTemplate);
                    this.renderCondicoes(rule.Content);
                }
                feather.replace();
            },
            renderCondicoes: function (conditions) {
                conditions.forEach((condition, index) => {
                    this.renderCondicao(condition, index);
                });
                this.bringAddedConditionToViewport();
                this.validateConditionList();
            },
            renderCondicao: function (condition, index) {
                const logicalOperators = rulesRepositoryController.getLogicalOperators();
                // utiliza o operatorAlias para decidir qual template renderizar
                if (logicalOperators.find(loperator => loperator.Alias == condition.OperatorAlias)) {
                    this.renderLogicalCondition(condition, index, logicalOperators)
                } else {
                    this.renderRegularCondition(condition, index);
                }
            },
            renderLogicalCondition: function (condition, index, logicalOperators) {
                const container = document.querySelector('.cadastro-condicoes .listagem-condicoes');
                const conditionTemplate = document.importNode(document.getElementById('logical-operator-template').content, true);
                const radioContainers = conditionTemplate.querySelector('.zuri-radio-inputs');
                // monta a estrutura de radio buttons 
                logicalOperators.forEach(loperator => {
                    let radioinput = document.createElement('input');
                    let label = document.createElement('label');
                    radioinput.value = loperator.Alias;
                    radioinput.setAttribute('type', 'radio');
                    radioinput.setAttribute('name', `OperatorAlias-${index}`);
                    radioinput.setAttribute('id', `${loperator.Alias}-${index}`);
                    if (loperator.Alias == condition.OperatorAlias) radioinput.setAttribute('checked', '');
                    label.innerHTML = loperator.Text;
                    label.setAttribute('for', `${loperator.Alias}-${index}`);
                    radioContainers.appendChild(radioinput);
                    radioContainers.appendChild(label);
                });
                radioContainers.addEventListener('input', (e) => {
                    rulesRepositoryController.updateCondition(index, e.target.getAttribute('name').split('-')[0], e.target.value);
                })
                container.appendChild(conditionTemplate);
            },
            renderRegularCondition: function (condition, index) {
                const container = document.querySelector('.cadastro-condicoes .listagem-condicoes');
                const operadoresDoTipoListagem = ["IN", "NOTIN"]
                const conditionTemplate = document.importNode(document.getElementById('condicoes-template').content, true);
                const open = rulesRepositoryController.getOpen();
                const operators = rulesRepositoryController.getOperators();
                const selectParmetros = conditionTemplate.querySelector('select[data-render="parameters"]');
                const selectOperators = conditionTemplate.querySelector('select[data-render="operators"]');
                const param1FieldsetContainer = conditionTemplate.querySelector('div[data-render="parameter1"] fieldset[data-render="param-1"]')
                const param2FieldsetContainer = conditionTemplate.querySelector('div[data-render="parameter2"] fieldset[data-render="param-2"]')
                const inputparam1 = conditionTemplate.querySelector('div[data-render="parameter1"] input');
                const inputparam2 = conditionTemplate.querySelector('div[data-render="parameter2"] input');

                // identifica se é o primeiro da listagem
                if (index == 0) {
                    conditionTemplate.querySelector('.condicao-container').classList.add('first');
                }

                // adiciona index ao html para buscas
                conditionTemplate.querySelector('.condicao-container').setAttribute('condition-index', index);

                // adiciona os devidos names aos inputs
                selectParmetros.setAttribute('name', `Variable-${index}`);
                selectOperators.setAttribute('name', `OperatorAlias-${index}`);
                inputparam1.setAttribute('name', `Param1-${index}`);
                inputparam2.setAttribute('name', `Param2-${index}`);

                // cria as options para parametros e operadores e faz o data binding do item que está selecionado
                open.Parameters.forEach(parameter => {
                    let option = document.createElement('option');
                    option.value = parameter.Name;
                    option.text = parameter.Name;
                    selectParmetros.appendChild(option);
                });
                operators.forEach(operator => {
                    let option = document.createElement('option');
                    option.value = operator.Alias;
                    option.text = operator.Text;
                    selectOperators.appendChild(option);
                });

                const paramOptionsContainer = conditionTemplate.querySelector('.param-option-list');
                const addToParamList = (e) => {
                    if (e.key == "Enter" || e.keyCode == 13 || e.key == ';' || e.keyCode == 59) {
                        e.preventDefault();
                        const name = e.target.getAttribute('name').split('-')[0];
                        const currentCondition = rulesRepositoryController.getSelectedRule().Content[index];
                        rulesRepositoryController.updateCondition(index, name, currentCondition[name] != '' ? `${currentCondition[name]};${e.target.value}` : e.target.value);
                        e.target.value = '';
                        renderParamList();
                        this.validateConditionList();
                    }
                }
                const removeFromParamList = (indexToRemove) => {
                    const currentCondition = rulesRepositoryController.getSelectedRule().Content[index];
                    const paramList = currentCondition.Param1.split(';');
                    paramList.splice(indexToRemove, 1);
                    rulesRepositoryController.updateCondition(index, 'Param1', paramList.join(';'));
                }
                const renderParamList = () => {
                    paramOptionsContainer.innerHTML = '';
                    const paramList = condition.Param1.split(';');
                    if (paramList.length > 0) {
                        paramList.forEach((paramItem, paramitemindex) => {
                            if (paramItem != '') {
                                const paramListItemTemplate = document.importNode(document.getElementById('param-option-item').content, true);
                                paramListItemTemplate.querySelector('span').innerText = paramItem;
                                paramListItemTemplate.querySelector('button').addEventListener('click', (e) => {
                                    e.preventDefault();
                                    removeFromParamList(paramitemindex);
                                    renderParamList();
                                    this.validateConditionList();
                                })
                                paramOptionsContainer.appendChild(paramListItemTemplate);
                            }
                        })
                    }
                    paramOptionsContainer.classList.remove('d-none');
                    feather.replace();
                }

                // bind dos dados com os inputs
                selectParmetros.value = condition.VariableName ?? condition.Variable;
                selectOperators.value = condition.OperatorAlias;
                (!operadoresDoTipoListagem.includes(condition.OperatorAlias)) ? (inputparam1.value = condition.Param1Name ? condition.Param1Name : (condition.Param1 ?? '')) : renderParamList();
                inputparam2.value = condition.Param2Name ? condition.Param2Name : (condition.Param2 ?? '');

                // habilita ou desabilita os inputs de parametro de acordo com o operador
                const operator = rulesRepositoryController.getOperatorFromAlias(condition.OperatorAlias);
                if (operator) {
                    (!operator.HasParam1) ? param1FieldsetContainer.setAttribute('disabled', '') : param1FieldsetContainer.removeAttribute('disabled');
                    (!operator.HasParam2) ? param2FieldsetContainer.setAttribute('disabled', '') : param2FieldsetContainer.removeAttribute('disabled');
                } else {
                    param1FieldsetContainer.setAttribute('disabled', '');
                    param2FieldsetContainer.setAttribute('disabled', '');
                }

                // renderiza o tipo dos inputs de parametro
                const optionsContainer = conditionTemplate.querySelector('.default-value-options');
                const atualizaTiposDosParametros = (paramName) => {
                    const parameter = rulesRepositoryController.getOpen().Parameters.find(p => p.Name == paramName);
                    const disabled_operators_while_radio_type = ['<', '>', '>=', '<=', 'BETWEEN', 'CONTAINS', 'IN', 'NOTIN'];
                    if (parameter) {
                        optionsContainer.innerHTML = '';
                        const paramType = rulesRepositoryController.getParamTypes().find(el => el.Type == parameter.Type);
                        // renderiza o tipo apropriadamente
                        if (paramType.InputType != 'radio') {
                            inputparam1.setAttribute('type', paramType.InputType);
                            inputparam2.setAttribute('type', paramType.InputType);
                            inputparam1.removeAttribute('step');
                            inputparam2.removeAttribute('step');
                            optionsContainer.classList.remove('d-flex');

                            // limpa qualquer listener dos inputs de parametro
                            inputparam1.removeEventListener('keypress', this.permitirApenasNumerosKeyPressEvent);
                            inputparam2.removeEventListener('keypress', this.permitirApenasNumerosKeyPressEvent);
                            inputparam1.removeEventListener('keypress', this.permitirDecimalKeyPressEvent);
                            inputparam2.removeEventListener('keypress', this.permitirDecimalKeyPressEvent);

                            //habilita operadores que não podem ser combinados com parametros do tipo radio
                            disabled_operators_while_radio_type.forEach(disabledOperator => {
                                selectOperators.querySelector(`option[value="${disabledOperator}"]`).classList.remove('d-none');
                            })

                            if (paramType.InputType == 'number') {
                                if (paramType.Step) {
                                    // input do tipo decimal
                                    inputparam1.setAttribute('step', paramType.Step);
                                    inputparam2.setAttribute('step', paramType.Step);
                                    inputparam1.addEventListener('keypress', this.permitirDecimalKeyPressEvent);
                                    inputparam2.addEventListener('keypress', this.permitirDecimalKeyPressEvent);
                                } else {
                                    // input do tipo number
                                    inputparam1.addEventListener('keypress', this.permitirApenasNumerosKeyPressEvent);
                                    inputparam2.addEventListener('keypress', this.permitirApenasNumerosKeyPressEvent);
                                }
                            }
                        } else {
                            //renderiza o input do tipo radio para seleção entre as opções.
                            paramType.InputOptions.forEach(paramOption => {
                                const containerDiv = document.createElement('div');
                                containerDiv.classList.add('d-flex', 'mr-2', 'align-center');
                                const optionRadio = document.createElement('input');
                                const optionLabel = document.createElement('label');
                                const paramOptionId = `paramoption-${index}-${paramOption.Value}`;
                                optionLabel.innerText = paramOption.Text;
                                optionLabel.setAttribute('for', paramOptionId);
                                optionLabel.classList.add('labelItem');
                                optionRadio.setAttribute('id', paramOptionId);
                                optionRadio.setAttribute('type', 'radio');
                                optionRadio.value = paramOption.Value;
                                optionRadio.setAttribute('name', `Param1-${index}`);
                                optionRadio.setAttribute('data-index', index);

                                console.log(condition.Param1);
                                console.log(paramOption.Value);
                                console.log(condition.Param1 == JSON.parse(paramOption.Value));
                                if (condition.Param1 == JSON.parse(paramOption.Value)) optionRadio.checked = true;

                                containerDiv.appendChild(optionRadio);
                                containerDiv.appendChild(optionLabel);
                                optionsContainer.appendChild(containerDiv);

                            })
                            optionsContainer.classList.add('d-flex');

                            //desabilita operadores que não podem ser combinados com parametros do tipo radio
                            disabled_operators_while_radio_type.forEach(disabledOperator => {
                                selectOperators.querySelector(`option[value="${disabledOperator}"]`).classList.add('d-none');
                            });

                            inputparam1.setAttribute('type', 'hidden');
                            inputparam2.setAttribute('type', 'hidden');
                        }
                    }
                }
                const limparParametros = () => {
                    rulesRepositoryController.updateCondition(index, "Param1", "");
                    inputparam1.value = "";
                }
                const limparParametrosEResetaSelectDeOperadores = () => {
                    //limpa os parametros e reseta o select de operadores
                    paramOptionsContainer.innerHTML = '';
                    //rulesRepositoryController.updateCondition(index, "OperatorAlias", "");
                    selectOperators.value = "";
                    selectOperators.dispatchEvent(new Event('input', { bubbles: true }));
                    limparParametros();
                }
                const atualizaInputDeParametro = () => {
                    const currentCondition = rulesRepositoryController.getSelectedRule().Content[index];
                    if (operadoresDoTipoListagem.includes(currentCondition.OperatorAlias)) {
                        inputparam1.addEventListener('keydown', addToParamList);
                    } else {
                        inputparam1.removeEventListener('keydown', addToParamList);
                        paramOptionsContainer.classList.add('d-none');
                    }
                }
                atualizaTiposDosParametros(condition.VariableName ?? condition.Variable);
                atualizaInputDeParametro();


                // adiciona evento de input para captar mudanças nas condiçoes
                conditionTemplate.querySelector('fieldset').addEventListener('input', (e) => {
                    const name = e.target.getAttribute('name').split('-')[0];
                    const currentCondition = rulesRepositoryController.getSelectedRule().Content[index];
                    if (name == "Param1" && operadoresDoTipoListagem.includes(currentCondition.OperatorAlias)) return; // desabilita modificações em parametros em caso de parametro do tipo listagem
                    rulesRepositoryController.updateCondition(index, name, e.target.value);
                    if (name == "OperatorAlias") {
                        const operator = rulesRepositoryController.getOperatorFromAlias(e.target.value);
                        if (operator) {
                            (!operator.HasParam1) ? param1FieldsetContainer.setAttribute('disabled', '') : param1FieldsetContainer.removeAttribute('disabled');
                            (!operator.HasParam2) ? param2FieldsetContainer.setAttribute('disabled', '') : param2FieldsetContainer.removeAttribute('disabled');
                        } else {
                            param1FieldsetContainer.setAttribute('disabled', '');
                            param2FieldsetContainer.setAttribute('disabled', '');
                        }
                        paramOptionsContainer.innerHTML = '';
                        atualizaInputDeParametro();
                        if (operator.HasParam1) limparParametros();
                    } else if (name == "Variable") {
                        limparParametrosEResetaSelectDeOperadores();
                        atualizaTiposDosParametros(e.target.value);
                    }
                    this.validateConditionList();
                });

                //adiciona eventos de click para criação de novas conditions
                conditionTemplate.querySelector('div[data-render="condicao-up"]').addEventListener('click', (e) => {
                    e.preventDefault();
                    rulesRepositoryController.addNewCondition('up', index);
                });
                conditionTemplate.querySelector('div[data-render="condicao-down"]').addEventListener('click', (e) => {
                    e.preventDefault();
                    rulesRepositoryController.addNewCondition('down', index);
                });

                // adiciona evento para deletar conditions
                conditionTemplate.querySelector('button[data-render="delete-condicao"]').addEventListener('click', (e) => {
                    e.preventDefault();
                    deleteRegisterView.openDialog(index, 'handleDeleteCondition');
                });

                container.appendChild(conditionTemplate);
            },
            permitirApenasNumerosKeyPressEvent: function (evt) {
                evt = (evt) ? evt : window.event;
                var charCode = (evt.which) ? evt.which : evt.keyCode;
                if (charCode > 31 && (charCode < 48 || charCode > 57)) {
                    evt.preventDefault();
                }
                return;
            },
            permitirDecimalKeyPressEvent: function (evt) {
                evt = (evt) ? evt : window.event;
                const validationRegex = new RegExp(/^(\d+\.?\d*)/);
                const futureValue = `${evt.currentTarget.value}${evt.key}`;
                if (!(futureValue.match(validationRegex))) evt.preventDefault();
                if (!(futureValue.match(validationRegex)[0] == futureValue)) {
                    evt.preventDefault();
                }
                return;
            },
            validateConditionList: function () {
                const okButton = document.querySelector('button[data-render="salvar-condicoes"]');
                const content = rulesRepositoryController.getSelectedRule().Content;
                console.log(content);
                if (content.length > 0) {
                    okButton.removeAttribute('disabled');
                    for (i = 0; i < content.length; i++) {
                        if ((content[i].Variable != '') && (content[i].OperatorAlias != '')) { // se não tiver parametro selecionado ou operador
                            // se tiver um parametro e ele não for diferente de vazio
                            if ((content[i].Param1 != null) && !(content[i].Param1 !== '')) {
                                okButton.setAttribute('disabled', '');
                                return;
                            }
                            if ((content[i].Param2 != null) && !(content[i].Param2 !== '')) {
                                okButton.setAttribute('disabled', '');
                                return;
                            }
                        } else {
                            okButton.setAttribute('disabled', '');
                            return;
                        }
                    }
                } else {
                    okButton.setAttribute('disabled', '');
                }
            },
            bringAddedConditionToViewport: function () {
                const lastAddedIndex = rulesRepositoryController.getLastAddedConditionIndex();
                if (lastAddedIndex) {
                    document.querySelector(`.condicao-container[condition-index="${lastAddedIndex}"]`)?.scrollIntoView();
                }
            },
            changeSaveAndNextButton: function (disabled) {
                this.changeNextButton(disabled);
                this.changeSaveButton(disabled);
            },
            changeNextButton: function (disabled) {
                if (disabled) {
                    document.getElementById('next-page-button').setAttribute('disabled', disabled);
                    document.getElementById('publish-button').setAttribute('disabled', disabled);
                } else {
                    document.getElementById('next-page-button').removeAttribute('disabled');
                    document.getElementById('publish-button').removeAttribute('disabled');
                }
            },
            changeSaveButton: function (disabled) {
                disabled ?
                    document.getElementById('save-and-close').setAttribute('disabled', disabled)
                    :
                    document.getElementById('save-and-close').removeAttribute('disabled')
            },
            changeCancelBackButton: function (disabled) {
                if (disabled) {
                    document.getElementById('cancel-button').setAttribute('disabled', disabled);
                    document.getElementById('back-button').setAttribute('disabled', disabled);
                } else {
                    document.getElementById('cancel-button').removeAttribute('disabled');
                    document.getElementById('back-button').removeAttribute('disabled');
                }
            },
            nameChangeHandler: function (e) {
                createEditModalView.changeSaveAndNextButton(e.target.value == '');
            },
            open: function () {
                const item = rulesRepositoryController.getOpen();
                this.updateTitle(item);
                modalController.abrirModal('cadastrar_editar_repositorio_regras');
                this.render(item);
            },
            updateTitle: function (item) {
                modalController.changeModalTitle('cadastrar_editar_repositorio_regras', item ? `${item.Name} (versão ${item.Version})` : ' Novo Repositório De Regras ');
            },
            enterLoadingState: function () {
                this.changeSaveAndNextButton(true);
                this.changeCancelBackButton(true);
            },
            leaveLoadingState: function () {
                this.changeCancelBackButton(false);
            },
            close: function () {
                modalController.closeModal('cadastrar_editar_repositorio_regras');
                rulesRepositoryController.handleCloseItem();
                newVersionView.closeDialog();
                this.changeCancelBackButton(false);
                this.disableViewMode();
                tabSystem.cleanDoneSteps();
            }
        }
        var rulesRepositoryView = {
            statusIcons: {
                published: 'check-square',
                edit: 'edit',
                old: 'clock',
            },
            init: function (rules = []) {
                this.render(rules);
                this.initHeaderFilter();
            },
            initHeaderFilter: function () {
                const filterableHeaders = document.querySelectorAll('table#rules-table thead tr th[data-filter]');
                const orderBy = rulesRepositoryController.getOrderBy();
                if (orderBy.fieldName) {
                    document.querySelector(`table#rules-table thead tr th[data-filter="${orderBy.fieldName}"]`)?.classList.add(orderBy.ascending ? 'up' : 'down');
                }
                if (filterableHeaders.length > 0) {
                    filterableHeaders.forEach(header => {
                        header.addEventListener('click', e => {
                            if (e.target.classList.contains('up')) {
                                e.target.classList.remove('up');
                                e.target.classList.add('down');
                                rulesRepositoryController.setOrderBy(e.target.getAttribute('data-filter'), false);
                            } else if (e.target.classList.contains('down')) {
                                e.target.classList.remove('down');
                                rulesRepositoryController.setOrderBy(null, null);
                            } else {
                                const activeFilter = document.querySelector('table#rules-table thead tr th.filter.up, table#rules-table thead tr th.filter.down');
                                if (activeFilter) {
                                    activeFilter.classList.remove('up', 'down');
                                }
                                e.target.classList.add('up');
                                rulesRepositoryController.setOrderBy(e.target.getAttribute('data-filter'), true);
                            }
                        });
                    });
                }
            },
            toggleLoader: function (show = false) {
                show ?
                    document.getElementById('table-loader').classList.add('show')
                    :
                    document.getElementById('table-loader').classList.remove('show');
            },
            render: function (rules = []) {
                this.cleanRender();
                if (rulesRepositoryController.getLoading()) {
                    this.toggleLoader(true);
                } else {
                    this.toggleLoader(false);
                    const template = document.getElementById('table-line-template');
                    const body = document.querySelector('table#rules-table tbody');
                    body.innerHTML = "";
                    if (rules.length > 0) {
                        rules.forEach(rule => {
                            this.renderLine(document.importNode(template.content, true), body, rule);
                            if (rule.Children?.length > 0) {
                                rule.Children.forEach((child, c_index) => {
                                    this.renderLine(document.importNode(template.content, true), body, child, rule, c_index == (rule.Children.length - 1));
                                })
                            }
                        })
                    } else {
                        document.querySelector('table#rules-table tfoot').classList.add('show');
                    }
                }
                feather.replace();
            },
            renderLine: function (template, body, rule, father, last_child) {
                const tr = template.querySelector('tr');
                let ruleStatus = '';
                if ((rule.PublishDate && !father) || (rule.PublishDate && !(father?.PublishDate))) {
                    ruleStatus = 'published';
                } else if (father?.PublishDate && rule.PublishDate) {
                    ruleStatus = 'old';
                } else {
                    ruleStatus = 'edit';
                }
                // seta key para updates na listagem
                tr.setAttribute('key', `${rule.Id}-${rule.Version}`);
                tr.classList.add(ruleStatus);

                if (father) {
                    tr.classList.add('child');
                    if (last_child) tr.classList.add('last');
                    tr.setAttribute('father-row', `${father.Id}-${father.Version}`);
                }
                // habilita a coluna de novas colunas
                if ((rule.Children?.length > 0) && !father) {
                    const versionsButton = document.createElement('button');
                    versionsButton.classList.add('table-action', 'arrow');
                    const iChevron = document.createElement('i');
                    iChevron.setAttribute('data-feather', 'chevron-right');
                    versionsButton.appendChild(iChevron);

                    // adiciona evento de click ao botão de collapse
                    versionsButton.addEventListener('click', (e) => {
                        e.preventDefault();
                        if (body.querySelector(`tr[key="${rule.Id}-${rule.Version}"]`).classList.contains('open')) {
                            body.querySelectorAll('tr.open').forEach(tr => tr.classList.remove('open'));
                        } else {
                            body.querySelectorAll('tr.open').forEach(tr => tr.classList.remove('open'));
                            body.querySelector(`tr[key="${rule.Id}-${rule.Version}"]`).classList.add('open');
                            body.querySelectorAll(`tr[father-row="${rule.Id}-${rule.Version}"]`).forEach(tr => tr.classList.add('open'));
                        }
                    })

                    template.querySelector('td div[data-render="openButton"]').appendChild(versionsButton);
                }
                // botão de status da versão
                const statusButton = document.createElement('button');
                statusButton.classList.add('table-action', 'status');
                const iStatus = document.createElement('i');
                iStatus.setAttribute('data-feather', rulesRepositoryView.statusIcons[ruleStatus]);
                statusButton.appendChild(iStatus);
                template.querySelector('td div[data-render="status"]').appendChild(statusButton);
                // colunas regulares
                template.querySelector('td div[data-render="cod"]').innerHTML = rule.Id;
                template.querySelector('td div[data-render="title"]').innerHTML = rule.Name;
                template.querySelector('td div[data-render="version"]').innerHTML = rule.Version;
                template.querySelector('td div[data-render="creator"]').innerHTML = rule.PublisherName ?? '-';
                template.querySelector('td div[data-render="createdAt"]').innerHTML = rule.PublishDate == '' ? '-' : rule.PublishDate;

                const policiesContainer = template.querySelector('td div[data-render="policies"]');
                if (rule.Policies?.length > 0) {
                    if (rule.Policies.length == 1) {
                        policiesContainer.innerHTML = rule.Policies[0];
                    } else {
                        const multiplePoliciesTemplate = document.importNode(document.getElementById('multiplas-politicas-template').content, true);
                        rule.Policies.forEach(policy => {
                            const policyLine = document.createElement('li');
                            policyLine.innerHTML = policy;
                            multiplePoliciesTemplate.querySelector('ul').appendChild(policyLine);
                        })
                        policiesContainer.appendChild(multiplePoliciesTemplate);
                    }
                } else {
                    policiesContainer.innerHTML = '-';
                }

                // pega todas as colunas exceto a primeira, que é responsável por abrir o accordion
                const tds = template.querySelectorAll('td:not(:first-of-type)');
                tds.forEach(td => {
                    td.addEventListener('click', () => {
                        if (tr.classList.contains('selected')) {
                            body.querySelectorAll('tr.selected').forEach(tr => tr.classList.remove('selected'));
                            rulesRepositoryController.handleSelectChange(null);
                        } else {
                            body.querySelectorAll('tr.selected').forEach(tr => tr.classList.remove('selected'));
                            tr.classList.add('selected');
                            rulesRepositoryController.handleSelectChange(rule);
                        }
                    });

                    td.addEventListener('dblclick', () => {
                        rulesRepositoryController.handleOpenItem({ ...rule });
                    });
                })
                body.appendChild(template);
            },
            cleanRender: function () {
                document.getElementById('table-loader').classList.remove('show');
                document.querySelector('table#rules-table tfoot').classList.remove('show');
            }
        }
        document.addEventListener("DOMContentLoaded", function (event) {
            rulesRepositoryController.init();
        });
    </script>
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="FooterContent" runat="server">
</asp:Content>
