﻿<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/AdmMaster.Master" CodeBehind="RepositorioPoliticas.aspx.vb" Inherits="WebFoundations.WFWorkflow.UI.RepositorioPoliticas" ValidateRequest="false" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TagHead" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ActionContent" runat="server">
    <ul class="list-of-actions">
        <li>
            <a id="open-modal-edit-create" class="add" href="#">
                <asp:Literal ID="lnkadd" runat="server" />
            </a>
        </li>
        <li>
            <a id="open-delete-dialog" class="delete" href="#">
                <asp:Literal ID="lnkdelete" runat="server" />
            </a>
        </li>
        <li>
            <a class="download" href="#">
                <asp:Literal ID="lnkdownload" runat="server" />
            </a>
        </li>
        <li>
            <a class="upload" href="#">
                <asp:Literal ID="lnkupload" runat="server" />
            </a>
        </li>
    </ul>
    <script>
        actionIcons.init();
    </script>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="FilterContent" runat="server">
    <div class="container-filtro">
        <fieldset>
            <div>
                <asp:Label ID="lblsubportal" runat="server" />
                <asp:Label ID="lblarea" runat="server" />
                <asp:Label ID="lbltitulo" runat="server" />
            </div>
            <div class="inputs">
                <select id="subportal-select">
                </select>
                <select id="area-select">
                </select>
                <input type="text" id="title" value="" />
            </div>
        </fieldset>
        <button id="search-form-button">
            <asp:Literal ID="buscarlbl1" runat="server" />
        </button>
    </div>
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="MainContent" runat="server">
    <input type="hidden" id="scoringlabelinput" data-render="scoringlabel" runat="server" />
    <input type="hidden" id="analiselabelinput" data-render="analiselabel" runat="server" />
    <input type="hidden" id="newpolicyrepository" data-render="newpolicytitle" runat="server" />
    <input type="hidden" id="versionlabelinput" data-render="versionlabel" runat="server" />
    <input type="hidden" id="publisherrotitleinput" data-render="publisherrotitleinput" value="" runat="server" />
    <input type="hidden" id="publisherromessageinput" data-render="publisherromessageinput" value="" runat="server" />

    <div id="delete-dialog" class="wf-dialog">
        <div class="dialog-header">
            <a id="close-delete-dialog" href="#">
                <i data-feather="x"></i>
            </a>
        </div>
        <div class="dialog-body">
            <h2>
                <asp:Literal ID="confirmlabel1" runat="server" />?
            </h2>
        </div>
        <div class="dialog-footer">
            <button class="secondary" id="cancel-delete">
                <asp:Literal ID="cancellabel1" runat="server" />
            </button>
            <button id="confirm-delete-button">
                <asp:Literal ID="confirmlabel2" runat="server" />
            </button>
        </div>
    </div>
    <div id="new-version-dialog" class="wf-dialog">
        <div class="dialog-header">
            <a id="close-new-version-dialog" href="#">
                <i data-feather="x"></i>
            </a>
        </div>
        <div class="dialog-body">
            <h3>
                <asp:Literal ID="newversionrepository" runat="server" />
            </h3>
            <h2>
                <asp:Literal ID="wanttocontinuenewversion" runat="server" />
            </h2>
        </div>
        <div class="dialog-footer">
            <button class="secondary" id="cancel-new-version">
                <asp:Literal ID="cancellabel2" runat="server" />
            </button>
            <button id="confirm-new-version-button">
                <asp:Literal ID="confirmlabel3" runat="server" />
            </button>
        </div>
    </div>

    <div class="table-responsive loadable">
        <table class="hoverable left-aligned" id="policies-table">
            <thead>
                <tr>
                    <th></th>
                    <th></th>
                    <th data-filter="Id" class="filter">
                        <asp:Literal ID="lblcode1" runat="server" />
                    </th>
                    <th data-filter="Name" class="filter">
                        <asp:Literal ID="lbltile1" runat="server" />
                    </th>
                    <th data-filter="TypeName" class="filter">
                        <asp:Literal ID="lbltype" runat="server" />
                    </th>
                    <th data-filter="Version" class="filter">
                        <asp:Literal ID="lblversion" runat="server" />
                    </th>
                    <th data-filter="Publisher" class="filter">
                        <asp:Literal ID="lblpublisher" runat="server" />
                    </th>
                    <th data-filter="PublishDate" class="filter">
                        <asp:Literal ID="lblpublishdate" runat="server" />
                    </th>
                    <th data-filter="RulesRepositoryName" class="filter">
                        <asp:Literal ID="labelrepositorioregras2" runat="server" />
                    </th>
                    <th>
                        <asp:Literal ID="lblproccessesthatuse" runat="server" />
                    </th>
                </tr>
            </thead>
            <tbody>
            </tbody>
            <tfoot class="empty-state">
                <tr>
                    <td colspan="8">
                        <h6>
                            <asp:Literal ID="noregistries" runat="server" />
                        </h6>
                    </td>
                </tr>
            </tfoot>
        </table>
        <div id="table-loader" class="loader-container">
            <i data-feather="loader"></i><span>Carregando dados...</span>
        </div>
        <template id="table-line-template">
            <tr>
                <td>
                    <div data-render="openButton"></div>
                </td>
                <td>
                    <div data-render="status"></div>
                </td>
                <td>
                    <div data-render="Id"></div>
                </td>
                <td>
                    <div data-render="Name"></div>
                </td>
                <td>
                    <div data-render="Alias"></div>
                </td>
                <td>
                    <div data-render="Version"></div>
                </td>
                <td>
                    <div data-render="PublisherName"></div>
                </td>
                <td>
                    <div data-render="PublishDate"></div>
                </td>
                <td>
                    <div data-render="RulesRepositoryName"></div>
                </td>
                <td>
                    <div data-render="Processes">
                    </div>
                </td>
            </tr>
        </template>
        <template id="multiplos-processos-template">
            <div class="tooltip-container">
                <asp:Literal ID="multipleprocesseslbl" runat="server" />
                <i data-feather="info"></i>
                <div class="tooltip-body bottom solid listed big">
                    <ul>
                    </ul>
                </div>
            </div>
        </template>
    </div>
    <div id="cadastrar_editar_repositorio_politicas" class="wf-modal">
        <div class="new-version-container">
            <span>
                <asp:Literal Text="Somente visualização" runat="server" />
            </span>
            <button id="new-version-open">
                <i class="mr-1" data-feather="edit"></i>
                <asp:Literal Text="Editar" runat="server" />
            </button>
        </div>
        <div class="cadastrar-editar-modal-body">
            <div class="tab-system">
                <ul class="tab-links">
                    <li data-link="1" class="link">
                        <div class="number">1</div>
                        <i class="icon-done" data-feather="check-square"></i>
                        <span class="rtsLink">
                            <asp:Literal ID="lblcadastro" runat="server" />
                        </span>
                    </li>
                    <li data-link="2" class="link">
                        <div class="number">2</div>
                        <i class="icon-done" data-feather="check-square"></i>
                        <span class="rtsLink">
                            <asp:Literal ID="lblpoliticas1" runat="server" />
                        </span>
                    </li>
                </ul>
                <div id="fieldset-modal" class="tab-pages">
                    <div data-page="1" class="page">
                    </div>
                    <div data-page="2" class="page">
                        <h1>Página 2</h1>
                    </div>
                </div>
            </div>
            <div class="buttons-container">
                <div>
                    <%-- O cancel button aparece apenas quando estiver no primeiro passo, o voltar aparece a partir do segundo --%>
                    <button id="cancel-button" class="secondary"><i class="mr-1" data-feather="x-circle"></i>
                        <asp:Literal ID="cancellabel3" runat="server" />
                    </button>
                    <button id="back-button" class="secondary"><i data-feather="chevron-left"></i>
                        <asp:Literal Text="Voltar" runat="server" />
                    </button>
                </div>
                <div>
                    <button id="save-and-close"><i class="mr-1" data-feather="save"></i>
                        <asp:Literal Text="Salvar e Fechar" runat="server" />
                    </button>
                </div>
                <div>
                    <button id="next-page-button"><i data-feather="chevron-right"></i>
                        <asp:Literal Text="Próximo" runat="server" />
                    </button>
                    <button id="publish-button"><i class="mr-1" data-feather="upload"></i>
                        <asp:Literal Text="Publicar" runat="server" />
                    </button>
                </div>
            </div>
        </div>
    </div>
    <div id="delete-register-dialog" class="wf-dialog">
        <div class="dialog-header">
            <a id="close-delete-register-dialog" href="#">
                <i data-feather="x"></i>
            </a>
        </div>
        <div class="dialog-body">
            <h2>
                <asp:Literal Text="Confirma a exclusão do registro?" runat="server" />
            </h2>
        </div>
        <div class="dialog-footer">
            <button class="secondary" id="cancel-delete-register">
                <asp:Literal ID="cancellabel4" runat="server" />
            </button>
            <button id="confirm-delete-register-button">
                <asp:Literal ID="confirmlabel4" runat="server" />
            </button>
        </div>
    </div>
    <div id="delete-condition-dialog" class="wf-dialog">
        <div class="dialog-header">
            <a id="close-delete-condition-dialog" href="#">
                <i data-feather="x"></i>
            </a>
        </div>
        <div class="dialog-body">
            <h2>
                <asp:Literal Text="Confirma a exclusão do registro?" runat="server" />
            </h2>
        </div>
        <div class="dialog-footer">
            <button class="secondary" id="cancel-delete-condition">
                <asp:Literal ID="cancellabel5" runat="server" />
            </button>
            <button id="confirm-delete-condition-button">
                <asp:Literal ID="confirmlabel5" runat="server" />
            </button>
        </div>
    </div>
    <template id="cadastro-form-template">
        <fieldset>
            <div>
                <label class="labelItem">
                    <asp:Literal ID="namelabel1" runat="server" />
                </label>
                <input id="nameinput" data-render="name-input" placeholder="Digite o nome do seu repositório de Políticas" maxlength="150" type="text" name="name" value="" runat="server"/>
            </div>
            <div>
                <label class="labelItem">
                    <asp:Literal ID="typeofpolicies" runat="server" />
                </label>
                <div class="d-flex align-center mb-2">
                    <div class="mr-2 d-flex align-center">
                        <input type="radio" checked name="type" value="2" id="type_analise" />
                        <label for="type_analise" class="labelItem">
                            <asp:Literal ID="labelanalise1" runat="server" />
                        </label>
                    </div>
                    <div class="d-flex align-center">
                        <input type="radio" name="type" value="1" id="type_scoring" />
                        <label for="type_scoring" class="labelItem">
                            <asp:Literal ID="labelscoring1" runat="server" />
                        </label>
                    </div>
                </div>
            </div>
            <div>
                <label class="labelItem" for="select-regra">
                    <asp:Literal ID="labelrepositorioregras1" runat="server" />
                </label>
                <select id="select-regra">
                </select>
            </div>
            <div class="d-flex align-center">
                <label class="switch mr-1">
                    <input id="visible_results" type="checkbox">
                    <span class="slider round"></span>
                </label>
                <label>
                    <asp:Literal ID="policyvisibleresults" runat="server" />
                </label>
            </div>
        </fieldset>
    </template>
    <template id="empty-state-politicas">
        <div class="empty-fields">
            <img src="data:image/png;base64,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" alt="Imagem de empty state de políticas" />
            <h3>
                <asp:Literal ID="lblpoliticas2" runat="server" />
            </h3>
            <h4>
                <asp:Literal ID="whatarepolicies" runat="server" />
            </h4>
            <h5>
                <asp:Literal ID="emptypolicies" runat="server" />
            </h5>
            <button class="secondary">
                <i data-feather="plus-square" class="mr-1"></i>
                <asp:Literal ID="labelcreatepolicies1" runat="server" />
            </button>
        </div>
    </template>
    <template id="empty-state-cenarios">
        <div class="empty-fields">
            <img src="data:image/png;base64,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" alt="Imagem de empty state de cenario" />
            <h3>
                <asp:Literal ID="cenarioslabel1" runat="server" />
            </h3>
            <h4>
                <asp:Literal ID="whatarescenaries" runat="server" />
            </h4>
            <h5>
                <asp:Literal ID="emptyscenaries" runat="server" />
            </h5>
            <button class="secondary">
                <i data-feather="plus-square" class="mr-1"></i>
                <asp:Literal ID="createscenaries1" runat="server" />
            </button>
        </div>
    </template>
    <template id="policy-template">
        <div class="rule">
            <div>
                <div class="status">
                    <i class="edit" data-feather="edit"></i>
                    <i class="done" data-feather="check-square"></i>
                </div>
                <input type="text" readonly value="" />
            </div>
            <div class="more off-in-view-mode">
                <div class="tooltip-container">
                    <i data-feather="more-horizontal"></i>
                    <div style="padding: 0 4px; top: -10px;" class="tooltip-body solid left">
                        <button data-render="delete-policy-button" class="minimal">
                            <i class="mr-1" data-feather="trash-2"></i>
                            <asp:Literal ID="deletepolicylabel" runat="server" />
                        </button>
                        <button data-render="enable-edit-policy" class="minimal">
                            <i class="mr-1" data-feather="edit"></i>
                            <asp:Literal ID="changepolicynamelabel" Text="Alterar Nome" runat="server" />
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </template>
    <template id="cadastro-politicas-layout">
        <div class="cadastro-regras-layout-container">
            <div class="cadastro-regras">
                <div class="cadastro-regras-header">
                    <div>
                        <h4>
                            <asp:Literal ID="lblpoliticas3" runat="server" />
                            <span class="tooltip-container">
                                <i data-feather="info"></i>
                                <span class="tooltip-body solid big centered bottom">
                                    <asp:Literal id="policyinfo1" runat="server" />
                                </span>
                            </span>
                        </h4>
                    </div>
                    <div>
                        <input ID="inputbuscapolitica" data-render="input-busca-politica" type="hidden" class="search minimal" runat="server" />
                    </div>
                </div>
                <div class="cadastro-regras-listagem-container">
                </div>
                <div class="cadastro-regras-form-container off-in-view-mode">
                    <fieldset class="fieldwithbutton">
                        <input id="novapoliticainput" type="text" data-render="nova-politica" value="" runat="server" />
                        <button id="nova-politica-button">
                            <i class="mr-1" data-feather="plus-square"></i>
                        </button>
                    </fieldset>
                </div>
            </div>
            <div class="cadastro-condicoes"></div>
        </div>
    </template>

    <template id="condicao-scoring">
        <div class="container-condicao-scoring d-flex align-start">
            <div class="d-flex">
                <span class="condition-index" data-render="index"></span>
            </div>
            <div class="flex-1 condition-content">
                <div class="header-condicao-scoring">
                    <h3 data-render="nome-regra"></h3>
                </div>
                <div class="d-flex align-start justify-between">
                    <div>
                        <p data-render="text-regra"></p>
                        <fieldset class="d-flex">
                            <div class="mr-2">
                                <label class="labelItem medium bold">
                                    <asp:Literal Text="Score : se passar" runat="server" />
                                </label>
                                <input class="medium" type="number" data-render="PassScoringValue" value="" />
                            </div>
                            <div>
                                <label class="labelItem medium bold">
                                    <asp:Literal Text="Score : se falhar" runat="server" />
                                </label>
                                <input class="medium" type="number" data-render="FailScoringValue" value="" />
                            </div>
                        </fieldset>
                    </div>
                    <div class="off-in-view-mode">
                        <button data-render="delete-condicao" class="icon-button medium">
                            <i data-feather="trash-2"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </template>

    <template id="rule-select-option">
        <div class="option">
            <input type="checkbox" />
            <label></label>
        </div>
    </template>

    <template id="scoring-scenario">
        <div class="container-listagem-condicoes">
            <div class="header-listagem-condicoes">
                <h6>
                    <span data-render="Name"></span>
                    <span class="alias" data-render="Alias"></span>
                </h6>
            </div>
            <div class="rule-select-container off-in-view-mode">
                <div id="select-rule-search-input" class="input-with-search">
                    <input class="text-search-input" placeholder="Selecione uma regra" data-render="search-input-text" type="text" name="rule-selector" />
                    <div class="options">
                    </div>
                </div>
                <button class="minimal medium" disabled data-render="adicionar-regra">
                    <i class="mr-half" data-feather="plus-square"></i>
                    <asp:Literal Text="ADICIONAR REGRAS SELECIONADAS" runat="server" />
                </button>
            </div>
            <div class="listagem-condicoes"></div>
            <div class="footer-listagem-condicoes off-in-view-mode">
                <div class="d-flex justify-end mt-2">
                    <button disabled data-render="salvar-condicoes" class="primary minimal centered">
                        <asp:Literal Text="OK" runat="server" />
                    </button>
                </div>
            </div>
        </div>
    </template>

    <template id="condition-analysis">
        <div class="container-condicao-scoring d-flex align-start">
            <div class="d-flex">
                <span class="condition-index" data-render="index"></span>
            </div>
            <div class="flex-1 condition-content">
                <div class="header-condicao-scoring">
                    <h3 data-render="nome-regra"></h3>
                </div>
                <div class="d-flex align-start justify-between">
                    <div>
                        <p data-render="text-regra"></p>
                    </div>
                    <div class="d-flex align-center">
                        <div class="flagged-checkbox mr-1">
                            <input type="checkbox" data-render="CausesScenarioFailure" />
                            <label>
                                <i data-feather="flag"></i>
                            </label>
                        </div>
                        <button data-render="delete-condicao" class="icon-button medium off-in-view-mode">
                            <i data-feather="trash-2"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </template>

    <template id="analysis-scenary">
        <div class="scenary">
            <div class="accordion-header align-center d-flex justify-between">
                <div class="d-flex align-center flex-1">
                    <button data-render="accordion-trigger" class="icon-button">
                        <i class="arrow" data-feather="chevron-right"></i>
                    </button>
                    <input type="text" placeholder="De um nome para o seu cenário." data-render="scenary-name" value="" />
                </div>
                <div class="more off-in-view-mode">
                    <div class="tooltip-container">
                        <i data-feather="more-horizontal"></i>
                        <div class="tooltip-body solid left">
                            <button data-render="delete-scenary-button" class="minimal">
                                <i class="mr-1" data-feather="trash-2"></i>
                                <asp:Literal Text="Excluir" runat="server" />
                            </button>
                            <button data-render="enable-edit-scenary" class="minimal">
                                <i class="mr-1" data-feather="edit"></i>
                                <asp:Literal Text="Alterar Nome" runat="server" />
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="accordion-body no-padding">
                <div class="rule-select-container off-in-view-mode">
                    <div data-render="select-regra" class="input-with-search">
                        <input class="text-search-input" placeholder="Selecione uma regra" data-render="search-input-text" type="text" name="rule-selector" />
                        <div class="options">
                        </div>
                    </div>
                    <button class="minimal medium" disabled data-render="adicionar-regra">
                        <i class="mr-half" data-feather="plus-square"></i>
                        <asp:Literal Text="ADICIONAR REGRAS SELECIONADAS" runat="server" />
                    </button>
                </div>
                <div class="lista-regras"></div>
                <div class="additional-info">
                    <div>
                        <fieldset class="d-flex">
                            <div class="mr-2 w-50 d-flex c-flex justify-between">
                                <div class="d-flex justify-between">
                                    <label class="labelItem mr-1">
                                        <asp:Literal Text="Quantas regras devem ser verdadeiras?" runat="server" />
                                    </label>
                                    <input type="number" value="1" data-render="MinValidConditions">
                                </div>
                                <div>
                                    <label class="labelItem">
                                        <asp:Literal Text="Qual o resultado para este cenário" runat="server" />
                                        <span class="tooltip-container">
                                            <i data-feather="info"></i>
                                            <span class="tooltip-body solid big right">
                                                <asp:Literal Text="Este resultado aparecerá quando as regras do cenário forem verdadeiras." runat="server" />
                                            </span>
                                        </span>
                                    </label>
                                    <input type="text" placeholder="Digite aqui sua saída" maxlength="30" data-render="Result" value="" />
                                </div>
                            </div>
                            <div class="ml-2 w-50">
                                <label class="labelItem">
                                    <asp:Literal Text="Forneça uma descrição para esta saída:" runat="server" />
                                </label>
                                <textarea data-render="ResultDescription" rows="5" placeholder="Digite aqui sua descrição"></textarea>
                            </div>
                        </fieldset>
                    </div>
                </div>
            </div>
        </div>
    </template>

    <template id="analysis-config-template">
        <div class="container-listagem-condicoes">
            <div class="header-listagem-condicoes">
                <h6>
                    <span data-render="Name"></span>
                    <span class="alias" data-render="Alias"></span>
                </h6>
            </div>
            <div class="listagem-condicoes">
            </div>
            <div class="footer-listagem-condicoes mt-2 off-in-view-mode">
                <button data-render="adicionar-cenario" class="secondary block">
                    <i class="mr-1" data-feather="plus-square"></i>
                    <asp:Literal Text="ADICIONAR CENÁRIO" runat="server" />
                </button>
                <div class="d-flex justify-end mt-2">
                    <button data-render="salvar-condicoes" class="primary medium centered">
                        <asp:Literal Text="Salvar Cenários" runat="server" />
                    </button>
                </div>
            </div>
        </div>
    </template>

    <input type="hidden" id="titlemodalimport" data-render="title-modal-import" value="Importação Repositório de Políticas" runat="server" />
    <div id="importar_repositorio_regras" class="wf-modal">
        <div class="cadastrar-editar-modal-body" data-render="import-container"></div>
    </div>

    <template id="form-iniciar-importacao">
        <fieldset>
            <div>
                <label class="labelItem">
                    <asp:Literal ID="loadafilelbl" runat="server" />
                </label>
                <input class="block" type="file" data-render="arquivo_importacao" name="arquivo_importacao" value="" />
            </div>
            <div>
                <label class="labelItem">
                    <asp:Literal ID="subportaldestinylbl" runat="server" />
                </label>
                <select class="block" data-render="import-subportal-select" name="import-subportal-select">
                    <option selected disabled value="">
                        <asp:Literal ID="selportaloption" runat="server" />
                    </option>
                </select>
            </div>
            <div id="import-select-area-container">
            </div>
            <div class="d-flex align-center justify-center mt-2">
                <button data-render="submit-init-form" class="mr-2" disabled>
                    <i class="mr-half" data-feather="upload"></i>
                    <asp:Literal Text="Fazer upload" runat="server" />
                </button>
                <button data-render="cancel-init-form" class="secondary">
                    <i class="mr-half" data-feather="x-circle"></i>
                    <asp:Literal ID="cancellabel6" runat="server" />
                </button>
            </div>
        </fieldset>
    </template>

    <template id="form-decision-importacao">
        <fieldset>
            <label class="labelItem">
                <asp:Literal ID="importrepoconflitmessagelbl" Text="Um repositório " runat="server" />
            </label>
            <div class="mt-2 mb-2">
                <div class="mb-1 d-flex align-center">
                    <input id="decisionnew" type="radio" name="decisionimport" value="true" checked />
                    <label for="decisionnew" class="labelItem">
                        <asp:Literal ID="createnewdecisionlbl" runat="server" />
                    </label>
                </div>
                <div class="d-flex align-center">
                    <input id="decisionupdate" type="radio" name="decisionimport" value="false" />
                    <label for="decisionupdate" class="labelItem">
                        <asp:Literal ID="updatedecisionlbl" runat="server" />
                    </label>
                </div>
            </div>
            <div class="mt-2 mb-2">
                <div class="aviso-importacao">
                    <i data-feather="alert-triangle"></i>
                    <p>
                        <asp:Literal ID="warningimpot" runat="server" />
                    </p>
                </div>
            </div>
            <div class="d-flex align-center mt-2">
                <button data-render="submit-decision-form" class="mr-2">
                    OK
                </button>
            </div>
        </fieldset>
    </template>

    <template id="import-select-area-template">
        <label class="labelItem">
            <asp:Literal ID="areadestinylbl" Text="Selecione a área de destino" runat="server" />
        </label>
        <select class="block" data-render="import-area-select" name="import-area-select">
            <option disabled selected value="">
                <asp:Literal ID="selareaoption" runat="server" />
            </option>
        </select>
    </template>

    <div id="import-success-dialog" class="wf-dialog">
        <div class="dialog-header">
            <a id="close-import-success-dialog" href="#">
                <i data-feather="x"></i>
            </a>
        </div>
        <div class="dialog-body">
            <h2>
                <asp:Literal ID="successimport" runat="server" />
            </h2>
        </div>
        <div class="dialog-footer">
            <button id="confirm-import-success-dialog">
                OK
            </button>
        </div>
    </div>
    <script>
        /**
         * Lib para input com busca:
         * 
         * Formato para uso:
         * <div id="select-rule-search-input" class="input-with-search">
                <input class="text-search-input" data-render="search-input-text" type="text" name="rule-selector" />
                <div class="options">
                    <div class="option">
                        <input value="example" data-text="Example" type="checkbox"/>
                        <label tabindex="0">Example</label>
                    </div>
                </div>
            </div>
         * 
         * OBS: A busca fica desabilitada quando o argumento multiselect for verdadeiro
         * */
        var inputWithSearch = {
            init: function (id, valueChangeCb, multiselect = false) {
                // adiciona eventos de foco e blur no input de busca
                const container = document.querySelector(`#${id}`);
                const inputBusca = container.querySelector(`input[data-render="search-input-text"]`);


                //define função de modificação do value
                const changeValue = (value, text) => {
                    const input = container.querySelector('input[data-render="search-input-text"]');
                    let currentValue = input.getAttribute('data-value') ?? '';
                    const newValue = (multiselect && currentValue != '') ? `${currentValue}-${value}` : value;
                    input.setAttribute('data-value', newValue);
                    valueChangeCb(newValue);
                    if (multiselect) {
                        const values = newValue.split('-');
                        if (values.length == 1) {
                            changeText(text);
                        } else {
                            changeText(`${values.length} selecionados`);
                        }
                    } else {
                        changeText(text);
                    }
                }

                // define função de remoção de valores
                const removeValue = (value) => {
                    const input = container.querySelector('input[data-render="search-input-text"]');
                    let currentValue = input.getAttribute('data-value');
                    let values = currentValue.split('-');
                    values = values.filter(v => v != value);
                    input.setAttribute('data-value', values.join('-'));
                    valueChangeCb(values.join('-'));
                    if (values.length == 0) {
                        changeText("");
                    } else if (values.length == 1) {
                        changeText(container.querySelector(`.options .option input[value="${values[0]}"]`).getAttribute('data-text'));
                    } else {
                        changeText(`${values.length} selecionados`);
                    }
                }

                //define função de modificação do texto
                const changeText = (text) => {
                    const input = container.querySelector('input[data-render="search-input-text"]');
                    input.value = text;
                }

                // adiciona click aos options
                const options = container.querySelectorAll('.options .option');
                let optionObjects = [];
                for (i = 0; i < options.length; i++) {
                    optionObjects.push({
                        value: options[i].querySelector('input').value,
                        text: options[i].querySelector('input').getAttribute('data-text')
                    })
                    options[i].querySelector('label').setAttribute('tabindex', 0);
                    options[i].addEventListener('input', (e) => {
                        const modifiedValue = e.target.value;
                        if (e.target.checked) {
                            changeValue(modifiedValue, e.target.getAttribute('data-text'));
                        } else {
                            removeValue(modifiedValue);
                        }
                    })
                }

                if (!multiselect) {
                    inputBusca.addEventListener('input', (e) => {
                        changeValue('');
                        const filterRegex = new RegExp(e.target.value.toLowerCase(), 'g');
                        optionObjects.forEach(option => {
                            if (!option.text.toLowerCase().match(filterRegex)) {
                                container.querySelector(`.options input[data-value="${option.value}"]`).parentNode.classList.add('hide');
                            } else {
                                container.querySelector(`.options input[data-value="${option.value}"]`).parentNode.classList.remove('hide');
                            }
                        })
                    });
                } else {
                    // reconhece o mousedown no input de busca, e caso a listagem de opções esteja aparente, aplica o blur do elemento ativo atual, para remover o foco do input ou qualquer checkbox das options e fechar a lista de seleção
                    inputBusca.addEventListener('mousedown', (e) => {
                        const options = e.target.parentNode.querySelector('.options');
                        if (window.getComputedStyle(options, null).display == 'block') {
                            e.preventDefault();
                            document.activeElement.blur()
                        }
                    });
                    inputBusca.setAttribute('readonly', '');
                    container.classList.add('multiselect');
                }
            },
            getValue: function (id) {
                return document.querySelector(`#${id} input[data-render="search-input-text"]`).getAttribute('data-value');
            },
            resetValue: function (id) {
                document.querySelector(`#${id} input[data-render="search-input-text"]`).value = '';
                document.querySelector(`#${id} input[data-render="search-input-text"]`).setAttribute('data-value', '');
                document.querySelectorAll(`#${id} .options .option input`).forEach(checkbox => {
                    checkbox.checked = false;
                });
            },
            disableOptionsWithValues: function (id, values = []) {
                values.forEach(value => {
                    document.querySelector(`#${id} .options .option input[value="${value}"]`).parentNode.classList.add('disabled');
                });
                const activeOptions = document.querySelectorAll(`#${id} .options .option:not(.disabled)`);
                if (activeOptions.length == 0) {
                    document.querySelector(`#${id} input[data-render="search-input-text"]`).setAttribute('disabled', '');
                }
            },
            enableOptionsWithValues: function (id, values = []) {
                values.forEach(value => {
                    document.querySelector(`#${id} .options .option input[value="${value}"]`).parentNode.classList.remove('disabled');
                });
                document.querySelector(`#${id} input[data-render="search-input-text"]`).removeAttribute('disabled');
            }
        }
        var policiesRepositoryModel = {
            policies: [],
            rulesRepositories: [],
            areas: [],
            subPortals: [],
            selected: null,  // repositório de políticas selecionado
            selectedPolicy: null,  // política selecionada
            openRepositories: null,
            loading: false,
            token: null,
            orderBy: {
                fieldName: null,
                ascending: null
            },
            setOrderBy: function (fieldName, ascending) {
                policiesRepositoryModel.orderBy.fieldName = fieldName;
                if (ascending == 'false') {
                    policiesRepositoryModel.orderBy.ascending = false;
                } else {
                    policiesRepositoryModel.orderBy.ascending = (ascending != null) ? !!ascending : null;
                }
            },
            getOrderBy: function () {
                return policiesRepositoryModel.orderBy;
            },
            getPolicies: () => {
                return this.policies;
            },
            setPolicies: (policies) => {
                this.policies = policies;
            },
            getLoading: () => {
                return this.loading;
            },
            setLoading: (loading) => {
                this.loading = loading;
            },
            getSelected: () => {
                return this.selected;
            },
            setSelected: (selected) => {
                this.selected = selected;
            },
            setOpen: (item) => {
                this.openRepositories = item;
            },
            getOpen: () => {
                return this.openRepositories;
            },
            setToken: (token) => {
                this.token = token;
            },
            getToken: () => {
                return this.token;
            },
            setRulesRepositories: (repositories) => {
                this.rulesRepositories = repositories;
            },
            getRulesRepositories: () => {
                return this.rulesRepositories;
            },
            setAreas: function (areas) {
                this.areas = areas;
            },
            getAreas: function () {
                return this.areas;
            },
            setSubPortals: function (subPortals) {
                this.subPortals = subPortals;
            },
            getSubPortals: function () {
                return this.subPortals;
            },
            setSelectedPolicy: function (policy) {
                this.selectedPolicy = policy;
            },
            getSelectedPolicy: function () {
                return this.selectedPolicy;
            },
        }
        var policiesRepositoryController = {
            init: function () {
                policiesRepositoryModel.setLoading(true);
                this.getOrderFromCookie();
                Api.get('/CA834727-8779-40C8-827B-717FDB87D652', null, 'text/plain').then(resp => {
                    policiesRepositoryModel.setToken(resp);
                    pagePickerCookieController.init();
                    searchFormView.init();
                    this.fetchSubPortals()
                        .then(subportals => {
                            policiesRepositoryModel.setSubPortals(subportals);
                            searchFormView.renderSubportals(subportals);
                            if (subportals.length > 0) {
                                let currentSubPortal = pagePickerCookieController.getCurrentPortal();
                                if (currentSubPortal) {
                                    currentSubPortal = subportals.find(el => el.Id == currentSubPortal);
                                }
                                this.fetchAreas(currentSubPortal ? currentSubPortal.EncId : subportals[0].EncId).then(areas => {
                                    policiesRepositoryModel.setAreas(areas);
                                    searchFormView.renderAreas(areas);
                                    this.fetchRuleRepositories(resp);
                                    this.fetchRepositories();
                                });
                            }
                        });
                });
                policiesRepositoryView.init();
                createEditModalView.init();
                deleteView.init();
                newVersionView.init();
                deleteRegisterView.init();
                deleteConditionView.init();
                importExportView.init();
                importSuccessView.init();
                tabSystem.init(); // esse item está no projeto  WF.Portal
            },
            fetchSubPortals: function () {
                const token = policiesRepositoryModel.getToken();
                return Api.get('/portal', `Bearer ${token}`)
            },
            fetchAreas: function (subportalId) {
                const token = policiesRepositoryModel.getToken();
                return Api.get(`/areas?category=AdminArea&portalId=${subportalId}`, `Bearer ${token}`);
            },
            fetchRuleRepositories: function () {
                const token = policiesRepositoryModel.getToken();
                const areaSelect = document.getElementById('area-select');
                const areaEncId = policiesRepositoryModel.getAreas().find(area => area.Id == areaSelect.value).EncId;
                Api.get(`/rulerepository?areaid=${areaEncId}&orderbyFieldName&orderAscending&title=&withChildrenGrouped=false`, `Bearer ${token}`)
                    .then(rules => {
                        policiesRepositoryModel.setRulesRepositories(rules);
                    })
            },
            getOrderFromCookie: function () {
                policiesRepositoryModel.setOrderBy(cookieController.get('policyRepositoryOrderByFieldName'), cookieController.get('policyRepositoryOrderByAscending'));
            },
            setOrderBy: function (fieldName, ascending) {
                policiesRepositoryModel.setOrderBy(fieldName, ascending);
                cookieController.set('policyRepositoryOrderByFieldName', (fieldName == null) ? ';Max-Age=-99999999;' : fieldName);
                cookieController.set('policyRepositoryOrderByAscending', (ascending == null) ? ';Max-Age=-99999999;' : ascending);
                this.fetchRepositories();
            },
            getOrderBy: function () {
                return policiesRepositoryModel.getOrderBy();
            },
            fetchRepositories: function () {
                const token = policiesRepositoryModel.getToken();
                const areaSelect = document.getElementById('area-select');
                const areaEncId = policiesRepositoryModel.getAreas().find(area => area.Id == areaSelect.value).EncId;
                const titleInput = document.getElementById('title');
                const orderBy = policiesRepositoryModel.getOrderBy();
                policiesRepositoryModel.setLoading(true);
                policiesRepositoryView.render([]);
                Api.get(`/policyrepository?areaid=${areaEncId}&orderbyFieldName=&orderAscending=&title=${titleInput.value}&frontOrderbyFieldName=${orderBy.fieldName ?? ''}&frontOrderAscending=${orderBy.ascending ?? true}`, `Bearer ${token}`)
                    .then(policies => {
                        policiesRepositoryModel.setLoading(false);
                        this.changePolicies(policies);
                    })
            },
            handleSubPortalChange: function (id) {
                const subPortals = policiesRepositoryModel.getSubPortals();
                this.fetchAreas(subPortals.find(el => el.Id == id).EncId)
                    .then(areas => {
                        policiesRepositoryModel.setAreas(areas);
                        searchFormView.renderAreas(areas);
                    });
            },
            changePolicies: function (policies) { // sempre utilizar esse método para atualizar as regras pois ele obriga o render após as atualizações.
                policiesRepositoryModel.setPolicies(policies);
                policiesRepositoryView.render(policies);
            },
            getOpen: function () {
                return policiesRepositoryModel.getOpen();
            },
            setOpen: function (item) {
                policiesRepositoryModel.setOpen(item);
            },
            handleCloseItem: function () {
                policiesRepositoryModel.setOpen(null)
                policiesRepositoryModel.setSelectedPolicy(null);
            },
            getLoading: function () {
                return policiesRepositoryModel.getLoading();
            },
            getSelectedPolicy: function () {
                return policiesRepositoryModel.getSelectedPolicy();
            },
            handleSelectChange: function (selected) {
                policiesRepositoryModel.setSelected(selected);
            },
            handleOpenItem: function (item = null) {
                policiesRepositoryModel.setOpen(item);
                createEditModalView.open(item);
            },
            handleSearchClick: function () {
                const subportalsSelect = document.getElementById('subportal-select');
                const areasSelect = document.getElementById('area-select');
                pagePickerCookieController.setCurrentPortal(subportalsSelect.value);
                pagePickerCookieController.setCurrentArea(areasSelect.value);
                this.fetchRepositories();
                this.fetchRuleRepositories();
            },
            handleOpenDelete: function () {
                const selected = policiesRepositoryModel.getSelected();
                if (selected) {
                    deleteView.openDialog();
                }
            },
            handleDeleteItem: function () {
                const selected = policiesRepositoryModel.getSelected();
                const token = policiesRepositoryModel.getToken();
                policiesRepositoryModel.setLoading(true);
                policiesRepositoryView.render([]);
                Api.delete(`/policyrepository/${selected.EncId}`, null, `Bearer ${token}`)
                    .then(_ => {
                        policiesRepositoryModel.setLoading(false);
                        this.fetchRepositories();
                        deleteView.closeDialog();
                    })
                    .catch(err => {
                        if (err?.exceptionMessage) {
                            toasterController.launch("Erro", err.exceptionMessage, "error", false, 3000, 'body');
                        }
                        policiesRepositoryModel.setLoading(false);
                        this.fetchRepositories();
                        deleteView.closeDialog();
                    })
            },
            getRuleRepositories: function () {
                return policiesRepositoryModel.getRulesRepositories();
            },
            getSubPortals: function () {
                return policiesRepositoryModel.getSubPortals();
            },
            enablePoliciesEdit: function () {
                const open = policiesRepositoryModel.getOpen();
                open.Policies = [];
                policiesRepositoryModel.setOpen(open);
            },
            addNewPolicy: function (name) {
                return new Promise((resolve, reject) => {
                    const token = policiesRepositoryModel.getToken();
                    const open = policiesRepositoryModel.getOpen();
                    const toSend = {
                        Name: name
                    }
                    Api.post(`/policyrepository/${open.EncId}/policy`, toSend, `Bearer ${token}`)
                        .then(newPolicy => {
                            open.Policies.push(newPolicy);
                            policiesRepositoryModel.setOpen(open);
                            createEditModalView.buscaPoliticaHabilitada(true);
                            createEditModalView.validatePolicyList();
                            this.fetchRepositories();
                            resolve(newPolicy);
                        })
                        .catch(err => {
                            if (err?.exceptionMessage) {
                                toasterController.launch("Erro", err.exceptionMessage, "error", false, 3000, '.modal-content-container');
                            }
                            resolve(null);
                        })
                })
            },
            editPolicy: function (value, index) {
                return new Promise((resolve, reject) => {
                    const token = policiesRepositoryModel.getToken();
                    const open = policiesRepositoryModel.getOpen();
                    open.Policies[index].Name = value;
                    Api.put(`/policyrepository/${open.EncId}/policy`, open.Policies[index], `Bearer ${token}`)
                        .then(editedPolicy => {
                            open.Policies[index] = editedPolicy
                            policiesRepositoryModel.setOpen(open);
                            this.fetchRepositories();
                            resolve(editedPolicy);
                        })
                        .catch(err => {
                            resolve();
                        })
                })
            },
            handleConfigPolicy: function () {
                return new Promise((resolve, reject) => {
                    const token = policiesRepositoryModel.getToken();
                    const open = policiesRepositoryModel.getOpen();
                    const selectedPolicy = policiesRepositoryModel.getSelectedPolicy();
                    Api.put(`/policyrepository/${open.EncId}/policy`, selectedPolicy, `Bearer ${token}`)
                        .then(editedPolicy => {
                            this.fetchRepositories();
                            for (i = 0; i < open.Policies.length; i++) {
                                if (open.Policies[i].Alias == selectedPolicy.Alias) {
                                    open.Policies[i].Name = editedPolicy.Name;
                                    open.Policies[i].Scenarios = editedPolicy.Scenarios;
                                    selectedPolicy.Name = editedPolicy.Name;
                                    selectedPolicy.Scenarios = editedPolicy.Scenarios;
                                }
                            }
                            policiesRepositoryModel.setOpen(open);
                            policiesRepositoryModel.setSelected(selectedPolicy);
                            createEditModalView.renderPolicies(open.Policies);
                            createEditModalView.renderScenarios(selectedPolicy);
                            resolve(editedPolicy);
                        })
                        .catch(err => {
                            resolve();
                        })
                })
            },
            handleDeletePolicy: function (index) {
                const open = policiesRepositoryModel.getOpen();
                const token = policiesRepositoryModel.getToken();
                const selectedPolicy = policiesRepositoryModel.getSelectedPolicy();
                Api.delete(`/policyrepository/${open.EncId}/policy/${open.Policies[index].Alias}`, null, `Bearer ${token}`)
                    .then(_ => {
                        if (selectedPolicy == open.Policies[index]) {
                            this.setSelectedPolicy(null);
                        }
                        open.Policies = open.Policies.filter((element, i) => i != index);
                        policiesRepositoryModel.setOpen(open);
                        createEditModalView.renderPolicies(open.Policies);
                        if (open.Policies.length == 0) this.setSelectedPolicy(null);
                        deleteRegisterView.closeDialog();
                        this.fetchRepositories();
                    })
            },
            setSelectedPolicy: function (policy) {
                const selectedPolicy = JSON.parse(JSON.stringify(policy))
                policiesRepositoryModel.setSelectedPolicy(selectedPolicy);
                createEditModalView.renderScenarios(selectedPolicy);
            },
            addAnalisyScenario: function () {
                const selectedPolicy = policiesRepositoryModel.getSelectedPolicy();
                const newScenary = {
                    Name: '',
                    Conditions: [],
                    open: true,
                    MinValidConditions: 1,
                    Result: '',
                    ResultDescription: ''
                }
                if (selectedPolicy.Scenarios) {
                    selectedPolicy.Scenarios.push(newScenary);
                } else {
                    selectedPolicy.Scenarios = [newScenary];
                }
                this.setSelectedPolicy(selectedPolicy);
            },
            addAnalisyScenaryConditions: function (index, rule_ids) {
                const selectedPolicy = policiesRepositoryModel.getSelectedPolicy();
                rule_ids.forEach(rule_id => {
                    const newCondition = {
                        RuleId: rule_id,
                        CausesScenarioFailure: false,
                    }
                    selectedPolicy.Scenarios[index].Conditions.push(newCondition);
                })
                policiesRepositoryModel.setSelectedPolicy(selectedPolicy);
            },
            updateScenary: function (index, name, value) {
                const selectedPolicy = policiesRepositoryModel.getSelectedPolicy();
                selectedPolicy.Scenarios[index][name] = value;
                policiesRepositoryModel.setSelectedPolicy(selectedPolicy);
            },
            addScoringScenarioCondition: function (rule_ids = []) {
                const selectedPolicy = policiesRepositoryModel.getSelectedPolicy();
                rule_ids.forEach(rule_id => {
                    const newCondition = {
                        RuleId: rule_id,
                        PassScoringValue: 0,
                        FailScoringValue: 0
                    }
                    if (!selectedPolicy.Scenarios) {
                        selectedPolicy.Scenarios = [
                            {
                                Name: "Cenário 1",
                                Conditions: [newCondition],
                            }
                        ]
                    } else {
                        selectedPolicy.Scenarios[0].Conditions.push(newCondition);
                    }
                })
                policiesRepositoryModel.setSelectedPolicy(selectedPolicy);
            },
            updateScenaryCondition: function (scenaryIndex, conditionIndex, name, value) {
                const selectedPolicy = policiesRepositoryModel.getSelectedPolicy();
                selectedPolicy.Scenarios[scenaryIndex].Conditions[conditionIndex][name] = value;
                policiesRepositoryModel.setSelectedPolicy(selectedPolicy);
            },
            handleDeleteCondition: function (scenaryIndex, conditionIndex) {
                const selectedPolicy = policiesRepositoryModel.getSelectedPolicy();
                selectedPolicy.Scenarios[scenaryIndex].Conditions.splice(conditionIndex, 1);
                if (selectedPolicy.Scenarios[scenaryIndex].MinValidConditions > selectedPolicy.Scenarios[scenaryIndex].Conditions.length) selectedPolicy.Scenarios[scenaryIndex].MinValidConditions = selectedPolicy.Scenarios[scenaryIndex].Conditions.length;
                policiesRepositoryModel.setSelectedPolicy(selectedPolicy);
                createEditModalView.renderScenarios(selectedPolicy);
                deleteConditionView.closeDialog();
            },
            handleDeleteScenary: function (index) {
                const selectedPolicy = policiesRepositoryModel.getSelectedPolicy();
                selectedPolicy.Scenarios = selectedPolicy.Scenarios.filter((scenary, i) => i != index);
                this.setSelectedPolicy(selectedPolicy);
                deleteRegisterView.closeDialog();
            },
            moveScenary: function (movedIndex, target) {
                const selectedPolicy = policiesRepositoryModel.getSelectedPolicy();
                const movedScenary = (selectedPolicy.Scenarios.splice(movedIndex, 1))[0];
                selectedPolicy.Scenarios.splice((movedIndex < target) ? (target - 1) : target, 0, movedScenary);
                this.setSelectedPolicy(selectedPolicy);
            },
            handleEditCreateRepository: function () {
                return new Promise((resolve, reject) => {
                    const item = policiesRepositoryModel.getOpen();
                    const token = policiesRepositoryModel.getToken();
                    const toSend = {
                        name: document.querySelector('input[data-render="name-input"]').value,
                        areaId: document.getElementById('area-select').value,
                        RulesRepositoryId: document.getElementById('select-regra').value,
                        type: document.querySelector('input[name="type"]:checked').value,
                        ShowInferenceResult: document.getElementById('visible_results').checked
                    };
                    if (item) { // edit
                        Api.put(`/policyrepository/${item.EncId}`, toSend, `Bearer ${token}`)
                            .then(resp => {
                                this.fetchRepositories();
                                resolve(resp);
                            })
                            .catch(err => {
                                resolve();
                            })
                    } else { // create
                        Api.post('/policyrepository', toSend, `Bearer ${token}`)
                            .then(resp => {
                                this.fetchRepositories();
                                resolve(resp);
                            })
                            .catch(err => {
                                resolve();
                            })
                    }
                })
            },
            handleNewVersion: function () {
                const token = policiesRepositoryModel.getToken();
                const open = policiesRepositoryModel.getOpen();
                policiesRepositoryModel.setLoading(true);
                policiesRepositoryView.render([]);
                return Api.post(`/policyrepository/${open.Identifier}`, null, `Bearer ${token}`)
                    .then(newItem => {
                        this.fetchRepositories();
                        newVersionView.closeDialog();
                        createEditModalView.close();
                        this.handleOpenItem(newItem);
                    })
            },
            publishRepository: function () {
                return new Promise((resolve, reject) => {
                    const open = policiesRepositoryModel.getOpen();
                    const token = policiesRepositoryModel.getToken();
                    Api.put(`/policyrepository/${open.EncId}/publish`, {}, `Bearer ${token}`)
                        .then(resp => {
                            this.fetchRepositories();
                            createEditModalView.close();
                            resolve(resp);
                        })
                        .catch(err => {
                            if (err?.exceptionMessage == 'Rule Repository must be published to publish the Policy Repository') {
                                toasterController.launch(document.querySelector('input[data-render="publisherrotitleinput"]').value, document.querySelector('input[data-render="publisherromessageinput"]').value, "error", false, 5000, '.modal-content-container');
                            } else if (err?.message) {
                                toasterController.launch(err?.message, "", "error", false, 3000, '.modal-content-container');
                            }
                            resolve(err);
                        })
                });
            },
            handleExport: function () {
                const selectedRepository = policiesRepositoryModel.getSelected();
                if (selectedRepository) {
                    const token = policiesRepositoryModel.getToken();
                    Api.get(`/policyrepository/${selectedRepository.EncId}/export`, `Bearer ${token}`)
                        .then(downloadtoken => {
                            window.open(`${window.location.origin}/api/v10/policyrepository/${downloadtoken}/download`, '_blank').focus()
                        })
                        .catch(err => console.log(err));
                }
            },
            handleInitImport: function (file, areaId) {
                const area = policiesRepositoryModel.getAreas().find(el => el.Id == areaId);
                const token = policiesRepositoryModel.getToken();
                const toSend = new FormData();
                toSend.append('file', file, file.name);
                Api.post(`/policyrepository/${area.EncId}/checkimport`, toSend, `Bearer ${token}`, 'multipart/form-data')
                    .then(res => {
                        if (res == 'true') {
                            importExportView.renderDecisionForm(toSend, area.EncId);
                        } else {
                            this.finishImport(toSend, area.EncId);
                        }
                    })
                    .catch(err => console.log(err));
            },
            finishImport: function (toSend, areaId, newRepFamily = false) {
                const token = policiesRepositoryModel.getToken();
                Api.post(`/policyrepository/${areaId}/import?newName&asNewRepFamily=${newRepFamily}`, toSend, `Bearer ${token}`, 'multipart/form-data')
                    .then(_ => {
                        this.fetchRuleRepositories();
                        this.fetchRepositories();
                        importExportView.closeWithSucces();
                    });
            }
        }
        // controla a view de exportar e importar repositórios
        const importExportView = {
            init: function () { 
                this.initializeExportButton();
                this.initilizeImportButton();
            },
            initializeExportButton: function () {
                document.querySelector('a.download').addEventListener('click', e => {
                    e.preventDefault();
                    policiesRepositoryController.handleExport();
                })
            },
            initilizeImportButton: function () {
                document.querySelector('a.upload').addEventListener('click', e => {
                    e.preventDefault();
                    modalController.abrirModal('importar_repositorio_regras');
                    modalController.changeModalTitle('importar_repositorio_regras', document.querySelector('input[data-render="title-modal-import"]').value);
                    modalController.disableModalDisposal('importar_repositorio_regras');
                    this.renderModal();
                })
            },
            renderModal: function () {
                const container = document.querySelector('div[data-render="import-container"]');
                container.innerHTML = '';
                const modalFormTemplate = document.importNode(document.getElementById('form-iniciar-importacao').content, true);

                const subportals = policiesRepositoryController.getSubPortals();
                const subportalsSelect = modalFormTemplate.querySelector('select[name="import-subportal-select"]');
                subportals.forEach(subportal => {
                    let option = document.createElement('option');
                    option.value = subportal.EncId;
                    option.text = subportal.Alias;
                    subportalsSelect.appendChild(option);
                })

                subportalsSelect.addEventListener('input', e => {
                    policiesRepositoryController.fetchAreas(e.target.value)
                        .then(areas => {
                            this.renderAreasSelect(areas);
                        });
                });

                modalFormTemplate.querySelector('fieldset').addEventListener('input', e => {
                    if (e.target.getAttribute('data-render') == 'import-subportal-select') {
                        this.initFormSubmitEnabled(false);
                    } else {
                        this.validateInitForm();
                    }
                });

                modalFormTemplate.querySelector('button[data-render="submit-init-form"]').addEventListener('click', e => {
                    e.preventDefault();
                    const container = document.querySelector('div[data-render="import-container"]');
                    const fileinput = container.querySelector('input[data-render="arquivo_importacao"]');
                    const areaSelect = container.querySelector('select[data-render="import-area-select"]');
                    policiesRepositoryController.handleInitImport(fileinput.files[0], areaSelect.value);
                })

                modalFormTemplate.querySelector('button[data-render="cancel-init-form"]').addEventListener('click', e => {
                    e.preventDefault();
                    modalController.closeModal('importar_repositorio_regras');
                });

                container.appendChild(modalFormTemplate);
                this.renderAreasSelect([]);

                feather.replace();
            },
            renderDecisionForm: function (formdata, areaId) {
                const container = document.querySelector('div[data-render="import-container"]');
                container.innerHTML = '';
                const decisionFormTemplate = document.importNode(document.getElementById('form-decision-importacao').content, true);
                decisionFormTemplate.querySelector('button').addEventListener('click', e => {
                    e.preventDefault();
                    policiesRepositoryController.finishImport(formdata, areaId, document.querySelector('input[name="decisionimport"]:checked').value);
                })
                container.appendChild(decisionFormTemplate);
                feather.replace();
            },
            renderAreasSelect: function (areas) {
                const container = document.getElementById('import-select-area-container');
                const selectAreaTemplate = document.importNode(document.getElementById('import-select-area-template').content, true);
                const select = selectAreaTemplate.querySelector('select');
                container.innerHTML = '';

                areas.forEach(area => {
                    let option = document.createElement('option');
                    option.value = area.Id;
                    option.text = area.Name;
                    select.appendChild(option);
                });

                container.appendChild(selectAreaTemplate);
            },
            validateInitForm: function () {
                const container = document.querySelector('div[data-render="import-container"]');
                const fileinput = container.querySelector('input[data-render="arquivo_importacao"]');
                const areaSelect = container.querySelector('select[data-render="import-area-select"]');

                if (fileinput.files[0] && areaSelect.value) {
                    this.initFormSubmitEnabled(true);
                }
            },
            initFormSubmitEnabled: function (enabled) {
                const submitButton = document.querySelector('div[data-render="import-container"] button[data-render="submit-init-form"]');

                if (enabled) {
                    submitButton.removeAttribute('disabled');
                } else {
                    submitButton.setAttribute('disabled', '');
                }
            },
            closeWithSucces: function () {
                modalController.closeModal('importar_repositorio_regras');
                importSuccessView.openDialog();
            }
        }
        var importSuccessView = {
            init: function () {
                document.getElementById('close-import-success-dialog').addEventListener('click', (e) => {
                    e.preventDefault();
                    dialogController.closeDialog('import-success-dialog');
                });
                document.getElementById('confirm-import-success-dialog').addEventListener('click', (e) => {
                    e.preventDefault();
                    dialogController.closeDialog('import-success-dialog');
                })
            },
            openDialog: function () {
                dialogController.openDialog('import-success-dialog');
            },
        }
        var createEditModalView = {
            init: function () {
                this.addEventToOpener();
                this.replaceModalHandlers();
                this.initializeButtons();
                tabSystem.enableSteps();
            },
            addEventToOpener: function () {
                document.getElementById('open-modal-edit-create').addEventListener('click', (e) => {
                    e.preventDefault();
                    policiesRepositoryController.handleOpenItem();
                })
            },
            replaceModalHandlers: function () {
                modalController.changeCloseModalMethod('cadastrar_editar_repositorio_politicas', (e) => {
                    e.preventDefault();
                    this.close();
                })
                modalController.disableModalDisposal('cadastrar_editar_repositorio_politicas');
            },
            initializeButtons: function () {
                document.getElementById('cancel-button').addEventListener('click', (e) => {
                    e.preventDefault();
                    modalController.closeModal('cadastrar_editar_repositorio_politicas');
                });
                document.getElementById('save-and-close').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.saveAndCloseHandler();
                });
                document.getElementById('back-button').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.backButtonHandler();
                });
                document.getElementById('next-page-button').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.nextStepHandler();
                });
                document.getElementById('new-version-open').addEventListener('click', (e) => {
                    e.preventDefault();
                    newVersionView.openDialog();
                });
                document.getElementById('publish-button').addEventListener('click', (e) => {
                    e.preventDefault();
                    policiesRepositoryController.publishRepository()
                });
            },
            backButtonHandler: function () {
                const item = policiesRepositoryController.getOpen();
                this.renderPage1(item);
            },
            saveAndCloseHandler: function () {
                this.enterLoadingState();
                switch (tabSystem.getPage()) {
                    case 1:
                        policiesRepositoryController.handleEditCreateRepository()
                            .then(resp => {
                                this.close();
                            });
                        break;
                    case 2:
                        this.close();
                        break;
                }
            },
            nextStepHandler: function () {
                this.enterLoadingState();
                policiesRepositoryController.handleEditCreateRepository()
                    .then(resp => {
                        policiesRepositoryController.setOpen(resp);
                        this.updateTitle(resp);
                        tabSystem.setStepDone(1);
                        this.renderPage2(resp);
                        this.leaveLoadingState();
                    });
            },
            render: function (item) {
                if (item) {
                    if (item.PublishDate != '') {
                        this.renderPage2(item);
                        this.renderPage1(item);
                        this.enableViewMode();
                    } else {
                        tabSystem.setStepDone(1);
                        this.renderPage2(item);
                    }
                } else {
                    this.changeSaveAndNextButton(true);
                    this.changeCancelBackButton(false);
                    this.disableViewMode();
                    this.renderPage1(item);
                }
            },
            enableViewMode: function () {
                modalController.addClassToModalBody('cadastrar_editar_repositorio_politicas', 'view-mode');
                tabSystem.enableTabs();
                tabSystem.disableSteps();
                document.querySelectorAll('.cadastrar-editar-modal-body fieldset').forEach(fieldset => {
                    fieldset.setAttribute('disabled', '');
                });
            },
            disableViewMode: function () {
                modalController.removeClassFromModalBody('cadastrar_editar_repositorio_politicas', 'view-mode');
                tabSystem.disableTabs();
                document.getElementById('fieldset-modal').removeAttribute('disabled');
                tabSystem.enableSteps();
            },
            renderPage1: function (item) {
                document.getElementById('cancel-button').setAttribute('style', 'display: flex');
                document.getElementById('back-button').setAttribute('style', 'display: none');
                document.getElementById('next-page-button').setAttribute('style', 'display: flex');
                document.getElementById('publish-button').setAttribute('style', 'display: none');
                const ruleRepositories = policiesRepositoryController.getRuleRepositories();
                const template = document.importNode(document.getElementById('cadastro-form-template').content, true);
                const pageContainer = document.querySelector('div[data-page="1"]');
                pageContainer.innerHTML = '';
                const ruleRepositoriesSelect = template.getElementById('select-regra');
                const versiontext = document.querySelector('input[data-render="versionlabel"]').value;
                ruleRepositories.forEach(ruleRepository => {
                    let option = document.createElement('option');
                    option.value = ruleRepository.Id;
                    option.text = `${ruleRepository.Name} (${versiontext} ${ruleRepository.Version})`;
                    ruleRepositoriesSelect.appendChild(option);
                })
                if (item) {
                    this.changeSaveAndNextButton(false);
                    ruleRepositoriesSelect.value = item.RulesRepositoryId;
                    template.getElementById('visible_results').checked = item.ShowInferenceResult;
                    template.querySelector('input[data-render="name-input"]').value = item.Name;
                    template.querySelector(`input[name="type"][value="${item.Type}"]`).checked = true;
                }
                pageContainer.appendChild(template);
                pageContainer.addEventListener('input', this.validarCadastroForm)
                tabSystem.setPage(1);
            },
            renderPage2: function (item) {
                document.getElementById('cancel-button').setAttribute('style', 'display: none');
                document.getElementById('back-button').setAttribute('style', 'display: flex');
                document.getElementById('next-page-button').setAttribute('style', 'display: none');
                document.getElementById('publish-button').setAttribute('style', 'display: flex');
                const pageContainer = document.querySelector('div[data-page="2"]');
                pageContainer.innerHTML = '';
                this.changeSaveButton(false);
                if (!item.Policies) {
                    const emptyStateTemplate = document.importNode(document.getElementById('empty-state-politicas').content, true);
                    emptyStateTemplate.querySelector('button').addEventListener('click', (e) => {
                        e.preventDefault();
                        policiesRepositoryController.enablePoliciesEdit();
                        this.renderPage2(item);
                    })
                    pageContainer.appendChild(emptyStateTemplate);
                    this.changeNextButton(true);
                } else {
                    const policiesLayout = document.importNode(document.getElementById('cadastro-politicas-layout').content, true);
                    const novapoliticaInput = policiesLayout.querySelector('input[data-render="nova-politica"]');
                    novapoliticaInput.addEventListener('keydown', (e) => {
                        if (e.key == "Enter" || e.keyCode == 13) {
                            e.preventDefault();
                            this.handleNewPolicy();
                        }
                    });
                    novapoliticaInput.addEventListener('blur', (e) => {
                        setTimeout(() => {
                            novapoliticaInput.value = "";
                        }, 500)
                    });
                    policiesLayout.querySelector('input[data-render="input-busca-politica"]').addEventListener('keydown', (e) => { // previne que o usuário dê um submit no form da página através do input de busca
                        if (e.key == "Enter" || e.keyCode == 13) {
                            e.preventDefault();
                        }
                    });
                    policiesLayout.querySelector('input[data-render="input-busca-politica"]').addEventListener('input', (e) => {
                        this.renderPolicies(item.Policies);
                    });
                    policiesLayout.getElementById('nova-politica-button').addEventListener('click', (e) => {
                        e.preventDefault();
                        this.handleNewPolicy();
                    });
                    pageContainer.appendChild(policiesLayout);
                    this.renderPolicies(item.Policies);
                }
                feather.replace();
                tabSystem.setPage(2);
            },
            renderPolicies: function (policies) {
                document.querySelector('.cadastro-regras-listagem-container').innerHTML = '';
                this.buscaPoliticaHabilitada(policies.length > 0);
                policies.forEach((policy, index) => {
                    this.renderPolicy(policy, index);
                });
                this.validatePolicyList();
            },
            renderPolicy: function (policy, index) {
                const filter = document.querySelector('.cadastro-regras-header input[data-render="input-busca-politica"]').value;
                const selectedPolicy = policiesRepositoryController.getSelectedPolicy();
                const open = policiesRepositoryController.getOpen();
                const filterRegex = new RegExp(filter.toLowerCase(), 'g');
                // caso esteja ocorrendo um filtro, verifica se o item atual faz parte da filtragem
                if (filter != '' && !policy.Name.toLowerCase().match(filterRegex)) {
                    return;
                }
                const container = document.querySelector('.cadastro-regras-listagem-container');
                const policyLayout = document.importNode(document.getElementById('policy-template').content, true);
                const policyContainer = policyLayout.querySelector('.rule');
                const nameInput = policyLayout.querySelector('input');

                // set attributes
                policyContainer.setAttribute('policy-index', index);
                nameInput.setAttribute('policy-index', index);

                // data binding
                nameInput.value = policy.Name;
                if (policy.Scenarios) policyLayout.querySelector('.status').classList.add('done');

                // checa se essa regra é a regra selecionada
                if (policy.Alias == selectedPolicy?.Alias) {
                    const currentSelected = document.querySelector('.rule.selected');
                    if (currentSelected) currentSelected.classList.remove('selected');

                    policyContainer.classList.add('selected');
                }

                // adiciona os eventos necessários
                policyContainer.querySelector('div:first-of-type').addEventListener('click', (e) => { // adiciona evento de click à primeira porção da politica para evitar evento de click no dropdown de opções.
                    e.preventDefault();
                    if (policyContainer.classList.contains('selected')) {
                        policyContainer.classList.remove('selected');
                        policiesRepositoryController.setSelectedPolicy(null);
                    } else {
                        const currentSelected = document.querySelector('.rule.selected');
                        if (currentSelected) currentSelected.classList.remove('selected');

                        policyContainer.classList.add('selected');
                        policiesRepositoryController.setSelectedPolicy(policy);
                    }
                });
                if (!open.PublishDate) {
                    nameInput.addEventListener('keydown', (e) => {
                        if (e.key == "Enter" || e.keyCode == 13) {
                            e.preventDefault();
                            e.target.setAttribute('readonly', "");
                            e.target.blur();
                        }
                    });
                    nameInput.addEventListener('blur', (e) => {
                        if (e.target.value != policy.Name) {
                            policiesRepositoryController.editPolicy(e.target.value, index);
                        }
                        e.target.setAttribute('readonly', "");
                    });
                    nameInput.addEventListener('dblclick', () => {
                        nameInput.removeAttribute('readonly');
                    })
                }

                policyLayout.querySelector('button[data-render="delete-policy-button"]').addEventListener('click', (e) => {
                    e.preventDefault();
                    deleteRegisterView.openDialog(index, 'handleDeletePolicy');
                });
                policyLayout.querySelector('button[data-render="enable-edit-policy"]').addEventListener('click', (e) => {
                    e.preventDefault();
                    nameInput.removeAttribute('readonly');
                    nameInput.focus();
                });

                container.appendChild(policyLayout);
                feather.replace();
            },
            handleNewPolicy: function () {
                const input = document.querySelector('div[data-page="2"] input[data-render="nova-politica"]');
                if (input.value != '') {
                    policiesRepositoryController.addNewPolicy(input.value)
                        .then(newPolicy => {
                            const newIndex = policiesRepositoryController.getOpen()?.Policies?.length;
                            input.value = '';
                            if (newPolicy) {
                                policiesRepositoryController.setSelectedPolicy(newPolicy);
                                createEditModalView.renderPolicy(newPolicy, newIndex - 1);
                            }
                        })
                }
            },
            buscaPoliticaHabilitada: function (habilitada) {
                if (habilitada) {
                    document.querySelector('.cadastro-regras-header input[data-render="input-busca-politica"]').setAttribute('type', 'text');
                } else {
                    document.querySelector('.cadastro-regras-header input[data-render="input-busca-politica"]').setAttribute('type', 'hidden');
                }
            },
            renderScenarios: function (policy) {
                if (policy) {
                    const open = policiesRepositoryController.getOpen();
                    if (open.Type == 1) { // políticas do tipo scoring
                        this.renderScoringScenario(open, policy);
                    } else {  // políticas do tipo análise
                        this.renderAnaliseScenarios(policy);
                    }
                } else {
                    const conditionsContainer = document.querySelector('div[data-page="2"] .cadastro-condicoes');
                    conditionsContainer.innerHTML = '';
                }
            },
            renderAnaliseScenarios: function (policy) {
                const conditionsContainer = document.querySelector('div[data-page="2"] .cadastro-condicoes');
                conditionsContainer.innerHTML = '';
                if (policy.Scenarios?.length > 0) {
                    const configTemplate = document.importNode(document.getElementById('analysis-config-template').content, true);
                    configTemplate.querySelector('button[data-render="adicionar-cenario"]').addEventListener('click', (e) => {
                        e.preventDefault();
                        policiesRepositoryController.addAnalisyScenario();
                    });
                    configTemplate.querySelector('button[data-render="salvar-condicoes"]').addEventListener('click', e => {
                        e.preventDefault();
                        e.target.setAttribute('disabled', '');
                        policiesRepositoryController.handleConfigPolicy()
                            .then(_ => {
                                e.target.removeAttribute('disabled');
                            });
                    })
                    configTemplate.querySelector('span[data-render="Name"]').innerHTML = policy.Name;
                    configTemplate.querySelector('span[data-render="Alias"]').innerHTML = `[${policy.Alias}]`;
                    conditionsContainer.appendChild(configTemplate);
                    policy.Scenarios.forEach((scenary, index, policy) => {
                        this.renderAnaliseScenary(scenary, index);
                    });
                } else { //empty state
                    const emptyStateTemplate = document.importNode(document.getElementById('empty-state-cenarios').content, true);
                    emptyStateTemplate.querySelector('button').addEventListener('click', (e) => {
                        e.preventDefault();
                        policiesRepositoryController.addAnalisyScenario();
                    });
                    conditionsContainer.appendChild(emptyStateTemplate);
                }
                feather.replace();
            },
            renderAnaliseScenary: function (scenary, index) {
                const open = policiesRepositoryController.getOpen();
                const container = document.querySelector('div[data-page="2"] .listagem-condicoes');
                const scenaryTemplate = document.importNode(document.getElementById('analysis-scenary').content, true);
                const scenaryContainer = scenaryTemplate.querySelector('.scenary');
                const nameInput = scenaryTemplate.querySelector('input[data-render="scenary-name"]');
                const minValidConditionsInput = scenaryTemplate.querySelector('input[data-render="MinValidConditions"]');
                const resultDescriptionInput = scenaryTemplate.querySelector('textarea[data-render="ResultDescription"]');
                const resultInput = scenaryTemplate.querySelector('input[data-render="Result"]');
                const accordionHeader = scenaryTemplate.querySelector('.accordion-header');
                const accordionBody = scenaryTemplate.querySelector('.accordion-body');
                const currentRepository = policiesRepositoryController.getRuleRepositories().find(el => el.Id == open.RulesRepositoryId);

                // remove animação do accordion-body na primeira renderização
                accordionBody.classList.add('unanimated');

                // bind de informações
                nameInput.value = scenary.Name;
                if (scenary.Name != '') nameInput.setAttribute('readonly', "");
                scenaryContainer.setAttribute('scenary-index', index);
                minValidConditionsInput.value = scenary.MinValidConditions ?? 1;
                resultInput.value = scenary.Result;
                resultDescriptionInput.value = scenary.ResultDescription;

                // renderiza o selec de regras
                const selectRegras = scenaryTemplate.querySelector('div[data-render="select-regra"]');
                const ruleSelectorId = `select-rules-scenary-${index}`;
                selectRegras.setAttribute('id', ruleSelectorId);

                // renderiza as opções de regra
                if (currentRepository.Rules?.length > 0) {
                    const optionsContainer = scenaryTemplate.querySelector('.options');
                    currentRepository.Rules.forEach(rule => {
                        const optionTemplate = document.importNode(document.getElementById('rule-select-option').content, true);
                        const optionLabel = optionTemplate.querySelector('label');
                        const optionCheckbox = optionTemplate.querySelector('input');
                        optionCheckbox.value = rule.Id;
                        optionCheckbox.setAttribute('id', `${index}-${rule.Alias}-${rule.Id}`);
                        optionCheckbox.setAttribute('data-text', rule.Alias);
                        optionLabel.setAttribute('for', `${index}-${rule.Alias}-${rule.Id}`);
                        optionLabel.innerHTML = rule.Alias;
                        optionsContainer.appendChild(optionTemplate);
                    });
                }


                // adiciona eventos
                if (!open.PublishDate) {
                    nameInput.addEventListener('keydown', (e) => { // previne que o usuário dê um submit no form da página através do input de busca
                        if (e.key == "Enter" || e.keyCode == 13) {
                            e.preventDefault();
                            if (e.target.value != '') {
                                e.target.blur();
                            }
                        }
                    });
                    nameInput.addEventListener('blur', (e) => {
                        if ((e.target.value != scenary.Name) && e.target.value != "") {
                            policiesRepositoryController.updateScenary(index, 'Name', e.target.value);
                            document.querySelector(`.scenary[scenary-index="${index}"]`).classList.remove('undereddit');
                            e.target.setAttribute('readonly', "");
                        } else {
                            e.target.value = scenary.Name;
                        }
                        this.validateAnalysisPolicyConfig();
                    });
                    nameInput.addEventListener('dblclick', () => {
                        nameInput.removeAttribute('readonly');
                    });
                    scenaryTemplate.querySelector('button[data-render="enable-edit-scenary"]').addEventListener('click', (e) => {
                        e.preventDefault();
                        nameInput.removeAttribute('readonly');
                        nameInput.focus();
                    });
                    scenaryTemplate.querySelector('button[data-render="delete-scenary-button"]').addEventListener('click', (e) => {
                        e.preventDefault();
                        deleteRegisterView.openDialog(index, 'handleDeleteScenary');
                    });
                    scenaryTemplate.querySelector('button[data-render="adicionar-regra"]').addEventListener('click', (e) => {
                        e.preventDefault();
                        const values = inputWithSearch.getValue(ruleSelectorId).split('-');
                        policiesRepositoryController.addAnalisyScenaryConditions(index, values);
                        inputWithSearch.resetValue(ruleSelectorId);
                        inputWithSearch.disableOptionsWithValues(ruleSelectorId, values);
                        document.querySelector(`div[scenary-index="${index}"] button[data-render="adicionar-regra"]`).setAttribute('disabled', '');
                        this.renderAnalysisScenaryConditions(index);
                        this.validateAnalysisPolicyConfig();
                    });
                    minValidConditionsInput.addEventListener('input', e => {
                        const currentScenary = policiesRepositoryController.getSelectedPolicy().Scenarios?.find((sEl, sElIndex) => sElIndex == index);
                        if (e.target.value == '') {
                            return;
                        } else if (Number(e.target.value) < 1) {
                            e.target.value = 1;
                            policiesRepositoryController.updateScenary(index, e.target.getAttribute('data-render'), 1);
                        } else if (Number(e.target.value) > currentScenary.Conditions?.length) {
                            e.target.value = currentScenary.Conditions?.length > 0 ? currentScenary.Conditions?.length : 1
                            policiesRepositoryController.updateScenary(index, e.target.getAttribute('data-render'), currentScenary.Conditions?.length > 0 ? currentScenary.Conditions?.length : 1);
                        } else {
                            policiesRepositoryController.updateScenary(index, e.target.getAttribute('data-render'), e.target.value);
                        }
                    });
                    minValidConditionsInput.addEventListener('blur', e => {
                        if (e.target.value == '') {
                            e.target.value = 1;
                            policiesRepositoryController.updateScenary(index, e.target.getAttribute('data-render'), 1);
                        }
                    })
                    resultInput.addEventListener('input', e => {
                        policiesRepositoryController.updateScenary(index, e.target.getAttribute('data-render'), e.target.value);
                        this.validateAnalysisPolicyConfig();
                    });
                    resultDescriptionInput.addEventListener('input', e => {
                        policiesRepositoryController.updateScenary(index, e.target.getAttribute('data-render'), e.target.value);
                    });
                    scenaryContainer.setAttribute('draggable', 'true');
                    scenaryContainer.addEventListener('dragover', e => {
                        e.preventDefault();
                        const targetRect = e.currentTarget.getBoundingClientRect();
                        if (e.clientY < (targetRect.y + ((targetRect.height - 16) / 2))) { // jogado acima do target
                            if (!e.currentTarget.classList.contains('up')) {
                                e.currentTarget.classList.remove('down');
                                e.currentTarget.classList.add('dragover', 'up');
                            }
                        } else {
                            if (!e.currentTarget.classList.contains('down')) {
                                e.currentTarget.classList.remove('up');
                                e.currentTarget.classList.add('dragover', 'down');
                            }
                        }
                    });
                    scenaryContainer.addEventListener('dragleave', e => {
                        e.currentTarget.classList.remove('down', 'up', 'dragover');
                    });
                    scenaryContainer.addEventListener('drop', e => {
                        const targetRect = e.currentTarget.getBoundingClientRect();
                        const draggedIndex = e.dataTransfer.getData('index');
                        const draggedTargetIndex = e.currentTarget.getAttribute("scenary-index");
                        if (e.clientY < (targetRect.y + ((targetRect.height - 16) / 2))) { // jogado acima do target
                            policiesRepositoryController.moveScenary(draggedIndex, Number(draggedTargetIndex))
                        } else {
                            policiesRepositoryController.moveScenary(draggedIndex, Number(draggedTargetIndex)+1 )
                        }
                    });
                    scenaryContainer.addEventListener('dragstart', e => {
                        e.dataTransfer.setData('index', index);
                        //e.currentTarget.setAttribute('style', 'opacity: 0');
                    });
                    scenaryContainer.addEventListener('dragend', e => {
                        e.currentTarget.removeAttribute('style');
                    })
                    
                } else {
                    scenaryTemplate.querySelector('fieldset').setAttribute('disabled', '');
                    nameInput.setAttribute('readonly', '');
                }

                scenaryTemplate.querySelector('button[data-render="accordion-trigger"]').addEventListener('click', e => { //adiciona listener para a abertura do accordion
                    e.preventDefault();
                    accordionBody.classList.remove('unanimated');
                    if (!accordionHeader.classList.contains('open')) {
                        accordionBody.setAttribute('style', `max-height: ${accordionBody.scrollHeight + 100}px;`);
                    } else {
                        accordionBody.removeAttribute('style');
                    }
                    accordionHeader.classList.toggle('open');
                    policiesRepositoryController.updateScenary(index, 'open', accordionHeader.classList.contains('open'));
                })

                if (scenary.Name == '') scenaryTemplate.querySelector('.scenary').classList.add('undereddit');

                container.appendChild(scenaryTemplate);

                inputWithSearch.init(ruleSelectorId, (value) => {
                    if (value == '') {
                        document.querySelector(`div[scenary-index="${index}"] button[data-render="adicionar-regra"]`).setAttribute('disabled', '');
                    } else {
                        document.querySelector(`div[scenary-index="${index}"] button[data-render="adicionar-regra"]`).removeAttribute('disabled', '');
                    }
                }, true);

                if (scenary.Name == '') {
                    nameInput.focus()
                    nameInput.scrollIntoView();
                };

                if (scenary.Conditions?.length > 0) {
                    this.renderAnalysisScenaryConditions(index);
                    inputWithSearch.disableOptionsWithValues(ruleSelectorId, scenary.Conditions.map(s => s.RuleId));
                };

                if (scenary.open) {
                    accordionHeader.classList.add('open');
                    // atualiza o tamanho do accordion
                    accordionBody.setAttribute('style', `max-height: ${accordionBody.scrollHeight + 100}px;`)
                };

                this.validateAnalysisPolicyConfig();
            },
            renderAnalysisScenaryConditions: function (index) {
                const policy = policiesRepositoryController.getSelectedPolicy();
                const policyRepository = policiesRepositoryController.getOpen();
                const container = document.querySelector(`div[scenary-index="${index}"] .lista-regras`);
                const accordionBody = document.querySelector(`div[scenary-index="${index}"] .accordion-body`);
                const scenary = policy.Scenarios[index];
                const open = policiesRepositoryController.getOpen();
                const ruleRepository = policiesRepositoryController.getRuleRepositories().find(el => el.Id == open.RulesRepositoryId);
                container.innerHTML = "";

                scenary.Conditions.forEach((condition, c_index) => {
                    const rule = ruleRepository.Rules.find(r => r.Id == condition.RuleId);
                    const conditionTemplate = document.importNode(document.getElementById('condition-analysis').content, true);
                    const checkbox = conditionTemplate.querySelector('.flagged-checkbox input');

                    // adiciona ids necessários
                    checkbox.setAttribute('id', `CausesScenarioFailure-${index}-${c_index}`);
                    conditionTemplate.querySelector('.flagged-checkbox label').setAttribute('for', `CausesScenarioFailure-${index}-${c_index}`);

                    //data-bind
                    conditionTemplate.querySelector('h3[data-render="nome-regra"]').innerHTML = rule.Alias;
                    conditionTemplate.querySelector('p[data-render="text-regra"]').innerHTML = rule.Text ?? '';
                    conditionTemplate.querySelector('span[data-render="index"]').innerHTML = c_index + 1;
                    if (condition.CausesScenarioFailure) checkbox.checked = true;

                    //adiciona eventos
                    if (!policyRepository.PublishDate) {
                        checkbox.addEventListener("input", (e) => {
                            policiesRepositoryController.updateScenaryCondition(index, c_index, 'CausesScenarioFailure', e.target.checked);
                        })

                        conditionTemplate.querySelector('button[data-render="delete-condicao"]').addEventListener('click', (e) => {
                            e.preventDefault();
                            deleteConditionView.openDialog(index, c_index);
                        })
                    } else {
                        checkbox.setAttribute('disabled', '');
                    }

                    container.appendChild(conditionTemplate);

                    // atualiza o tamanho do accordion
                    if (scenary.open) {
                        accordionBody.setAttribute('style', `max-height: ${accordionBody.scrollHeight + 100}px;`)
                    };
                })

                feather.replace();
            },
            validateAnalysisPolicyConfig: function () {
                const policy = policiesRepositoryController.getSelectedPolicy();
                const saveButton = document.querySelector('button[data-render="salvar-condicoes"]');
                if (policy.Scenarios?.length > 0) {
                    saveButton.removeAttribute('disabled');
                    policy.Scenarios.forEach(scenary => {
                        if (!(scenary.Name && scenary.Result && (scenary.Conditions?.length > 0))) {
                            saveButton.setAttribute('disabled', '');
                            return;
                        }
                    })
                } else {
                    saveButton.setAttribute('disabled', '');
                }
            },
            renderScoringScenario: function (open, policy) {
                const scenarioTemplate = document.importNode(document.getElementById('scoring-scenario').content, true);
                const conditionsContainer = document.querySelector('div[data-page="2"] .cadastro-condicoes');
                const currentRepository = policiesRepositoryController.getRuleRepositories().find(el => el.Id == open.RulesRepositoryId);
                conditionsContainer.innerHTML = '';

                // bind das informações da politica
                scenarioTemplate.querySelector('span[data-render="Name"]').innerHTML = policy.Name;
                scenarioTemplate.querySelector('span[data-render="Alias"]').innerHTML = `[${policy.Alias}]`;

                // renderiza as opções de regra
                if (currentRepository.Rules?.length > 0) {
                    const optionsContainer = scenarioTemplate.querySelector('.options');
                    currentRepository.Rules.forEach(rule => {
                        const optionTemplate = document.importNode(document.getElementById('rule-select-option').content, true);
                        const optionLabel = optionTemplate.querySelector('label');
                        const optionCheckbox = optionTemplate.querySelector('input');
                        optionCheckbox.value = rule.Id;
                        optionCheckbox.setAttribute('id', `${policy.Alias}-${rule.Id}`);
                        optionCheckbox.setAttribute('data-text', rule.Alias);
                        optionLabel.setAttribute('for', `${policy.Alias}-${rule.Id}`);
                        optionLabel.innerHTML = rule.Alias;
                        optionsContainer.appendChild(optionTemplate);
                    })
                }

                // adiciona evento para criar novas condicoes
                scenarioTemplate.querySelector('button[data-render="adicionar-regra"]').addEventListener('click', (e) => {
                    e.preventDefault();
                    const values = inputWithSearch.getValue('select-rule-search-input').split('-');
                    policiesRepositoryController.addScoringScenarioCondition(values);
                    inputWithSearch.resetValue('select-rule-search-input');
                    inputWithSearch.disableOptionsWithValues('select-rule-search-input', values);
                    document.querySelector('button[data-render="adicionar-regra"]').setAttribute('disabled', '');
                    this.renderScoringConditions();
                })

                scenarioTemplate.querySelector('button[data-render="salvar-condicoes"]').addEventListener('click', (e) => {
                    e.preventDefault();
                    e.target.setAttribute('disabled', '');
                    policiesRepositoryController.handleConfigPolicy()
                        .then(_ => {
                            e.target.removeAttribute('disabled');
                        });
                })

                conditionsContainer.appendChild(scenarioTemplate);
                if (policy.Scenarios) {
                    this.renderScoringConditions();
                    if (policy.Scenarios[0]?.Conditions?.length > 0) {
                        const ruleIds = []
                        const conditions = policy.Scenarios[0].Conditions;
                        for (i = 0; i < conditions.length; i++) {
                            ruleIds.push(conditions[i].RuleId);
                        }
                        inputWithSearch.disableOptionsWithValues('select-rule-search-input', ruleIds);
                    }
                };
                inputWithSearch.init('select-rule-search-input', (value) => {
                    if (value == '') {
                        document.querySelector('button[data-render="adicionar-regra"]').setAttribute('disabled', '');
                    } else {
                        document.querySelector('button[data-render="adicionar-regra"]').removeAttribute('disabled', '');
                    }
                }, true);
                feather.replace();
            },
            renderScoringConditions: function () {
                const container = document.querySelector('.listagem-condicoes');
                const selectedPolicy = policiesRepositoryController.getSelectedPolicy();
                container.innerHTML = '';
                if (selectedPolicy.Scenarios[0]?.Conditions?.length > 0) {
                    selectedPolicy.Scenarios[0].Conditions.forEach((condition, index) => {
                        this.renderScoringCondition(condition, index);
                    });
                }
                this.validaConfigScoringPolicy();
                feather.replace();
            },
            renderScoringCondition: function (condition, index) {
                const container = document.querySelector('.listagem-condicoes');
                const open = policiesRepositoryController.getOpen();
                const ruleRepository = policiesRepositoryController.getRuleRepositories().find(el => el.Id == open.RulesRepositoryId);
                const rule = ruleRepository.Rules.find(r => r.Id == condition.RuleId);
                const conditionTemplate = document.importNode(document.getElementById('condicao-scoring').content, true);

                // bind de dados
                conditionTemplate.querySelector('h3[data-render="nome-regra"]').innerHTML = rule.Alias;
                conditionTemplate.querySelector('p[data-render="text-regra"]').innerHTML = rule.Text ?? '';
                conditionTemplate.querySelector('span[data-render="index"]').innerHTML = index + 1;
                conditionTemplate.querySelector('input[data-render="PassScoringValue"]').value = condition.PassScoringValue;
                conditionTemplate.querySelector('input[data-render="FailScoringValue"]').value = condition.FailScoringValue;

                if (open.PublishDate) {
                    conditionTemplate.querySelector('fieldset').setAttribute('disabled', '');
                }

                // adiciona evento de change
                conditionTemplate.querySelector('fieldset').addEventListener("input", (e) => {
                    policiesRepositoryController.updateScenaryCondition(0, index, e.target.getAttribute('data-render'), e.target.value);
                    this.validaConfigScoringPolicy();
                })

                // adiciona evento para delete
                conditionTemplate.querySelector('button[data-render="delete-condicao"]').addEventListener('click', e => {
                    e.preventDefault();
                    deleteConditionView.openDialog(0, index);
                })

                container.appendChild(conditionTemplate);
            },
            validaConfigScoringPolicy: function () {
                const button = document.querySelector('button[data-render="salvar-condicoes"]');
                const selectedPolicy = policiesRepositoryController.getSelectedPolicy();
                if (selectedPolicy.Scenarios?.length > 0) {
                    if (selectedPolicy.Scenarios[0].Conditions?.length > 0) {
                        button.removeAttribute('disabled');
                        selectedPolicy.Scenarios[0].Conditions.forEach(condition => {
                            if (condition.PassScoringValue === "" || condition.FailScoringValue === "") {
                                button.setAttribute('disabled', '');
                                return;
                            }
                        })
                    } else {
                        button.setAttribute('disabled', '');
                    }
                } else {
                    button.setAttribute('disabled', '');
                }
            },
            validatePolicyList: function () {
                const open = policiesRepositoryController.getOpen();
                if (open.Policies?.length > 0) {
                    this.changeNextButton(false);
                    open.Policies.forEach(policy => {
                        if (!policy.Scenarios) {
                            this.changeNextButton(true);
                            return;
                        }
                    })
                } else {
                    this.changeNextButton(true);
                }
            },
            validarCadastroForm: () => {
                const nameInputValue = document.querySelector('input[data-render="name-input"]').value;
                const ruleRepositorySelectValue = document.getElementById('select-regra').value;
                if (nameInputValue != '' && ruleRepositorySelectValue !== '') {
                    createEditModalView.changeSaveAndNextButton(false);
                } else {
                    createEditModalView.changeSaveAndNextButton(true);
                }
            },
            changeSaveAndNextButton: function (disabled) {
                this.changeNextButton(disabled);
                this.changeSaveButton(disabled);
            },
            changeNextButton: function (disabled) {
                if (disabled) {
                    document.getElementById('next-page-button').setAttribute('disabled', disabled);
                    document.getElementById('publish-button').setAttribute('disabled', disabled);
                } else {
                    document.getElementById('next-page-button').removeAttribute('disabled');
                    document.getElementById('publish-button').removeAttribute('disabled');
                }
            },
            changeSaveButton: function (disabled) {
                disabled ?
                    document.getElementById('save-and-close').setAttribute('disabled', disabled)
                    :
                    document.getElementById('save-and-close').removeAttribute('disabled')
            },
            changeCancelBackButton: function (disabled) {
                if (disabled) {
                    document.getElementById('cancel-button').setAttribute('disabled', disabled);
                    document.getElementById('back-button').setAttribute('disabled', disabled);
                } else {
                    document.getElementById('cancel-button').removeAttribute('disabled');
                    document.getElementById('back-button').removeAttribute('disabled');
                }
            },
            nameChangeHandler: function (e) {
                createEditModalView.changeSaveAndNextButton(e.target.value == '');
            },
            open: function () {
                const item = policiesRepositoryController.getOpen();
                this.updateTitle(item);
                modalController.abrirModal('cadastrar_editar_repositorio_politicas');
                this.render(item);
            },
            updateTitle: function (item) {
                const newPolicyTitle = document.querySelector('input[data-render="newpolicytitle"]').value;
                modalController.changeModalTitle('cadastrar_editar_repositorio_politicas', item ? `${item.Name} (versão ${item.Version})` : newPolicyTitle);
            },
            enterLoadingState: function () {
                this.changeSaveAndNextButton(true);
                this.changeCancelBackButton(true);
            },
            leaveLoadingState: function () {
                this.changeCancelBackButton(false);
            },
            close: function () {
                toasterController.clearToasters('.modal-content-container');
                modalController.closeModal('cadastrar_editar_repositorio_politicas');
                policiesRepositoryController.handleCloseItem();
                newVersionView.closeDialog();
                this.changeCancelBackButton(false);
                this.disableViewMode();
                tabSystem.cleanDoneSteps();
            }
        }
        var policiesRepositoryView = {
            statusIcons: {
                published: 'check-square',
                edit: 'edit',
                old: 'clock',
            },
            init: function (policies = []) {
                this.render(policies);
                this.initHeaderFilter();
            },
            initHeaderFilter: function () {
                const filterableHeaders = document.querySelectorAll('table#policies-table thead tr th[data-filter]');
                const orderBy = policiesRepositoryController.getOrderBy();
                console.log(orderBy);
                if (orderBy.fieldName) {
                    document.querySelector(`table#policies-table thead tr th[data-filter="${orderBy.fieldName}"]`)?.classList.add(orderBy.ascending ? 'up' : 'down');
                }
                if (filterableHeaders.length > 0) {
                    filterableHeaders.forEach(header => {
                        header.addEventListener('click', e => {
                            if (e.target.classList.contains('up')) {
                                e.target.classList.remove('up');
                                e.target.classList.add('down');
                                policiesRepositoryController.setOrderBy(e.target.getAttribute('data-filter'), false);
                            } else if (e.target.classList.contains('down')) {
                                e.target.classList.remove('down');
                                policiesRepositoryController.setOrderBy(null, null);
                            } else {
                                const activeFilter = document.querySelector('table#policies-table thead tr th.filter.up, table#policies-table thead tr th.filter.down');
                                if (activeFilter) {
                                    activeFilter.classList.remove('up', 'down');
                                }
                                e.target.classList.add('up');
                                policiesRepositoryController.setOrderBy(e.target.getAttribute('data-filter'), true);
                            }
                        });
                    });
                }
            },
            toggleLoader: function (show = false) {
                show ?
                    document.getElementById('table-loader').classList.add('show')
                    :
                    document.getElementById('table-loader').classList.remove('show');
            },
            render: function (policies = []) {
                this.cleanRender();
                if (policiesRepositoryController.getLoading()) {
                    this.toggleLoader(true);
                } else {
                    this.toggleLoader(false);
                    const template = document.getElementById('table-line-template');
                    const body = document.querySelector('table#policies-table tbody');
                    body.innerHTML = "";
                    if (policies.length > 0) {
                        policies.forEach(policy => {
                            this.renderLine(document.importNode(template.content, true), body, policy);
                            if (policy.Children?.length > 0) {
                                policy.Children.forEach((child, c_index) => {
                                    this.renderLine(document.importNode(template.content, true), body, child, policy, c_index == (policy.Children.length - 1));
                                })
                            }
                        })
                    } else {
                        document.querySelector('table#policies-table tfoot').classList.add('show');
                    }
                }
                feather.replace();
            },
            renderLine: function (template, body, policy, father, last_child) {
                const tr = template.querySelector('tr');
                let policyStatus = '';
                if ((policy.PublishDate && !father) || (policy.PublishDate && !(father?.PublishDate))) {
                    policyStatus = 'published';
                } else if (father?.PublishDate && policy.PublishDate) {
                    policyStatus = 'old';
                } else {
                    policyStatus = 'edit';
                }
                // seta key para updates na listagem
                tr.setAttribute('key', `${policy.Id}-${policy.Version}`);
                tr.classList.add(policyStatus);

                if (father) {
                    tr.classList.add('child');
                    if (last_child) tr.classList.add('last');
                    tr.setAttribute('father-row', `${father.Id}-${father.Version}`);
                }
                // habilita a coluna de novas colunas
                if ((policy.Children?.length > 0) && !father) {
                    const versionsButton = document.createElement('button');
                    versionsButton.classList.add('table-action', 'arrow');
                    const iChevron = document.createElement('i');
                    iChevron.setAttribute('data-feather', 'chevron-right');
                    versionsButton.appendChild(iChevron);

                    // adiciona evento de click ao botão de collapse
                    versionsButton.addEventListener('click', (e) => {
                        e.preventDefault();
                        if (body.querySelector(`tr[key="${policy.Id}-${policy.Version}"]`).classList.contains('open')) {
                            body.querySelectorAll('tr.open').forEach(tr => tr.classList.remove('open'));
                        } else {
                            body.querySelectorAll('tr.open').forEach(tr => tr.classList.remove('open'));
                            body.querySelector(`tr[key="${policy.Id}-${policy.Version}"]`).classList.add('open');
                            body.querySelectorAll(`tr[father-row="${policy.Id}-${policy.Version}"]`).forEach(tr => tr.classList.add('open'));
                        }
                    })

                    template.querySelector('td div[data-render="openButton"]').appendChild(versionsButton);
                }
                // botão de status da versão
                const statusButton = document.createElement('button');
                statusButton.classList.add('table-action', 'status');
                const iStatus = document.createElement('i');
                iStatus.setAttribute('data-feather', this.statusIcons[policyStatus]);
                statusButton.appendChild(iStatus);
                template.querySelector('td div[data-render="status"]').appendChild(statusButton);
                // colunas regulares
                const possibleTypes = {
                    1: document.querySelector('input[data-render="scoringlabel"]').value,
                    2: document.querySelector('input[data-render="analiselabel"]').value,
                }
                template.querySelector('td div[data-render="Id"]').innerHTML = policy.Id;
                template.querySelector('td div[data-render="Name"]').innerHTML = policy.Name;
                template.querySelector('td div[data-render="Alias"]').innerHTML = possibleTypes[policy.Type];
                template.querySelector('td div[data-render="Version"]').innerHTML = policy.Version;
                template.querySelector('td div[data-render="PublisherName"]').innerHTML = policy.PublisherName ?? '-';
                template.querySelector('td div[data-render="PublishDate"]').innerHTML = policy.PublishDate ?? '-';
                template.querySelector('td div[data-render="RulesRepositoryName"]').innerHTML = policy.RulesRepositoryName;

                const processContainer = template.querySelector('td div[data-render="Processes"]');
                if (policy.Processes?.length > 0) {
                    if (policy.Processes.length == 1) {
                        processContainer.innerHTML = policy.Processes[0];
                    } else {
                        const multipleProcessesTemplate = document.importNode(document.getElementById('multiplos-processos-template').content, true);
                        policy.Processes.forEach(process => {
                            const policyLine = document.createElement('li');
                            policyLine.innerHTML = process;
                            multipleProcessesTemplate.querySelector('ul').appendChild(policyLine);
                        })
                        processContainer.appendChild(multipleProcessesTemplate);
                    }
                } else {
                    processContainer.innerHTML = '-';
                }


                // pega todas as colunas exceto a primeira, que é responsável por abrir o accordion
                const tds = template.querySelectorAll('td:not(:first-of-type)');
                tds.forEach(td => {
                    td.addEventListener('click', () => {
                        if (tr.classList.contains('selected')) {
                            body.querySelectorAll('tr.selected').forEach(tr => tr.classList.remove('selected'));
                            policiesRepositoryController.handleSelectChange(null);
                        } else {
                            body.querySelectorAll('tr.selected').forEach(tr => tr.classList.remove('selected'));
                            tr.classList.add('selected');
                            policiesRepositoryController.handleSelectChange(policy);
                        }
                    });

                    td.addEventListener('dblclick', () => {
                        policiesRepositoryController.handleOpenItem(policy);
                    });
                })
                body.appendChild(template);
            },
            cleanRender: function () {
                document.getElementById('table-loader').classList.remove('show');
                document.querySelector('table#policies-table tfoot').classList.remove('show');
            }
        }
        var searchFormView = {
            init: function () {
                const subportalsSelect = document.getElementById('subportal-select');
                subportalsSelect.addEventListener('change', (e) => {
                    policiesRepositoryController.handleSubPortalChange(e.target.value);
                })
                const searchButton = document.getElementById('search-form-button');
                searchButton.addEventListener('click', (e) => {
                    e.preventDefault();
                    policiesRepositoryController.handleSearchClick();
                });
            },
            renderSubportals: function (subportals) {
                const subportalsSelect = document.getElementById('subportal-select');
                const selectedPortal = pagePickerCookieController.getCurrentPortal();
                subportals.forEach(subportal => {
                    let option = document.createElement('option');
                    option.value = subportal.Id;
                    option.text = subportal.Alias;
                    if (selectedPortal == subportal.Id) option.selected = true;
                    subportalsSelect.appendChild(option);
                })
            },
            renderAreas: function (areas) {
                const areasSelect = document.getElementById('area-select');
                const selectedArea = pagePickerCookieController.getCurrentArea();
                areasSelect.innerHTML = '';
                areas.forEach(area => {
                    let option = document.createElement('option');
                    option.value = area.Id;
                    option.text = area.Name;
                    if (selectedArea == area.Id) option.selected = true;
                    areasSelect.appendChild(option);
                })
            }
        }
        var newVersionView = {
            init: function () {
                document.getElementById('close-new-version-dialog').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.closeDialog();
                });
                document.getElementById('cancel-new-version').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.closeDialog();
                });
                document.getElementById('confirm-new-version-button').addEventListener('click', (e) => {
                    e.preventDefault();
                    e.target.setAttribute('disabled', '');
                    policiesRepositoryController.handleNewVersion();
                })
            },
            openDialog: function () {
                dialogController.openDialog('new-version-dialog');
            },
            closeDialog: function () {
                document.getElementById('confirm-new-version-button').removeAttribute('disabled');
                dialogController.closeDialog('new-version-dialog');
            }
        }
        var deleteView = {
            init: function () {
                document.getElementById('open-delete-dialog').addEventListener('click', (e) => {
                    e.preventDefault();
                    policiesRepositoryController.handleOpenDelete();
                });
                document.getElementById('close-delete-dialog').addEventListener('click', (e) => {
                    e.preventDefault();
                    dialogController.closeDialog('delete-dialog');
                });
                document.getElementById('cancel-delete').addEventListener('click', (e) => {
                    e.preventDefault();
                    dialogController.closeDialog('delete-dialog');
                });
                document.getElementById('confirm-delete-button').addEventListener('click', (e) => {
                    e.preventDefault();
                    policiesRepositoryController.handleDeleteItem();
                })
            },
            openDialog: function () {
                dialogController.openDialog('delete-dialog');
            },
            closeDialog: function () {
                dialogController.closeDialog('delete-dialog');
            }
        }
        // diálogo de deletar políticas dentro de um repositório.
        var deleteRegisterView = {
            init: function () {
                document.getElementById('close-delete-register-dialog').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.closeDialog();
                });
                document.getElementById('cancel-delete-register').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.closeDialog();
                });
                document.getElementById('confirm-delete-register-button').addEventListener('click', (e) => {
                    e.preventDefault();
                    const method = e.target.getAttribute('data-register-method');
                    policiesRepositoryController[method](e.target.getAttribute('data-register-index'));
                })
            },
            openDialog: function (id, method) {
                document.getElementById('confirm-delete-register-button').setAttribute('data-register-index', id);
                document.getElementById('confirm-delete-register-button').setAttribute('data-register-method', method);
                dialogController.openDialog('delete-register-dialog');
            },
            closeDialog: function () {
                dialogController.closeDialog('delete-register-dialog');
            }
        }

        // diálogo para deleter registros dentro de repositósios
        var deleteConditionView = {
            init: function () {
                document.getElementById('close-delete-condition-dialog').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.closeDialog();
                });
                document.getElementById('cancel-delete-condition').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.closeDialog();
                });
                document.getElementById('confirm-delete-condition-button').addEventListener('click', (e) => {
                    e.preventDefault();
                    const scenary_index = e.target.getAttribute('data-scenary-index');
                    const condition_index = e.target.getAttribute('data-condition-index');
                    policiesRepositoryController.handleDeleteCondition(scenary_index, condition_index);
                })
            },
            openDialog: function (scenary_index, condition_index) {
                document.getElementById('confirm-delete-condition-button').setAttribute('data-scenary-index', scenary_index);
                document.getElementById('confirm-delete-condition-button').setAttribute('data-condition-index', condition_index);
                dialogController.openDialog('delete-condition-dialog');
            },
            closeDialog: function () {
                dialogController.closeDialog('delete-condition-dialog');
            }
        }

        document.addEventListener("DOMContentLoaded", function (event) {
            policiesRepositoryController.init();
        });
    </script>
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="FooterContent" runat="server">
</asp:Content>
