﻿<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/AdmMaster.Master" CodeBehind="Processos.aspx.vb" Inherits="WebFoundations.WFWorkflow.UI.Processos" %>

<%@ Register Src="~/WFControls/WFPagePicker.ascx" TagName="WFPagePicker" TagPrefix="uc1" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register TagPrefix="wff" Namespace="WebFoundations.ServerControls" Assembly="WebFoundations.ServerControls" %>

<asp:Content ContentPlaceHolderID="TagHead" runat="server">
    <script type="text/javascript">
        var MySelectedItem = '';
        function postBackDelete(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = 'DELETE' + MySelectedItem;
                MySelectedItem = '';
                __doPostBack(hiddenFieldID, '');
            }
        }
        function postBackHiddenField(hiddenFieldID) {
            var hiddenField = $get(hiddenFieldID);
            if (hiddenField) {
                hiddenField.value = (new Date()).getTime();
                __doPostBack(hiddenFieldID, '');
            }
        }
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="ActionContent" runat="server">
    <ul class="list-of-actions">
        <li>
            <asp:HyperLink ID="lnkadd" runat="server" CssClass="add" /></li>
        <li>
            <asp:HyperLink ID="lnkpreview" runat="server" CssClass="edit" /></li>
        <li>
            <asp:HyperLink ID="lnkdelete" runat="server" CssClass="delete" /></li>
        <li>
            <asp:HyperLink ID="lnkrefresh" runat="server" CssClass="refresh" /></li>
        <li style="display: none">
            <asp:LinkButton ID="lnkExport" runat="server" CssClass="export" Visible="false" /></li>
        <li>
            <asp:HyperLink ID="lnkdownload" runat="server" CssClass="download" /></li>
        <li>
            <asp:HyperLink ID="lnkupload" runat="server" CssClass="upload" /></li>
        <li>
            <asp:HyperLink ID="lnkRestore" runat="server" CssClass="rewind" /></li>
        <li>
            <asp:HyperLink ID="lnkdocument" runat="server" CssClass="documentacao" /></li>
    </ul>
    <script>
        actionIcons.init();
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="FilterContent" runat="server">
    <div class="fields">
        <uc1:WFPagePicker ID="portalpicker" runat="server" AddSelect="false" ForceCheckEvenForSiteAdmin="true"
            AdminMode="true" AutoSelectLast="true" ShowArea="true" ShowPage="false" NoLabels="false" />
        <div>
            <asp:Label ID="lblName" runat="server" />
            <asp:TextBox ID="txtName" runat="server" />
        </div>
    </div>
    <asp:Button ID="btnbuscar" runat="server" ValidationGroup="SEARCH" CssClass="search" />
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <asp:UpdatePanel ID="updateform" runat="server">
        <ContentTemplate>
            <telerik:RadGrid ID="grdProcesso" runat="server" AutoGenerateColumns="false" AllowSorting="True"
                GridLines="None" AllowPaging="True" PageSize="15">
                <MasterTableView>
                    <Columns>
                        <telerik:GridTemplateColumn HeaderText="" UniqueName="PUBLISHED" HeaderStyle-Width="40px" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" ItemStyle-VerticalAlign="middle">
                            <ItemTemplate>
                                <div style="float: left;">
                                    <asp:Image ID="imgPublished" runat="server" />
                                </div>
                                <div style="float: left;">
                                    <asp:Image ID="imgManagersNotConfigured" runat="server" Visible="false" />
                                </div>
                                <div style="float: left; padding-left: 4px;">
                                    <asp:Image ID="imgEdicao" ImageUrl="~/WFResources/process/images/maintenance.png" runat="server" />
                                </div>
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridBoundColumn DataField="Id" HeaderText="Id" UniqueName="Id" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" ItemStyle-VerticalAlign="middle" />
                        <telerik:GridBoundColumn DataField="Nome" HeaderText="Nome" UniqueName="Nome" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" ItemStyle-VerticalAlign="middle" />
                        <telerik:GridBoundColumn DataField="Ativo" HeaderText="Ativo" UniqueName="Ativo" Visible="false" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" ItemStyle-VerticalAlign="middle" />
                        <telerik:GridBoundColumn DataField="Ativacao" HeaderText="Ultima Ativacao" UniqueName="Ativacao" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" ItemStyle-VerticalAlign="middle" />
                        <telerik:GridBoundColumn DataField="Alteracao" HeaderText="Alteracao" UniqueName="Alteracao" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" ItemStyle-VerticalAlign="middle" />
                        <telerik:GridBoundColumn DataField="LastEditor" HeaderText="Ultimo Alterador" UniqueName="UsuAlterador" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" ItemStyle-VerticalAlign="middle" />
                        <telerik:GridBoundColumn DataField="Managers" HeaderText="Gestores" UniqueName="Gestores" HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="center" ItemStyle-VerticalAlign="middle" />
                    </Columns>
                </MasterTableView>
                <ClientSettings AllowColumnsReorder="false" AllowDragToGroup="false"
                    AllowColumnHide="false"
                    Selecting-AllowRowSelect="true" Scrolling-AllowScroll="false"
                    Scrolling-UseStaticHeaders="true">
                </ClientSettings>
                <ExportSettings ExportOnlyData="True" FileName="Pages" IgnorePaging="True" OpenInNewWindow="True" />
            </telerik:RadGrid>
            <asp:HiddenField ID="PostBackHidden" runat="server" />
            <asp:HiddenField ID="SelectedAreaId" runat="server" />
        </ContentTemplate>
        <Triggers>
            <asp:AsyncPostBackTrigger ControlID="ctl00$FilterContent$btnbuscar" EventName="Click" />
            <asp:AsyncPostBackTrigger ControlID="PostBackHidden" EventName="ValueChanged" />
        </Triggers>
    </asp:UpdatePanel>
    <wff:WindowManager ID="EditWindow" runat="server" DestroyOnClose="true" ReloadOnShow="false" Modal="true">
        <windows>
            <telerik:RadWindow ID="ImportDialog" runat="server" Height="480px" Width="800px" />
            <telerik:RadWindow ID="ExportDialog" runat="server" Height="450px" Width="800px" />
            <telerik:RadWindow ID="DocumentDialog" runat="server" Height="600px" Width="900px" />
        </windows>
    </wff:WindowManager>
</asp:Content>
