﻿<%@ Page Title="" Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/ModalAdminPage.master" CodeBehind="policies.aspx.vb" Inherits="WebFoundations.WFWorkflow.Modules.UI.policies" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TagHead" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <input id="policyAliasWrongFormat" type="hidden" name="policyAliasWrongFormat" data-render="policyAliasWrongFormat" value="O formato deve corresponder ao de uma variável de contexto %% - %%" runat="server" />
    <asp:Button ID="finalsubmit" Text="" data-render="finalsubmit" runat="server" CssClass="d-none" />
    <h1>
        <asp:Literal Text="Configurações - Módulo Política" runat="server" />
    </h1>
    <div class="module-config-form mt-2">
        <fieldset id="form-container">
        </fieldset>
    </div>
    <div id="change-policy-repository-dialog" class="wf-dialog">
        <div class="dialog-header">
            <a id="close-change-policy-repository-dialog" href="#">
                <i data-feather="x"></i>
            </a>
        </div>
        <div class="dialog-body">
            <h2>
                <asp:Literal Text="Ao alterar o repositório de políticas os parâmetros já preenchidos serão perdidos." runat="server" />
            </h2>
            <h2>
                <asp:Literal Text="Deseja continuar?" runat="server" />
            </h2>
        </div>
        <div class="dialog-footer">
            <button class="secondary" id="cancel-change-policy-repository">
                <asp:Literal Text="Não" runat="server" />
            </button>
            <button id="confirm-change-policy-repository-button">
                <asp:Literal Text="Sim" runat="server" />
            </button>
        </div>
    </div>
    <template id="loading-template">
        <div class="loader-container show">
            <i data-feather="loader"></i>
            <span>
                <asp:Literal Text="Carregando dados..." runat="server" />
            </span>
        </div>
    </template>
    <template id="form-template">
        <div class="main-form">
            <div>
                <label class="labelItem bold" for="select-policy">
                    <asp:Literal Text="Repositório de políticas" runat="server" />
                    *
                </label>
                <select required data-render="repositories-select" name="PolicyRepositoryId">
                    <option selected disabled value="">
                        <asp:Literal Text="Selecione seu repositório de Políticas" runat="server" />
                    </option>
                </select>
            </div>
            <div class="adaptative-form">
            </div>
        </div>
        <div class="d-flex align-center justify-center">
            <button data-render="cancel-button" class="secondary mr-2">
                <i class="mr-half" data-feather="x-circle"></i>
                <asp:Literal Text="Cancelar" runat="server" />
            </button>
            <button data-render="submit-button">
                <i class="mr-half" data-feather="save"></i>
                <asp:Literal Text="Salvar configuração" runat="server" />
            </button>
        </div>
    </template>
    <template id="adaptative-form-template">
        <div class="d-flex align-center mb-2">
            <label class="switch mr-1">
                <input id="dynamicallyAssigned" name="dynamicallyAssigned" type="checkbox">
                <span class="slider round"></span>
            </label>
            <label class="labelItem bold" for="dynamicallyAssigned">
                <asp:Literal Text="Habilitar atribuição dinâmica de políticas do mesmo repositório" runat="server" />
                <span class="tooltip-container">
                    <i data-feather="info"></i>
                    <span class="tooltip-body big centered">
                        <asp:Literal Text="Com esta opção habilitada você deve fornecer uma variável de contexto para que o Zuri defina qual das políticas deste repositório será executada." runat="server" />
                    </span>
                </span>
            </label>
        </div>
        <div class="politica-config-container mb-2"></div>
        <h5 class="bold uppercased">
            <asp:Literal Text="preencha abaixo os parâmetros relacionados a este repositório de políticas" runat="server" />
            <span class="tooltip-container">
                <i data-feather="info"></i>
                <span class="tooltip-body bottom left-bottom solid listed bigger">
                    <ul>
                        <li>
                            <asp:Literal Text="Caso não passe valor para algum dos parâmetros será adotado o valor padrão utilizado  neste parâmetro no repositório de regras;" runat="server" />
                        </li>
                        <li>
                            <asp:Literal Text="Caso não exista um valor padrão configurado para um parâmetro que não receber nenhum valor, a saída escolhida para política será a de nenhuma condição satisfeita
"
                                runat="server" />
                        </li>
                    </ul>
                </span>
            </span>
        </h5>
        <div class="parameter-config-container mt-2"></div>
    </template>
    <template id="politica-select-template">
        <label class="labelItem bold" for="select-policy">
            <asp:Literal Text="Selecione uma política para ser executada neste ponto do fluxo" runat="server" />
            *
        </label>
        <select required data-render="politicas-select" name="PolicyAlias">
            <option selected disabled value="">
                <asp:Literal Text="Selecione a política" runat="server" />
            </option>
        </select>
    </template>
    <template id="politica-context-variable-template">
        <label class="labelItem bold" for="select-policy">
            <asp:Literal Text="Fonte que determina qual política será utilizada" runat="server" />
            *
        </label>
        <div id="select-politica-context" class="input-with-search">
            <input autocomplete="off" placeholder="Selecione ou digite um valor (Variáveis de contexto)" required class="text-search-input" data-render="search-input-text" type="text" name="PolicyAlias" />
            <div class="options">
            </div>
        </div>
    </template>
    <template id="context-variable-option-template">
        <div class="option">
            <img alt="Context variable image" />
            <span></span>
        </div>
    </template>
    <template id="parameter-template">
        <label class="labelItem" for="select-policy">
        </label>
        <div id="" class="input-with-search">
            <input autocomplete="off" placeholder="Selecione ou digite um valor" autocomplete="off" class="text-search-input" data-render="search-input-text" type="text" />
            <div class="options">
            </div>
        </div>
    </template>
    <script>
        const policyConfigModel = {
            init: function () {
                this.loading = true;
                this.loadingAdaptativeForm = false;
                this.policyRepositories = [];
                this.ruleParams = [];
                this.currentParams = [];
                this.token = null;
                this.searchParams = {
                    ITEMID: null,
                    PARTID: null,
                    PROCID: null
                };
                this.contextValues = [];
                this.selectedPolicyRepository = null;
                this.selectedRuleRepository = null;
                this.dynamicallyAssigned = false;
                this.policyAlias = '';
            },
            setLoading: function (loading) {
                this.loading = loading;
            },
            getLoading: function () {
                return this.loading;
            },
            setPolicyAlias: function (policyAlias) {
                this.policyAlias = policyAlias;
            },
            getPolicyAlias: function () {
                return this.policyAlias;
            },
            setCurrentParams: function (currentParams) {
                this.currentParams = currentParams
            },
            getCurrentParams: function () {
                return this.currentParams
            },
            setLoadingAdaptativeForm: function (loading) {
                this.loadingAdaptativeForm = loading;
            },
            getLoadingAdaptativeForm: function () {
                return this.loadingAdaptativeForm;
            },
            setPolicyRepositories: function (policyRepositories) {
                this.policyRepositories = policyRepositories;
            },
            getPolicyRepositories: function () {
                return this.policyRepositories;
            },
            setToken: function (token) {
                this.token = token;
            },
            getToken: function () {
                return this.token;
            },
            setSearchParams: function (searchParams) {
                this.searchParams = searchParams;
            },
            getItemid: function () {
                return this.searchParams.ITEMID;
            },
            getPartId: function () {
                return this.searchParams.PARTID;
            },
            getProcId: function () {
                return this.searchParams.PROCID;
            },
            setRuleParams: function (params) {
                this.ruleParams = params;
            },
            getRuleParams: function () {
                return this.ruleParams;
            },
            setContextValues: function (values) {
                this.contextValues = values;
            },
            getContextValues: function () {
                return this.contextValues;
            },
            setSelectedRepository: function (id) {
                this.selectedPolicyRepository = this.policyRepositories.find(el => el.Id == id) ?? null;
            },
            getSelectedRepository: function () {
                return this.selectedPolicyRepository;
            },
            setDynamicallyAssigned: function (dynamicallyAssigned) {
                this.dynamicallyAssigned = dynamicallyAssigned
            },
            getDynamicallyAssigned: function () {
                return this.dynamicallyAssigned
            }
        }
        const policyConfigController = {
            init: function () {
                policyConfigModel.init();
                policyConfigView.init();
                this.getSearchParams()
                Api.get('/CA834727-8779-40C8-827B-717FDB87D652', null, 'text/plain').then(resp => {
                    policyConfigModel.setToken(resp);
                    this.fetchAreaFromProcess()
                        .then(area => {
                            this.encriptNumber(area)
                                .then(encAreaId => {
                                    const fetchPromises = [];
                                    fetchPromises.push(this.fetchPolicyRepositories(encAreaId));
                                    fetchPromises.push(this.fetchContextValues());
                                    fetchPromises.push(this.fetchCurrentItem());
                                    Promise.all(fetchPromises).then(values => {
                                        policyConfigModel.setLoading(false);
                                        policyConfigView.render();
                                        if (values[2]) {
                                            policyConfigModel.setCurrentParams(values[2].ParameterValues);
                                            policyConfigModel.setPolicyAlias(values[2].PolicyAlias);
                                            policyConfigModel.setDynamicallyAssigned(values[2].DynamicallyAssigned);
                                            this.setSelectedRepository(values[2].PolicyRepositoryId);
                                        }
                                    });
                                })
                        })
                });
                changeRepositoryDialogView.init();
            },
            onSubmitEvent: function (e) {
                e.preventDefault();
                if (document.querySelector('form').reportValidity()) {
                    const itemId = policyConfigModel.getItemid();
                    const token = policyConfigModel.getToken();
                    const ruleParams = policyConfigModel.getRuleParams();
                    const dynamicallyAssigned = policyConfigModel.getDynamicallyAssigned();
                    const policyAlias = policyConfigModel.getPolicyAlias();


                    // valida formato do policy alias no caso de uma atribuição dinamica
                    const policyAliasInput = document.querySelector('input[name="PolicyAlias"]');
                    if (dynamicallyAssigned && (policyAlias.match(/^%%.*%%$/) != policyAlias)) {
                        policyAliasInput.setCustomValidity(document.querySelector('input[data-render="policyAliasWrongFormat"]').value);
                        policyAliasInput.reportValidity();
                        return;
                    }

                    //desabilita o formulário
                    document.querySelector('fieldset#form-container').setAttribute('disabled', '');

                    const toSend = {
                        PolicyRepositoryId: policyConfigModel.getSelectedRepository().Id,
                        PolicyAlias: policyAlias,
                        Params: [],
                    }

                    // monta o array de parametros
                    for (i = 0; i < ruleParams.length; i++) {
                        const inputValue = document.querySelector(`input[name="Params[${i}][DefaultValue]"]`)?.getAttribute('data-value');
                        const ruleParam = ruleParams[i];
                        toSend.Params.push({
                            name: ruleParam.Name,
                            defaultValue: inputValue ?? ruleParam.DefaultValue
                        });
                    }
                    Api.post(`/policymodule/${itemId}`, toSend, `Bearer ${token}`)
                        .finally(() => {
                            document.querySelector('fieldset#form-container').removeAttribute('disabled');
                            document.querySelector('input[data-render="finalsubmit"]').click();
                        })
                }
            },
            fetchAreaFromProcess: function () {
                const token = policyConfigModel.getToken();
                const procEncId = policyConfigModel.getProcId();
                return Api.get(`/policymodule/${procEncId}/area`, `Bearer ${token}`)
            },
            fetchPolicyRepositories: function (area) {
                const token = policyConfigModel.getToken();
                return Api.get(`/policyrepository/published?areaId=${area}&orderbyFieldName&orderAscending=&title`, `Bearer ${token}`)
                    .then(repositories => {
                        policyConfigModel.setPolicyRepositories(repositories);
                    });
            },
            fetchRuleParams: function () {
                const token = policyConfigModel.getToken();
                const selectedPolicy = policyConfigModel.getSelectedRepository();
                return Api.get(`/policymodule/${selectedPolicy.EncId}/params`, `Bearer ${token}`)
                    .then(ruleParams => {
                        policyConfigModel.setRuleParams(ruleParams);
                    })
            },
            fetchContextValues: function () {
                const token = policyConfigModel.getToken();
                const procEncId = policyConfigModel.getProcId();
                return Api.get(`/policymodule/${procEncId}/context`, `Bearer ${token}`)
                    .then(values => {
                        policyConfigModel.setContextValues(values);
                    })
            },
            fetchCurrentItem: function () {
                return new Promise((resolve, reject) => {
                    const itemId = policyConfigModel.getItemid();
                    const token = policyConfigModel.getToken();
                    Api.get(`/policymodule/${itemId}`, `Bearer ${token}`)
                        .then(currentItem => {
                            resolve(currentItem);
                        })
                        .catch(_ => {
                            resolve(null);
                        })
                })
            },
            encriptNumber: function (number) {
                const token = policyConfigModel.getToken();
                return Api.get(`/util/encnumber/${number}`, `Bearer ${token}`);
            },
            getLoading: function () {
                return policyConfigModel.getLoading();
            },
            getPolicyRepositories: function () {
                return policyConfigModel.getPolicyRepositories();
            },
            getSearchParams: function () {
                const urlsearchparams = new URLSearchParams(window.location.search);
                const searchParams = {};
                for (let p of urlsearchparams) {
                    searchParams[p[0]] = p[1];
                }
                policyConfigModel.setSearchParams(searchParams);
            },
            setSelectedRepository: function (id) {
                policyConfigModel.setSelectedRepository(id);
                policyConfigView.updatePolicyRepositoriesSelect(id);
                policyConfigModel.setLoadingAdaptativeForm(true);
                policyConfigView.renderAdaptativeForm();
                this.fetchRuleParams()
                    .then(_ => {
                        policyConfigModel.setLoadingAdaptativeForm(false);
                        policyConfigView.renderAdaptativeForm();
                    })
            },
            setDynamicallyAssigned: function (dinamycAssigned) {
                policyConfigModel.setDynamicallyAssigned(dinamycAssigned);
                policyConfigModel.setPolicyAlias('');
                dinamycAssigned ? policyConfigView.renderPolicyContextVariable() : policyConfigView.renderPolicySelect();
            },
            cleanCurrentParams: function () {
                policyConfigModel.setCurrentParams([]);
            },
            getSelectedRepository: function () {
                return policyConfigModel.getSelectedRepository();
            },
            getDynamicallyAssigned: function () {
                return policyConfigModel.getDynamicallyAssigned();
            },
            getContextValues: function () {
                return policyConfigModel.getContextValues();
            },
            getLoadingAdaptativeForm: function () {
                return policyConfigModel.getLoadingAdaptativeForm();
            },
            getRuleParams: function () {
                return policyConfigModel.getRuleParams();
            },
            setPolicyAlias: function (setPolicyAlias) {
                policyConfigModel.setPolicyAlias(setPolicyAlias);
            },
            getPolicyAlias: function () {
                return policyConfigModel.getPolicyAlias();
            },
            getCurrentParamFromName: function (name) {
                return policyConfigModel.getCurrentParams()[name];
            },
            getContextVariableFromValue: function (value) {
                return policyConfigModel.getContextValues().find(el => el.Value == value);
            }
        }
        const policyConfigView = {
            init: function () {
                this.addClassToBody();
                this.render();
            },
            addClassToBody: function () {
                document.querySelector('body').classList.add('full-height');
            },
            render: function () {
                const loading = policyConfigController.getLoading();
                const container = document.getElementById('form-container');
                container.innerHTML = '';
                if (loading) {
                    const loadingtemplate = document.importNode(document.getElementById('loading-template').content, true);
                    container.appendChild(loadingtemplate);
                } else {
                    const formTemplate = document.importNode(document.getElementById('form-template').content, true);
                    formTemplate.querySelector('button[data-render="submit-button"]').addEventListener('click', policyConfigController.onSubmitEvent);
                    formTemplate.querySelector('button[data-render="cancel-button"]').addEventListener('click', e => {
                        e.preventDefault();
                        window.close(``, `_parent`, ``);
                    })
                    container.appendChild(formTemplate);
                    this.renderPolicyRepositoriesSelect();
                    this.renderAdaptativeForm();
                }
                feather.replace();
            },
            renderPolicyRepositoriesSelect: function () {
                const policyRepositories = policyConfigController.getPolicyRepositories();
                const selectedPolicy = policyConfigController.getSelectedRepository();
                const repositoriesSelect = document.querySelector('select[data-render="repositories-select"]');
                policyRepositories.forEach(repository => {
                    const option = document.createElement('option');
                    option.value = repository.Id;
                    option.innerText = repository.DisplayName;
                    repositoriesSelect.appendChild(option);
                });
                repositoriesSelect.value = selectedPolicy ? selectedPolicy.EncId : '';
                repositoriesSelect.addEventListener('input', e => {
                    const selectedRepository = policyConfigController.getSelectedRepository();
                    const editedParam = document.querySelector('input[name*="Param"]:not([data-value=""])');
                    if (!editedParam) {
                        policyConfigController.setSelectedRepository(e.target.value);
                    } else {
                        changeRepositoryDialogView.openDialog(e.target.value);
                        e.target.value = selectedRepository.Id;
                    }
                });
            },
            updatePolicyRepositoriesSelect: function (value) {
                const repositoriesSelect = document.querySelector('select[data-render="repositories-select"]');
                repositoriesSelect.value = value;
            },
            renderAdaptativeForm: function () {
                const container = document.querySelector('.adaptative-form');
                container.innerHTML = '';
                const loadingAdaptativeForm = policyConfigController.getLoadingAdaptativeForm();
                const ruleParams = policyConfigController.getRuleParams();
                if (loadingAdaptativeForm) {
                    const loadingtemplate = document.importNode(document.getElementById('loading-template').content, true);
                    container.appendChild(loadingtemplate);
                } else if (ruleParams.length > 0) {
                    const selectedPolicy = policyConfigController.getSelectedRepository();
                    const dynamicallyAssigned = policyConfigController.getDynamicallyAssigned();
                    const adaptativeFormTemplate = document.importNode(document.getElementById('adaptative-form-template').content, true);
                    if (selectedPolicy) {
                        adaptativeFormTemplate.querySelector('input#dynamicallyAssigned').addEventListener('input', e => {
                            policyConfigController.setDynamicallyAssigned(e.target.checked);
                        });
                        adaptativeFormTemplate.querySelector('input#dynamicallyAssigned').checked = dynamicallyAssigned;
                        container.appendChild(adaptativeFormTemplate);
                        dynamicallyAssigned ? this.renderPolicyContextVariable() : this.renderPolicySelect();
                        this.renderParameters(ruleParams);
                    }
                }
                feather.replace();
            },
            renderPolicySelect: function () {
                const policyRepository = policyConfigController.getSelectedRepository();
                const policyAlias = policyConfigController.getPolicyAlias();
                const container = document.querySelector('.politica-config-container');
                container.innerHTML = '';
                const politicaSelectTemplate = document.importNode(document.getElementById('politica-select-template').content, true);
                const select = politicaSelectTemplate.querySelector('select');
                policyRepository.Policies?.forEach(policy => {
                    const option = document.createElement('option');
                    option.value = policy.Alias;
                    option.innerText = policy.Name;
                    select.appendChild(option);
                })
                select.addEventListener('input', e => {
                    policyConfigController.setPolicyAlias(e.target.value);
                })
                if (policyAlias) select.value = policyAlias;
                container.appendChild(politicaSelectTemplate);
            },
            renderPolicyContextVariable: function () {
                const container = document.querySelector('.politica-config-container');
                const policyAlias = policyConfigController.getPolicyAlias();
                container.innerHTML = '';

                const contextVariables = policyConfigController.getContextValues();

                const politicaSearchContext = document.importNode(document.getElementById('politica-context-variable-template').content, true);
                const optionsContainer = politicaSearchContext.querySelector('.options');
                //tira a possibilidade de submit através do input de texto
                politicaSearchContext.querySelector('input').addEventListener('keydown', this.preventSubmit);

                contextVariables.forEach(variable => {
                    const optionTemplate = document.importNode(document.getElementById('context-variable-option-template').content, true);
                    const option = optionTemplate.querySelector('.option');
                    option.setAttribute('data-value', variable.Value);
                    option.setAttribute('data-text', variable.DropDownText);
                    optionTemplate.querySelector('img').setAttribute('src', `/WFContent/WFWorkflow/${variable.ImageURL}`);
                    optionTemplate.querySelector('span').innerText = variable.DropDownText;
                    optionsContainer.appendChild(optionTemplate);
                })
                container.appendChild(politicaSearchContext);

                specialInputs.inputWithSearch.init('select-politica-context', (value) => {
                    policyConfigController.setPolicyAlias(value);
                    document.querySelector('input[name="PolicyAlias"]').setCustomValidity('');
                });

                if (policyAlias) {
                    const currentParam = policyConfigController.getContextVariableFromValue(policyAlias);
                    currentParam ? specialInputs.setValue('select-politica-context', currentParam.Value, currentParam.DropDownText) : specialInputs.setValue('select-politica-context', policyAlias, policyAlias);
                }
            },
            renderParameters: function (ruleParams) {
                const container = document.querySelector('.parameter-config-container');
                container.innerHTML = '';
                ruleParams.forEach((parameter, index) => {
                    this.renderParameter(index, container, parameter);
                })
            },
            renderParameter: function (index, container, parameter) {
                const parameterTemplate = document.importNode(document.getElementById('parameter-template').content, true);
                parameterTemplate.querySelector('.labelItem').innerText = `${parameter.Name}${parameter.DefaultValue === null ? '*' : ''}`
                const searchInputId = `params-${index}`;
                const searchContainer = parameterTemplate.querySelector('.input-with-search');
                searchContainer.setAttribute('id', searchInputId);
                const searchInput = searchContainer.querySelector('input[data-render="search-input-text"]');

                searchInput.setAttribute('name', `Params[${index}][DefaultValue]`);
                searchInput.addEventListener('keydown', this.preventSubmit);

                if (parameter.DefaultValue === null) searchInput.setAttribute('required', '');

                const optionsContainer = parameterTemplate.querySelector('.options');
                const contextVariables = policyConfigController.getContextValues();
                contextVariables.forEach(variable => {
                    const optionTemplate = document.importNode(document.getElementById('context-variable-option-template').content, true);
                    const option = optionTemplate.querySelector('.option');
                    option.setAttribute('data-value', variable.Value);
                    option.setAttribute('data-text', variable.DropDownText);
                    optionTemplate.querySelector('img').setAttribute('src', `/WFContent/WFWorkflow/${variable.ImageURL}`);
                    optionTemplate.querySelector('span').innerText = variable.DropDownText;
                    optionsContainer.appendChild(optionTemplate);
                })
                container.appendChild(parameterTemplate);

                specialInputs.inputWithSearch.init(searchInputId, (_) => { })

                const currentParam = policyConfigController.getCurrentParamFromName(parameter.Name);
                if (currentParam) {
                    const currentContextVariable = policyConfigController.getContextVariableFromValue(currentParam);
                    if (currentContextVariable) {
                        specialInputs.setValue(searchInputId, currentParam, currentContextVariable.DropDownText);
                    } else {
                        specialInputs.setValue(searchInputId, currentParam, currentParam);

                    }
                } else {
                    specialInputs.setValue(searchInputId, '', '');
                }
            },
            preventSubmit: function (e) {
                if (e.key == "Enter" || e.keyCode == 13) {
                    e.preventDefault();
                }
            }
        }

        var changeRepositoryDialogView = {
            init: function () {
                document.getElementById('close-change-policy-repository-dialog').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.closeDialog();
                });
                document.getElementById('cancel-change-policy-repository').addEventListener('click', (e) => {
                    e.preventDefault();
                    this.closeDialog();
                });
                document.getElementById('confirm-change-policy-repository-button').addEventListener('click', (e) => {
                    e.preventDefault();
                    const selectedRepositoryId = e.target.getAttribute('data-id');
                    policyConfigController.cleanCurrentParams();
                    policyConfigController.setSelectedRepository(selectedRepositoryId);
                    this.closeDialog();
                })
            },
            openDialog: function (id) {
                document.getElementById('confirm-change-policy-repository-button').setAttribute('data-id', id);
                dialogController.openDialog('change-policy-repository-dialog');
            },
            closeDialog: function () {
                dialogController.closeDialog('change-policy-repository-dialog');
            }
        }
        document.addEventListener("DOMContentLoaded", function (event) {
            policyConfigController.init();
        });
    </script>
</asp:Content>
