﻿<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/ModalAdminPage.master" CodeBehind="WebService.aspx.vb" Inherits="WebFoundations.WFWorkflow.Modules.UI.WebService1" %>

<%@ Register TagPrefix="wff" Namespace="WebFoundations.WFWorkflow.Services.UI" Assembly="WebFoundations.WFWorkflow.Services" %>
<%@ Register Assembly="WebFoundations.ServerControls" Namespace="WebFoundations.ServerControls" TagPrefix="wff" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register Src="~/WFAdmin/WFWorkflow/Components/OutputsByStatusCode.ascx" TagPrefix="wf" TagName="OutputsByStatusCode" %>
<asp:Content ContentPlaceHolderID="TagHead" runat="server">
    <style>
        .user-agent-config {
            margin-bottom: 0 !important;
        }

            .user-agent-config input {
                margin-bottom: 0 !important;
            }

        .no-border:read-only {
            border: none !important;
        }

        table:not(.reLayoutWrapper) tbody > tr:nth-child(2n) .no-border:read-only {
            background: #ededed;
        }
    </style>
    <script type="text/javascript">
        $(document).ready(function () {
            var attchk = $(".rest-responsetype").find('input[type=checkbox]');
            var checkResponseType = function () {
                if (attchk.is(":checked")) {
                    $(".attach-info").show();
                } else {
                    $(".attach-info").hide();
                }
            };
            attchk.change(function () { checkResponseType(); });

            checkResponseType();
        });
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <h1>
        <asp:Label Text="" ID="lblModuleName" runat="server" /></h1>
    <div class="fields no-columns mod-soap-config">
        <label class="name">
            <asp:Label ID="lblnome" runat="server" />
            <asp:TextBox ID="txtnome" runat="server" MaxLength="50" />
            <asp:RequiredFieldValidator ID="rfvName" runat="server" Display="Dynamic" ControlToValidate="txtnome" />
        </label>
        <label class="soap-url">
            <asp:Label ID="lblUrl" runat="server" />
            <asp:TextBox ID="txtUrl" ValidationGroup="tstEndPoint" runat="server" MaxLength="300" />
            <asp:RequiredFieldValidator ID="rfvUrl" runat="server" ValidationGroup="tstEndPoint" Display="Dynamic" ControlToValidate="txtUrl" />
            <asp:RegularExpressionValidator ID="rexUrl" runat="server" ControlToValidate="txtUrl" Display="Dynamic" ValidationGroup="tstEndPoint"
                ValidationExpression="(http|https|HTTP|HTTPS):\/\/[a-zA-Z0-9\/\.\-\:_]*\.?(asmx|ASMX|wso|WSO|svc|SVC)*\??(wsdl|WSDL)?" />
            <asp:Panel ID="pnlUpload" runat="server">
                <asp:Label ID="lblWSDL" runat="server" />
                <asp:ImageButton ID="btnExcluir" CssClass="deleteFile" Width="20px" ImageUrl="~/WFResources/FormsWeb/Images/deletefile.png" runat="server" />
                <div style="margin-top:5px;">
                    <telerik:RadAsyncUpload ID="wsdlUpload" OnClientFileUploaded="" UploadedFilesRendering="BelowFileInput"
                        MaxFileInputsCount="1" PersistConfiguration="True" runat="server" />
                </div>
            </asp:Panel>
        </label>
        <fieldset id="fldAutenticacao" class="soap-auth">
            <legend>
                <asp:Label ID="lblAutenticacaoWS" runat="server" /></legend>
            <asp:RadioButtonList ID="rdlTipoAutenticacao" runat="server" RepeatLayout="UnorderedList" AutoPostBack="true">
                <asp:ListItem Value="0" Selected="true"></asp:ListItem>
                <asp:ListItem Value="1"></asp:ListItem>
                <asp:ListItem Value="2"></asp:ListItem>
                <asp:ListItem Value="3"></asp:ListItem>
            </asp:RadioButtonList>
            <asp:Panel ID="pnlAuthentication" runat="server" Visible="false">
                <asp:Label ID="lblAutenticacaoUsuario" runat="server" Style="float: left !important;" Width="60px" />
                <asp:RequiredFieldValidator ID="rfvUsuario" runat="server" ValidationGroup="tstEndPoint" Display="Dynamic" ControlToValidate="txtUsuario" Text="*" />
                <asp:TextBox ID="txtUsuario" runat="server" MaxLength="50" ClientIDMode="Static" AutoCompleteType="None" />
                <asp:Label ID="lblAutenticacaoSenha" runat="server" />
                <asp:RequiredFieldValidator ID="rfvSenha" runat="server" ValidationGroup="tstEndPoint" Display="Dynamic" ControlToValidate="txtSenha" Text="*" />
                <asp:TextBox ID="txtSenha" runat="server" MaxLength="20" ClientIDMode="Static" AutoCompleteType="None" />
            </asp:Panel>
        </fieldset>
        <div style="margin-bottom: 5px; display: flex; flex-wrap: wrap; align-items: center;" runat="server">
            <label class="switch" style="display: inline-block; margin-right: 4px; margin-bottom: 0px;">
                <asp:CheckBox ID="chkUserAgent" runat="server" OnCheckedChanged="chkUserAgent_CheckedChanged" AutoPostBack="true" />
                <span class="slider round"></span>
            </label>
            <asp:Label ID="lblConfigurarUserAgent" runat="server" />

            <asp:Panel ID="pnlUserAgent" runat="server" Visible="false" CssClass="w-100 user-agent-config">
                <asp:Label ID="lblUserAgent" runat="server" />
                <asp:TextBox ID="txtUserAgent" runat="server" MaxLength="100" />
            </asp:Panel>
        </div>
        <asp:Button ID="btnCheckUrl" runat="server" ValidationGroup="tstEndPoint" />
        <label id="trMethods" runat="server" visible="false">
            <asp:Label ID="lblMethodName" runat="server" />
            <asp:DropDownList ID="ddlMethod" AutoPostBack="true" CssClass="" runat="server" />
        </label>
        <asp:Panel ID="pnlToggleXml" runat="server" Visible="False">
            <label class="switch" style="display: inline-block;">
                <asp:CheckBox ID="chkNivelXml" runat="server" OnCheckedChanged="chkNivelXml_CheckedChanged" AutoPostBack="true" />
                <span class="slider round"></span>
            </label>
            <asp:Label ID="lblAlterarNivelXml" runat="server" />

            <asp:Panel ID="pnlNivelXml" runat="server" Visible="False">
                <asp:Label ID="lblNivelXml" runat="server" />
                <asp:TextBox ID="txtNivelXml" runat="server" MaxLength="50" Text="0" />
            </asp:Panel>
        </asp:Panel>
        <asp:PlaceHolder ID="paramsConfig" Visible="false" runat="server">
            <asp:Panel ID="pnlparams" runat="server">
                <table>
                    <thead>
                        <tr>
                            <th>
                                <asp:Label ID="lblParams" runat="server" /></th>
                            <th>
                                <asp:Label ID="lblParamsType" runat="server" /></th>
                            <th>
                                <asp:Label ID="lblRun" runat="server" /></th>
                            <th>
                                <asp:Label ID="lblTest" runat="server" /></th>
                        </tr>
                    </thead>
                    <asp:Repeater ID="rptParams" runat="server">
                        <ItemTemplate>
                            <tr>
                                <td>
                                    <asp:TextBox ID="txtParName" runat="server" Width="300px" CssClass="no-border" ReadOnly="true" />
                                </td>
                                <td>
                                    <asp:Label ID="lblParType" runat="server" Visible="true" /></td>
                                <td>
                                    <wff:zuricontextlist id="ddlParValue" filterproviders="REQUESTINFO;CTXWORKFLOWDATA" dropdownautowidth="enabled" width="100%" pagersize="10" runat="server" />
                                </td>
                                <td>
                                    <asp:TextBox ID="txtParTestValue" runat="server" Width="60px">NULL</asp:TextBox></td>
                            </tr>
                        </ItemTemplate>
                    </asp:Repeater>
                </table>
            </asp:Panel>
            <asp:PlaceHolder ID="phResultConfig" runat="server" Visible="false">
            <fieldset>
                <legend>
                    <asp:Literal ID="litReturn" runat="server" /></legend>
                    <div style="display: grid; width: 100%">
                        <asp:Label ID="lblResult" runat="server" /><br />
                        <asp:TextBox runat="server" ID="txtResult" Height="15em" TextMode="MultiLine" />
                    </div>
            </fieldset>
            </asp:PlaceHolder>
            <asp:Button ID="btnTestWeb" runat="server" />
        </asp:PlaceHolder>
        <asp:PlaceHolder ID="phResult" Visible="false" runat="server">
            <fieldset class="result">
                <legend>
                    <asp:Literal runat="server" ID="litResult" />
                </legend>
                <label class="rest-responsetype">
                    <asp:CheckBox ID="chkaddXML" CssClass="checkbox" runat="server" />
                </label>
                <label class="rest-alias attach-info">
                    <span>
                        <asp:Literal runat="server" ID="litAttAlias" />:
                    </span>
                    <asp:TextBox runat="server" ID="txtAttachmentAlias" CssClass="remain" />
                    <asp:RegularExpressionValidator ID="vlAlias" runat="server" ControlToValidate="txtAttachmentAlias" ValidationExpression="[A-Za-z][A-Za-z0-9_-]*" />
                </label>
                <label>
                    <asp:Button ID="btnDownload" runat="server" />
                </label>
                <wf:outputsbystatuscode runat="server" id="serviceOutputs" />
            </fieldset>
        </asp:PlaceHolder>
    </div>
    <section class="actions">
        <asp:Button ID="btnOk" runat="server" />
        <input id="btnCancel" type="button" value="button" runat="server" />
    </section>
</asp:Content>
