﻿<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/ModalAdminPage.master" CodeBehind="WFForms.aspx.vb" Inherits="WebFoundations.WFForms.WFWorkflow.WFFormsWorkflow" %>

<%@ Register TagPrefix="wff" Namespace="WebFoundations.WFWorkflow.Services.UI" Assembly="WebFoundations.WFWorkflow.Services" %>
<%@ Register Assembly="WebFoundations.ServerControls" Namespace="WebFoundations.ServerControls" TagPrefix="wff" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register TagPrefix="wfhtml" Namespace="WebFoundations.WFWorkflow.Services.UI" Assembly="WebFoundations.WFWorkflow.Services" %>

<asp:Content ContentPlaceHolderID="TagHead" runat="server">
    <script type="text/javascript">
        (function () {
            //função para atualizar a listagem, incluindo o novo formulário
            window.refreshGrid = function () {
                document.location.replace(document.location.href); //atualiza a tela sem adicionar ao history
            }
        })();
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">

    <style>
        .fields:not(.no-columns) {
            white-space: nowrap;
            column-width: 35em !important;
        }

        .arquivoDados table tr {
            height: 45px;
        }
    </style>

    <h1>
        <asp:Label Text="Formulário" ID="lblModuleName" runat="server" />
    </h1>
    <telerik:RadTabStrip RenderMode="Lightweight" runat="server" ID="tbConfig" MultiPageID="configPages" CausesValidation="false" SelectedIndex="0">
        <Tabs>
            <telerik:RadTab Text="Definições"></telerik:RadTab>
            <telerik:RadTab Text="Mensagem"></telerik:RadTab>
        </Tabs>
    </telerik:RadTabStrip>
    <telerik:RadMultiPage runat="server" ID="configPages" SelectedIndex="0">
        <telerik:RadPageView runat="server" ID="Configuracoes">
            <div class="fields arquivoDados">
                <label>
                    <asp:Label ID="lblformname" runat="server" />
                    <asp:DropDownList ID="ddlForm" CssClass="select_geralModulo" runat="server" AutoPostBack="True" />
                    <asp:HyperLink ID="lnkNewForm" CssClass="create-form" runat="server" Text="Criar novo formulário" NavigateUrl="/WFAdmin/WFForms/FormEdit.aspx" Target="form-editor" />
                </label>
                <asp:PlaceHolder ID="pnlDIV" Visible="false" runat="server">
                    <label>
                        <asp:Label ID="lblseldiv" runat="server" />
                        <asp:CheckBoxList ID="cblDIV" CssClass="checkbox" runat="server" RepeatColumns="2" />
                    </label>
                </asp:PlaceHolder>
                <asp:PlaceHolder ID="pnlDIVEdit" Visible="false" runat="server">
                    <label>
                        <asp:Label ID="lblseldisdiv" runat="server" />
                        <asp:CheckBoxList ID="cblDIVEdit" CssClass="checkbox" runat="server" RepeatColumns="2" />
                    </label>
                </asp:PlaceHolder>
                <asp:PlaceHolder ID="pnlDataSource" Visible="false" runat="server">
                    <label>
                        <asp:Label ID="lblDescricao" runat="server" />
                    </label>
                    <asp:Repeater ID="rptContent" runat="server">
                        <HeaderTemplate>
                            <table>
                                <colgroup>
                                    <col width="35%" />
                                    <col width="65%" />
                                </colgroup>
                                <tr>
                                    <th>
                                        <asp:Label ID="lblXmlTitle" runat="server" />
                                    </th>
                                    <th>
                                        <asp:Label ID="lblatividades" runat="server" />
                                    </th>
                                </tr>
                        </HeaderTemplate>
                        <FooterTemplate>
                            </table>
                        </FooterTemplate>
                        <ItemTemplate>
                            <tr>
                                <td>
                                    <asp:Label ID="lblXML" CssClass="txt_normal" runat="server" />
                                </td>
                                <td>
                                    <asp:DropDownList ID="cboAtividade" CssClass="select_geralModulo" runat="server" />
                                </td>
                            </tr>
                        </ItemTemplate>
                    </asp:Repeater>
                </asp:PlaceHolder>
                <label>
                    <span>&nbsp;</span>
                    <asp:CheckBox ID="chkmultiplo" runat="server" CssClass="checkbox" />
                </label>
                <label>
                    <asp:Label ID="lblacesso" runat="server" />
                    <wff:accesslist id="listaacesso" disableitems="-7;-6;-5;-4;-3;-2;" enableuser="true" enablerole="true" enablerolegroup="true" runat="server" />
                </label>
                <label>
                    <asp:Label ID="lblItemId" runat="server" />
                    <wff:zurivaluepicker id="ddlContextValue" showzuriproperties="false" showportalproperties="false" showactivities="false" width="100%" pagersize="10" runat="server" />
                </label>
                <label>
                    <asp:Label ID="lblCodigoAutomatico" runat="server" />
                    <wff:zurivaluepicker id="ddlContextCodigoAutomatico" showzuriproperties="false" showportalproperties="false" showactivities="false" width="100%" pagersize="10" runat="server" />
                </label>
            </div>
        </telerik:RadPageView>
        <telerik:RadPageView runat="server" ID="Mensagem">
            <div class="fields no-columns">
                <label>
                    <asp:CheckBox runat="server" ID="chkShowMsg" />
                </label>

                <label>
                    <asp:Label runat="server" ID="lblStartScreen" />
                    <asp:RadioButtonList runat="server" ID="rdbStartScreen" RepeatDirection="Horizontal" class="unstyled">
                        <asp:ListItem Value="0" Selected="True" />
                        <asp:ListItem Value="1" />
                    </asp:RadioButtonList>
                </label>
                <label>
                    <asp:Label runat="server" ID="lblFirstTab" />
                    <asp:RadioButtonList runat="server" ID="rdbFirstTab" RepeatDirection="Horizontal" class="unstyled">
                        <asp:ListItem Value="0" Selected="True" />
                        <asp:ListItem Value="1" />
                    </asp:RadioButtonList>
                </label>
                <label>
                    <asp:Label runat="server" ID="lblTitleTabForm" />
                    <asp:TextBox runat="server" ID="txtTitleTabForm" />
                    <asp:CheckBox runat="server" ID="chkUseDefaulTitleTabForm" />
                </label>
                <label>
                    <asp:Label runat="server" ID="lblTitleTabMsg" />
                    <asp:TextBox runat="server" ID="txtTitleTabMsg" />
                    <asp:CheckBox runat="server" ID="chkUseDefaulTitleTabMsg" />
                </label>
            </div>
            <wfhtml:zurihtmleditor width="100%" runat="server" id="HTMLContent" />
        </telerik:RadPageView>
    </telerik:RadMultiPage>
    <section class="actions">
        <asp:Button runat="server" ID="btnOK" Text="OK" />
        &nbsp;&nbsp;
        <input id="btncancel" type="button" value="button" runat="server" />
    </section>
</asp:Content>
