﻿<%@ Page Language="vb" AutoEventWireup="false" MasterPageFile="~/WFAdmin/ModalAdminPage.master" CodeBehind="UserCodeConfig.aspx.vb" Inherits="WebFoundations.WFWorkflow.Modules.UI.UserCodeConfig" ValidateRequest="false" %>

<%@ Register TagPrefix="wff" Namespace="WebFoundations.WFWorkflow.Services.UI" Assembly="WebFoundations.WFWorkflow.Services" %>
<%@ Register Src="~/WFAdmin/WFWorkflow/Components/UserCodeParameters.ascx" TagPrefix="wf" TagName="UserCodeParameters" %>

<asp:Content ContentPlaceHolderID="TagHead" runat="server">
    <style>
        body, .sidebar > div {
            background: #eee;
        }

        html, body, form, .wf-admin-modal {
            margin: 0;
            padding: 0;
            height: 100vh;
            font-size: 100%;
        }

        form {
            display: grid;
            grid-template-columns: 1fr auto;
            grid-template-rows: auto 1fr;
            grid-template-areas: "head props" "code props";
        }

        h1 {
            margin: .5rem;
            padding: 0;
        }

        form > div, .aspNetHidden {
            display: none;
        }

        html, body, input, textarea, select, button {
            font-size: 16px;
        }

        .sidebar {
            padding: .5em .5em .5em 0;
            min-width: 20em;
            max-width: 35em;
            grid-area: props;
            display: none;
            grid-template-rows: 1fr auto;
            grid-template-areas: "full" "tabs";
        }

            .sidebar > div {
                grid-area: full;
                display: none;
                overflow-x: hidden;
                overflow-y: auto;
                max-height: 100%;
                margin: 0;
                padding: .5em;
                border: solid 1px #ccc;
            }

            .sidebar > input {
                display: none;
            }

            .sidebar > ul {
                grid-area: tabs;
            }

            .sidebar #cfg:checked ~ .config, .sidebar #param:checked ~ .param {
                display: block;
            }

        ul.tabs {
            list-style: none;
            padding: 0;
            display: flex;
        }

            ul.tabs li {
                padding: .2em .5em;
                cursor: pointer;
            }

        .sidebar #cfg:checked ~ ul .cfg, .sidebar #param:checked ~ ul .param {
            border: solid 1px #ccc;
            background: #ccc;
        }

        main {
            display: none;
            padding: .5em;
            padding-bottom: .5em;
            grid-template-areas: "toolbar" "header" "code" "footer" "output" "status";
            grid-template-rows: auto auto 1fr auto auto auto;
        }

        .no-grid {
            padding: .5rem;
        }

        textarea.source, textarea.source:focus {
            font-family: Consolas, 'Courier New', monospace;
            font-weight: 500;
            resize: none;
            grid-area: code;
            padding-left: 2.4em;
            border: solid 1px #ddd;
            outline: none;
        }


        ul.output {
            grid-area: output;
            margin: .5em 0 0;
            padding: 0;
            list-style: none;
            max-height: 30vh;
            overflow-y: auto;
            overflow-x: hidden;
        }

            ul.output li {
                padding: .2em;
                cursor: default;
                line-height: 1.3em;
            }

                ul.output li:not(.head) {
                    font-family: Consolas, 'Courier New', monospace;
                    white-space: pre-wrap;
                }

                ul.output li[onclick] {
                    cursor: pointer;
                }

                ul.output li:not(.head) + li {
                    border-top: solid 1px #ddd;
                }

                ul.output li:not(.head):hover {
                    background-color: #ddd;
                }

                ul.output li:not(.head), ul.output li:not(.head) span:first-child {
                    background-position: .2em .4em;
                    background-repeat: no-repeat;
                }

                    ul.output li:not(.head) span:first-child {
                        background-position: left center;
                        display: inline-block;
                    }

                ul.output li.error span:first-child, li.head label[for=showError] {
                    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAYAAAA7bUf6AAAAv0lEQVQ4EWNgoDW4p8nACMSiIJoczSFAvBuI3wHxfygN4gcTo1kAiFdANeLCy0Hq8BkCUvD/aajp/wdm/CiaQXyQOJS/DJ8XwAr/ffvy/8fFE3CDQDSIDxJHMigYmyG7kTWAAIh+5CSHwkdy4S5ssfAO2ekwjf9+/cRmAAi/RYk1aDSihAHIBTADQDSIjyWQRajrEqqECdSQYIpjhyrpBCnFLieQYpcBMT+xeWcXNPBggbiLqLyDIxeLkJWLSQUARH5rLhTT9nMAAAAASUVORK5CYII=");
                    text-indent: 1.5em;
                }

                ul.output li.warning span:first-child, li.head label[for=showWarn] {
                    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAYAAAA7bUf6AAAA9UlEQVQ4EWNgGBLg/2YGbiCeA8Rc5BrACMSrgPg/lGYkx5AEqAEwHE+qAcJA/PrKFIb/boYM/69MBRvyGoiFSDFkNsj2U30M/0Hc031w18wi1gBrmBfOT4QYcmESiresCBnABMSnYRpA3gAJX52KYsgpvIEMlAxDDsxbMyGG3J6FYggIh+IygBWI7yArvj8XYsiDuRiG3Aapx2ZIFprC/783MPw/1AGh0eWAOBNbWDxCV3i8B+KSEz1YDXkI0odsiCMWRf9fLmb435cCpJdgNQSEHZANMQbidiDeDMRHgfgsEF+B+v0hlL4CFT8KVQdSbzy4cjsAorAwNXlxaPAAAAAASUVORK5CYII=");
                    text-indent: 1.5em;
                }

                ul.output li.info, li.head label[for=showInfo] {
                    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAYAAAA7bUf6AAAA10lEQVQ4EWNgoAtY8oSTXI3uQLwOiB8B8X8ovQ4sToRmHiCeDdWIC88Cq8NjyHxkDbYbnv9fcf0TmEYzaB4uA3zQbc3e9/r/j9///mcCaSwu8sFmyA50hVLLn/6P2PEKTGMxZDu6AYxA/AabS0AgG7tLXoP1IRkiii0QCRgCwiLoLvlAoiHvUV0CMWgviYbswRawMSQaEo3NEJCXNiAr9Nny4v/RJ9/ANJoB6zG9gjBIBIg3E0ixIHlhQkkf5KJ4ID4GxN+hGr9B+fG4XYDbQBYgVgTTtAYAxF6TKEitcgUAAAAASUVORK5CYII=");
                    text-indent: 1.5em;
                }

            ul.output input[type=checkbox] {
                display: none;
            }

            ul.output li.head {
                display: flex;
                text-transform: lowercase;
                position: sticky;
                top: 0;
                background: #eee;
            }

                ul.output li.head label {
                    background-position: .4em center;
                    background-repeat: no-repeat;
                    margin-right: .5em;
                    border: solid 1px transparent;
                    padding: .2em .5em;
                    cursor: pointer;
                }

                    ul.output li.head label span {
                        margin-right: 0.5em;
                    }

            ul.output #showError:checked ~ li label[for=showError],
            ul.output #showWarn:checked ~ li label[for=showWarn],
            ul.output #showInfo:checked ~ li label[for=showInfo] {
                border-color: inherit;
            }

            ul.output #showError:not(:checked) ~ li.error,
            ul.output #showWarn:not(:checked) ~ li.warning,
            ul.output #showInfo:not(:checked) ~ li.info {
                display: none;
            }

        ul.status {
            grid-area: status;
            display: flex;
            list-style: none;
            padding: .1em;
            white-space: nowrap;
            margin-top: 0.5em;
            color: #fff;
            background: #007acc;
        }

            ul.status li {
                /*border: solid 1px #ddd;*/
                padding: 0 .5em;
            }

                ul.status li + li {
                    margin-left: .2em;
                }

                ul.status li.msg {
                    flex: 1 1 100%;
                }

        ul.toolbar {
            list-style: none;
            display: grid;
            grid-template-columns: auto 1fr auto;
            padding: 0;
            grid-gap: .5em;
            margin-bottom: 0.5em;
            text-transform: lowercase;
        }

            ul.toolbar li {
                display: inline-flex;
            }


            ul.toolbar .compile {
                background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAQAAACQTsNJAAAAhklEQVRIDWNgGAXEgf94INGAFacRrKS4hQOrERykeokbwwhuckKGH8UIPnIDWBhuhDAl8SQBNkKczimDYj2D1RA2jEQO47MRbwgsof2Bi/zBkuCGjCHDJIp50KKWCc5nQotqHtyGwHLtV6goC1wTC1TkK1KuHvSGDJbYIQeigA9kwlGAAwAAX8z+pYYOlBwAAAAASUVORK5CYII=") no-repeat left center;
                background-size: contain;
            }

            ul.toolbar .test {
                background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAYAAAA6RwvCAAABUElEQVRYCe3XPyhFURzA8YueRF6kLJRBKb3llZK6swFlYHqSsvgzeamHCaUMitluUDYZFAOjhYGZqLfKZKL3fE+9Uy+9cs69v3OvW/fUZ7vDt+49v37X89KTpDO0l1tCCX1xh1ygigquMI/WOEJeayH1XlBAc1QR2QYR9R4wHkXI2B8h2jVGXIZMGoZopxh0ETJjGaJ84QAdkiGFACHaG6alQhZDhGjnGAgbsiIQonzWhmImaMiaUIj2BD9IyKZwiLZrNQx5eNtRiHKGdtOQfYchyj36/0PIM4ZNQnYcRtygx/TVbDmKOLa6yjxcFA4oYxZNttd3VSjgG4fojHPE3yEfdsTPhQj4wLLIFhdwDVBO0Cu5BkxZBtxi1MVi5BsGPGLC+jZYhHQbLD8LaIligS43CHjHOtqi/K+5/LVPbKArjh8stVkdqVng7BtIT1LOD4lrADFQfE9tAAAAAElFTkSuQmCC") no-repeat left center;
                background-size: contain;
            }

            ul.toolbar li a {
                text-indent: 1.5em;
                text-decoration: none;
                border: solid 1px transparent;
                padding: .15em .6em;
            }

                ul.toolbar li a:hover, ul.output li.head label:hover {
                    border-color: #bbb;
                }

            ul.toolbar li input[type=submit] {
                height: 27px;
                padding-top: 0;
                padding-bottom: 0;
            }

        .func {
            font-family: Consolas, 'Courier New', monospace;
            white-space: pre-wrap;
            background: #fff;
            margin: 0;
            padding: .2em;
            border: solid 1px #ddd;
        }

            .func mark {
                color: #3E991E;
                background: inherit;
            }


        ul.params {
            display: inline-flex;
            flex-wrap: wrap;
            list-style: none;
            padding: 0;
            white-space: normal;
            max-width: calc(100% - 12em);
        }

            ul.params li {
                padding: 0;
                break-inside: avoid;
            }

                ul.params li:not(:last-child) {
                    margin: 0 .5em .5em 0;
                }

            ul.params button, ul.params input[type=submit] {
                margin: 0;
                padding: .2em .5em;
                min-width: 1.5em;
                border-radius: .2em;
            }

                ul.params button.arg {
                    background: #ddd;
                    border: solid 2px transparent;
                    color: inherit;
                    text-transform: none;
                }

                    ul.params button.arg.current {
                        border-color: #12364a;
                    }

            ul.params li:not(:last-child):after {
                content: ",";
            }

            ul.params .remove {
                display: inline-flex;
                width: 21px;
                height: 21px;
                overflow: hidden;
                white-space: nowrap;
                text-indent: 150%;
                background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABUAAAAVCAMAAACeyVWkAAAAIVBMVEUAAADeKQDeKQDeKQDeKQDeKQDeKQDeKQDeKQDeKQDeKQCbtfQxAAAACnRSTlMABa+uoz0K9OnqieRn6AAAAFNJREFUeNq10AMCACEQQNHczL//gdc2kl7OPA0x2L5lQxwx422HjjxwgJo7hDAscy2P9YLTgAuWHpc84hSSApImWM292Hd7h+19j9+2/Yf9PysYKo4oA5is5nN7AAAAAElFTkSuQmCC)no-repeat center center;
                background-size: contain;
            }
    </style>

    <style>
        .help dt {
            font-weight: 600;
        }

        .help dd + dt {
            margin-top: 1.5em;
        }

        .help p {
            margin: 1em 0;
        }

        .help details {
            margin: .5em 0;
        }

        .help summary {
            color: #12364a;
            font-size: 1.5em;
            font-style: italic;
            background: #ddd;
            padding: 0 .5rem;
            margin: 0 -.5rem;
        }

        .help code {
            white-space: pre-line;
        }
    </style>
    <style>
        @supports (display: grid) {
            main, .sidebar {
                display: grid;
            }

            .no-grid {
                display: none;
            }
        }
    </style>
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <h1>
        <asp:Label ID="lblModuleName" runat="server" Text="User Code" />
    </h1>
    <main>
        <ul class="toolbar">
            <li>
                <asp:LinkButton ID="compile" CssClass="compile" runat="server" Text="Compilar" ToolTip="Compilar" />
            </li>
            <li>
                <asp:LinkButton ID="test" CssClass="test" runat="server" Text="Testar" ToolTip="Testar" />
            </li>
            <li>
                <asp:Button ID="save" CssClass="save" runat="server" Text="Salvar e Fechar" ToolTip="Save and Close" OnClick="save_Click" />
            </li>
        </ul>
        <div runat="server" class="func" id="funcHeader" visible="false">
            <asp:Literal runat="server" ID="funcHeaderStart" /><wf:usercodeparameters runat="server" id="codeParameters" /><asp:Literal runat="server" ID="funcHeaderEnd" /></div>
        <asp:TextBox TextMode="MultiLine" CssClass="source" ID="source" runat="server" autofocus="autofocus" />
        <p runat="server" class="func" id="funcFooter" visible="false"></p>
        <asp:Repeater runat="server" ID="output" Visible="false">
            <headertemplate>
                <ul class="output">
                    <input type="checkbox" id="showInfo" checked="checked" />
                    <input type="checkbox" id="showWarn" checked="checked" />
                    <input type="checkbox" id="showError" checked="checked" />
                    <li class="head">
                        <label for="showError">
                            <asp:Label runat="server" ID="errCount" Text="0" />
                            Errors</label>
                        <label for="showWarn">
                            <asp:Label runat="server" ID="warnCount" Text="0" />
                            Warnings</label>
                        <label for="showInfo">
                            <asp:Label runat="server" ID="msgCount" Text="0" />
                            Messages</label>
                    </li>
            </headertemplate>
            <footertemplate></ul></footertemplate>
        </asp:Repeater>
        <ul class="status">
            <li class="msg">
                <asp:Literal runat="server" ID="status" /></li>
            <li>Ln <span id="linenumber">1</span></li>
            <li>Col <span id="colnumber">1</span></li>
        </ul>
    </main>
    <aside class="sidebar fields">
        <input type="radio" name="sidebar_tabs" id="cfg" checked="checked" />
        <input type="radio" name="sidebar_tabs" id="param" />
        <ul class="tabs">
            <li class="cfg">
                <label for="cfg">
                    <asp:Literal ID="lblTabConfig" runat="server" Text="Configurações" /></label></li>
            <li class="param">
                <label for="param">
                    <asp:Literal ID="lblTabParams" runat="server" Text="Parâmetros" /></label></li>
        </ul>
        <div class="config">
            <h2>
                <asp:Literal ID="lblHeaderConfig" runat="server" Text="Configurações" /></h2>
            <label>
                <asp:Label ID="lblName" runat="server" Text="Nome" />
                <asp:TextBox ID="txtName" runat="server" placeholder="User Code" />
            </label>
            <label>
                <asp:Label ID="lblLanguage" runat="server" Text="Linguagem" />
                <asp:DropDownList ID="ddlLanguage" runat="server" AutoPostBack="true">
                    <asp:ListItem Value="CSharp" Text="C#" />
                    <asp:ListItem Value="VBNET" Text="Visual Basic .NET" />
                </asp:DropDownList>
            </label>
            <asp:PlaceHolder ID="phReturnConfig" runat="server">
                <label>
                    <asp:Label ID="lblReturnType" runat="server" Text="Retorno" />
                    <asp:DropDownList ID="ddlReturnType" runat="server" AutoPostBack="true">
                        <asp:ListItem Value="None" Text="None" />
                        <asp:ListItem Value="Text" Text="Text" />
                        <asp:ListItem Value="TextArray" Text="Text Array" />
                        <asp:ListItem Value="Xml" Text="XML" />
                    </asp:DropDownList>
                </label>
                <label>
                    <asp:Label ID="lblAlias" runat="server" Text="Apelido" />
                    <asp:TextBox ID="txtAlias" runat="server" />
                </label>
            </asp:PlaceHolder>
        </div>
        <div class="param">
            <h2>
                <asp:Literal ID="lblSelectParamMsg" runat="server" Text="Selecione um parâmetro." /></h2>
        </div>
        <div class="prop">
            <h2>
                <asp:Literal ID="lblHeaderParam" runat="server" Text="Parâmetro" /></h2>
            <label>
                <asp:Label runat="server" Text="Name" />
                <asp:TextBox ID="TextBox1" runat="server" CssClass="arg-name" placeholder="Name" />
            </label>
            <label>
                <asp:Label runat="server" Text="Type" />
                <asp:DropDownList ID="pType" runat="server" CssClass="arg-type">
                    <asp:ListItem Value="System.String" Text="String" />
                    <asp:ListItem Value="System.Int32" Text="Integer" />
                    <asp:ListItem Value="System.Int32?" Text="Integer?" />
                    <asp:ListItem Value="System.Int64" Text="Long" />
                    <asp:ListItem Value="System.Int64?" Text="Long?" />
                    <asp:ListItem Value="System.Decimal" Text="Decimal" />
                    <asp:ListItem Value="System.Decimal?" Text="Decimal?" />
                    <asp:ListItem Value="System.Boolean" Text="Boolean" />
                    <asp:ListItem Value="System.Boolean?" Text="Boolean?" />
                    <asp:ListItem Value="System.DateTime" Text="DateTime" />
                    <asp:ListItem Value="System.DateTime?" Text="DateTime?" />
                    <asp:ListItem Value="System.TimeSpan" Text="TimeSpan" />
                    <asp:ListItem Value="System.TimeSpan?" Text="TimeSpan?" />
                </asp:DropDownList>
            </label>
            <label>
                <asp:Label runat="server" Text="Value" />
                <wff:zuricontextlist id="ddlValue" filterproviders="REQUESTINFO;CTXWORKFLOWDATA" cssclass="arg-value" width="100%" pagersize="10" runat="server" />
            </label>
            <label>
                <asp:Label runat="server" Text="Test Value" />
                <asp:TextBox ID="txtTest" runat="server" CssClass="arg-test" placeholder="TestValue" />
            </label>
        </div>
        <div class="help">
            <h2>Ajuda sobre contexto</h2>
            <p>O parâmetro "context" permite a execução simplificada de algumas das tarefas mais comuns em módulos na lógica do módulo de código.</p>
            <details>
                <summary>método Attach</summary>
                <p>Adiciona um anexo ao item atual.</p>
                <h3>Lista de sobrecargas</h3>
                <dl class="overloads">
                    <dt>Attach(System.IO.Stream file, string name, string alias, [string description, string access])</dt>
                    <dd>Adiciona o Stream informado no parêmtro "file" como um arquivo anexo do item com o nome informado.</dd>
                    <dt>Attach(System.Xml.Linq.XNode data, string name, string alias, [string description, string access])</dt>
                    <dd>Adiciona o objeto xml (XElement ou XDocument) informado no parâmetro "data" como um anexo de dados no item.</dd>
                </dl>
                <p>Na lista acima, os parâmetros entre [] são opicionais. Abaixo há uma descrição de todos os parâmetros possíveis.</p>
                <dl class="arguments">
                    <dt>file</dt>
                    <dd>Objeto do tipo System.IO.Stream que será adicionado como um arquivo anexo ao item, vinculado ao módulo atual.</dd>
                    <dt>data</dt>
                    <dd>Representa dados que serão adicionados ao item para ser consumidos em outros pontos do processo.</dd>
                    <dt>name</dt>
                    <dd>Nome do anexo a ser adicionado ao item.</dd>
                    <dt>alias</dt>
                    <dd>Apelido do anexo a ser adicionado.</dd>
                    <dt>description</dt>
                    <dd>Opcional. Descrição do anexo, apenas para efeito de organização.</dd>
                    <dt>access</dt>
                    <dd>Opcional. Lista de acesso usada para limitar quem pode visualizar o anexo.</dd>
                </dl>
                <h3>Exemplo</h3>
                <code>var file = new MemoryStream();
                    //...lógica para gerar o conteúdo do arquivo na variável "file"...

                    //adiciona o arquivo como anexo do item
                    context.Attach(file, "relatorio.xlsx");

                    //adicionando um xml de dados com uma tag "raiz" contendo uma tag chamada "nome".
                    context.Attach(new XElement("raiz", new XElement("nome", "nome qualquer"));
                </code>
            </details>
            <details>
                <summary>método ReadValue</summary>
                <p>Obtém o valor tipado de uma variável de contexto do item atual.</p>
                <h3>Exemplo</h3>
                <code>int p = context.ReadValue("%%WFLParams.ItemProperties.Param1%%", 0);
                </code>
            </details>
            <details>
                <summary>propriedade IsTest (boolean)</summary>
                <p>Indica se o código está sendo executado em modo de Teste. Esta propriedade é útil para alterar o comportamento do módulo e garantir que não vai executar nada que não pode ou não é capaz ao clicar em Testar nesta tela de configuração.</p>
            </details>
        </div>
    </aside>
    <aside class="no-grid">A configuração deste módulo não é suportada neste browser. Favor utilizar um browser mais atualizado como o Microsoft Edge, Google Chrome ou Firefox.</aside>

    <script type="text/javascript">
        (function sourcePosition() {
            var source = document.querySelector("textarea");
            var ln = document.getElementById("linenumber");
            var col = document.getElementById("colnumber");

            if (source) {
                window.goToSourceCodePosition = function (l, c) {
                    var lines = source.value.split("\n");
                    var offset = Math.max(0, c - 1);

                    if (l > 0 && l <= lines.length) {
                        if (l > 1) {
                            for (i = 1; i < l; i++) {
                                offset += lines[i - 1].length + 1;
                            }
                        }

                    } else {
                        offset = source.value.length;
                    }
                    source.setSelectionRange(offset, offset);
                    source.focus();
                };

                if (ln && col) {
                    var updatePos = function () {
                        var p = source.selectionStart;
                        var l = 1;
                        var c = 1;
                        if (p) {
                            var part = source.value.substr(0, p);
                            var lines = part.split("\n");
                            l = lines.length;
                            c = lines[l - 1].length + 1;
                        }
                        ln.innerText = l;
                        col.innerText = c;
                    };

                    source.addEventListener("keyup", updatePos, false);
                    source.addEventListener("load", updatePos, false);
                    source.addEventListener("mouseup", updatePos, false);
                    source.addEventListener("focus", updatePos, false);
                }
            }
        })();

        (function argsEdit() {
            var args = document.querySelectorAll("ul.params button.arg");

            var current;

            var argName;
            var argType;
            var argTest;
            var argValue;

            var pName, pType, pValue, pTest, pTypeLabel, pNameLabel;

            var clear = function () {
                listen();

                current = null;
                pName = null;
                pType = null;
                pValue = null;
                pTest = null;
                pTypeLabel = null;
                pNameLabel = null;
                argName.value = "";
                argType.value = "";
                argTest.value = "";

                $("ul.params button.arg.current").removeClass("current");
                $(".sidebar .prop, .sidebar .help").removeClass("param");

                if (argValue) argValue.clearSelection();
            }

            var selectArg = function (name, type, value, test) {
                argName.value = name;
                argType.value = type;
                argTest.value = test;

                if (argValue) {
                    var item = argValue.findItemByValue(value);
                    if (item) {
                        item.select();
                    } else {
                        argValue.set_text(value);
                    }
                }
            }

            var chooseArg = function (e) {
                e.preventDefault();

                if (current != this) {
                    clear();

                    current = this;
                    var p = current.parentElement;
                    current.classList.add("current");

                    document.querySelector(".sidebar input#param").checked = true;

                    if (current.classList.contains("ctx")) {
                        document.querySelector(".sidebar .help").classList.add("param")
                    } else {
                        document.querySelector(".sidebar .prop").classList.add("param")

                        pName = p.querySelector("input[id$=Name]");
                        pType = p.querySelector("input[id$=Type]");
                        pValue = p.querySelector("input[id$=Value]");
                        pTest = p.querySelector("input[id$=Test]");
                        pNameLabel = current.querySelector(".name");
                        pTypeLabel = current.querySelector(".type");

                        var n = "";
                        if (pName) { n = pName.value || ""; }
                        var t = "";
                        if (pType) { t = pType.value || ""; }
                        var v = "";
                        if (pValue) { v = pValue.value || ""; }
                        var tt = "";
                        if (pTest) { tt = pTest.value || ""; }

                        selectArg(n, t, v, tt);
                    }
                }

                return false;
            };

            var getDefaultParamName = function (v) {
                if (current && !v) {
                    var p = current.parentElement;
                    t = $(current.parentElement).prevAll("li").length;
                    v = "param" + t;
                }
                return v;
            }

            var setArgValue = function (target, label, v) {
                v = v || "";
                if (target) { target.value = v; }
                if (label) { label.innerText = v; }
            };

            var listen = function () {
                if (!argName) {
                    argName = document.querySelector(".arg-name");
                    if (argName) argName.addEventListener("input", function () { setArgValue(pName, pNameLabel, getDefaultParamName(argName.value)); }, false);
                }
                if (!argType) {
                    argType = document.querySelector(".arg-type");
                    if (argType) {
                        argType.addEventListener("input", function () { setArgValue(pType, pTypeLabel, argType.value); }, false);
                        argType.addEventListener("change", function () { setArgValue(pType, pTypeLabel, argType.value); }, false);
                    }
                }
                if (!argTest) {
                    argTest = document.querySelector(".arg-test");
                    if (argTest) argTest.addEventListener("input", function () { setArgValue(pTest, null, argTest.value); }, false);
                }
                if (!argValue) {
                    //https://docs.telerik.com/devtools/aspnet-ajax/controls/combobox/client-side-programming/events/onclienttextchange
                    argValue = $find(document.querySelector(".arg-value").id);
                    if (argValue) {
                        argValue.add_textChange(function (sender, e) {
                            setArgValue(pValue, null, sender.get_text());
                            //console.log("changed", sender, e, sender.get_text());
                        });

                        argValue.add_selectedIndexChanged(function (sender, e) {
                            setArgValue(pValue, null, e.get_item().get_value());
                            //console.log("selected", sender, e, e.get_item().get_value());
                        });
                    }
                }
            };

            var load = function () {
                listen();

                args.forEach(function (a) {
                    a.addEventListener("click", chooseArg, false);
                });
            };

            $(document).ready(load);
        })();

        window.onbeforeunload = function () {
            document.body.classList.add("loading");
        }
    </script>
</asp:Content>

