﻿<%@ page language="vb" title="Rest Api Config" masterpagefile="~/WFAdmin/ModalAdminPage.master" autoeventwireup="false" codebehind="RestApiConfig.aspx.vb" inherits="WebFoundations.WFWorkflow.Modules.UI.RestApiConfig" validaterequest="false" %>

<%@ register src="~/WFAdmin/WFWorkflow/Components/RestApiHeaders.ascx" tagprefix="wf" tagname="RestApiHeaders" %>
<%@ register src="~/WFAdmin/WFWorkflow/Components/RestApiParameters.ascx" tagprefix="wf" tagname="RestApiParameters" %>
<%@ register src="~/WFAdmin/WFWorkflow/Components/OutputsByStatusCode.ascx" tagprefix="wf" tagname="OutputsByStatusCode" %>


<asp:Content ContentPlaceHolderID="TagHead" runat="server">
    <style type="text/css">
        .config-error {
            max-height: 9em;
            overflow: auto;
            background: rgba(255,0,0,.15);
            margin-bottom: .5em;
        }

            .config-error li {
                white-space: pre-wrap;
                margin: .5em;
            }

        .fields > fieldset > .rest-method, .fields > fieldset > .rest-reqtype, .fields > fieldset > .rest-addheader {
            display: grid;
            grid-template-columns: 15em;
            grid-column-gap: .5em;
        }

        .rest-addheader input, .rest-addparam input {
            width: 170px !important;
        }

        .rest-method select, .rest-reqtype select, .rest-addheader select {
            grid-column-start: 1;
        }

            .rest-method select + input, .rest-reqtype select + input, .rest-addheader select + input {
                grid-column-start: 2;
            }

        .rest-body textarea {
            font-family: Consolas, monospace;
            min-height: 15em;
        }

        @supports (display: grid) {
            .rest-method select + input, .rest-reqtype select + input, .rest-addheader select + input {
                height: 100%;
            }
        }
    </style>
    <script type="text/javascript">
        $(document).ready(function () {
            var met = $(".rest-method select");
            var req = $(".rest-reqtype select");
            var attchk = $(".rest-responsetype").find('input[type=checkbox]');

            var checkReqType = function () {
                var v = req.val();
                var v2 = met.val();
                if (v === "application/x-www-form-urlencoded" || v2 === "GET" || v2 === "DELETE") {
                    a = $(".rest-body").hide();
                } else {
                    a = $(".rest-body").css("display", "");
                }
                if (v && $(".rest-reqtype").is(":visible")) {
                    b = $(".rest-reqtype select + input").hide();
                } else {
                    $(".rest-reqtype select + input").css("display", "");
                }
            };
            req.change(function () { checkReqType(); });

            var checkMethod = function () {
                var v = met.val();
                if (v === "GET" || v === "DELETE") {
                    a = $(".rest-reqtype").hide();
                } else {
                    a = $(".rest-reqtype").css("display", "");
                }
                if (v) {
                    b = $(".rest-method select + input").hide();
                } else {
                    b = $(".rest-method select + input").css("display", "");
                }
                checkReqType();
            };
            met.change(function () { checkMethod(); });



            var checkResponseType = function () {
                if (attchk.is(":checked")) {
                    $(".attach-info").show();
                } else {
                    $(".attach-info").hide();
                }
            };
            attchk.change(function () { checkResponseType(); });

            checkMethod();
            checkResponseType();
        });
    </script>
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <asp:HiddenField ID="hdApiResult" runat="server" />
    <h1>
        <asp:Label Text="" ID="lblModuleName" runat="server" />
    </h1>
    <div class="config-error">
        <asp:ValidationSummary runat="server" />
    </div>
    <div class="fields no-columns mod-rest-config">
        <fieldset class="main">
            <legend>
                <asp:Literal runat="server" ID="litMainInfo" Text="Informações Iniciais" /></legend>
            <label class="rext-name">
                <asp:Literal runat="server" ID="litName" Text="Nome" />*:
            <asp:TextBox CssClass="remain" ID="txtName" runat="server" />
                <asp:RequiredFieldValidator runat="server" ControlToValidate="txtName" Display="None" ErrorMessage="O campo Nome é obrigatório." Text="" />
            </label>
            <label class="rest-method">
                <span>
                    <asp:Literal runat="server" ID="litMethod" Text="Método" />:</span>
                <asp:DropDownList runat="server" ID="ddlMethod" />
                <asp:TextBox ID="txtMethod" runat="server" />
                <asp:CustomValidator runat="server" Display="None" ID="MethodValidation" ErrorMessage="O método de request é obrigatório." OnServerValidate="MethodValidation_ServerValidate" />
            </label>
            <label class="rest-url">
                <span>Url*:</span>
                <asp:TextBox CssClass="remain" ID="txtUrl" runat="server" />
                <asp:RequiredFieldValidator runat="server" ControlToValidate="txtUrl" Display="None" ErrorMessage="O campo Url é obrigatório." Text="" />
                <asp:RegularExpressionValidator runat="server" ControlToValidate="txtUrl" Display="None" ValidationExpression="(h|H)(t|T){2}(p|P)(s|S)?://.{3,}" ErrorMessage="O campo Url deve ser uma url absoluta, começando com http." Text="" />
            </label>
            <asp:Label ID="lblAutenticacao" runat="server" />
            <asp:RadioButtonList ID="rdlTipoAutenticacao" runat="server" RepeatDirection="Horizontal" CssClass="unstyled" AutoPostBack="true">
                <asp:ListItem Value="0" Selected="true"></asp:ListItem>
                <asp:ListItem Value="1"></asp:ListItem>
                <asp:ListItem Value="2"></asp:ListItem>
            </asp:RadioButtonList>
            <asp:Panel ID="pnlAuthentication" runat="server" Visible="false">
                <asp:Label ID="lblAutenticacaoUsuario" runat="server" Style="float: left !important;" Width="60px" />
                <asp:RequiredFieldValidator ID="rfvUsuario" runat="server" Display="Dynamic" ControlToValidate="txtUsuario" Text="*" />
                <asp:TextBox ID="txtUsuario" runat="server" MaxLength="50" ClientIDMode="Static" AutoCompleteType="None" />
                <asp:Label ID="lblAutenticacaoSenha" runat="server" />
                <asp:RequiredFieldValidator ID="rfvSenha" runat="server" Display="Dynamic" ControlToValidate="txtSenha" Text="*" />
                <asp:TextBox ID="txtSenha" runat="server" MaxLength="20" ClientIDMode="Static" AutoCompleteType="None" />
            </asp:Panel>
            <asp:Panel ID="pnlCertificate" runat="server" Visible="false">
                <asp:Label runat="server" ID="lblCertificate" />               
                 <asp:DropDownList runat="server" ID="ddlCertificates" />
                <asp:RequiredFieldValidator ID="rfvCertificate" runat="server" Display="Dynamic" ControlToValidate="ddlCertificates" Text="*" />
            </asp:Panel>
            <label class="rest-reqtype">
                <span>
                <asp:Literal runat="server" ID="litReqType" Text="Request Content Type" />:</span>
                <asp:DropDownList runat="server" ID="ddlRequestContentType" />
                <asp:TextBox ID="txtRequestContentType" runat="server" />
                <asp:CustomValidator runat="server" Display="None" ID="ReqTypeValidation" ErrorMessage="O tipo de conteúdo do request deve ser informado quando há conteúdo." OnServerValidate="ReqTypeValidation_ServerValidate" />
            </label>
        </fieldset>
        <wf:restapiparameters runat="server" id="restParameters" />
        <fieldset class="config rest-body">
            <legend>
                <asp:Literal runat="server" ID="litContent" Text="Conteúdo" /></legend>
            <label class="rest-body">
                <span></span>
                <asp:TextBox runat="server" ID="txtContent" TextMode="MultiLine" />
            </label>
        </fieldset>
        <wf:restapiheaders runat="server" id="restHeaders" />
        <fieldset class="result">
            <legend>
                <asp:Literal runat="server" ID="litRetorno" Text="Retorno Esperado" />
            </legend>
            <label class="rest-responsetype">
                <span>
                    <asp:Literal runat="server" ID="litReturnFmt" Text="Formato" />:
                </span>
                <asp:DropDownList runat="server" ID="ddlResultType" />
            </label>
            <asp:PlaceHolder ID="phResultConfig" runat="server" Visible="false">
            <label>
                <asp:CheckBox ID="chkResult" runat="server" AutoPostBack="true" />
            </label>
            <asp:PlaceHolder ID="phMockDef" runat="server" Visible="false">
                <div style="display: grid; width: 100%">
                    <asp:Label ID="lblResult" runat="server" /><br />
                    <asp:TextBox runat="server" ID="txtResult" Height="15em" TextMode="MultiLine" />
                    <asp:RequiredFieldValidator ID="reqResult" runat="server" Display="Dynamic" ControlToValidate="txtResult" Text="*" />
                </div>
            </asp:PlaceHolder>
            </asp:PlaceHolder>
        </fieldset>
        <label>
            <asp:Button runat="server" ID="btnTest" OnClick="Test_Click" />
        </label>
        <asp:PlaceHolder ID="phResult" Visible="false" runat="server">
            <fieldset class="result">
                <legend>
                    <asp:Literal runat="server" ID="litResult" Text="Resultado e Saídas" />
                </legend>
                <label class="rest-responsetype">
                    <asp:CheckBox ID="chkaddXML" CssClass="checkbox" runat="server" />
                </label>
                <label class="rest-alias attach-info">
                    <span>
                        <asp:Literal runat="server" ID="litAttAlias" Text="Apelido Anexo" />:
                    </span>
                    <asp:TextBox runat="server" ID="txtAttachmentAlias" CssClass="remain" />
                    <asp:RegularExpressionValidator ID="vlAlias" runat="server" ControlToValidate="txtAttachmentAlias" ValidationExpression="[A-Za-z][A-Za-z0-9_-]*" />
                </label>
                <label>
                    <asp:Button ID="btnDownload" runat="server" />
                </label>
                <wf:outputsbystatuscode runat="server" id="serviceOutputs" allowerrorattachment="true" />
            </fieldset>
        </asp:PlaceHolder>
    </div>
    <section class="actions mod-rest-config">
        <asp:Button runat="server" ID="btnOK" Text="Ok" OnClick="Ok_Click" />
        <asp:Button runat="server" ID="btnCancel" Text="Cancelar" OnClientClick="try{window.close();}catch(ex){} return false;" CausesValidation="false" />
    </section>
</asp:Content>
